/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.category;

import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.category.ObjectAccessListener;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.ntfs.FileAccessUtil;
import java.util.Hashtable;

public final class FileIntegrityListener
extends ObjectAccessListener {
    private static final AdventNetResourceBundle RB = ResourceBundleMgr.getInstance().getBundle();

    @Override
    protected String getFormatMessage(Row row, int accessType, int eventType, Hashtable<String, Object> eventTbl) {
        StringBuffer message = new StringBuffer().append(RB.getString("adap.ADMPObjects.display_text.User"));
        message.append("'").append(row.get("USERNAME"));
        if (eventType == 16) {
            message.append(RB.getString("adap.ObjectAccessListener.s_attempt_to"));
        } else if (eventType == 8) {
            message.append("' ");
        }
        message.append(FileAccessUtil.getAccessTypeString(accessType, eventType));
        message.append(RB.getString("adap.ObjectAccessListener.file_folder"));
        message.append(row.get("OBJECT_NAME"));
        message.append("'");
        if (eventType == 16) {
            message.append(RB.getString("adap.ObjectAccessListener.failed"));
        }
        message.append(".");
        Integer eventNumber = (Integer)row.get("EVENT_NUMBER");
        if (eventNumber == 5143) {
            message.append(this.getFormatMessage(eventTbl));
        }
        return message.toString();
    }

    protected String getFormatMessage(Hashtable<String, Object> eventTbl) {
        StringBuffer sb = new StringBuffer();
        if (!((String)eventTbl.get("Old Remark")).equals((String)eventTbl.get("New Remark"))) {
            sb.append("\n").append(RB.getString("adap.ObjectAccessListener.Old_Remark")).append(" : ").append((String)eventTbl.get("Old Remark")).append("\n").append(RB.getString("adap.ObjectAccessListener.New_Remark")).append(" : ").append((String)eventTbl.get("New Remark"));
        }
        if (!((String)eventTbl.get("Old MaxUsers")).equals((String)eventTbl.get("New Maxusers"))) {
            sb.append("\n").append(RB.getString("adap.ObjectAccessListener.Old_Maxusers")).append(" : ").append(((String)eventTbl.get("Old MaxUsers")).equals("0xffffffff") ? RB.getString("adap.FileIntegrityListener.All_Users") : Long.toString(Long.decode((String)eventTbl.get("Old MaxUsers")))).append("\n").append(RB.getString("adap.ObjectAccessListener.New_MaxUsers")).append(" : ").append(Long.toString(Long.decode((String)eventTbl.get("New Maxusers"))));
        }
        if (!((String)eventTbl.get("Old ShareFlags")).equals((String)eventTbl.get("New ShareFlags"))) {
            sb.append("\n").append(RB.getString("adap.ObjectAccessListener.Old_ShareFlags")).append(" : ").append(Long.toString(Long.decode((String)eventTbl.get("Old ShareFlags")))).append("\n").append(RB.getString("adap.ObjectAccessListener.New_ShareFlags")).append(" : ").append(Long.toString(Long.decode((String)eventTbl.get("New ShareFlags"))));
        }
        return sb.toString();
    }
}

