/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.category;

import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import java.util.ArrayList;
import java.util.Hashtable;

public final class FormatMessageUtil {
    private static final AdventNetResourceBundle RB = ResourceBundleMgr.getInstance().getBundle();
    private static final DirectoryObjectAPI DIRECTORY_OBJECT_API = DirectoryObjectAPI.getInstance();

    public static String getRemarksMsg(Hashtable<String, Object> eventTbl, String objectStr, Row row) {
        String comRemarksStr = "-";
        try {
            Integer eventNumber = (Integer)row.get("EVENT_NUMBER");
            if (eventNumber.equals(5139)) {
                comRemarksStr = RB.handleGetObject("adap.FormatMessageUtil.objectStr___Account_Moved", new String[]{objectStr});
            } else {
                String accessMask = (String)eventTbl.get(RB.getString("adap.AUDRuleVariables.variable_name.Access_Mask"));
                String additionalInf2 = (String)eventTbl.get(RB.getString("adap.AUDRuleVariables.variable_name.Additional_Info2"));
                if (accessMask.equalsIgnoreCase("0x20") && (!additionalInf2.equalsIgnoreCase("") || additionalInf2 != null)) {
                    comRemarksStr = RB.handleGetObject("adap.FormatMessageUtil.objectStr_Account_Moved", new String[]{objectStr});
                }
                if (accessMask.equalsIgnoreCase("0x20") && (additionalInf2 == null || additionalInf2.equalsIgnoreCase(""))) {
                    comRemarksStr = RB.handleGetObject("adap.FormatMessageUtil.objectStr_Account_Renamed", new String[]{objectStr});
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return comRemarksStr;
    }

    public static String setFormatMessage(String domainName, Row row, Hashtable<String, Object> eventTbl, String objectStr) {
        String formatMessage = "-";
        try {
            Integer eventNumber = (Integer)row.get("EVENT_NUMBER");
            String dcName = (String)row.get("SOURCE");
            if (eventNumber.equals(5139)) {
                String objectNewDN = (String)eventTbl.get(RB.getString("adap.AUDRuleVariables.variable_name.Object_New_DN"));
                String objectOldDN = (String)eventTbl.get(RB.getString("adap.AUDRuleVariables.variable_name.Object_Old_DN"));
                formatMessage = RB.handleGetObject("adap.FormatMessageUtil.objectStr_StringrowgetACCOUNT_NAME_moved_from_objectOldDN", new String[]{objectStr, (String)row.get("ACCOUNT_NAME"), objectOldDN, objectNewDN});
            } else {
                String accessMask = (String)eventTbl.get(RB.getString("adap.AUDRuleVariables.variable_name.Access_Mask"));
                String additionalInf2 = (String)eventTbl.get(RB.getString("adap.AUDRuleVariables.variable_name.Additional_Info2"));
                String additionalInf = (String)eventTbl.get(RB.getString("adap.AUDRuleVariables.variable_name.Additional_Info"));
                ArrayList attributeList = (ArrayList)eventTbl.get(RB.getString("adap.AUDRuleVariables.variable_name.Attributes"));
                formatMessage = new StringBuffer().append(objectStr).append(" '").append(row.get("ACCOUNT_NAME")).append("'").toString();
                if (attributeList != null && (attributeList.contains("bf967a0e-0de6-11d0-a285-00aa003049e2") || attributeList.contains("bf96793f-0de6-11d0-a285-00aa003049e2"))) {
                    Row row1 = FormatMessageUtil.getObjectRow(domainName, additionalInf2, "organizationalUnit", dcName, null);
                    String objectName = "";
                    if (row1 != null) {
                        objectName = (String)row1.get("NAME");
                    }
                    if ((row1 = FormatMessageUtil.getObjectRow(domainName, additionalInf2, "container", dcName, null)) != null) {
                        objectName = (String)row1.get("NAME");
                    }
                    if (accessMask.equalsIgnoreCase("0x20") && !additionalInf2.equalsIgnoreCase("")) {
                        formatMessage = objectName != null ? new StringBuffer().append(formatMessage).append(RB.handleGetObject("adap.FormatMessageUtil._was_moved_to_objectName", new String[]{objectName})).toString() : new StringBuffer().append(formatMessage).append(RB.handleGetObject("adap.FormatMessageUtil._was_moved_to", new String[]{additionalInf})).toString();
                    }
                    if (accessMask.equalsIgnoreCase("0x20") && additionalInf2.equalsIgnoreCase("")) {
                        formatMessage = RB.handleGetObject("adap.FormatMessageUtil.objectStr___StringrowgetACCOUNT_NAME", new String[]{objectStr, (String)row.get("ACCOUNT_NAME")});
                    }
                } else {
                    formatMessage = new StringBuffer().append(formatMessage).append(RB.handleGetObject("adap.DSAListener._was_modified_by")).toString();
                }
            }
            if (!formatMessage.equalsIgnoreCase("-")) {
                formatMessage = new StringBuffer().append(formatMessage).append(" '").append(row.get("CALLER_USER_DOMAIN")).append("\\").append(row.get("CALLER_USER_NAME")).append("'").toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return formatMessage;
    }

    public static Row getObjectRow(String domainName, String objectGUID, String objectClass, String dcName, Integer isArchive) {
        Row row = null;
        try {
            objectGUID = objectGUID.replace("%", "");
            row = isArchive != null ? DIRECTORY_OBJECT_API.getObjectRowFromTable(domainName, objectGUID, "OBJECT_GUID", objectClass, dcName) : DIRECTORY_OBJECT_API.getObjectRow(domainName, objectGUID, "OBJECT_GUID", objectClass, dcName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return row;
    }
}

