/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.category;

import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.EventFormatMessageAPI;
import com.adventnet.sym.adsm.auditing.server.category.DefaultAccountMgmtListener;
import com.adventnet.sym.adsm.auditing.server.category.FormatMessageUtil;
import com.adventnet.sym.adsm.auditing.server.util.ExchangeCallerUserNameUtil;
import com.adventnet.sym.adsm.common.server.schema.SchemaAPI;
import com.adventnet.sym.adsm.common.server.util.UserAttributeUtil;
import java.util.ArrayList;
import java.util.Hashtable;

public final class GroupMgmtListener
extends DefaultAccountMgmtListener {
    private static final EventFormatMessageAPI EVENT_FORMAT_MESSAGE_API = EventFormatMessageAPI.getInstance();

    @Override
    public Object getColumnValue(String columnName, Object value) {
        Object customizedValue = null;
        if (columnName.equalsIgnoreCase("GROUP_TYPE")) {
            Integer valueInt = (Integer)value;
            customizedValue = this.getGroupType(valueInt);
        } else if (columnName.equalsIgnoreCase("GROUP_SCOPE")) {
            Integer valueInt = (Integer)value;
            customizedValue = this.getGroupScope(valueInt);
        } else {
            customizedValue = super.getColumnValue(columnName, value);
        }
        return customizedValue;
    }

    @Override
    public ArrayList<Row> getEventRowList(String domainName, Hashtable<String, Object> eventTbl, Long monitorId, String objectClass, Long categoryId) throws Exception {
        ArrayList<Row> rowList = null;
        Row row = super.getEventRow(domainName, eventTbl, monitorId, objectClass, categoryId);
        if (row != null) {
            String dcName = (String)row.get("SOURCE");
            rowList = new ArrayList<Row>();
            rowList.add(row);
            Integer eventNumber = (Integer)row.get("EVENT_NUMBER");
            if (eventNumber.equals(566) || eventNumber.equals(5139) || eventNumber.equals(5136)) {
                Integer isArchive;
                String objectName = (String)row.get("ACCOUNT_NAME");
                Row row1 = FormatMessageUtil.getObjectRow(domainName, objectName, "group", dcName, isArchive = (Integer)eventTbl.get("IsArchiveEvent"));
                if (row1 != null) {
                    String sIdString = (String)row1.get("SID_STRING");
                    sIdString = new StringBuffer().append("%{").append(sIdString).append("}").toString();
                    row.set("ACCOUNT_SID", (Object)sIdString);
                    row.set("ACCOUNT_NAME", (Object)((String)row1.get("NAME")));
                }
                String groupMgmtType = this.getGroupMgmtType(row, eventNumber, eventTbl);
                row.set("GROUP_MGMT_TYPE", (Object)groupMgmtType);
                String formatMessage = FormatMessageUtil.setFormatMessage(domainName, row, eventTbl, RB.getString("adap.ADMPObjects.display_text.Group"));
                if (formatMessage != null) {
                    formatMessage = new StringBuffer().append(formatMessage).append(RB.handleGetObject("adap.DSAListener.Modified_Properties__modifiedAttributesText", new String[]{groupMgmtType})).toString();
                }
                row.set("FORMAT_MESSAGE", (Object)formatMessage);
                String attributeString = row.get("ATTRIBUTES_TEXT") != null ? SchemaAPI.getInstance().getAttributeCommonName((String)row.get("ATTRIBUTES_TEXT")) : null;
                row.set("ATTRIBUTES_TEXT", (Object)attributeString);
                if (attributeString != null) {
                    Long attribCategoryId = SchemaAPI.getInstance().getAttributeCategoryId(attributeString);
                    row.set("ATTRIBUTE_CATEGORY_ID", (Object)attribCategoryId);
                    if (attributeString.equalsIgnoreCase("NT-Security-Descriptor") || attributeString.equalsIgnoreCase("WRITE_DAC")) {
                        row.set("ATTRIBUTE_CATEGORY_ID", (Object)3L);
                    }
                }
                if (eventNumber.equals(5136)) {
                    row.set("REMARKS", (Object)RB.getString("adap.AUDSQLQuery.sql_string.Group_Modified"));
                    if (eventTbl.get("ATTRIBUTES_OLD_VALUE") != null) {
                        row.set("ATTRIBUTES_OLD_VALUE", (Object)((String)eventTbl.get("ATTRIBUTES_OLD_VALUE")));
                    }
                    if (attributeString != null) {
                        if (attributeString.equalsIgnoreCase("NT-Security-Descriptor")) {
                            try {
                                UserAttributeUtil.setACLChanges(rowList, domainName, "NT-Security-Descriptor");
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        } else if (attributeString.equalsIgnoreCase("Group-Type")) {
                            String newVal = (String)row.get("ATTRIBUTES_NEW_VALUE");
                            String oldVal = (String)row.get("ATTRIBUTES_OLD_VALUE");
                            for (int i = 0; i < GROUP_TYPE.length; ++i) {
                                if (newVal != null && newVal.equalsIgnoreCase(GROUP_TYPE[i])) {
                                    row.set("ATTRIBUTES_NEW_VALUE", (Object)RB.handleGetObject("adap.DefaultAccountMgmtListener.Group_Scope_Group_type", new String[]{GROUP_SCOPE_STRINGS[i], GROUP_TYPE_STRINGS[i]}));
                                }
                                if (oldVal == null || !oldVal.equalsIgnoreCase(GROUP_TYPE[i])) continue;
                                row.set("ATTRIBUTES_OLD_VALUE", (Object)RB.handleGetObject("adap.DefaultAccountMgmtListener.Group_Scope_Group_type", new String[]{GROUP_SCOPE_STRINGS[i], GROUP_TYPE_STRINGS[i]}));
                            }
                        }
                        if (!attributeString.equalsIgnoreCase("NT-Security-Descriptor") && row.get("ATTRIBUTES_NEW_VALUE") != null && row.get("ATTRIBUTES_NEW_VALUE") != "") {
                            formatMessage = new StringBuffer().append(formatMessage).append(", ").append(RB.handleGetObject("adap.DefaultAccountMgmtListener.values", new String[]{(String)row.get("ATTRIBUTES_NEW_VALUE")})).toString();
                            row.set("FORMAT_MESSAGE", (Object)formatMessage);
                        }
                        if (!attributeString.equalsIgnoreCase("NT-Security-Descriptor")) {
                            if (row.get("ATTRIBUTES_OLD_VALUE") == null) {
                                row.set("REMARKS", (Object)"Group Attribute Added");
                            } else if (row.get("ATTRIBUTES_NEW_VALUE") == null || row.get("ATTRIBUTES_NEW_VALUE").equals("")) {
                                row.set("REMARKS", (Object)"Group Attribute Removed");
                            }
                        }
                    }
                } else {
                    String remarks = FormatMessageUtil.getRemarksMsg(eventTbl, "Group", row);
                    if (attributeString != null) {
                        row.set("REMARKS", (Object)RB.getString("adap.AUDSQLQuery.sql_string.Group_Modified"));
                    } else {
                        row.set("REMARKS", (Object)remarks);
                    }
                }
            } else {
                String memberName = (String)row.get("MEMBER_NAME");
                if (memberName == null || memberName.equalsIgnoreCase("") || memberName.equalsIgnoreCase("-")) {
                    row.set("MEMBER_NAME", (Object)this.getMemberName(domainName, row));
                }
                if (eventNumber.equals(636) || eventNumber.equals(637) || eventNumber.equals(4732) || eventNumber.equals(4733)) {
                    row.set("ACCOUNT_DOMAIN", (Object)domainName);
                }
                row.set("FORMAT_MESSAGE", (Object)EVENT_FORMAT_MESSAGE_API.getFormatMessage(row, eventNumber, objectClass));
            }
            ExchangeCallerUserNameUtil.getInstance().updateExchangeInfoInEventRow(row, eventTbl);
        }
        return rowList;
    }
}

