/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.category;

import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.DNSResolver;
import com.adventnet.sym.adsm.auditing.server.EventFormatMessageAPI;
import com.adventnet.sym.adsm.auditing.server.EventVariablesAPI;
import com.adventnet.sym.adsm.auditing.server.category.DefaultCategoryListener;
import com.adventnet.sym.adsm.common.server.objects.ADAPObjectCacheAPI;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class LogonCategoryListener
extends DefaultCategoryListener {
    protected static final Logger REPORT_LOGGER = Logger.getLogger("ReportLogger");
    private static final EventFormatMessageAPI EVENT_FORMAT_MESSAGE_API = EventFormatMessageAPI.getInstance();
    private static final DirectoryObjectAPI DIRECTORY_OBJECT_API = DirectoryObjectAPI.getInstance();
    private static final EventVariablesAPI EVENT_VARIABLES_API = EventVariablesAPI.getInstance();
    private static final DNSResolver DNS_RESOLVER = DNSResolver.getInstance();

    @Override
    public Object getColumnValue(String columnName, Object value) {
        Object customizedValue = null;
        customizedValue = columnName.equalsIgnoreCase("ERROR_CODE_TEXT") ? (value != null ? EVENT_VARIABLES_API.getKerberosErrorCodeText(value.toString()) : "-") : (columnName.equalsIgnoreCase("LOGON_TYPE_TEXT") ? (value != null ? EVENT_VARIABLES_API.getLogonTypeCodeText(value.toString()) : "-") : (columnName.equalsIgnoreCase("CLIENT_MC_NAME") || columnName.equalsIgnoreCase("CLIENT_HOST_NAME") ? (value != null ? value.toString().replace("\\", "") : "-") : super.getColumnValue(columnName, value)));
        return customizedValue;
    }

    @Override
    public Row getEventRow(String domainName, Hashtable<String, Object> eventTbl, Long monitorId, String objectClass, Long categoryId) throws Exception {
        Row row = super.getEventRow(domainName, eventTbl, monitorId, objectClass, categoryId);
        Integer eventNumber = (Integer)row.get("EVENT_NUMBER");
        if (row != null) {
            String accountName = (String)row.get("USER_SID");
            if (accountName == null || accountName.equalsIgnoreCase("") || accountName.equalsIgnoreCase("-") || accountName.equalsIgnoreCase("S-1-0-0")) {
                if (eventNumber > 671 && eventNumber < 677 || eventNumber > 4767 && eventNumber < 4773) {
                    String errorCode = (String)row.get("ERROR_CODE");
                    if (errorCode != null && !errorCode.equals("0x6")) {
                        row.set("USER_SID", (Object)this.getUserSID(domainName, row));
                    }
                } else if (eventNumber > 199 && eventNumber < 205 || eventNumber >= 299 && eventNumber < 307) {
                    row.set("USER_SID", (Object)this.getUserSID(domainName, row));
                }
            } else if (!accountName.startsWith("%")) {
                row.set("USER_SID", (Object)new StringBuffer().append("%{").append(row.get("USER_SID")).append("}").toString());
            }
            String tempDomainName = (String)row.get("DOMAIN");
            if (tempDomainName == null || "".equals(tempDomainName)) {
                row.set("DOMAIN", (Object)domainName);
            }
            if (eventNumber != 682 && eventNumber != 683 && eventNumber != 551 && eventNumber != 4647 && eventNumber != 4778 && eventNumber != 4779 && eventNumber != 4800 && eventNumber != 4801 && eventNumber != 4776 && eventNumber != 680 && (eventNumber < 6272 || eventNumber > 6280)) {
                String ipAddress = (String)row.get("CLIENT_HOST_NAME");
                ArrayList<Object> hostName = new ArrayList<String>();
                if (ipAddress != null) {
                    if (ipAddress.equals("127.0.0.1") || ipAddress.equals("::1") || ipAddress.equals("-")) {
                        row.set("CLIENT_HOST_NAME", (Object)((String)row.get("SOURCE")));
                        row.set("CLIENT_MC_NAME", (Object)"127.0.0.1");
                    } else {
                        try {
                            hostName = DNS_RESOLVER.getHostName(ipAddress);
                        }
                        catch (Exception e) {
                            hostName.add(0, ipAddress);
                            hostName.add(1, ipAddress);
                            REPORT_LOGGER.log(Level.WARNING, "For Event {[0]} ,Error while fetching IPAddress {[1]}", new Object[]{eventNumber, ipAddress});
                            e.printStackTrace();
                        }
                        row.set("CLIENT_HOST_NAME", hostName.get(0));
                        row.set("CLIENT_MC_NAME", hostName.get(1));
                    }
                }
            }
            if (eventNumber >= 528 && eventNumber < 540 || eventNumber == 4624 || eventNumber == 4625 || eventNumber == 4800 || eventNumber == 4801 || eventNumber == 4778 || eventNumber == 4779 || eventNumber >= 6272 && eventNumber <= 6280) {
                row.set("FORMAT_MESSAGE", (Object)EVENT_FORMAT_MESSAGE_API.getFormatMessage(row, eventNumber, objectClass));
            }
        }
        return row;
    }

    private String getUserSID(String domainName, Row row) {
        String userSid = "-";
        try {
            String userName = null;
            Integer eventNumber = (Integer)row.get("EVENT_NUMBER");
            if (eventNumber > 199 && eventNumber < 205 || eventNumber > 299 && eventNumber < 307) {
                userName = (String)row.get("CALLER_USER_NAME");
            } else {
                String string = userName = (String)row.get("USERNAME") != null ? (String)row.get("USERNAME") : "-";
            }
            if (userName.contains("\\")) {
                userName = userName.substring(userName.indexOf("\\") + 1);
                if (eventNumber > 199 && eventNumber < 205 || eventNumber > 299 && eventNumber < 307) {
                    row.set("CALLER_USER_NAME", (Object)userName);
                } else {
                    row.set("USERNAME", (Object)userName);
                }
            }
            String dcName = (String)row.get("SOURCE");
            String columnName = "SAM_ACCOUNT_NAME";
            if (userName.contains("@")) {
                columnName = "LOGON_NAME";
            }
            userSid = ADAPObjectCacheAPI.getInstance().getSidFromName(domainName, columnName, userName, dcName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return userSid;
    }
}

