/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.category;

import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.DNSResolver;
import com.adventnet.sym.adsm.auditing.server.category.DefaultCategoryListener;
import com.adventnet.sym.adsm.auditing.server.delegation.DelegationConstants;
import com.adventnet.sym.adsm.auditing.server.monitor.Action;
import com.adventnet.sym.adsm.auditing.server.util.FileAuditIpResolverUtil;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.ntfs.FileAccessUtil;
import com.adventnet.sym.adsm.common.server.objects.ADAPObjectCacheAPI;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ObjectAccessListener
extends DefaultCategoryListener {
    private static final AdventNetResourceBundle RB = ResourceBundleMgr.getInstance().getBundle();
    private static final ADAPObjectCacheAPI ADAP_OBJECT_CACHE_API = ADAPObjectCacheAPI.getInstance();
    private static final DNSResolver DNS_RESOLVER = DNSResolver.getInstance();
    private static Logger logger = Logger.getLogger(ObjectAccessListener.class.getName());
    public static String[] new_i18n_text = null;

    @Override
    public ArrayList<Row> getEventRowList(String domainName, Hashtable<String, Object> eventTbl, Long monitorId, String objectClass, Long categoryId) throws Exception {
        ArrayList<Row> rowList = null;
        Row row = super.getEventRow(domainName, eventTbl, monitorId, objectClass, categoryId);
        Long actionId = (Long)eventTbl.get("ActionId");
        if (row != null) {
            Integer eventNumber;
            block30: {
                ArrayList<Object> hostName;
                String ipAddress;
                String objectName;
                eventNumber = (Integer)row.get("EVENT_NUMBER");
                int machineType = (Integer)eventTbl.get("MachineType");
                if (eventNumber == 560 || eventNumber == 563 || eventNumber == 567) {
                    String userName = (String)row.get("PRIMARY_USER_NAME");
                    String clientUserName = (String)row.get("CLIENT_USER_NAME");
                    clientUserName = clientUserName.trim();
                    if (userName.endsWith("$") && (clientUserName.equalsIgnoreCase("-") || clientUserName.endsWith("$"))) {
                        return null;
                    }
                    if (userName.endsWith("$") && !clientUserName.equalsIgnoreCase("-")) {
                        row.set("USERNAME", (Object)clientUserName);
                    } else if (userName.equalsIgnoreCase("-") && !clientUserName.equalsIgnoreCase("-")) {
                        row.set("USERNAME", (Object)clientUserName);
                    } else {
                        row.set("USERNAME", (Object)userName);
                    }
                }
                if ((objectName = (String)row.get("OBJECT_NAME")) != null) {
                    String[] fileDetails = ObjectAccessListener.getFileDetails(objectName);
                    row.set("FILE_LOCATION", (Object)fileDetails[0]);
                    row.set("FILE_NAME", (Object)fileDetails[1]);
                }
                if ((machineType & 0x80000) == 524288) {
                    if (objectName.endsWith("/")) {
                        objectName = objectName.substring(0, objectName.length() - 1);
                    }
                    row.set("FILE_LOCATION", (Object)objectName.substring(0, objectName.lastIndexOf("/") + 1));
                    row.set("FILE_NAME", (Object)objectName.substring(objectName.lastIndexOf("/") + 1, objectName.length()));
                }
                if (eventNumber == 560 || eventNumber == 563 || eventNumber == 567 || eventNumber == 4656 || eventNumber == 4663 || eventNumber == 4670 || eventNumber == 4907 || eventNumber == 4659 || eventNumber == 5140 || eventNumber == 5142 || eventNumber == 5143 || eventNumber == 5144 || eventNumber == 9999 || eventNumber == 4660) {
                    this.setAccessRights(row, actionId, eventTbl, domainName);
                }
                if (eventNumber == 5140) {
                    ipAddress = (String)row.get("ORIGINAL_PERMISSIONS");
                    hostName = new ArrayList<String>();
                    if (ipAddress != null) {
                        if (ipAddress.equals("127.0.0.1") || ipAddress.equals("-")) {
                            row.set("ORIGINAL_PERMISSIONS", (Object)((String)row.get("SOURCE")));
                            row.set("NEW_PERMISSIONS", (Object)"127.0.0.1");
                        } else {
                            try {
                                hostName = DNS_RESOLVER.getHostName(ipAddress);
                            }
                            catch (Exception e) {
                                hostName.add(0, ipAddress);
                                hostName.add(1, ipAddress);
                                logger.log(Level.WARNING, "For Event {[0]} ,Error while fetching IPAddress in File Audit {[1]}", new Object[]{eventNumber, ipAddress});
                                e.printStackTrace();
                            }
                            row.set("ORIGINAL_PERMISSIONS", hostName.get(0));
                            row.set("NEW_PERMISSIONS", hostName.get(1));
                        }
                    }
                }
                if (eventNumber == 4656 || eventNumber == 4663 || eventNumber == 4670 || eventNumber == 4907 || eventNumber == 4659) {
                    row.set("ORIGINAL_PERMISSIONS", (Object)FileAuditIpResolverUtil.getInstance().getIpForLogonId(row, eventTbl));
                    row.set("NEW_PERMISSIONS", (Object)FileAuditIpResolverUtil.getHostNameforIP((String)row.get("ORIGINAL_PERMISSIONS"), row));
                }
                try {
                    if (machineType == 256) {
                        row.set("ORIGINAL_PERMISSIONS", (Object)((String)eventTbl.get("Client User Name")));
                        row.set("NEW_PERMISSIONS", (Object)FileAuditIpResolverUtil.getHostNameforIP((String)row.get("ORIGINAL_PERMISSIONS"), row));
                    }
                    if (machineType == 131072) {
                        row.set("ORIGINAL_PERMISSIONS", (Object)"-");
                        String clientLogonID = (String)eventTbl.get("Client Logon ID");
                        String callerMachineName = clientLogonID.substring(clientLogonID.indexOf("-") + 2, clientLogonID.length());
                        row.set("NEW_PERMISSIONS", (Object)callerMachineName);
                    }
                    if ((machineType & 0x80000) != 524288) break block30;
                    ipAddress = (String)eventTbl.get("Security IP");
                    hostName = new ArrayList();
                    try {
                        hostName = DNS_RESOLVER.getHostName(ipAddress);
                    }
                    catch (Exception e) {
                        hostName.add(0, ipAddress);
                        hostName.add(1, ipAddress);
                    }
                    row.set("NEW_PERMISSIONS", hostName.get(0));
                    row.set("ORIGINAL_PERMISSIONS", hostName.get(1));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            rowList = new ArrayList<Row>();
            rowList.add(row);
            if (eventNumber == 4670 || eventNumber == 4907 || eventNumber == 5143) {
                this.setModifiedPermission(rowList, domainName, "AUDFolderACLValues", "AUDFolderACLChanges");
            } else if (eventNumber == 4659 || eventNumber == 5140) {
                Long accesses = (Long)row.get("ACCESS_MASK");
                if (accesses.equals(65536L)) {
                    row.set("REMARKS", (Object)RB.getString("adap.ObjectAccessListener.An_object_was_deleted"));
                } else if ((accesses & 0x10000L) == 65536L && eventNumber == 4659) {
                    row.set("REMARKS", (Object)RB.getString("adap.ObjectAccessListener.An_object_was_deleted"));
                }
            }
        }
        return rowList;
    }

    private static String[] getFileDetails(String absoluteName) {
        String[] fileDetails = new String[2];
        if (absoluteName.indexOf("\\") != -1) {
            if (absoluteName.endsWith("\\")) {
                absoluteName = absoluteName.substring(0, absoluteName.length() - 1);
            }
            int lastIndex = absoluteName.lastIndexOf("\\");
            fileDetails[0] = absoluteName.substring(0, lastIndex + 1);
            fileDetails[1] = absoluteName.substring(lastIndex + 1, absoluteName.length());
            if (fileDetails[1] != null && fileDetails[1].equals("")) {
                fileDetails[1] = absoluteName.substring(0, lastIndex + 1);
            }
        } else {
            fileDetails[0] = "-";
            fileDetails[1] = absoluteName;
        }
        return fileDetails;
    }

    private void getEMCFileCreationName(Row row, String domainName) throws Exception {
        try {
            String file;
            ArrayList fileList;
            String[] fileDetails = ObjectAccessListener.getFileDetails((String)row.get("UNC_NAME"));
            String fileName = fileDetails[1];
            String fileLocation = fileDetails[0];
            int i = fileName.lastIndexOf(46);
            String extension = null;
            if (i > 0) {
                extension = fileName.substring(i + 1);
            }
            if ((fileList = ADHandler.searchFile(fileLocation, fileName, extension, (Long)row.get("TIME_GENERATED"), domainName)).size() == 1 && (file = (String)fileList.get(0)) != null) {
                row.set("UNC_NAME", (Object)fileLocation.concat(file));
                row.set("FILE_NAME", (Object)file);
                row.set("OBJECT_NAME", (Object)((String)row.get("FILE_LOCATION")).concat(file));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setModifiedPermission(ArrayList<Row> rowList, String domainName, String valTable, String chanTable) throws Exception {
        Row row = rowList.get(0);
        DataAccess.generateValues((Row)row);
        String newStringSecDesc = (String)row.get("NEW_SEC_DESC");
        String originalStringSecDesc = (String)row.get("ORIGINAL_SEC_DESC");
        Hashtable newAceTable = null;
        Hashtable originalAceTable = null;
        try {
            newAceTable = ADHandler.getSecurityDescriptorFromStringSD(domainName, newStringSecDesc);
            originalAceTable = ADHandler.getSecurityDescriptorFromStringSD(domainName, originalStringSecDesc);
            if (originalAceTable != null) {
                Enumeration enumeration = originalAceTable.keys();
                while (enumeration.hasMoreElements()) {
                    String keyStr = (String)enumeration.nextElement();
                    if (keyStr.equals("Owner")) {
                        String originalOwner;
                        String newOwner = ADAP_OBJECT_CACHE_API.getObjectNameFromSID(domainName, (String)newAceTable.get("Owner"), "NAME", null);
                        if (newOwner.equals(originalOwner = ADAP_OBJECT_CACHE_API.getObjectNameFromSID(domainName, (String)originalAceTable.get("Owner"), "NAME", null))) continue;
                        if (row.get("ACL_CHANGE") == null) {
                            row.set("ACL_CHANGE", (Object)RB.handleGetObject("adap.ObjectAccessListener.Owner_changed_from", new String[]{originalOwner, newOwner}));
                            continue;
                        }
                        String s = (String)row.get("ACL_CHANGE");
                        s = s + " ";
                        s = s + RB.handleGetObject("adap.ObjectAccessListener.Owner_changed_from", new String[]{originalOwner, newOwner});
                        row.set("ACL_CHANGE", (Object)s);
                        continue;
                    }
                    if (!keyStr.equals("Dacl") && !keyStr.equals("Sacl")) continue;
                    ArrayList originalAcl = (ArrayList)originalAceTable.get(keyStr);
                    ArrayList newAcl = new ArrayList();
                    if (newAceTable != null) {
                        newAcl = (ArrayList)newAceTable.get(keyStr);
                    }
                    ObjectAccessListener.compareAcList(domainName, rowList, newAcl, originalAcl, chanTable, "File");
                }
            }
            if (row != null) {
                Row newOldValueRow = new Row(valTable);
                newOldValueRow.set("ACCOUNT_DOMAIN", row.get("DOMAIN"));
                newOldValueRow.set("UNIQUE_ID", row.get("UNIQUE_ID"));
                newOldValueRow.set("NEW_SEC_DESC", row.get("NEW_SEC_DESC"));
                newOldValueRow.set("ORIGINAL_SEC_DESC", row.get("ORIGINAL_SEC_DESC"));
                rowList.add(newOldValueRow);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setAccessRights(Row row, Long actionId, Hashtable<String, Object> eventTbl, String domainName) throws Exception {
        Integer eventNumber = (Integer)row.get("EVENT_NUMBER");
        int accessType = this.getAccessType(actionId);
        Integer eventType = (Integer)row.get("EVENT_TYPE");
        Integer eventCategory = (Integer)eventTbl.get("EventCategory");
        if (new_i18n_text == null) {
            String new_i18n = CommonUtil.getSysParams("FILECREATION_NEW_TEXT");
            if (new_i18n == null) {
                new_i18n = "new";
            }
            new_i18n_text = new_i18n.split(",");
        }
        if (accessType == 5) {
            for (int i = 0; i < new_i18n_text.length; ++i) {
                if (!((String)row.get("FILE_NAME")).toLowerCase().startsWith(new_i18n_text[i])) continue;
                this.getEMCFileCreationName(row, domainName);
                break;
            }
        }
        if (eventTbl.get("ACCESS_TYPE") != null && (Integer)eventTbl.get("ACCESS_TYPE") == 14) {
            accessType = 14;
        }
        if (accessType == 0) {
            Long accesses = (Long)row.get("ACCESS_MASK");
            if (eventNumber == 4670) {
                accessType = 3;
            } else if (eventNumber == 4907) {
                accessType = 4;
            } else if (eventNumber == 4659) {
                accessType = 10;
            } else if (eventType == 16) {
                if ((accesses & 0x10000L) == 65536L) {
                    accessType = 10;
                } else if ((accesses & 0x10000L) != 65536L && (accesses & 2L) == 2L) {
                    accessType = 2;
                } else if ((accesses & 1L) == 1L && (accesses & 0x20000L) == 131072L && (accesses & 2L) != 2L) {
                    accessType = 1;
                } else if ((accesses & 1L) == 1L && (accesses & 2L) != 2L) {
                    accessType = 1;
                }
            } else if (eventType == 8) {
                if ((accesses & 0x16019FL) == 1442207L && eventNumber == 4656 || (accesses & 0x6019FL) == 393631L && eventNumber == 560 || (accesses & 0x130196L) == 1245590L && eventNumber == 560) {
                    accessType = 7;
                } else if ((accesses & 1L) == 1L && (eventNumber == 560 || eventNumber == 4656)) {
                    accessType = 1;
                } else if (eventNumber == 4663 || eventNumber == 5140) {
                    if (accesses.equals(65536L)) {
                        accessType = 10;
                    } else if ((accesses & 1L) == 1L) {
                        accessType = 1;
                    } else if ((accesses & 4L) == 4L || (accesses & 2L) == 2L) {
                        accessType = 2;
                    } else if ((accesses & 0x100L) == 256L && eventCategory == 12812) {
                        accessType = 7;
                    }
                } else if ((accesses & 0x110080L) == 0x110080L && (eventNumber == 560 || eventNumber == 4656)) {
                    accessType = 6;
                } else if (eventNumber == 560 || eventNumber == 563) {
                    if (accesses.equals(65536L) || (accesses & 0x10000L) == 65536L) {
                        accessType = 10;
                    } else if (accesses == 4L || accesses == 2L || accesses == 6L || (accesses & 4L) == 4L || (accesses & 2L) == 2L || (accesses & 0x100L) == 256L) {
                        accessType = 2;
                    } else if (accesses.equals(262144L) || (accesses & 0x40000L) == 262144L) {
                        accessType = 3;
                    }
                }
            }
        }
        if (accessType == 14 && eventNumber == 9999 && this.isFileMove((String)eventTbl.get("UNC_NAME"), (String)eventTbl.get("NEW_UNC_NAME"), true)) {
            accessType = 6;
        }
        if (accessType != 0) {
            this.setAccessRights(row, accessType, eventType, eventTbl);
        }
    }

    private void setAccessRights(Row row, int accessType, int eventType, Hashtable<String, Object> eventTbl) {
        row.set("ACCESS_TYPE", (Object)accessType);
        row.set("ACCESS_TYPE_TEXT", (Object)FileAccessUtil.getAccessTypeString(accessType, 0));
        row.set("FORMAT_MESSAGE", (Object)this.getFormatMessage(row, accessType, eventType, eventTbl));
    }

    protected String getFormatMessage(Row row, int accessType, int eventType, Hashtable<String, Object> eventTbl) {
        StringBuffer message = new StringBuffer().append(RB.getString("adap.ADMPObjects.display_text.User"));
        boolean isNetappMoveEvent = false;
        boolean isMoveEvent = false;
        message.append(" '").append(row.get("USERNAME"));
        if (eventType == 16) {
            message.append(RB.getString("adap.ObjectAccessListener.s_attempt_to"));
        } else if (eventType == 8) {
            message.append("' ");
        }
        int machineType = (Integer)eventTbl.get("MachineType");
        if (!((machineType & 0x100) != 256 && (machineType & 0x80000) != 524288 || accessType != 6 && accessType != 14)) {
            isNetappMoveEvent = true;
        } else if (((Integer)eventTbl.get("MachineType") & 0x100) != 256 && accessType == 6) {
            isMoveEvent = true;
        }
        message.append(FileAccessUtil.getAccessTypeString(accessType, eventType));
        message.append(RB.getString("adap.ObjectAccessListener.file_folder"));
        message.append(row.get("UNC_NAME"));
        message.append("'");
        if (isNetappMoveEvent || isMoveEvent && eventTbl.get("NEW_UNC_NAME") != null) {
            message.append(" to ");
            message.append("'").append((String)eventTbl.get("NEW_UNC_NAME"));
            message.append("'");
        }
        if (eventType == 16) {
            message.append(RB.getString("adap.ObjectAccessListener.failed"));
        }
        message.append(".");
        return message.toString();
    }

    public static void compareAcList(String domainName, ArrayList<Row> rowList, ArrayList<Hashtable<String, Object>> newAcl, ArrayList<Hashtable<String, Object>> originalAcl, String tableName, String objectType) {
        int i;
        Row row = rowList.get(0);
        int addedCount = 0;
        int removedCount = 0;
        if (originalAcl == null) {
            addedCount = newAcl.size();
            for (i = 0; i < newAcl.size(); ++i) {
                Hashtable<String, Object> aceTable = newAcl.get(i);
                rowList.add(ObjectAccessListener.getACERow(domainName, RB.getString("adap.Reports.Schedule_Report.added"), aceTable, row, tableName, objectType));
            }
        } else if (newAcl == null) {
            removedCount = originalAcl.size();
            for (i = 0; i < originalAcl.size(); ++i) {
                Hashtable<String, Object> aceTable = originalAcl.get(i);
                rowList.add(ObjectAccessListener.getACERow(domainName, RB.getString("adap.ObjectAccessListener.removed"), aceTable, row, tableName, objectType));
            }
        } else {
            Hashtable<String, Object> aceTable;
            for (i = 0; i < newAcl.size(); ++i) {
                aceTable = newAcl.get(i);
                if (originalAcl.contains(aceTable)) continue;
                ++addedCount;
                rowList.add(ObjectAccessListener.getACERow(domainName, RB.getString("adap.Reports.Schedule_Report.added"), aceTable, row, tableName, objectType));
            }
            for (i = 0; i < originalAcl.size(); ++i) {
                aceTable = originalAcl.get(i);
                if (newAcl.contains(aceTable)) continue;
                ++removedCount;
                rowList.add(ObjectAccessListener.getACERow(domainName, RB.getString("adap.ObjectAccessListener.removed"), aceTable, row, tableName, objectType));
            }
        }
        StringBuffer aclChangeSummary = new StringBuffer().append("");
        if (addedCount > 0) {
            aclChangeSummary.append(addedCount).append(RB.getString("adap.ObjectAccessListener.aces_added"));
        }
        if (removedCount > 0) {
            if (!aclChangeSummary.toString().equals("")) {
                aclChangeSummary.append(", ");
            }
            aclChangeSummary.append(removedCount).append(RB.getString("adap.ObjectAccessListener.aces_removed"));
        }
        if (addedCount == 0 && removedCount == 0) {
            if (!aclChangeSummary.toString().equals("")) {
                aclChangeSummary.append(", ");
            }
            aclChangeSummary.append(RB.getString("adap.ObjectAccessListener.no_changes_on_sd"));
        }
        if (tableName.equalsIgnoreCase("AUDACLChanges")) {
            row.set("REMARKS", (Object)aclChangeSummary);
        } else {
            row.set("ACL_CHANGE", (Object)aclChangeSummary);
        }
    }

    private static Row getACERow(String domainName, String modificationType, Hashtable<String, Object> aceTable, Row row, String tableName, String objectType) {
        String permission;
        Row aceRow = new Row(tableName);
        aceRow.set("UNIQUE_ID", row.get("UNIQUE_ID"));
        aceRow.set("MODIFICATION_TYPE", (Object)modificationType);
        String trustee = (String)aceTable.get("Trustee");
        Integer aceType = (Integer)aceTable.get("AceType");
        Integer aceFlags = (Integer)aceTable.get("AceFlags");
        aceRow.set("TRUSTEE_SID", (Object)trustee);
        aceRow.set("SECURITY_PRINCIPAL", (Object)ADAP_OBJECT_CACHE_API.getObjectNameFromSID(domainName, trustee, "NAME", null));
        String string = permission = !objectType.equalsIgnoreCase("DS") ? DelegationConstants.getAccessMaskString(aceTable.get("AccessMask").toString(), objectType) : DelegationConstants.getPermissionString(aceTable, domainName);
        if ("".equals(permission.trim())) {
            permission = "-";
        }
        aceRow.set("PERMISSION", (Object)permission);
        aceRow.set("ACE_TYPE", (Object)DelegationConstants.getFileAceTypeString(aceType, aceFlags));
        aceRow.set("APPLIES_TO", (Object)(!objectType.equalsIgnoreCase("File") ? DelegationConstants.getAppliesToString(aceTable, domainName) : DelegationConstants.getFileAppliesToString(aceFlags)));
        aceRow.set("INHERITED_ACE", (Object)DelegationConstants.isInheritedString(aceFlags));
        return aceRow;
    }

    private int getAccessType(Long actionId) {
        int result = 0;
        Integer accessType = Action.getAccessType(actionId);
        if (accessType != null) {
            result = accessType;
        }
        return result;
    }

    private boolean isFileMove(String oldPath, String newPath, boolean isBackSlash) {
        int oldLastIndex = oldPath.lastIndexOf(isBackSlash ? "\\" : "/");
        int newLastIndex = newPath.lastIndexOf(isBackSlash ? "\\" : "/");
        if (oldLastIndex != -1 && newLastIndex != -1) {
            String oldPrefix = oldPath.substring(0, oldLastIndex);
            String oldSuffix = oldPath.substring(oldLastIndex + 1, oldPath.length());
            String newPrefix = newPath.substring(0, newLastIndex);
            String newSuffix = newPath.substring(newLastIndex + 1, newPath.length());
            return !oldPrefix.equals(newPrefix) && oldSuffix.equals(newSuffix);
        }
        return false;
    }
}

