/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.category;

import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.EventFormatMessageAPI;
import com.adventnet.sym.adsm.auditing.server.EventVariablesAPI;
import com.adventnet.sym.adsm.auditing.server.category.DefaultCategoryListener;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.TimeUtil;
import java.util.Hashtable;

public final class PolicyChangeListener
extends DefaultCategoryListener {
    private static final AdventNetResourceBundle RB = ResourceBundleMgr.getInstance().getBundle();
    private static final EventFormatMessageAPI EVENT_FORMAT_MESSAGE_API = EventFormatMessageAPI.getInstance();
    private static final EventVariablesAPI EVENT_VARIABLES_API = EventVariablesAPI.getInstance();
    private static final String[] PROP_COLUMNS = new String[]{"MIN_PASSWORD_AGE", "MAX_PASSWORD_AGE", "MIN_PASSWORD_LENGTH", "PASSWORD_HIST_LENGTH", "PASSWORD_PROP", "LOCKOUT_THRESHOLD", "LOCKOUT_OBSERV_WINDOW", "LOCKOUT_DURATION"};
    private static final String[] PROP_DISPLAY = new String[]{RB.getString("adap.PolicyChangeListener.Minimum_Password_Age"), RB.getString("adap.PolicyChangeListener.Maximum_Password_Age"), RB.getString("adap.PolicyChangeListener.Minimum_Password_Length"), RB.getString("adap.PolicyChangeListener.Password_History_Length"), RB.getString("adap.PolicyChangeListener.Password_Properties"), RB.getString("adap.PolicyChangeListener.Lockout_Threshold"), RB.getString("adap.PolicyChangeListener.Lockout_Observation_Window"), RB.getString("adap.PolicyChangeListener.Lockout_Duration")};

    @Override
    public Object getColumnValue(String columnName, Object value) {
        Object customizedValue = null;
        if (columnName.equalsIgnoreCase("PASSWORD_HIST_LENGTH") || columnName.equalsIgnoreCase("MIN_PASSWORD_LENGTH") || columnName.equalsIgnoreCase("LOCKOUT_THRESHOLD")) {
            StringBuffer valueStr;
            String customizedString = "-";
            if (value != null && !(valueStr = new StringBuffer().append(value)).toString().equalsIgnoreCase("-")) {
                if (columnName.equalsIgnoreCase("PASSWORD_HIST_LENGTH")) {
                    valueStr.append(RB.getString("adap.PolicyChangeListener._passwords_remebered"));
                } else if (columnName.equalsIgnoreCase("MIN_PASSWORD_LENGTH")) {
                    valueStr.append(RB.getString("adap.PolicyChangeListener._characters"));
                } else if (columnName.equalsIgnoreCase("LOCKOUT_THRESHOLD")) {
                    valueStr.append(RB.getString("adap.PolicyChangeListener._invalid_logon_attempts"));
                }
                customizedString = valueStr.toString();
            }
            customizedValue = customizedString;
        } else if (columnName.equalsIgnoreCase("MAX_PASSWORD_AGE") || columnName.equalsIgnoreCase("MIN_PASSWORD_AGE")) {
            String valueStr;
            String customizedString = "-";
            if (value != null && !(valueStr = (String)value).equalsIgnoreCase("-")) {
                customizedString = new StringBuffer().append(TimeUtil.getDaysFromSeconds(valueStr)).append(RB.getString("adap.PolicyChangeListener._days")).toString();
            }
            customizedValue = customizedString;
        } else if (columnName.equalsIgnoreCase("LOCKOUT_OBSERV_WINDOW") || columnName.equalsIgnoreCase("LOCKOUT_DURATION")) {
            String valueStr;
            String customizedString = "-";
            if (value != null && !(valueStr = (String)value).equalsIgnoreCase("-")) {
                customizedString = new StringBuffer().append(TimeUtil.getMinutesFromSeconds(valueStr)).append(RB.getString("adap.PolicyChangeListener._minutes")).toString();
            }
            customizedValue = customizedString;
        } else if (columnName.equalsIgnoreCase("PASSWORD_PROP")) {
            String customizedString = "-";
            if (value != null) {
                customizedString = this.getPasswordPropString((String)value);
            }
            customizedValue = customizedString;
        } else if (columnName.equalsIgnoreCase("USER_RIGHTS_VALUE")) {
            String customizedString = "-";
            if (value != null) {
                customizedString = EVENT_VARIABLES_API.getUserRightsValue(value);
            }
            customizedValue = customizedString;
        } else {
            customizedValue = super.getColumnValue(columnName, value);
        }
        return customizedValue;
    }

    public String getPasswordPropString(String string) {
        String pwdPropString = "-";
        if (string.equalsIgnoreCase("0")) {
            pwdPropString = RB.getString("adap.PolicyChangeListener.Password_must_meet_complexity_requirements");
        } else if (string.equalsIgnoreCase("1")) {
            pwdPropString = RB.getString("adap.PolicyChangeListener.Password_must_meet_complexity_requirements");
        } else if (string.equalsIgnoreCase("16")) {
            pwdPropString = RB.getString("adap.PolicyChangeListener.Password_must_meet_complexity_requirements");
        } else if (string.equalsIgnoreCase("17")) {
            pwdPropString = RB.getString("adap.PolicyChangeListener.Password_must_meet_complexity_requirements");
        }
        return pwdPropString;
    }

    @Override
    public Row getEventRow(String domainName, Hashtable<String, Object> eventTbl, Long monitorId, String objectClass, Long categoryId) throws Exception {
        Row row = super.getEventRow(domainName, eventTbl, monitorId, objectClass, categoryId);
        if (row != null) {
            Integer eventNumber = (Integer)row.get("EVENT_NUMBER");
            if (eventNumber == 643 || eventNumber == 4739) {
                row.set("MODIFIED_PROPS", (Object)this.getModPropsText(row));
            }
            row.set("FORMAT_MESSAGE", (Object)EVENT_FORMAT_MESSAGE_API.getFormatMessage(row, eventNumber, objectClass));
        }
        return row;
    }

    private String getModPropsText(Row row) {
        StringBuilder modPropsTxt = null;
        int propColumnLength = PROP_COLUMNS.length;
        for (int i = 0; i < propColumnLength; ++i) {
            String attributeValue = row.get(PROP_COLUMNS[i]).toString();
            if (attributeValue == null || attributeValue.equalsIgnoreCase("-")) continue;
            if (modPropsTxt == null) {
                modPropsTxt = new StringBuilder();
            } else {
                modPropsTxt.append(", ");
            }
            modPropsTxt.append(PROP_DISPLAY[i]);
            modPropsTxt.append("-");
            modPropsTxt.append(attributeValue);
        }
        if (modPropsTxt == null) {
            modPropsTxt = new StringBuilder("-");
        }
        return modPropsTxt.toString();
    }
}

