/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.category;

import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.EventFormatMessageAPI;
import com.adventnet.sym.adsm.auditing.server.category.DefaultCategoryListener;
import com.adventnet.sym.adsm.common.server.ntfs.FileAccessUtil;
import java.io.IOException;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class ProcessTrackingListener
extends DefaultCategoryListener {
    private static final Logger EVENT_LOGGER = Logger.getLogger("EventLogger");
    private static final EventFormatMessageAPI EVENT_FORMAT_MESSAGE_API = EventFormatMessageAPI.getInstance();
    private static StringBuffer value = null;

    @Override
    public Row getEventRow(String domainName, Hashtable<String, Object> eventTbl, Long monitorId, String objectClass, Long categoryId) throws Exception {
        Row row = super.getEventRow(domainName, eventTbl, monitorId, objectClass, categoryId);
        if (row != null) {
            Integer eventNumber;
            if (eventTbl.get("Task Content") != null || eventTbl.get("Task New Content") != null) {
                this.parseTaskContent(row, eventTbl);
            }
            if ((eventNumber = (Integer)row.get("EVENT_NUMBER")) != 560) {
                row.set("FORMAT_MESSAGE", (Object)EVENT_FORMAT_MESSAGE_API.getFormatMessage(row, eventNumber, objectClass));
            } else {
                row.set("FORMAT_MESSAGE", (Object)this.getFormatMessage(eventTbl, row));
            }
        }
        EVENT_LOGGER.log(Level.FINE, new StringBuffer().append("Row value is ::: ").append(row).toString());
        return row;
    }

    private void parseTaskContent(Row row, Hashtable<String, Object> eventTbl) throws ParserConfigurationException, SAXException, IOException {
        String xmlString = (String)eventTbl.get("Task Content");
        if (xmlString == null) {
            xmlString = (String)eventTbl.get("Task New Content");
        }
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setIgnoringElementContentWhitespace(true);
        DocumentBuilder builder = docBuilderFactory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(xmlString)));
        Element rootNode = document.getDocumentElement();
        this.setRowValueFromXML(rootNode, row);
    }

    private void setRowValueFromXML(Node node, Row row) {
        value = new StringBuffer();
        value.append("");
        String nodeName = node.getNodeName();
        String nodeValue = this.getElementValue(node);
        NodeList childNodeList = node.getChildNodes();
        if (nodeName.equalsIgnoreCase("Date")) {
            row.set("SCHEDULE_TIME", (Object)nodeValue);
        } else if (nodeName.equalsIgnoreCase("Command")) {
            row.set("APPLICATION_NAME", (Object)nodeValue);
        } else if (nodeName.equalsIgnoreCase("StartBoundary")) {
            String[] time = nodeValue.split("T");
            value.append("Starting Date ").append(time[0]).append(" , at ").append(time[1]);
        } else if (nodeName.equalsIgnoreCase("DaysInterval")) {
            if (nodeValue.equals("1")) {
                value.append(", Everyday");
            } else {
                value.append(", Every ").append(nodeValue).append(" days");
            }
        } else if (nodeName.equalsIgnoreCase("Week") || nodeName.equalsIgnoreCase("WeeksInterval")) {
            if (nodeValue.equals("1")) {
                value.append(" , Every Week");
            } else {
                value.append(" , Every ").append(nodeValue).append(" Week");
            }
        } else if (nodeName.equalsIgnoreCase("DaysOfMonth") || nodeName.equalsIgnoreCase("DaysOfWeek") || nodeName.equalsIgnoreCase("Months")) {
            value.append(" , Every ");
        } else if (nodeName.equalsIgnoreCase("Day")) {
            value.append(",").append(nodeValue);
        } else if (nodeValue.equals("") && childNodeList.getLength() == 0) {
            value.append(",").append(nodeName);
        }
        if (!value.toString().equals("")) {
            row.set("SCHEDULE_AT", (Object)value);
        }
        for (int i = 0; i < childNodeList.getLength(); ++i) {
            Node childNode = childNodeList.item(i);
            if (childNode.getNodeType() != 1) continue;
            this.setRowValueFromXML(childNode, row);
        }
    }

    private String getElementValue(Node node) {
        if (node != null && node.hasChildNodes()) {
            for (Node grandChildNode = node.getFirstChild(); grandChildNode != null; grandChildNode = grandChildNode.getNextSibling()) {
                if (grandChildNode.getNodeType() != 3) continue;
                return grandChildNode.getNodeValue();
            }
        }
        return "";
    }

    private String getFormatMessage(Hashtable<String, Object> eventTbl, Row row) {
        String formatMessage = null;
        int accessType = 0;
        Integer eventType = (Integer)row.get("EVENT_TYPE");
        String accessStr = (String)eventTbl.get("Access Mask");
        Long accesses = Long.decode(accessStr);
        if (eventType == 8) {
            if ((accesses & 1L) == 1L) {
                accessType = 1;
            } else if (accesses.equals(65536L) || (accesses & 0x10000L) == 65536L) {
                accessType = 10;
            } else if (accesses == 4L || accesses == 2L || accesses == 6L || (accesses & 4L) == 4L || (accesses & 2L) == 2L) {
                accessType = 2;
            } else if (accesses.equals(262144L) || (accesses & 0x40000L) == 262144L) {
                accessType = 3;
            }
        }
        if (accessType != 0) {
            formatMessage = new StringBuffer().append("User '").append(row.get("CALLER_USER_NAME")).append("' was ").append(FileAccessUtil.getAccessTypeString(accessType, eventType)).append(" ").append(row.get("PROCESS_NAME")).toString();
        }
        return formatMessage;
    }
}

