/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.category;

import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.EventFormatMessageAPI;
import com.adventnet.sym.adsm.auditing.server.category.DefaultCategoryListener;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SystemEventsListener
extends DefaultCategoryListener {
    private static final Logger EVENT_LOGGER = Logger.getLogger("EventLogger");
    private static final EventFormatMessageAPI EVENT_FORMAT_MESSAGE_API = EventFormatMessageAPI.getInstance();

    @Override
    public Row getEventRow(String domainName, Hashtable<String, Object> eventTbl, Long monitorId, String objectClass, Long categoryId) throws Exception {
        Row row = super.getEventRow(domainName, eventTbl, monitorId, objectClass, categoryId);
        if (row != null) {
            Integer eventNumber = (Integer)row.get("EVENT_NUMBER");
            if ((String)row.get("PREVIOUS_TIME") != null && ((String)row.get("PREVIOUS_TIME")).equals((String)row.get("NEW_TIME")) && eventNumber == 520) {
                EVENT_LOGGER.log(Level.INFO, "Both previous and end times are equal for the eventNumber " + eventNumber);
                row = null;
            } else {
                row.set("FORMAT_MESSAGE", (Object)EVENT_FORMAT_MESSAGE_API.getFormatMessage(row, eventNumber, objectClass));
            }
        }
        return row;
    }
}

