/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.category;

import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.EventFormatMessageAPI;
import com.adventnet.sym.adsm.auditing.server.category.DefaultAccountMgmtListener;
import com.adventnet.sym.adsm.auditing.server.category.FormatMessageUtil;
import com.adventnet.sym.adsm.auditing.server.category.UserTerminalServiceListener;
import com.adventnet.sym.adsm.auditing.server.reports.AuditReportAPI;
import com.adventnet.sym.adsm.auditing.server.util.ExchangeCallerUserNameUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.objects.ADAPObjectCacheAPI;
import com.adventnet.sym.adsm.common.server.schema.SchemaAPI;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.UserAttributeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.regex.Pattern;

public final class UserMgmtListener
extends DefaultAccountMgmtListener {
    private static final AdventNetResourceBundle RB = ResourceBundleMgr.getInstance().getBundle();
    private static final EventFormatMessageAPI EVENT_FORMAT_MESSAGE_API = EventFormatMessageAPI.getInstance();

    @Override
    public ArrayList<Row> getEventRowList(String domainName, Hashtable<String, Object> eventTbl, Long monitorId, String objectClass, Long categoryId) throws Exception {
        ArrayList<Row> rowList = null;
        Row row = super.getEventRow(domainName, eventTbl, monitorId, objectClass, categoryId);
        if (row != null) {
            String accountSID;
            String dcName = (String)row.get("SOURCE");
            String accountName = (String)row.get("ACCOUNT_NAME");
            Integer eventNumber = (Integer)row.get("EVENT_NUMBER");
            String sidString = null;
            String mgmtTypeAndRemarks = "-";
            rowList = new ArrayList<Row>();
            if (!(eventNumber == 566 && eventNumber == 5139 && eventNumber == 5137 && eventNumber == 5136 || (accountSID = (String)row.get("ACCOUNT_SID")) == null || accountSID.startsWith("%{"))) {
                row.set("ACCOUNT_SID", (Object)new StringBuffer().append("%{").append(accountSID).append("}").toString());
            }
            if (eventNumber.equals(566) || eventNumber.equals(5139) || eventNumber.equals(5136)) {
                Integer isArchive = (Integer)eventTbl.get("IsArchiveEvent");
                Row row1 = FormatMessageUtil.getObjectRow(domainName, accountName, "user", dcName, isArchive);
                if (row1 != null) {
                    sidString = (String)row1.get("SID_STRING");
                    sidString = new StringBuffer().append("%{").append(sidString).append("}").toString();
                    row.set("ACCOUNT_NAME", (Object)((String)row1.get("SAM_ACCOUNT_NAME")));
                    row.set("ACCOUNT_SID", (Object)sidString);
                }
                mgmtTypeAndRemarks = this.getUserMgmtText(row, eventNumber, eventTbl);
                String attributeTxt = row.get("ATTRIBUTES_TEXT") != null ? SchemaAPI.getInstance().getAttributeCommonName((String)row.get("ATTRIBUTES_TEXT")) : "-";
                row.set("ATTRIBUTES_TEXT", (Object)attributeTxt);
                row.set("USER_MGMT_TYPE", (Object)mgmtTypeAndRemarks);
                ArrayList attributeList = (ArrayList)eventTbl.get(RB.getString("adap.AUDRuleVariables.variable_name.Attributes"));
                if (attributeList != null && (attributeList.contains("bf967a0e-0de6-11d0-a285-00aa003049e2") || attributeList.contains("bf96793f-0de6-11d0-a285-00aa003049e2"))) {
                    row.set("REMARKS", (Object)mgmtTypeAndRemarks);
                } else {
                    row.set("REMARKS", (Object)RB.getString("adap.UserMgmtListener.User_Modified"));
                }
                String formatMessage = FormatMessageUtil.setFormatMessage(domainName, row, eventTbl, RB.getString("adap.ADMPObjects.display_text.User"));
                if (formatMessage != null) {
                    formatMessage = new StringBuffer().append(formatMessage).append(RB.handleGetObject("adap.DSAListener.Modified_Properties__modifiedAttributesText", new String[]{mgmtTypeAndRemarks})).toString();
                }
                row.set("FORMAT_MESSAGE", (Object)formatMessage);
                if (attributeTxt != null) {
                    Long attribCategoryId = SchemaAPI.getInstance().getAttributeCategoryId(attributeTxt);
                    row.set("ATTRIBUTE_CATEGORY_ID", (Object)attribCategoryId);
                    if (attributeTxt.equalsIgnoreCase("NT-Security-Descriptor") || attributeTxt.equalsIgnoreCase("ms-Exch-Mailbox-Security-Descriptor") || attributeTxt.equalsIgnoreCase("WRITE_DAC")) {
                        row.set("ATTRIBUTE_CATEGORY_ID", (Object)3L);
                    }
                }
                rowList.add(row);
                if (eventNumber.equals(5136)) {
                    if (eventTbl.get("ATTRIBUTES_OLD_VALUE") != null) {
                        row.set("ATTRIBUTES_OLD_VALUE", (Object)((String)eventTbl.get("ATTRIBUTES_OLD_VALUE")));
                    }
                    if (row.get("ATTRIBUTES_TEXT") != null) {
                        Boolean b;
                        Long attributeOldVal;
                        if (attributeTxt.equalsIgnoreCase("User-Account-Control")) {
                            if (row.get("ATTRIBUTES_NEW_VALUE") != null) {
                                row.set("ATTRIBUTES_NEW_VALUE", (Object)UserAttributeUtil.getUserFlagString((String)row.get("ATTRIBUTES_NEW_VALUE")));
                            }
                            if (row.get("ATTRIBUTES_OLD_VALUE") != null) {
                                row.set("ATTRIBUTES_OLD_VALUE", (Object)UserAttributeUtil.getUserFlagString((String)row.get("ATTRIBUTES_OLD_VALUE")));
                            }
                        } else if (attributeTxt.equalsIgnoreCase("NT-Security-Descriptor") || attributeTxt.equalsIgnoreCase("ms-Exch-Mailbox-Security-Descriptor")) {
                            try {
                                UserAttributeUtil.setACLChanges(rowList, domainName, attributeTxt);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        } else if (attributeTxt.equalsIgnoreCase("Account-Expires")) {
                            Long longVal = Long.MAX_VALUE;
                            if (row.get("ATTRIBUTES_NEW_VALUE") != null) {
                                Long attributeNewVal = Long.valueOf(row.get("ATTRIBUTES_NEW_VALUE").toString());
                                if (attributeNewVal.equals(0L) || attributeNewVal.equals(longVal)) {
                                    row.set("ATTRIBUTES_NEW_VALUE", (Object)RB.getString("adap.UserMgmtListener.Account_Expires_never"));
                                } else {
                                    row.set("ATTRIBUTES_NEW_VALUE", (Object)UserAttributeUtil.getAccountExpTime(attributeNewVal));
                                }
                            }
                            if (row.get("ATTRIBUTES_OLD_VALUE") != null) {
                                Long attributeOldVal2 = Long.valueOf(row.get("ATTRIBUTES_OLD_VALUE").toString());
                                if (attributeOldVal2.equals(0L) || attributeOldVal2.equals(longVal)) {
                                    row.set("ATTRIBUTES_OLD_VALUE", (Object)RB.getString("adap.UserMgmtListener.Account_Expires_never"));
                                } else {
                                    row.set("ATTRIBUTES_OLD_VALUE", (Object)UserAttributeUtil.getAccountExpTime(attributeOldVal2));
                                }
                            }
                        } else if (attributeTxt.equalsIgnoreCase("msRASSavedFramedIPAddress") || attributeTxt.equalsIgnoreCase("msRADIUSFramedIPAddress")) {
                            if (row.get("ATTRIBUTES_NEW_VALUE") != null) {
                                Long ipAddress = Long.valueOf(row.get("ATTRIBUTES_NEW_VALUE").toString());
                                row.set("ATTRIBUTES_NEW_VALUE", (Object)UserAttributeUtil.getIPAddress(ipAddress));
                            }
                            if (row.get("ATTRIBUTES_OLD_VALUE") != null) {
                                Long oldIpAddress = Long.valueOf(row.get("ATTRIBUTES_OLD_VALUE").toString());
                                row.set("ATTRIBUTES_OLD_VALUE", (Object)UserAttributeUtil.getIPAddress(oldIpAddress));
                            }
                        } else if (attributeTxt.equalsIgnoreCase("msNPAllowDialin")) {
                            if (row.get("ATTRIBUTES_NEW_VALUE") == null) {
                                row.set("ATTRIBUTES_NEW_VALUE", (Object)RB.getString("adap.UserMgmtListener.Control_access_through_NPS"));
                            }
                            if (row.get("ATTRIBUTES_OLD_VALUE") == null) {
                                row.set("ATTRIBUTES_OLD_VALUE", (Object)RB.getString("adap.UserMgmtListener.Control_access_through_NPS"));
                            }
                        } else if (attributeTxt.equalsIgnoreCase("Lockout-Time")) {
                            Long attributeNewVal;
                            if (row.get("ATTRIBUTES_NEW_VALUE") != null && !row.get("ATTRIBUTES_NEW_VALUE").toString().equals("") && !(attributeNewVal = Long.valueOf(row.get("ATTRIBUTES_NEW_VALUE").toString())).equals(0L)) {
                                row.set("ATTRIBUTES_NEW_VALUE", (Object)UserAttributeUtil.getAccountExpTime(attributeNewVal));
                            }
                            if (row.get("ATTRIBUTES_OLD_VALUE") != null && !row.get("ATTRIBUTES_OLD_VALUE").toString().equals("") && !(attributeOldVal = Long.valueOf(row.get("ATTRIBUTES_OLD_VALUE").toString())).equals(0L)) {
                                row.set("ATTRIBUTES_OLD_VALUE", (Object)UserAttributeUtil.getAccountExpTime(attributeOldVal));
                            }
                        } else if (attributeTxt.equalsIgnoreCase("User-Parameters")) {
                            String[] columnName;
                            DataAccess.generateValues((Row)row);
                            HashMap<String, Object> map = new HashMap<String, Object>();
                            map.put("OBJECT_GUID", accountName);
                            map.put("DOMAIN_NAME", domainName);
                            map.put("UNIQUE_ID", row.get("UNIQUE_ID"));
                            UserTerminalServiceListener.getInstance().addInQueue(map);
                            String userParameterPatternStr = "Ctx";
                            String userParameterPatternKeyStr = "[0-9a-zA-Z]+";
                            Pattern pattern = UserAttributeUtil.getUserParameterPattern(userParameterPatternKeyStr);
                            for (String object : columnName = new String[]{"ATTRIBUTES_NEW_VALUE", "ATTRIBUTES_OLD_VALUE"}) {
                                if (row.get(object) == null) continue;
                                String objectStr = object;
                                row.set(objectStr, (Object)"");
                            }
                        } else if (attributeTxt.equalsIgnoreCase("User-Workstations")) {
                            if (row.get("ATTRIBUTES_NEW_VALUE") == "") {
                                row.set("ATTRIBUTES_NEW_VALUE", (Object)RB.getString("adap.UserMgmtListener.All_Computers"));
                            }
                            if (row.get("ATTRIBUTES_OLD_VALUE") == null) {
                                row.set("ATTRIBUTES_OLD_VALUE", (Object)RB.getString("adap.UserMgmtListener.All_Computers"));
                            }
                        } else if (attributeTxt.equalsIgnoreCase("Pwd-Last-Set")) {
                            attributeOldVal = 0L;
                            if (row.get("ATTRIBUTES_OLD_VALUE") != null && !(attributeOldVal = Long.valueOf(row.get("ATTRIBUTES_OLD_VALUE").toString())).equals(0L)) {
                                row.set("ATTRIBUTES_OLD_VALUE", (Object)CommonUtil.getDateFromFileTime(attributeOldVal));
                            }
                        } else if (attributeTxt.equalsIgnoreCase("Primary-Group-ID")) {
                            String domainSID = AuditReportAPI.getInstance().getDomainSIDString(domainName);
                            String oldSid = (String)row.get("ATTRIBUTES_OLD_VALUE");
                            String newSid = (String)row.get("ATTRIBUTES_NEW_VALUE");
                            if (oldSid != null && !oldSid.trim().equals("")) {
                                row.set("ATTRIBUTES_OLD_VALUE", (Object)ADAPObjectCacheAPI.getInstance().getObjectNameFromSID(domainName, domainSID + "-" + oldSid, "group"));
                            }
                            if (newSid != null && !newSid.trim().equals("")) {
                                row.set("ATTRIBUTES_NEW_VALUE", (Object)ADAPObjectCacheAPI.getInstance().getObjectNameFromSID(domainName, domainSID + "-" + newSid, "group"));
                            }
                        }
                        if (!attributeTxt.equalsIgnoreCase("NT-Security-Descriptor") && !attributeTxt.equalsIgnoreCase("ms-Exch-Mailbox-Security-Descriptor") && row.get("ATTRIBUTES_NEW_VALUE") != null && row.get("ATTRIBUTES_NEW_VALUE") != "") {
                            formatMessage = new StringBuffer().append(formatMessage).append(", ").append(RB.handleGetObject("adap.DefaultAccountMgmtListener.values", new String[]{(String)row.get("ATTRIBUTES_NEW_VALUE")})).toString();
                            row.set("FORMAT_MESSAGE", (Object)formatMessage);
                        }
                        if (!(attributeTxt.equalsIgnoreCase("NT-Security-Descriptor") || attributeTxt.equalsIgnoreCase("ms-Exch-Mailbox-Security-Descriptor") || attributeTxt.equalsIgnoreCase("User-Parameters"))) {
                            if (row.get("ATTRIBUTES_OLD_VALUE") == null) {
                                row.set("REMARKS", (Object)"User Attribute Added");
                            } else if (row.get("ATTRIBUTES_NEW_VALUE") == null || row.get("ATTRIBUTES_NEW_VALUE").equals("")) {
                                row.set("REMARKS", (Object)"User Attribute Removed");
                            }
                        }
                        if (!attributeTxt.equalsIgnoreCase("User-Parameters") && (b = this.compareAttributesValue(row)).booleanValue()) {
                            rowList = null;
                        }
                    }
                }
            } else {
                rowList.add(row);
                if (accountName == null || accountName.equalsIgnoreCase("") || accountName.equalsIgnoreCase("-")) {
                    row.set("ACCOUNT_NAME", (Object)this.getUserName(domainName, row));
                }
                row.set("USER_MGMT_TYPE", (Object)this.getUserMgmtText(row, eventNumber, eventTbl));
                if (eventNumber == 4723) {
                    row.set("REMARKS", (Object)RB.getString("adap.UserMgmtListener.Change_Password_Attempt"));
                } else if (eventNumber == 4724) {
                    row.set("REMARKS", (Object)RB.getString("adap.UserMgmtListener.User_Account_password_set"));
                }
                row.set("FORMAT_MESSAGE", (Object)EVENT_FORMAT_MESSAGE_API.getFormatMessage(row, eventNumber, objectClass));
            }
            if (eventNumber != 4740) {
                ExchangeCallerUserNameUtil.getInstance().updateExchangeInfoInEventRow(row, eventTbl);
            }
        }
        return rowList;
    }
}

