/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.category;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;

public final class UserTerminalServiceListener {
    private static final AdventNetResourceBundle RB = ResourceBundleMgr.getInstance().getBundle();
    private static UserTerminalServiceListener userTerminalServiceListener = null;
    public Queue<HashMap> queue = null;
    public TSThread tsThread = null;
    public ArrayList<String> tsList = new ArrayList();
    public static String aud_ts_properties = "AudTSProperties";
    public static String aud_ts_values = "AudTSValues";
    public static String aud_ts_uniqueid_map = "AudTSUniqueIdMap";
    public static final String[] TS_PROPERTIES = new String[]{"tsIntialProgram", "tsWorkingDir", "tsProfilePath", "tsHomeDir", "tsHomeDirDrive", "tsInheritInitialProgram", "tsAllowLogon", "tsDeviceClientDrives", "tsDeviceClientPrinters", "tsDeviceClientDefaultPrinter", "tsBrokenTimeOutSettings", "tsReConnectSettings", "tsTimeOutSettingsConnections", "tsTimeOutSettingsDisConnections", "tsTimeOutSettingsIdle", "tsShadowSettings", "tsServerRemoteHomeDir"};
    public static final String[] TS_COMMON_NAME = new String[]{"Program-File-Name", "Start-In", "Profile-Path", "Local-Path", "Connect", "Start-Program-At-Logon", "Deny-User-Permissions-RDP", "Connect-Client-Drives-At-Logon", "Connect-Client-Printers-At-Logon", "Default-To-Main-Client-Printer", "Session-Limit-Reached", "Allow-Reconnection", "Active-Session-Limit", "End-Disconnected-Session", "Idle-Session-Limit", "Enable-Remote-Control", "Local-OR-UNC-Path"};
    public static final Long[] TS_PROP_ID = new Long[]{DBObjectUtil.getUVHValues(aud_ts_properties, "AudTSProperties:ts_prop_id:1"), DBObjectUtil.getUVHValues(aud_ts_properties, "AudTSProperties:ts_prop_id:2"), DBObjectUtil.getUVHValues(aud_ts_properties, "AudTSProperties:ts_prop_id:3"), DBObjectUtil.getUVHValues(aud_ts_properties, "AudTSProperties:ts_prop_id:4"), DBObjectUtil.getUVHValues(aud_ts_properties, "AudTSProperties:ts_prop_id:5"), DBObjectUtil.getUVHValues(aud_ts_properties, "AudTSProperties:ts_prop_id:6"), DBObjectUtil.getUVHValues(aud_ts_properties, "AudTSProperties:ts_prop_id:7"), DBObjectUtil.getUVHValues(aud_ts_properties, "AudTSProperties:ts_prop_id:8"), DBObjectUtil.getUVHValues(aud_ts_properties, "AudTSProperties:ts_prop_id:9"), DBObjectUtil.getUVHValues(aud_ts_properties, "AudTSProperties:ts_prop_id:10"), DBObjectUtil.getUVHValues(aud_ts_properties, "AudTSProperties:ts_prop_id:11"), DBObjectUtil.getUVHValues(aud_ts_properties, "AudTSProperties:ts_prop_id:12"), DBObjectUtil.getUVHValues(aud_ts_properties, "AudTSProperties:ts_prop_id:13"), DBObjectUtil.getUVHValues(aud_ts_properties, "AudTSProperties:ts_prop_id:14"), DBObjectUtil.getUVHValues(aud_ts_properties, "AudTSProperties:ts_prop_id:15"), DBObjectUtil.getUVHValues(aud_ts_properties, "AudTSProperties:ts_prop_id:16"), DBObjectUtil.getUVHValues(aud_ts_properties, "AudTSProperties:ts_prop_id:17")};

    private UserTerminalServiceListener() {
        try {
            this.tsList.add("TerminalService");
            this.queue = new LinkedBlockingQueue<HashMap>();
            this.tsThread = new TSThread();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UserTerminalServiceListener getInstance() {
        if (userTerminalServiceListener != null) return userTerminalServiceListener;
        Class<UserTerminalServiceListener> clazz = UserTerminalServiceListener.class;
        synchronized (UserTerminalServiceListener.class) {
            userTerminalServiceListener = new UserTerminalServiceListener();
            // ** MonitorExit[var0] (shouldn't be in output)
            return userTerminalServiceListener;
        }
    }

    public void addInQueue(HashMap map) {
        try {
            this.queue.add(map);
            if (!this.tsThread.isAlive()) {
                this.tsThread = new TSThread();
                this.tsThread.start();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void process(HashMap map) {
        try {
            String guidStr = map.get("OBJECT_GUID").toString();
            guidStr = guidStr.substring(guidStr.indexOf("{") + 1, guidStr.indexOf("}"));
            String domainName = map.get("DOMAIN_NAME").toString();
            Properties prop = ADHandler.getUserTerminalObjects(domainName, 1L, guidStr, this.tsList);
            this.addInDB(map, prop);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void addInDB(HashMap map, Properties prop) {
        try {
            Properties valProp;
            if (!prop.isEmpty() && !(valProp = (Properties)prop.get("TerminalService")).isEmpty()) {
                String guid = map.get("OBJECT_GUID").toString();
                Long oldUniquId = this.getPrewUniqueId(guid);
                DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                int i = 0;
                for (String key : TS_PROPERTIES) {
                    Object value = valProp.get(key);
                    if (value == null || value.equals("")) {
                        value = "-";
                    }
                    Row row = new Row(aud_ts_values);
                    row.set("TS_PROP_ID", (Object)TS_PROP_ID[i]);
                    row.set("UNIQUE_ID", map.get("UNIQUE_ID"));
                    row.set("VALUE", value);
                    dataObject.addRow(row);
                    ++i;
                }
                Row mapRow = new Row(aud_ts_uniqueid_map);
                mapRow.set("OBJECT_GUID", (Object)guid);
                mapRow.set("UNIQUE_ID", map.get("UNIQUE_ID"));
                mapRow.set("OLD_UNIQUE_ID", (Object)oldUniquId);
                dataObject.addRow(mapRow);
                CommonUtil.getPersistence(new boolean[0]).update(dataObject);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getPrewUniqueId(String guid) {
        Long uniqueId = 0L;
        DataSet dataSet = null;
        Connection connection = null;
        try {
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            Table table = Table.getTable((String)aud_ts_uniqueid_map);
            Criteria criteria = new Criteria(Column.getColumn((String)aud_ts_uniqueid_map, (String)"OBJECT_GUID"), (Object)guid, 0, false);
            SelectQueryImpl query = new SelectQueryImpl(table);
            query.setCriteria(criteria);
            Column col = Column.getColumn((String)aud_ts_uniqueid_map, (String)"UNIQUE_ID").maximum();
            col.setColumnAlias("UNIQUE_ID");
            query.addSelectColumn(col);
            dataSet = relationalAPI.executeQuery((Query)query, connection);
            String queryStr = relationalAPI.getSelectSQL((Query)query);
            while (dataSet.next()) {
                if (dataSet.getValue("UNIQUE_ID") == null) continue;
                uniqueId = (Long)dataSet.getValue("UNIQUE_ID");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (dataSet != null) {
                    dataSet.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
        return uniqueId;
    }

    public HashMap getDataMap(Long uniqueId) {
        HashMap map = new HashMap();
        try {
            HashMap<String, Long> critMap = new HashMap<String, Long>();
            critMap.put("UNIQUE_ID", uniqueId);
            DataObject dataObject = this.getDataObject(aud_ts_values, critMap);
            Long oldUniquId = this.getOldUniqueId(uniqueId);
            critMap.put("UNIQUE_ID", oldUniquId);
            DataObject oldDataObject = this.getDataObject(aud_ts_values, critMap);
            if (dataObject != null && !dataObject.isEmpty()) {
                Iterator iterator = dataObject.getRows(aud_ts_values);
                while (iterator.hasNext()) {
                    HashMap<String, String> valMap = new HashMap<String, String>();
                    Row row = (Row)iterator.next();
                    Long propId = (Long)row.get("TS_PROP_ID");
                    Object value = row.get("VALUE");
                    Criteria crit = new Criteria(Column.getColumn((String)aud_ts_values, (String)"TS_PROP_ID"), (Object)propId, 0);
                    Row oldRow = oldDataObject.getRow(aud_ts_values, crit);
                    Object oldValue = "-";
                    if (oldRow != null) {
                        oldValue = oldRow.get("VALUE");
                    }
                    String key = this.getTSPropName(propId, "name");
                    valMap.put("NEW_VALUE", this.getValueString(key, value.toString()));
                    valMap.put("OLD_VALUE", this.getValueString(key, oldValue.toString()));
                    String tsPropCommonName = this.getTSPropName(propId, "commonname");
                    map.put(tsPropCommonName, valMap);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return map;
    }

    public String getValueString(String key, String value) {
        String val = "-";
        try {
            if (key != null && value != null && !value.equals("-")) {
                val = key.equalsIgnoreCase("tsInheritInitialProgram") ? this.getBooleanValue(key, value) : (key.equalsIgnoreCase("tsAllowLogon") ? this.getBooleanValue(key, value) : (key.equalsIgnoreCase("tsDeviceClientDrives") ? this.getBooleanValue(key, value) : (key.equalsIgnoreCase("tsDeviceClientPrinters") ? this.getBooleanValue(key, value) : (key.equalsIgnoreCase("tsDeviceClientDefaultPrinter") ? this.getBooleanValue(key, value) : (key.equalsIgnoreCase("tsBrokenTimeOutSettings") ? this.getBooleanValue(key, value) : (key.equalsIgnoreCase("tsReConnectSettings") ? this.getBooleanValue(key, value) : (key.equalsIgnoreCase("tsShadowSettings") ? this.getMappedValue(key, value) : (key.equalsIgnoreCase("tsServerRemoteHomeDir") ? this.getMappedValue(key, value) : (key.equalsIgnoreCase("tsTimeOutSettingsConnections") ? this.getDwordValue(key, value) : (key.equalsIgnoreCase("tsTimeOutSettingsDisConnections") ? this.getDwordValue(key, value) : (key.equalsIgnoreCase("tsTimeOutSettingsIdle") ? this.getDwordValue(key, value) : value.toString())))))))))));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return val;
    }

    public String getBooleanValue(String key, String value) {
        String val = "false";
        try {
            if (key.equalsIgnoreCase("tsBrokenTimeOutSettings")) {
                val = value.equals("1") ? "The session is terminated" : "The session is disconnected";
            } else if (key.equalsIgnoreCase("tsReConnectSettings")) {
                val = value.equals("1") ? "From originating client only" : "From any client";
            } else if (value.equals("1")) {
                val = "true";
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return val;
    }

    public String getMappedValue(String key, String value) {
        String val = "-";
        try {
            val = key.equalsIgnoreCase("tsShadowSettings") ? (value.equals("0") ? "Disabled" : (value.equals("1") ? "Enabled,requires users permission,interact session" : (value.equals("2") ? "Enabled,not requires users permission,interact session" : (value.equals("3") ? "Enabled,requires users permission,view session" : "Enabled,not requires users permission,view session")))) : (value.equals("1") ? "UNC path Enabled" : "Local path Enabled");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return val;
    }

    public String getDwordValue(String key, String value) {
        String val = "Never";
        try {
            if (!value.equals("0")) {
                Long milliSecond = new Long(value);
                Long minutes = milliSecond / 60000L;
                val = minutes.equals(60L) ? "1 hour" : (minutes.equals(120L) ? "2 hours" : (minutes.equals(180L) ? "3 hours" : (minutes.equals(1440L) ? "1 day" : (minutes.equals(2880L) ? "2 days" : minutes.toString() + " minutes"))));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return val;
    }

    public Long getOldUniqueId(Long uniqueId) {
        Long oldUniqueId = 0L;
        try {
            HashMap<String, Long> critMap = new HashMap<String, Long>();
            critMap.put("UNIQUE_ID", uniqueId);
            DataObject dataObject = this.getDataObject(aud_ts_uniqueid_map, critMap);
            if (!dataObject.isEmpty()) {
                Row row = dataObject.getRow(aud_ts_uniqueid_map);
                oldUniqueId = (Long)row.get("OLD_UNIQUE_ID");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return oldUniqueId;
    }

    public String getTSPropName(Long propId, String name) {
        String tsPropName = null;
        try {
            int i = 0;
            for (Long tsPropId : TS_PROP_ID) {
                if (propId.equals(tsPropId)) {
                    tsPropName = name.equalsIgnoreCase("name") ? TS_PROPERTIES[i] : TS_COMMON_NAME[i];
                }
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return tsPropName;
    }

    public DataObject getDataObject(String tableName, HashMap critMap) {
        DataObject dataObject = null;
        try {
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)tableName));
            Criteria criteria = null;
            Set keySet = critMap.keySet();
            for (String key : keySet) {
                Object value = critMap.get(key);
                if (criteria == null) {
                    criteria = new Criteria(Column.getColumn((String)tableName, (String)key), value, 0);
                    continue;
                }
                criteria = criteria.and(new Criteria(Column.getColumn((String)tableName, (String)key), value, 0));
            }
            if (criteria != null) {
                selectQuery.setCriteria(criteria);
            }
            selectQuery.addSelectColumn(Column.getColumn((String)tableName, (String)"*"));
            dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return dataObject;
    }

    class TSThread
    extends Thread {
        private boolean shutDown = false;

        public TSThread() {
            this.setName("Users-Terminal-Services-Thread");
        }

        @Override
        public void run() {
            try {
                while (UserTerminalServiceListener.this.queue.size() > 0) {
                    for (int i = 0; i < UserTerminalServiceListener.this.queue.size(); ++i) {
                        HashMap map = UserTerminalServiceListener.this.queue.remove();
                        UserTerminalServiceListener.this.process(map);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void shutDown() {
            this.shutDown = true;
        }
    }
}

