/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.compliance;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.compliance.TemplateTableHandler;
import com.adventnet.sym.adsm.auditing.server.reports.AUDCustomViewAPI;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.sql.ADAPSQLQueryAPI;
import com.adventnet.sym.adsm.common.server.sql.FileWriterObject;
import com.adventnet.sym.adsm.common.server.sql.query.QueryBuilder;
import com.adventnet.sym.adsm.common.server.sql.query.QueryBuilderAPI;
import com.adventnet.sym.adsm.common.server.util.ADSMPersUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import com.adventnet.sym.adsm.common.server.util.TimeUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataCruncher {
    public static Logger logger = Logger.getLogger("Logger");
    public static final String[] CATEGORIES = new String[]{"AUDUserMgmtCrunch", "AUDComputerMgmtCrunch", "AUDGroupMgmtCrunch", "AUDOUMgmtCrunch", "AUDGPOMgmtCrunch", "AUDDNSAuditInfoCrunch", "AUDADOAuditInfoCrunch", "UserLogonFailuresCrunch", "MachineLogonFailuresCrunch", "ReasonLogonFailuresCrunch", "UserLogonSuccessCrunch", "MachineLogonSuccessCrunch", "LocalLogonSourceCrunch", "LocalLogonUserCrunch"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void taskCrunch(int scheduler) {
        boolean crunchCriteria = false;
        crunchCriteria = scheduler == 0 ? Boolean.parseBoolean(ADSMPersUtil.getSyMParameter("firstRefreshCrunch")) : ADSMPersUtil.getSyMParameter(TemplateTableHandler.CRUNCHPARAMS[scheduler - 1]).contains("CRUNCHING");
        if (!crunchCriteria) {
            String importCrunch = ADSMPersUtil.getSyMParameter("importCrunch");
            HashMap<String, ArrayList<String>> domainMap = DomainHandler.getConfiguredDomainsList();
            ArrayList<String> DomainNameList = domainMap.get("DomainNameList");
            ArrayList<String> DomainDnsNameList = domainMap.get("domainDnsNameList");
            ArrayList<String> DomainFlatNameList = domainMap.get("DomainFlatNameList");
            ADSMPersUtil.updateSyMParameter(TemplateTableHandler.CRUNCHPARAMS[scheduler], ADSMPersUtil.getSyMParameter(TemplateTableHandler.CRUNCHPARAMS[scheduler]) + "_CRUNCHING");
            ArrayList<String> categories = new ArrayList<String>();
            String confFile = System.getProperty("server.home") + File.separator + "conf" + File.separator + "templateTables.conf";
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(new File(confFile)));
                String category = reader.readLine();
                categories.add(category);
                while ((category = reader.readLine()) != null) {
                    categories.add(category);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    reader.close();
                }
                catch (Exception eee) {
                    eee.printStackTrace();
                }
            }
            for (int i = 0; i < DomainNameList.size(); ++i) {
                try {
                    for (int j = 0; j < categories.size(); ++j) {
                        DataCruncher.cruncher(DomainNameList.get(i), DomainFlatNameList.get(i), DomainDnsNameList.get(i), (String)categories.get(j), scheduler, importCrunch);
                    }
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (Boolean.parseBoolean(importCrunch)) {
                ADSMPersUtil.updateSyMParameter("importCrunch", "false");
            }
            ADSMPersUtil.updateSyMParameter(TemplateTableHandler.CRUNCHPARAMS[scheduler], TimeUtil.getTodayFloor().toString());
        } else if (scheduler == 0) {
            DataCruncher.oneTimeCrunch(true);
        } else {
            DataCruncher.delayCrunch(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cruncher(String domainName, String domainFlatName, String domainDnsName, String category, int scheduler, String importCrunch) {
        String unique_id = TemplateTableHandler.getDomainListEntry(domainName);
        if (unique_id != null) {
            Connection connection = null;
            Statement statement = null;
            ResultSet resultSet = null;
            HashMap<String, Object> inputMap = new HashMap<String, Object>();
            try {
                logger.log(Level.INFO, "schedule for " + domainName + " " + scheduler + " and for " + category);
                RelationalAPI relationalAPI = RelationalAPI.getInstance();
                connection = relationalAPI.getConnection();
                statement = connection.createStatement();
                resultSet = statement.executeQuery("SELECT * FROM AUDCRUNCHTABLES WHERE TABLE_NAME='" + category + "_" + unique_id + "_" + scheduler + "'");
                if (resultSet.next()) {
                    inputMap.put("scheduler", Long.valueOf(resultSet.getLong("SCHEDULER")).intValue());
                    inputMap.put("referenceTable", resultSet.getString("REFERENCE_TABLE_NAME"));
                    inputMap.put("tableName", resultSet.getString("TABLE_NAME"));
                    inputMap.put("domainFlatName", domainFlatName);
                    inputMap.put("domainDnsName", domainDnsName);
                    inputMap.put("domainName", domainName);
                    inputMap.put("importCrunch", importCrunch);
                    if (resultSet.getBoolean("SCHEDULE")) {
                        if (resultSet.getBoolean("IS_MINIMUM_SCHEDULE")) {
                            DataCruncher.minimumCruncher(category, inputMap);
                        } else {
                            DataCruncher.defaultCruncher(category, inputMap);
                        }
                    }
                }
                DataCruncher.closeConnection(connection, statement, resultSet);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                DataCruncher.closeConnection(connection, statement, resultSet);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getInputMap(String domainName, String domainFlatName, String domainDnsName, String[] lastSchedule, String importCrunch, Connection connection) {
        Statement statement = null;
        ResultSet resultSet = null;
        HashMap<String, Object> inputMap = new HashMap<String, Object>();
        Long refreshTimeCeil = System.currentTimeMillis() / 1000L - 1L;
        try {
            logger.log(Level.INFO, "refresh crunch for " + domainName);
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            statement = connection.createStatement();
            String dbServerName = CommonUtil.getDBServerName();
            resultSet = dbServerName.equalsIgnoreCase("mysql") ? statement.executeQuery("SELECT * FROM AUDCRUNCHTABLES WHERE IS_MINIMUM_SCHEDULE=TRUE AND DOMAIN_NAME='" + domainName + "'") : statement.executeQuery("SELECT * FROM AUDCRUNCHTABLES WHERE IS_MINIMUM_SCHEDULE='TRUE' AND DOMAIN_NAME='" + domainName + "'");
            while (resultSet.next()) {
                int scheduler = (int)resultSet.getLong("SCHEDULER");
                if (lastSchedule[scheduler].contains("CRUNCHING") || Long.parseLong(lastSchedule[scheduler]) >= refreshTimeCeil) continue;
                String tableName = resultSet.getString("TABLE_NAME");
                String category = tableName.substring(0, tableName.indexOf("_"));
                inputMap.put("scheduler", scheduler);
                inputMap.put("refreshTimeCeil", refreshTimeCeil);
                inputMap.put("referenceTable", resultSet.getString("REFERENCE_TABLE_NAME"));
                inputMap.put("tableName", tableName);
                inputMap.put("domainFlatName", domainFlatName);
                inputMap.put("domainDnsName", domainDnsName);
                inputMap.put("domainName", domainName);
                inputMap.put("importCrunch", importCrunch);
                if (!resultSet.getBoolean("SCHEDULE")) continue;
                DataCruncher.minimumCruncher(category, inputMap);
            }
            DataCruncher.closeConnection(null, statement, resultSet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DataCruncher.closeConnection(null, statement, resultSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshCruncher() {
        logger.log(Level.INFO, "in refresh cruncher");
        Connection connection = null;
        try {
            String[] lastSchedule = new String[]{ADSMPersUtil.getSyMParameter(TemplateTableHandler.CRUNCHPARAMS[0]), ADSMPersUtil.getSyMParameter(TemplateTableHandler.CRUNCHPARAMS[1]), ADSMPersUtil.getSyMParameter(TemplateTableHandler.CRUNCHPARAMS[2])};
            String importCrunch = ADSMPersUtil.getSyMParameter("importCrunch");
            HashMap<String, ArrayList<String>> domainMap = DomainHandler.getConfiguredDomainsList();
            ArrayList<String> DomainNameList = domainMap.get("DomainNameList");
            ArrayList<String> DomainFlatNameList = domainMap.get("DomainFlatNameList");
            ArrayList<String> DomainDnsNameList = domainMap.get("domainDnsNameList");
            for (int i = 0; i < DomainNameList.size(); ++i) {
                try {
                    DataCruncher.getInputMap(DomainNameList.get(i), DomainFlatNameList.get(i), DomainDnsNameList.get(i), lastSchedule, importCrunch, connection);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (Boolean.parseBoolean(importCrunch)) {
                ADSMPersUtil.updateSyMParameter("importCrunch", "false");
            }
            logger.log(Level.INFO, "refresh cruncher completed");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DataCruncher.closeConnection(connection, null, null);
        }
    }

    public static void minimumCruncher(String category, HashMap inputMap) {
        if (TemplateTableHandler.cvMap.containsKey(category)) {
            String[] lastSchedule = new String[]{ADSMPersUtil.getSyMParameter(TemplateTableHandler.CRUNCHPARAMS[0]), ADSMPersUtil.getSyMParameter(TemplateTableHandler.CRUNCHPARAMS[1]), ADSMPersUtil.getSyMParameter(TemplateTableHandler.CRUNCHPARAMS[2]), ADSMPersUtil.getSyMParameter(TemplateTableHandler.CRUNCHPARAMS[3]), ADSMPersUtil.getSyMParameter(TemplateTableHandler.CRUNCHPARAMS[4]), ADSMPersUtil.getSyMParameter(TemplateTableHandler.CRUNCHPARAMS[5])};
            Integer[] CVvalues = TemplateTableHandler.cvMap.get(category);
            String searchCriteria = "";
            boolean isOneTime = inputMap.containsKey("oneTimeCrunch");
            boolean isRefresh = inputMap.containsKey("refreshTimeCeil");
            Long ceil = TimeUtil.getTodayFloor();
            if (isOneTime) {
                ceil = (Long)inputMap.get("oneTimeCeil");
            }
            if (isRefresh) {
                ceil = (Long)inputMap.get("refreshTimeCeil");
            }
            int scheduler = (Integer)inputMap.get("scheduler");
            boolean isHourly = true;
            if (scheduler > 0) {
                isHourly = false;
            }
            if (isOneTime) {
                if (scheduler == 0) {
                    searchCriteria = "TIME_GENERATED>=" + (Long)inputMap.get("yestFloor") + " AND TIME_GENERATED<" + ceil;
                } else if (scheduler == 1) {
                    searchCriteria = ((Boolean)inputMap.get("oneTimeCrunch")).booleanValue() ? "TIME_GENERATED>=" + (Long)inputMap.get("lastWeekFloor") + " AND TIME_GENERATED<" + ceil : "TIME_GENERATED>=" + (Long)inputMap.get("lastWeekFloor") + " AND TIME_GENERATED<" + (Long)inputMap.get("yestFloor");
                } else if (scheduler == 2) {
                    searchCriteria = "TIME_GENERATED<" + (Long)inputMap.get("lastWeekFloor");
                }
            } else {
                searchCriteria = "TIME_GENERATED<" + ceil;
            }
            if (isOneTime) {
                if (isHourly) {
                    inputMap.put("smartCrunch", "TIME_GENERATED>=" + (Long)inputMap.get("yestFloor") + " AND ");
                } else {
                    inputMap.put("smartCrunch", "TIME_GENERATED>=" + (Long)inputMap.get("lastWeekFloor") + " AND ");
                }
            }
            for (int i = CVvalues[0].intValue(); i < CVvalues[0] + CVvalues[1]; ++i) {
                Long cvId = DBObjectUtil.getUVHValues("AUDCVConfig", "AUDCVConfig:cv_id:" + i);
                if (!DataCruncher.getEnabledStatus(cvId, (String)inputMap.get("domainName"))) continue;
                logger.log(Level.INFO, "for cvid " + cvId);
                if (i == CVvalues[0] + CVvalues[1] - 2 && (category.equalsIgnoreCase("AUDGroupMgmtCrunch") || category.equalsIgnoreCase("LocalLogonSourceCrunch")) && TemplateTableHandler.accCreationMap.containsKey(category)) {
                    inputMap.put("referenceTable", TemplateTableHandler.accCreationMap.get(category));
                }
                if (i == CVvalues[0] + CVvalues[1] - 1 && TemplateTableHandler.accCreationMap.containsKey(category)) {
                    inputMap.put("referenceTable", TemplateTableHandler.accCreationMap.get(category));
                }
                if (!isOneTime) {
                    Long referenceValue = 0L;
                    if (cvId != -1L) {
                        referenceValue = DataCruncher.getReferenceId(cvId, (String)inputMap.get("domainName"), scheduler);
                    }
                    if (referenceValue == 0L) {
                        DataCruncher.smartCrunch(cvId, inputMap, searchCriteria, scheduler, lastSchedule, false, isHourly);
                        DataCruncher.smartCrunch(cvId, inputMap, searchCriteria, scheduler, lastSchedule, true, isHourly);
                        continue;
                    }
                    DataCruncher.crunchDataTables(cvId, inputMap, searchCriteria, isOneTime, isHourly);
                    if (!Boolean.parseBoolean((String)inputMap.get("importCrunch"))) continue;
                    DataCruncher.smartCrunch(cvId, inputMap, searchCriteria, scheduler, lastSchedule, true, isHourly);
                    continue;
                }
                DataCruncher.crunchDataTables(cvId, inputMap, searchCriteria, isOneTime, isHourly);
                if (!Boolean.parseBoolean((String)inputMap.get("importCrunch"))) continue;
                DataCruncher.smartCrunch(cvId, inputMap, searchCriteria, scheduler, lastSchedule, true, isHourly);
            }
        }
    }

    public static void smartCrunch(Long cvId, HashMap inputMap, String searchCriteria, int scheduler, String[] lastSchedule, boolean isImport, boolean isHourly) {
        logger.log(Level.INFO, "in smart cruncher and isImport is " + isImport);
        String table = (String)inputMap.get("tableName");
        table = table.substring(0, table.length() - 1);
        HashMap importInputMap = inputMap;
        boolean isRefresh = importInputMap.containsKey("refreshTimeCeil");
        Long ceil = TimeUtil.getTodayFloor();
        if (isRefresh) {
            ceil = (Long)importInputMap.get("refreshTimeCeil");
        }
        if (!inputMap.containsKey("oneTimeCrunch")) {
            for (int sch = 5; sch >= scheduler; --sch) {
                String searchCriteria1 = searchCriteria;
                if (sch == 5) {
                    if (Long.parseLong(lastSchedule[sch]) > 0L) {
                        searchCriteria1 = "TIME_GENERATED<" + lastSchedule[sch];
                    } else {
                        --sch;
                    }
                }
                if (sch == 4) {
                    if (Long.parseLong(lastSchedule[sch]) > 0L && Long.parseLong(lastSchedule[sch]) > Long.parseLong(lastSchedule[sch + 1])) {
                        searchCriteria1 = "TIME_GENERATED>=" + lastSchedule[sch + 1] + " AND TIME_GENERATED<" + lastSchedule[sch];
                    } else {
                        --sch;
                    }
                }
                if (sch == 3) {
                    if (Long.parseLong(lastSchedule[sch]) > 0L && Long.parseLong(lastSchedule[sch]) > Long.parseLong(lastSchedule[sch + 1])) {
                        searchCriteria1 = "TIME_GENERATED>=" + lastSchedule[sch + 1] + " AND TIME_GENERATED<" + lastSchedule[sch];
                    } else {
                        --sch;
                    }
                }
                if (sch == 2) {
                    if (Long.parseLong(lastSchedule[sch]) > 0L && Long.parseLong(lastSchedule[sch]) > Long.parseLong(lastSchedule[sch + 1])) {
                        searchCriteria1 = "TIME_GENERATED>=" + lastSchedule[sch + 1] + " AND TIME_GENERATED<" + lastSchedule[sch];
                    } else {
                        --sch;
                    }
                }
                if (sch <= 1) {
                    if (isHourly) {
                        if (sch == 1) {
                            if (Long.parseLong(lastSchedule[sch]) > 0L && Long.parseLong(lastSchedule[sch]) > Long.parseLong(lastSchedule[sch + 1])) {
                                searchCriteria1 = "TIME_GENERATED>=" + lastSchedule[sch + 1] + " AND TIME_GENERATED<" + lastSchedule[sch];
                            } else {
                                --sch;
                            }
                        }
                        if (sch == 0) {
                            searchCriteria1 = "TIME_GENERATED>=" + lastSchedule[sch + 1] + " AND TIME_GENERATED<" + ceil;
                            importInputMap.put("smartCrunch", "TIME_GENERATED>=" + lastSchedule[sch + 1] + " AND ");
                        }
                    } else if (sch == 1) {
                        searchCriteria1 = "TIME_GENERATED>=" + lastSchedule[sch + 1] + " AND TIME_GENERATED<" + ceil;
                        importInputMap.put("smartCrunch", "TIME_GENERATED>=" + lastSchedule[sch + 1] + " AND ");
                    }
                }
                importInputMap.put("tableName", table + sch);
                importInputMap.put("scheduler", sch);
                if (isImport) {
                    DataCruncher.crunchImportTables(cvId, importInputMap, searchCriteria1, isHourly);
                    continue;
                }
                DataCruncher.crunchDataTables(cvId, importInputMap, searchCriteria1, false, isHourly);
            }
        } else if (isImport) {
            DataCruncher.crunchImportTables(cvId, importInputMap, searchCriteria, isHourly);
        }
    }

    public static void defaultCruncher(String category, HashMap inputMap) {
        logger.log(Level.INFO, "in default cruncher");
        if (TemplateTableHandler.cvMap.containsKey(category)) {
            Integer[] CVvalues = TemplateTableHandler.cvMap.get(category);
            String searchCrit = "FLOOR<" + TimeUtil.getTodayFloor();
            for (int i = CVvalues[0].intValue(); i < CVvalues[0] + CVvalues[1]; ++i) {
                Long cvId = DBObjectUtil.getUVHValues("AUDCVConfig", "AUDCVConfig:cv_id:" + i);
                if (!DataCruncher.getEnabledStatus(cvId, (String)inputMap.get("domainName"))) continue;
                ArrayList rowsList = new ArrayList();
                logger.log(Level.INFO, "for cvid " + cvId);
                Long referenceValue = DataCruncher.getReferenceId(cvId, (String)inputMap.get("domainName"), (Integer)inputMap.get("scheduler"));
                Long maxRefValue = DataCruncher.getMaxValue((String)inputMap.get("referenceTable"), searchCrit);
                String searchCriteria = "UNIQUE_ID<=" + maxRefValue;
                logger.log(Level.INFO, "get data from reference table");
                String sqlQuery = DataCruncher.getSqlQuery(cvId, false);
                sqlQuery = DataCruncher.getConstructedSqlQuery(sqlQuery, searchCriteria, inputMap, referenceValue, false, false, (String)inputMap.get("referenceTable"));
                if (!DataCruncher.getCrunchRows(sqlQuery, (String)inputMap.get("tableName"), rowsList)) continue;
                if (rowsList.size() > 0) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception ex) {
                        Thread.currentThread().interrupt();
                    }
                    FileWriterObject.getInstance().dumpRows((String)inputMap.get("tableName"), rowsList);
                }
                DataCruncher.updateReferenceValue(cvId, (String)inputMap.get("domainName"), (Integer)inputMap.get("scheduler"), maxRefValue);
            }
            if ((Integer)inputMap.get("scheduler") <= 2 && (Integer)inputMap.get("scheduler") > 0) {
                DataCruncher.deleteOldData((String)inputMap.get("referenceTable"), (Integer)inputMap.get("scheduler"));
            }
        }
    }

    public static void crunchDataTables(Long cvId, HashMap inputMap, String searchCrit, boolean isOneTime, boolean isHourly) {
        block19: {
            ArrayList rowsList = new ArrayList();
            try {
                int scheduler;
                String searchCriteria = searchCrit;
                boolean isMin = false;
                int sch = scheduler = ((Integer)inputMap.get("scheduler")).intValue();
                if (isHourly) {
                    sch = 0;
                }
                logger.log(Level.INFO, "check for normal underscore tables");
                HashMap referenceMap = DataCruncher.getReferenceTables(cvId, inputMap, sch);
                if (referenceMap == null) break block19;
                Long maxRefValue = 0L;
                if (scheduler <= 1 && (isHourly && scheduler == 0 || !isHourly)) {
                    isMin = true;
                }
                if (isOneTime) {
                    isMin = (Boolean)inputMap.get("oneTimeCrunch") != false;
                }
                if (isMin) {
                    maxRefValue = DataCruncher.getMaxValue((String)inputMap.get("referenceTable"), searchCrit);
                    logger.log(Level.FINE, "min crunch maxRefValue is " + maxRefValue);
                    searchCriteria = !inputMap.containsKey("smartCrunch") ? "UNIQUE_ID<=" + maxRefValue : (String)inputMap.get("smartCrunch") + "UNIQUE_ID<=" + maxRefValue;
                }
                String sqlQuery = DataCruncher.getSqlQuery(cvId, true);
                ArrayList indexList = (ArrayList)referenceMap.get("referenceValues");
                Long referenceValue = (Long)indexList.get(indexList.size() - 1);
                if (referenceMap.containsKey("dataTables")) {
                    ArrayList tableList = (ArrayList)referenceMap.get("dataTables");
                    for (int j = 0; j < tableList.size(); ++j) {
                        logger.log(Level.FINE, "get data from normal underscore tables " + tableList.get(j));
                        String constructedSqlQuery = DataCruncher.getConstructedSqlQuery(sqlQuery, searchCriteria, inputMap, referenceValue, true, true, (String)tableList.get(j));
                        referenceValue = (Long)indexList.get(j);
                        if (!DataCruncher.getCrunchRows(constructedSqlQuery, (String)inputMap.get("tableName"), rowsList) || j <= 0 || j % 20 != 0) continue;
                        logger.log(Level.INFO, "dumping 20 tables");
                        if (rowsList.size() > 0) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (Exception ex) {
                                Thread.currentThread().interrupt();
                            }
                            FileWriterObject.getInstance().dumpRows((String)inputMap.get("tableName"), rowsList);
                            rowsList.clear();
                        }
                        if (inputMap.containsKey("oneTimeCrunch")) {
                            if (!((Boolean)inputMap.get("oneTimeCrunch")).booleanValue()) continue;
                            DataCruncher.updateReferenceValue(cvId, (String)inputMap.get("domainName"), (Integer)inputMap.get("scheduler"), referenceValue);
                            continue;
                        }
                        if (!isMin) continue;
                        DataCruncher.updateReferenceValue(cvId, (String)inputMap.get("domainName"), sch, referenceValue);
                    }
                }
                logger.log(Level.FINE, "get data from main table from ref value= " + referenceValue);
                String constructedSqlQuery = DataCruncher.getConstructedSqlQuery(sqlQuery, searchCriteria, inputMap, referenceValue, true, true, (String)inputMap.get("referenceTable"));
                logger.log(Level.FINE, "query is\n\t " + constructedSqlQuery);
                if (!DataCruncher.getCrunchRows(constructedSqlQuery, (String)inputMap.get("tableName"), rowsList)) break block19;
                if (rowsList.size() > 0) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception ex) {
                        Thread.currentThread().interrupt();
                    }
                    FileWriterObject.getInstance().dumpRows((String)inputMap.get("tableName"), rowsList);
                }
                if (inputMap.containsKey("oneTimeCrunch")) {
                    if (((Boolean)inputMap.get("oneTimeCrunch")).booleanValue()) {
                        DataCruncher.updateReferenceValue(cvId, (String)inputMap.get("domainName"), (Integer)inputMap.get("scheduler"), maxRefValue);
                    }
                } else if (isMin) {
                    DataCruncher.updateReferenceValue(cvId, (String)inputMap.get("domainName"), sch, maxRefValue);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void crunchImportTables(Long cvId, HashMap inputMap, String searchCrit, boolean isHourly) {
        block17: {
            ArrayList rowsList = new ArrayList();
            int scheduler = (Integer)inputMap.get("scheduler");
            try {
                String searchCriteria = searchCrit;
                boolean isMin = false;
                logger.log(Level.INFO, "check for import underscore tables for " + scheduler);
                HashMap referenceMap = DataCruncher.getReferenceTables(cvId, inputMap, -1);
                if (referenceMap == null) break block17;
                Long maxRefValue = 0L;
                if (scheduler <= 1 && (isHourly && scheduler == 0 || !isHourly)) {
                    isMin = true;
                }
                if (isMin) {
                    maxRefValue = DataCruncher.getMaxValue((String)inputMap.get("referenceTable") + "_0", searchCrit);
                    logger.log(Level.FINE, "min import crunch maxRefValue is " + maxRefValue);
                    searchCriteria = !inputMap.containsKey("smartCrunch") ? "UNIQUE_ID<=" + maxRefValue : (String)inputMap.get("smartCrunch") + "UNIQUE_ID<=" + maxRefValue;
                }
                String sqlQuery = DataCruncher.getSqlQuery(cvId, true);
                ArrayList indexList = (ArrayList)referenceMap.get("referenceValues");
                Long referenceValue = (Long)indexList.get(indexList.size() - 1);
                if (referenceMap.containsKey("dataTables")) {
                    ArrayList tableList = (ArrayList)referenceMap.get("dataTables");
                    logger.log(Level.INFO, "get data from import underscore tables");
                    for (int j = 0; j < tableList.size(); ++j) {
                        String constructedSqlQuery = DataCruncher.getConstructedSqlQuery(sqlQuery, searchCriteria, inputMap, referenceValue, true, true, (String)tableList.get(j));
                        referenceValue = (Long)indexList.get(j);
                        if (!DataCruncher.getCrunchRows(constructedSqlQuery, (String)inputMap.get("tableName"), rowsList) || j <= 0 || j % 20 != 0) continue;
                        logger.log(Level.INFO, "dumping 20 import tables");
                        if (rowsList.size() > 0) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (Exception ex) {
                                Thread.currentThread().interrupt();
                            }
                            FileWriterObject.getInstance().dumpRows((String)inputMap.get("tableName"), rowsList);
                            rowsList.clear();
                        }
                        if (inputMap.containsKey("oneTimeCrunch")) {
                            if (!((Boolean)inputMap.get("oneTimeCrunch")).booleanValue()) continue;
                            DataCruncher.updateReferenceValue(cvId, (String)inputMap.get("domainName"), -1, referenceValue);
                            continue;
                        }
                        if (!isMin) continue;
                        DataCruncher.updateReferenceValue(cvId, (String)inputMap.get("domainName"), -1, referenceValue);
                    }
                }
                logger.log(Level.INFO, "get data from main import table");
                String constructedSqlQuery = DataCruncher.getConstructedSqlQuery(sqlQuery, searchCriteria, inputMap, referenceValue, true, true, (String)inputMap.get("referenceTable") + "_0");
                if (!DataCruncher.getCrunchRows(constructedSqlQuery, (String)inputMap.get("tableName"), rowsList)) break block17;
                if (rowsList.size() > 0) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception ex) {
                        Thread.currentThread().interrupt();
                    }
                    FileWriterObject.getInstance().dumpRows((String)inputMap.get("tableName"), rowsList);
                }
                if (inputMap.containsKey("oneTimeCrunch")) {
                    if (((Boolean)inputMap.get("oneTimeCrunch")).booleanValue()) {
                        DataCruncher.updateReferenceValue(cvId, (String)inputMap.get("domainName"), -1, maxRefValue);
                    }
                } else if (isMin) {
                    DataCruncher.updateReferenceValue(cvId, (String)inputMap.get("domainName"), -1, maxRefValue);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String getColumnName(int scheduler) {
        if (scheduler == 0) {
            return "HOURLY_REFERENCE_VALUE";
        }
        if (scheduler == 1) {
            return "DAILY_REFERENCE_VALUE";
        }
        if (scheduler == 2) {
            return "MONTHLY_REFERENCE_VALUE";
        }
        if (scheduler == 3) {
            return "QUARTERLY_REFERENCE_VALUE";
        }
        if (scheduler == 4) {
            return "HALFYEARLY_REFERENCE_VALUE";
        }
        if (scheduler == 5) {
            return "YEARLY_REFERENCE_VALUE";
        }
        return "IMPORT_REFERENCE_VALUE";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long getMaxValue(String referenceTable, String searchCriteria) {
        Long referenceValue;
        ResultSet resultSet;
        Statement statement;
        Connection connection;
        block4: {
            connection = null;
            statement = null;
            resultSet = null;
            referenceValue = -1L;
            try {
                RelationalAPI relationalAPI = RelationalAPI.getInstance();
                connection = relationalAPI.getConnection();
                statement = connection.createStatement();
                resultSet = statement.executeQuery("SELECT MAX(UNIQUE_ID) AS REFERENCE_MIN,(SELECT MAX(UNIQUE_ID) FROM " + referenceTable + " WHERE " + searchCriteria + ") AS REFERENCE FROM " + referenceTable);
                resultSet.next();
                referenceValue = resultSet.getLong("REFERENCE");
                if (referenceValue != 0L) break block4;
                referenceValue = resultSet.getLong("REFERENCE_MIN");
                logger.log(Level.FINE, "reference returned null. so the min unique id is got --> " + referenceValue);
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    DataCruncher.closeConnection(connection, statement, resultSet);
                    throw throwable;
                }
                DataCruncher.closeConnection(connection, statement, resultSet);
            }
        }
        DataCruncher.closeConnection(connection, statement, resultSet);
        return referenceValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteOldData(String referenceTable, Integer scheduler) {
        Statement statement;
        Connection connection;
        block4: {
            connection = null;
            statement = null;
            try {
                RelationalAPI relationalAPI = RelationalAPI.getInstance();
                connection = relationalAPI.getConnection();
                statement = connection.createStatement();
                Long referenceValue = DataCruncher.getMaxValue(referenceTable, "FLOOR<" + TimeUtil.getTodayFloor());
                if (referenceValue == -1L) break block4;
                Long floorVal = 0L;
                floorVal = scheduler == 1 ? TimeUtil.getFromFloor(scheduler - 1) : TimeUtil.getFromFloor(scheduler);
                statement.executeUpdate("DELETE FROM " + referenceTable + " WHERE UNIQUE_ID<=" + referenceValue + " AND FLOOR<" + floorVal);
                logger.log(Level.INFO, "deleted values less than " + floorVal + " in table " + referenceTable);
            }
            catch (Exception ex) {
                try {
                    ex.printStackTrace();
                }
                catch (Throwable throwable) {
                    DataCruncher.closeConnection(connection, statement, null);
                    throw throwable;
                }
                DataCruncher.closeConnection(connection, statement, null);
            }
        }
        DataCruncher.closeConnection(connection, statement, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateReferenceValue(Long cvId, String domainName, int scheduler, Long maxRefValue) {
        Statement statement;
        Connection connection;
        block4: {
            connection = null;
            statement = null;
            try {
                RelationalAPI relationalAPI = RelationalAPI.getInstance();
                connection = relationalAPI.getConnection();
                statement = connection.createStatement();
                if (maxRefValue == -1L) break block4;
                statement.executeUpdate("UPDATE AUDCrunchTableReference SET " + DataCruncher.getColumnName(scheduler) + "=" + maxRefValue + " WHERE DOMAIN_NAME='" + domainName + "' AND CV_ID=" + cvId);
                logger.log(Level.INFO, "the column " + DataCruncher.getColumnName(scheduler) + " for " + cvId + " and " + domainName + " is updated to value of " + maxRefValue);
            }
            catch (Exception ex) {
                try {
                    ex.printStackTrace();
                }
                catch (Throwable throwable) {
                    DataCruncher.closeConnection(connection, statement, null);
                    throw throwable;
                }
                DataCruncher.closeConnection(connection, statement, null);
            }
        }
        DataCruncher.closeConnection(connection, statement, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getCrunchRows(String sqlQuery, String tableName, ArrayList rowsList) {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        boolean result = false;
        try {
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(sqlQuery);
            if (!resultSet.next()) {
                logger.log(Level.INFO, "NO values found ");
            } else {
                ResultSetMetaData rsMetaData = resultSet.getMetaData();
                int columnCount = rsMetaData.getColumnCount();
                ArrayList<String> headerList = new ArrayList<String>();
                logger.log(Level.INFO, "values are found ");
                for (int i = 1; i <= columnCount; ++i) {
                    headerList.add(rsMetaData.getColumnLabel(i).trim());
                }
                do {
                    Row row = new Row(tableName);
                    for (int i = 0; i < columnCount; ++i) {
                        if ((((String)headerList.get(i)).contains("name") || ((String)headerList.get(i)).contains("NAME") || ((String)headerList.get(i)).contains("sid") || ((String)headerList.get(i)).contains("SID") || ((String)headerList.get(i)).contains("error_code") || ((String)headerList.get(i)).contains("ERROR_CODE") || ((String)headerList.get(i)).contains("logon_type") || ((String)headerList.get(i)).contains("LOGON_TYPE") || ((String)headerList.get(i)).contains("source") || ((String)headerList.get(i)).contains("SOURCE")) && (!((String)headerList.get(i)).contains("bad_username") || !((String)headerList.get(i)).contains("BAD_USERNAME"))) {
                            row.set(((String)headerList.get(i)).toUpperCase(), (Object)resultSet.getString(((String)headerList.get(i)).toUpperCase()));
                            continue;
                        }
                        try {
                            row.set(((String)headerList.get(i)).toUpperCase(), (Object)resultSet.getLong(((String)headerList.get(i)).toUpperCase()));
                            continue;
                        }
                        catch (Exception ex) {
                            logger.log(Level.INFO, (String)headerList.get(i) + " is not LONG. so getting it as string");
                            row.set(((String)headerList.get(i)).toUpperCase(), (Object)resultSet.getString(((String)headerList.get(i)).toUpperCase()));
                        }
                    }
                    rowsList.add(row);
                } while (resultSet.next());
            }
            result = true;
        }
        catch (Exception ex) {
            try {
                result = false;
                logger.log(Level.INFO, "error executing query :   " + sqlQuery);
                ex.printStackTrace();
            }
            catch (Throwable throwable) {
                DataCruncher.closeConnection(connection, statement, resultSet);
                throw throwable;
            }
            DataCruncher.closeConnection(connection, statement, resultSet);
        }
        DataCruncher.closeConnection(connection, statement, resultSet);
        return result;
    }

    public static String getSqlQuery(Long cvId, boolean isMinCrunch) {
        String constructedSQL = null;
        try {
            DataObject cvDO = AUDCustomViewAPI.getInstance().getCustomViewDO(cvId);
            if (cvDO.size("AUDSQLQuery") > 0) {
                Row row = cvDO.getRow("AUDSQLQuery");
                if (isMinCrunch) {
                    constructedSQL = (String)row.get("SQL_STRING");
                    if (constructedSQL.contains("${PATTERNREPLACE")) {
                        QueryBuilder queryBuilder = QueryBuilderAPI.getInstance().getQueryBuilder();
                        constructedSQL = queryBuilder.replaceFunctionPattern(constructedSQL);
                    }
                } else {
                    constructedSQL = (String)row.get("COUNT_SQL_STRING");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return constructedSQL;
    }

    public static String getConstructedSqlQuery(String sqlQuery, String searchCriteria, HashMap inputMap, Long referenceValue, boolean isMinCrunch, boolean isImportTable, String tableName) {
        String constructedSQL = sqlQuery;
        try {
            if (searchCriteria == null) {
                searchCriteria = "1=1";
            }
            if (isMinCrunch) {
                if (!isImportTable) {
                    constructedSQL = constructedSQL.replace("${REFERENCE}", "0");
                    constructedSQL = constructedSQL.replace("${SCRITERIA}", searchCriteria);
                    while (constructedSQL.contains("${REFERENCE}")) {
                        constructedSQL = constructedSQL.replace("${REFERENCE}", referenceValue.toString());
                    }
                } else {
                    constructedSQL = constructedSQL.replace("${SCRITERIA}", searchCriteria);
                    constructedSQL = constructedSQL.replace("${REFERENCE}", referenceValue.toString());
                }
                constructedSQL = constructedSQL.replace("${TABLENAME}", tableName);
                constructedSQL = constructedSQL.replace("${DOMAIN}", (String)inputMap.get("domainDnsName"));
                constructedSQL = constructedSQL.replace("${DOMAINFLAT}", (String)inputMap.get("domainFlatName"));
                while (constructedSQL.contains("${TIMEFLOOR}")) {
                    constructedSQL = constructedSQL.replace("${TIMEFLOOR}", ADAPSQLQueryAPI.getInstance().getMinCrunchTimeValue("TIME_GENERATED", TimeUtil.getTimeZoneOffset(), (Integer)inputMap.get("scheduler")));
                }
            } else {
                constructedSQL = constructedSQL.replace("${SCRITERIA}", searchCriteria);
                constructedSQL = constructedSQL.replace("${TABLENAME}", tableName);
                constructedSQL = constructedSQL.replace("${REFERENCE}", referenceValue.toString());
                while (constructedSQL.contains("${TIMEFLOOR}")) {
                    constructedSQL = constructedSQL.replace("${TIMEFLOOR}", ADAPSQLQueryAPI.getInstance().getMinCrunchTimeValue("FLOOR", TimeUtil.getTimeZoneOffset(), (Integer)inputMap.get("scheduler")));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return constructedSQL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap getReferenceTables(Long cvId, HashMap inputMap, int scheduler) {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        String domainName = (String)inputMap.get("domainName");
        String referenceTable = (String)inputMap.get("referenceTable");
        if (scheduler == -1) {
            referenceTable = referenceTable + "_0";
        }
        Long referenceValue = 0L;
        HashMap referenceMap = new HashMap();
        ArrayList<String> tableList = new ArrayList<String>();
        ArrayList<Long> endindexList = new ArrayList<Long>();
        boolean getReference = true;
        if (inputMap.containsKey("oneTimeCrunch") && !((Boolean)inputMap.get("oneTimeCrunch")).booleanValue()) {
            getReference = false;
        }
        if (cvId != -1L && getReference) {
            referenceValue = DataCruncher.getReferenceId(cvId, domainName, scheduler);
        }
        try {
            if (referenceValue != -1L) {
                String sqlQuery = "SELECT LOOKUP_TABLENAME,END_INDEX,START_INDEX FROM AUDMETATABLE WHERE TABLE_NAME='" + referenceTable + "' AND STATUS='SUCCESS' AND END_INDEX>" + referenceValue + " ORDER BY START_INDEX";
                RelationalAPI relationalAPI = RelationalAPI.getInstance();
                connection = relationalAPI.getConnection();
                statement = connection.createStatement();
                resultSet = statement.executeQuery(sqlQuery);
                if (!resultSet.isBeforeFirst()) {
                    logger.log(Level.INFO, "NO Data tables for " + referenceTable);
                } else {
                    Long previousIndex = 0L;
                    while (resultSet.next()) {
                        tableList.add(resultSet.getString("LOOKUP_TABLENAME"));
                        Long endIndex = resultSet.getLong("END_INDEX");
                        if (endIndex > previousIndex) {
                            endindexList.add(endIndex);
                        } else {
                            endindexList.add(resultSet.getLong("START_INDEX") - 1L);
                        }
                        previousIndex = endIndex;
                    }
                    referenceMap.put("dataTables", tableList);
                }
                endindexList.add(referenceValue);
                referenceMap.put("referenceValues", endindexList);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            DataCruncher.closeConnection(connection, statement, resultSet);
        }
        return referenceMap;
    }

    public static void closeConnection(Connection connection, Statement statement, ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException se) {
            se.printStackTrace();
        }
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException se) {
            se.printStackTrace();
        }
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException se) {
            se.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long getReferenceId(Long cvId, String domainName, int scheduler) {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        Long referenceValue = -1L;
        String columnName = DataCruncher.getColumnName(scheduler);
        try {
            String sqlQuery = "SELECT " + columnName + " FROM AUDCrunchTableReference WHERE DOMAIN_NAME='" + domainName + "' AND CV_ID=" + cvId;
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(sqlQuery);
            if (resultSet.next()) {
                referenceValue = resultSet.getLong(columnName);
            }
            logger.log(Level.FINE, "ref val for cvid " + cvId + " and domain " + domainName + " and sch - " + scheduler + " is " + referenceValue);
            DataCruncher.closeConnection(connection, statement, resultSet);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            DataCruncher.closeConnection(connection, statement, resultSet);
        }
        return referenceValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getEnabledStatus(Long cvId, String domainName) {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        boolean isEnabled = true;
        String columnName = "IS_ENABLED";
        try {
            String sqlQuery = "SELECT " + columnName + " FROM AUDCrunchTableReference WHERE DOMAIN_NAME='" + domainName + "' AND CV_ID=" + cvId;
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(sqlQuery);
            if (resultSet.next()) {
                isEnabled = resultSet.getBoolean(columnName);
            }
            DataCruncher.closeConnection(connection, statement, resultSet);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            DataCruncher.closeConnection(connection, statement, resultSet);
        }
        return isEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delayCrunch(int scheduler) {
        Connection connection = null;
        Statement statement = null;
        String[] scheduleList = new String[]{"Schedule:schedule_id:UVH@6001", "Schedule:schedule_id:UVH@6002", "Schedule:schedule_id:UVH@6003", "Schedule:schedule_id:UVH@6004", "Schedule:schedule_id:UVH@6005", "Schedule:schedule_id:UVH@6006"};
        Long schedule_id = DBObjectUtil.getUVHValues("Schedule", scheduleList[scheduler]);
        try {
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            statement = connection.createStatement();
            statement.executeUpdate("UPDATE TASK_INPUT SET SCHEDULE_TIME='" + TimeUtil.getDelayedCrunchTime() + "' WHERE SCHEDULE_ID='" + schedule_id + "'");
            logger.log(Level.INFO, "scheduler " + scheduler + " is delayed by 30 min");
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                DataCruncher.closeConnection(connection, statement, null);
                throw throwable;
            }
            DataCruncher.closeConnection(connection, statement, null);
        }
        DataCruncher.closeConnection(connection, statement, null);
    }

    public static String categoryString(ArrayList<Integer> list) {
        String str = list.get(0).toString();
        for (int i = 1; i < list.size(); ++i) {
            str = str + ";" + list.get(i);
        }
        if (!str.contains(";-1")) {
            str = str + ";-1";
        }
        return str;
    }

    public static ArrayList<Integer> categoryStringToList(String str) {
        String[] strArray = str.split(";");
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < strArray.length; ++i) {
            list.add(Integer.parseInt(strArray[i]));
        }
        return list;
    }

    public static boolean isCategoryReset(String category, String str) {
        ArrayList<Integer> list = DataCruncher.categoryStringToList(str);
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) == -1 || !CATEGORIES[list.get(i)].equals(category)) continue;
            return true;
        }
        return false;
    }

    public static void updateCrunchReset(int category) {
        String crunchReset = ADSMPersUtil.getSyMParameter("isCrunchReset");
        ArrayList<Integer> list = DataCruncher.categoryStringToList(crunchReset);
        list.remove(new Integer(category));
        crunchReset = DataCruncher.categoryString(list);
        ADSMPersUtil.updateSyMParameter("isCrunchReset", crunchReset);
    }

    public static void oneTimeCrunch(boolean isNew) {
        logger.log(Level.INFO, "in one time cruncher");
        Thread t = Thread.currentThread();
        t.setName("Crunch Thread");
        logger.log(Level.INFO, "priority was :: " + t.getPriority());
        t.setPriority(8);
        logger.log(Level.INFO, "priority is :: " + t.getPriority());
        logger.log(Level.INFO, "Thread = " + t);
        int count = Thread.activeCount();
        logger.log(Level.INFO, "currently active threads = " + count);
        String resetCrunch = ADSMPersUtil.getSyMParameter("isCrunchReset");
        boolean isReset = false;
        boolean isAllReset = true;
        if (!resetCrunch.equalsIgnoreCase("false")) {
            isReset = true;
            if (!resetCrunch.equalsIgnoreCase("true")) {
                isAllReset = false;
            }
        }
        if (isReset) {
            DataCruncher.resetCrunchTableValues(resetCrunch);
        }
        HashMap<String, ArrayList<String>> domainMap = DomainHandler.getConfiguredDomainsList();
        ArrayList<String> DomainNameList = domainMap.get("DomainNameList");
        ArrayList<String> DomainFlatNameList = domainMap.get("DomainFlatNameList");
        ArrayList<String> DomainDnsNameList = domainMap.get("domainDnsNameList");
        Long yestFloor = TimeUtil.getFromFloor(0);
        Long lastWeekFloor = TimeUtil.getFromFloor(2);
        String importCrunch = ADSMPersUtil.getSyMParameter("importCrunch");
        ADSMPersUtil.updateSyMParameter(TemplateTableHandler.CRUNCHPARAMS[0], ADSMPersUtil.getSyMParameter(TemplateTableHandler.CRUNCHPARAMS[0]) + "_CRUNCHING");
        ADSMPersUtil.updateSyMParameter(TemplateTableHandler.CRUNCHPARAMS[1], ADSMPersUtil.getSyMParameter(TemplateTableHandler.CRUNCHPARAMS[1]) + "_CRUNCHING");
        ADSMPersUtil.updateSyMParameter(TemplateTableHandler.CRUNCHPARAMS[2], ADSMPersUtil.getSyMParameter(TemplateTableHandler.CRUNCHPARAMS[2]) + "_CRUNCHING");
        ArrayList<Integer> categoryList = DataCruncher.getCategoryPriority();
        if (!isReset || isAllReset) {
            ADSMPersUtil.updateSyMParameter("isCrunchReset", DataCruncher.categoryString(categoryList));
        }
        for (int k = 0; k < categoryList.size(); ++k) {
            boolean categoryReset = true;
            if (isReset && !isAllReset) {
                categoryReset = DataCruncher.isCategoryReset(CATEGORIES[categoryList.get(k)], resetCrunch);
            }
            if (categoryReset) {
                for (int i = 0; i < DomainNameList.size(); ++i) {
                    try {
                        DataCruncher.getOneTimeInputMap(DomainNameList.get(i), DomainFlatNameList.get(i), DomainDnsNameList.get(i), CATEGORIES[categoryList.get(k)], yestFloor, lastWeekFloor, importCrunch);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                logger.log(Level.INFO, "skipped category :: " + CATEGORIES[categoryList.get(k)]);
            }
            if (!isReset) continue;
            DataCruncher.updateCrunchReset(categoryList.get(k));
        }
        ADSMPersUtil.updateSyMParameter(TemplateTableHandler.CRUNCHPARAMS[0], TimeUtil.getTodayFloor().toString());
        ADSMPersUtil.updateSyMParameter(TemplateTableHandler.CRUNCHPARAMS[1], yestFloor.toString());
        ADSMPersUtil.updateSyMParameter(TemplateTableHandler.CRUNCHPARAMS[2], lastWeekFloor.toString());
        if (isNew) {
            ADSMPersUtil.updateSyMParameter("firstRefreshCrunch", "false");
        }
        if (Boolean.parseBoolean(importCrunch)) {
            ADSMPersUtil.updateSyMParameter("importCrunch", "false");
        }
        if (isReset) {
            ADSMPersUtil.updateSyMParameter("isCrunchReset", "false");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> getmetaTablePriority() {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            String sqlQuery = "SELECT TABLE_NAME,COUNT(*) AS COUNT FROM AUDMETATABLE WHERE TABLE_NAME NOT LIKE '%_0' AND TABLE_NAME IN ('AUDLOGONINFO', 'AUDLOGONLOGOFFINFO', 'AUDNPSAUDITINFO', 'AUDADOAUDITINFO', 'AUDGPOMGMT', 'AUDUSERMGMT', 'AUDCOMPUTERMGMT', 'AUDGROUPMGMT', 'AUDDNSAUDITINFO','AUDOUMGMT','AUDACCOUNTCREATION') GROUP BY TABLE_NAME ORDER BY COUNT ASC";
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(sqlQuery);
            while (resultSet.next()) {
                list.add(resultSet.getString("TABLE_NAME"));
            }
        }
        catch (Exception ex) {
            try {
                ex.printStackTrace();
            }
            catch (Throwable throwable) {
                DataCruncher.closeConnection(connection, statement, resultSet);
                throw throwable;
            }
            DataCruncher.closeConnection(connection, statement, resultSet);
        }
        DataCruncher.closeConnection(connection, statement, resultSet);
        return list;
    }

    public static ArrayList<Integer> getCategoryPriority() {
        ArrayList<String> metaList = DataCruncher.getmetaTablePriority();
        ArrayList<Integer> categoryList = new ArrayList<Integer>();
        for (int i = 0; i < metaList.size(); ++i) {
            for (int j = 0; j < CATEGORIES.length; ++j) {
                if (!TemplateTableHandler.tableMap.containsKey(CATEGORIES[j]) || !TemplateTableHandler.tableMap.get(CATEGORIES[j]).equals(metaList.get(i))) continue;
                categoryList.add(j);
            }
        }
        return categoryList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getOneTimeInputMap(String domainName, String domainFlatName, String domainDnsName, String categories, Long yestFloor, Long lastWeekFloor, String importCrunch) {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        HashMap<String, Object> inputMap = new HashMap<String, Object>();
        try {
            logger.log(Level.INFO, "one time crunch for " + domainName);
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            statement = connection.createStatement();
            String dbServerName = CommonUtil.getDBServerName();
            Long currentCeil = System.currentTimeMillis() / 1000L - 1L;
            resultSet = dbServerName.equalsIgnoreCase("mysql") ? statement.executeQuery("SELECT * FROM AUDCRUNCHTABLES WHERE TABLE_NAME LIKE '%" + categories + "%' AND SCHEDULER IN(0,1,2) AND SCHEDULE=TRUE AND DOMAIN_NAME='" + domainName + "' ORDER BY SCHEDULER") : statement.executeQuery("SELECT * FROM AUDCRUNCHTABLES WHERE TABLE_NAME LIKE '%" + categories + "%' AND SCHEDULER IN(0,1,2) AND SCHEDULE='TRUE' AND DOMAIN_NAME='" + domainName + "' ORDER BY SCHEDULER");
            while (resultSet.next()) {
                int scheduler = (int)resultSet.getLong("SCHEDULER");
                String tableName = resultSet.getString("TABLE_NAME");
                String category = tableName.substring(0, tableName.indexOf("_"));
                if (TemplateTableHandler.tableMap.containsKey(category)) {
                    inputMap.put("referenceTable", TemplateTableHandler.tableMap.get(category));
                }
                inputMap.put("scheduler", scheduler);
                inputMap.put("tableName", tableName);
                inputMap.put("domainFlatName", domainFlatName);
                inputMap.put("domainDnsName", domainDnsName);
                inputMap.put("domainName", domainName);
                inputMap.put("yestFloor", yestFloor);
                inputMap.put("importCrunch", "true");
                inputMap.put("lastWeekFloor", lastWeekFloor);
                inputMap.put("oneTimeCrunch", resultSet.getBoolean("IS_MINIMUM_SCHEDULE"));
                inputMap.put("oneTimeCeil", currentCeil);
                DataCruncher.minimumCruncher(category, inputMap);
            }
            DataCruncher.closeConnection(connection, statement, resultSet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DataCruncher.closeConnection(connection, statement, resultSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getAllDomainListEntries() {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        ArrayList<String> domainList = new ArrayList<String>();
        try {
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery("SELECT DOMAIN_ID FROM AUDDomainList");
            while (resultSet.next()) {
                domainList.add(resultSet.getString("DOMAIN_ID"));
            }
            logger.log(Level.INFO, "domain IDs got " + domainList);
        }
        catch (Exception eee) {
            try {
                eee.printStackTrace();
            }
            catch (Throwable throwable) {
                DataCruncher.closeConnection(connection, statement, resultSet);
                throw throwable;
            }
            DataCruncher.closeConnection(connection, statement, resultSet);
        }
        DataCruncher.closeConnection(connection, statement, resultSet);
        return domainList;
    }

    public static void resetCrunchParams() {
        ADSMPersUtil.updateSyMParameter("refreshCrunch", "false");
        for (int i = 0; i < 6; ++i) {
            boolean isCrunching = ADSMPersUtil.getSyMParameter(TemplateTableHandler.CRUNCHPARAMS[i]).contains("CRUNCHING");
            String crunchValue = "";
            if (!isCrunching) continue;
            crunchValue = ADSMPersUtil.getSyMParameter(TemplateTableHandler.CRUNCHPARAMS[i]);
            crunchValue = crunchValue.substring(0, crunchValue.indexOf("_"));
            ADSMPersUtil.updateSyMParameter(TemplateTableHandler.CRUNCHPARAMS[i], crunchValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetCrunchTableReferences(String template) {
        Connection connection = null;
        Statement statement = null;
        try {
            String cvids = "";
            if (TemplateTableHandler.cvMap.containsKey(template)) {
                Integer[] CVvalues = TemplateTableHandler.cvMap.get(template);
                for (int i = CVvalues[0].intValue(); i < CVvalues[0] + CVvalues[1]; ++i) {
                    Long cvId = DBObjectUtil.getUVHValues("AUDCVConfig", "AUDCVConfig:cv_id:" + i);
                    cvids = cvids + "'" + cvId + "'";
                    if (i >= CVvalues[0] + CVvalues[1] - 1) continue;
                    cvids = cvids + ",";
                }
            }
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            statement = connection.createStatement();
            statement.executeUpdate("UPDATE AUDCRUNCHTABLEREFERENCE SET HOURLY_REFERENCE_VALUE=0, DAILY_REFERENCE_VALUE=0, MONTHLY_REFERENCE_VALUE=0, QUARTERLY_REFERENCE_VALUE=0, HALFYEARLY_REFERENCE_VALUE=0, YEARLY_REFERENCE_VALUE=0, IMPORT_REFERENCE_VALUE=0 WHERE CV_ID IN (" + cvids + ")");
            logger.log(Level.INFO, "crunch table references are reset for " + template);
            DataCruncher.closeConnection(connection, statement, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DataCruncher.closeConnection(connection, statement, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteTableData(String templateInstance) {
        Connection connection = null;
        Statement statement = null;
        try {
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            statement = connection.createStatement();
            statement.executeUpdate("DELETE FROM " + templateInstance);
            logger.log(Level.INFO, "crunch table references are reset");
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                DataCruncher.closeConnection(connection, statement, null);
                throw throwable;
            }
            DataCruncher.closeConnection(connection, statement, null);
        }
        DataCruncher.closeConnection(connection, statement, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetCrunchTableValues(String resetCrunch) {
        ArrayList DomainIdList = DataCruncher.getAllDomainListEntries();
        boolean isAllReset = true;
        if (!resetCrunch.equalsIgnoreCase("true")) {
            isAllReset = false;
        }
        if (DomainIdList.size() > 0) {
            String confFile = System.getProperty("server.home") + File.separator + "conf" + File.separator + "templateTables.conf";
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(new File(confFile)));
                String template = null;
                String instance = null;
                template = reader.readLine();
                while ((template = reader.readLine()) != null) {
                    boolean categoryReset = true;
                    if (!isAllReset) {
                        categoryReset = DataCruncher.isCategoryReset(template, resetCrunch);
                    }
                    if (!categoryReset) continue;
                    for (int i = 0; i < TemplateTableHandler.CRUNCHPARAMS.length; ++i) {
                        for (int j = 0; j < DomainIdList.size(); ++j) {
                            try {
                                instance = (String)DomainIdList.get(j) + "_" + i;
                                String templateInstance = template + "_" + instance;
                                DataCruncher.deleteTableData(templateInstance);
                                logger.log(Level.INFO, "The template instance " + template + "_" + instance + " was reset successfully. ");
                                continue;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    DataCruncher.resetCrunchTableReferences(template);
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
            finally {
                try {
                    reader.close();
                }
                catch (Exception eee) {
                    eee.printStackTrace();
                }
            }
        }
    }

    public static void createCrunchTemplateInstances() {
        boolean crunchCriteria = Boolean.parseBoolean(ADSMPersUtil.getSyMParameter("createTemplateInstances"));
        if (crunchCriteria) {
            ArrayList domainList = DomainHandler.getConfiguredList(1L);
            for (Object object : domainList) {
                Properties properties = (Properties)object;
                String domainName = properties.getProperty("DOMAIN_NAME");
                try {
                    TemplateTableHandler.createAll(domainName);
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
            ADSMPersUtil.updateSyMParameter("createTemplateInstances", "false");
        }
    }
}

