/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.compliance;

import com.adventnet.db.persistence.metadata.ColumnDefinition;
import com.adventnet.db.persistence.metadata.TableDefinition;
import com.adventnet.db.persistence.metadata.util.MetaDataUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.compliance.DataCruncher;
import com.adventnet.sym.adsm.common.server.sql.FileWriterObject;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TemplateTableHandler {
    public static Logger logger = Logger.getLogger("Logger");
    public static String[] tables = new String[]{"hourly", "daily", "monthly", "quarterly", "halfyearly", "yearly"};
    public static HashMap<String, String> tableMap = new HashMap();
    public static HashMap<String, String> accCreationMap = new HashMap();
    public static HashMap<String, Integer> scheduleMap = new HashMap();
    public static HashMap<String, Integer[]> cvMap = new HashMap();
    public static HashMap<String, Integer[]> cvEnabledMap = new HashMap();
    public static final String[] CRUNCHPARAMS = new String[]{"HOURLY_LAST_CRUNCH", "DAILY_LAST_CRUNCH", "MONTHLY_LAST_CRUNCH", "QUARTERLY_LAST_CRUNCH", "HALFYEARLY_LAST_CRUNCH", "YEARLY_LAST_CRUNCH"};
    public static final int HOURLY = 0;
    public static final int DAILY = 1;
    public static final int MONTHLY = 2;
    public static final int QUARTERLY = 3;
    public static final int HALFYEARLY = 4;
    public static final int YEARLY = 5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createAll(String domainName) {
        String uniqueId = TemplateTableHandler.putDomainListEntry(domainName);
        if (uniqueId != null) {
            String confFile = System.getProperty("server.home") + File.separator + "conf" + File.separator + "templateTables.conf";
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(new File(confFile)));
                String template = null;
                String instance = null;
                String reference = null;
                int min_schedule = 0;
                boolean min_value = false;
                boolean schedule = false;
                Object insertquery = null;
                DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                logger.log(Level.INFO, "The domain is " + domainName);
                template = reader.readLine();
                while ((template = reader.readLine()) != null) {
                    if (tableMap.containsKey(template)) {
                        reference = tableMap.get(template);
                    }
                    if (scheduleMap.containsKey(template)) {
                        min_schedule = scheduleMap.get(template);
                    }
                    schedule = false;
                    for (int i = 0; i < tables.length; ++i) {
                        try {
                            instance = uniqueId + "_" + i;
                            logger.log(Level.INFO, "The template is " + template + " and instance is " + instance);
                            DataAccess.createTableInstance((String)template, (String)instance, null);
                            if (i == min_schedule) {
                                min_value = true;
                                schedule = true;
                            } else {
                                min_value = false;
                            }
                            Row row1 = new Row("AUDCrunchTables");
                            row1.set("DOMAIN_NAME", (Object)domainName);
                            row1.set("TABLE_NAME", (Object)(template + "_" + instance));
                            row1.set("SCHEDULER", (Object)i);
                            row1.set("IS_MINIMUM_SCHEDULE", (Object)min_value);
                            row1.set("SCHEDULE", (Object)schedule);
                            row1.set("REFERENCE_TABLE_NAME", (Object)reference);
                            dataObject.addRow(row1);
                            if (i >= min_schedule) {
                                reference = template + "_" + instance;
                            }
                            logger.log(Level.INFO, "The template instance " + template + "_" + instance + " was created successfully. ");
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    TemplateTableHandler.addToCrunchTableReference(domainName, template);
                }
                CommonUtil.getPersistence(new boolean[0]).add(dataObject);
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
            finally {
                try {
                    reader.close();
                }
                catch (Exception eee) {
                    eee.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAll(String domainName) {
        String uniqueId = TemplateTableHandler.getDomainListEntry(domainName);
        if (uniqueId != null) {
            String confFile = System.getProperty("server.home") + File.separator + "conf" + File.separator + "templateTables.conf";
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(new File(confFile)));
                String template = null;
                String instance = null;
                logger.log(Level.INFO, "The domain is " + domainName);
                template = reader.readLine();
                while ((template = reader.readLine()) != null) {
                    for (int i = 0; i < tables.length; ++i) {
                        try {
                            instance = uniqueId + "_" + i;
                            DataAccess.dropTableInstance((String)template, (String)instance);
                            logger.log(Level.INFO, "The template instance " + template + "_" + instance + " was dropped successfully. ");
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
            finally {
                try {
                    reader.close();
                }
                catch (Exception eee) {
                    eee.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createCrunchTemplateInstances() {
        ArrayList DomainIdList = DataCruncher.getAllDomainListEntries();
        if (DomainIdList.size() > 0) {
            String confFile = System.getProperty("server.home") + File.separator + "conf" + File.separator + "templateTables.conf";
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(new File(confFile)));
                String template = null;
                String instance = null;
                template = reader.readLine();
                while ((template = reader.readLine()) != null) {
                    for (int i = 0; i < tables.length; ++i) {
                        for (int j = 0; j < DomainIdList.size(); ++j) {
                            try {
                                instance = (String)DomainIdList.get(j) + "_" + i;
                                DataAccess.createTableInstance((String)template, (String)instance, null);
                                logger.log(Level.INFO, "The template instance " + template + "_" + instance + " was created successfully. ");
                                continue;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
            finally {
                try {
                    reader.close();
                }
                catch (Exception eee) {
                    eee.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAllTables() {
        ArrayList DomainIdList = DataCruncher.getAllDomainListEntries();
        if (DomainIdList.size() > 0) {
            String confFile = System.getProperty("server.home") + File.separator + "conf" + File.separator + "templateTables.conf";
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(new File(confFile)));
                String template = null;
                String instance = null;
                template = reader.readLine();
                while ((template = reader.readLine()) != null) {
                    for (int i = 0; i < tables.length; ++i) {
                        for (int j = 0; j < DomainIdList.size(); ++j) {
                            try {
                                instance = (String)DomainIdList.get(j) + "_" + i;
                                DataAccess.dropTableInstance((String)template, (String)instance);
                                logger.log(Level.INFO, "The template instance " + template + "_" + instance + " was dropped successfully. ");
                                continue;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
            finally {
                try {
                    reader.close();
                }
                catch (Exception eee) {
                    eee.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getTemplateInstanceList() {
        ArrayList DomainIdList = DataCruncher.getAllDomainListEntries();
        ArrayList<String> templateInstanceList = new ArrayList<String>();
        if (DomainIdList.size() > 0) {
            String confFile = System.getProperty("server.home") + File.separator + "conf" + File.separator + "templateTables.conf";
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(new File(confFile)));
                String template = null;
                Object instance = null;
                template = reader.readLine();
                while ((template = reader.readLine()) != null) {
                    for (int i = 0; i < DomainIdList.size(); ++i) {
                        for (int j = 0; j < tables.length; ++j) {
                            templateInstanceList.add(template + "_" + (String)DomainIdList.get(i) + "_" + j);
                        }
                    }
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
            finally {
                try {
                    reader.close();
                }
                catch (Exception eee) {
                    eee.printStackTrace();
                }
            }
        }
        return templateInstanceList;
    }

    public static String putDomainListEntry(String domainName) {
        String uniqueId = null;
        TableDefinition tableDefinition = null;
        ColumnDefinition uvhColumnDefinition = null;
        try {
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            tableDefinition = MetaDataUtil.getTableDefinitionByName((String)"AUDDomainList");
            uvhColumnDefinition = tableDefinition.getColumnDefinitionByName("DOMAIN_ID");
            if (uvhColumnDefinition.getUniqueValueGeneration() != null) {
                uniqueId = FileWriterObject.generateValue(uvhColumnDefinition.getUniqueValueGeneration().getGeneratorName(), tableDefinition);
                Row row1 = new Row("AUDDomainList");
                row1.set("DOMAIN_ID", (Object)Long.parseLong(uniqueId));
                row1.set("DOMAIN_NAME", (Object)domainName);
                dataObject.addRow(row1);
                CommonUtil.getPersistence(new boolean[0]).add(dataObject);
            }
        }
        catch (Exception eee) {
            eee.printStackTrace();
        }
        return uniqueId;
    }

    public static String getDomainListEntry(String domainName) {
        String uniqueId = null;
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"AUDDomainList", (String)"DOMAIN_NAME"), (Object)domainName, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDDomainList", crit);
            logger.log(Level.INFO, "the col is " + Column.getColumn((String)"AUDDomainList", (String)"DOMAIN_NAME") + " and domain is " + domainName);
            Row row1 = dataObject.getFirstRow("AUDDomainList");
            uniqueId = row1.get("DOMAIN_ID").toString();
        }
        catch (Exception eee) {
            eee.printStackTrace();
        }
        return uniqueId;
    }

    public static void addToCrunchTableReference(String domainName, String template) {
        try {
            if (cvMap.containsKey(template)) {
                Integer[] CVvalues = cvMap.get(template);
                DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                for (int i = CVvalues[0].intValue(); i < CVvalues[0] + CVvalues[1]; ++i) {
                    String value = "AUDCVConfig:cv_id:" + i;
                    logger.log(Level.INFO, "the string is " + value);
                    Row row2 = new Row("AUDCrunchTableReference");
                    row2.set("DOMAIN_NAME", (Object)domainName);
                    row2.set("CV_ID", (Object)DBObjectUtil.getUVHValues("AUDCVConfig", value));
                    row2.set("HOURLY_REFERENCE_VALUE", (Object)0L);
                    row2.set("DAILY_REFERENCE_VALUE", (Object)0L);
                    row2.set("MONTHLY_REFERENCE_VALUE", (Object)0L);
                    row2.set("QUARTERLY_REFERENCE_VALUE", (Object)0L);
                    row2.set("HALFYEARLY_REFERENCE_VALUE", (Object)0L);
                    row2.set("YEARLY_REFERENCE_VALUE", (Object)0L);
                    row2.set("IMPORT_REFERENCE_VALUE", (Object)0L);
                    row2.set("IS_ENABLED", (Object)true);
                    dataObject.addRow(row2);
                }
                CommonUtil.getPersistence(new boolean[0]).add(dataObject);
            }
        }
        catch (Exception eee) {
            eee.printStackTrace();
        }
    }

    public static boolean isenabled(int cvid, String template) {
        if (cvEnabledMap.containsKey(template)) {
            Integer[] disabledValues = cvEnabledMap.get(template);
            for (int j = 0; j < disabledValues.length; ++j) {
                if (cvid != disabledValues[j]) continue;
                return false;
            }
        }
        return true;
    }

    static {
        tableMap.put("AUDUserMgmtCrunch", "AUDUserMgmt");
        tableMap.put("AUDComputerMgmtCrunch", "AUDComputerMgmt");
        tableMap.put("AUDGroupMgmtCrunch", "AUDGroupMgmt");
        tableMap.put("AUDOUMgmtCrunch", "AUDOUMgmt");
        tableMap.put("AUDGPOMgmtCrunch", "AUDGPOMgmt");
        tableMap.put("AUDDNSAuditInfoCrunch", "AUDDNSAuditInfo");
        tableMap.put("AUDADOAuditInfoCrunch", "AUDADOAuditInfo");
        tableMap.put("UserLogonFailuresCrunch", "AUDLogonInfo");
        tableMap.put("MachineLogonFailuresCrunch", "AUDLogonInfo");
        tableMap.put("ReasonLogonFailuresCrunch", "AUDLogonInfo");
        tableMap.put("UserLogonSuccessCrunch", "AUDLogonInfo");
        tableMap.put("MachineLogonSuccessCrunch", "AUDLogonInfo");
        tableMap.put("LocalLogonSourceCrunch", "AUDLogonLogoffInfo");
        tableMap.put("LocalLogonUserCrunch", "AUDLogonLogoffInfo");
        accCreationMap.put("AUDUserMgmtCrunch", "AUDAccountCreation");
        accCreationMap.put("AUDComputerMgmtCrunch", "AUDAccountCreation");
        accCreationMap.put("AUDGroupMgmtCrunch", "AUDAccountCreation");
        accCreationMap.put("LocalLogonSourceCrunch", "AUDNPSAuditInfo");
        scheduleMap.put("AUDUserMgmtCrunch", 1);
        scheduleMap.put("AUDComputerMgmtCrunch", 1);
        scheduleMap.put("AUDGroupMgmtCrunch", 1);
        scheduleMap.put("AUDOUMgmtCrunch", 1);
        scheduleMap.put("AUDGPOMgmtCrunch", 1);
        scheduleMap.put("AUDDNSAuditInfoCrunch", 1);
        scheduleMap.put("AUDADOAuditInfoCrunch", 1);
        scheduleMap.put("UserLogonFailuresCrunch", 0);
        scheduleMap.put("MachineLogonFailuresCrunch", 0);
        scheduleMap.put("ReasonLogonFailuresCrunch", 0);
        scheduleMap.put("UserLogonSuccessCrunch", 0);
        scheduleMap.put("MachineLogonSuccessCrunch", 0);
        scheduleMap.put("LocalLogonSourceCrunch", 0);
        scheduleMap.put("LocalLogonUserCrunch", 0);
        cvMap.put("AUDUserMgmtCrunch", new Integer[]{51201, 21});
        cvMap.put("AUDComputerMgmtCrunch", new Integer[]{51301, 12});
        cvMap.put("AUDGroupMgmtCrunch", new Integer[]{51401, 18});
        cvMap.put("AUDOUMgmtCrunch", new Integer[]{51501, 8});
        cvMap.put("AUDGPOMgmtCrunch", new Integer[]{51601, 5});
        cvMap.put("AUDDNSAuditInfoCrunch", new Integer[]{51701, 10});
        cvMap.put("AUDADOAuditInfoCrunch", new Integer[]{51801, 11});
        cvMap.put("UserLogonFailuresCrunch", new Integer[]{51901, 1});
        cvMap.put("MachineLogonFailuresCrunch", new Integer[]{51902, 1});
        cvMap.put("ReasonLogonFailuresCrunch", new Integer[]{51903, 1});
        cvMap.put("UserLogonSuccessCrunch", new Integer[]{51904, 1});
        cvMap.put("MachineLogonSuccessCrunch", new Integer[]{51905, 1});
        cvMap.put("LocalLogonSourceCrunch", new Integer[]{52001, 5});
        cvMap.put("LocalLogonUserCrunch", new Integer[]{52006, 4});
        cvEnabledMap.put("AUDUserMgmtCrunch", new Integer[]{51203, 51205, 51208});
        cvEnabledMap.put("AUDComputerMgmtCrunch", new Integer[]{51303, 51305});
        cvEnabledMap.put("AUDGroupMgmtCrunch", new Integer[]{51406, 51408});
        cvEnabledMap.put("AUDOUMgmtCrunch", new Integer[]{51504});
        cvEnabledMap.put("AUDGPOMgmtCrunch", new Integer[]{51604});
        cvEnabledMap.put("AUDDNSAuditInfoCrunch", new Integer[]{51704, 51707});
        cvEnabledMap.put("AUDADOAuditInfoCrunch", new Integer[]{51807});
    }
}

