/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.config;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class GlobalExcludeConfig {
    private static volatile GlobalExcludeConfig instance = null;
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private static Logger logger = Logger.getLogger(GlobalExcludeConfig.class.getName());
    public String[] machineTypeStrings = new String[]{"Domain Controller", "Member Server", "File Server"};
    public Integer[] machineTypeIds = new Integer[]{1, 16, 4};
    public String[] operatorStrings = new String[]{"Equals", "Not Equals", "StartsWith", "EndsWith", "Contains"};
    public Integer[] operatorIds = new Integer[]{1, 2, 7, 8, 13};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GlobalExcludeConfig getInstance() {
        if (instance != null) return instance;
        Class<GlobalExcludeConfig> clazz = GlobalExcludeConfig.class;
        synchronized (GlobalExcludeConfig.class) {
            if (instance != null) return instance;
            instance = new GlobalExcludeConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private GlobalExcludeConfig() {
    }

    public static Criteria getSearchCriteria(JSONObject reportReqData, ArrayList<HashMap<String, Object>> tableAllColumnList) throws Exception {
        JSONObject searchData = null;
        Criteria criteria = null;
        if (reportReqData.has("searchData")) {
            searchData = reportReqData.getJSONObject("searchData");
            for (HashMap<String, Object> tableconfig : tableAllColumnList) {
                String columnValue = tableconfig.get("columnalias").toString();
                String tableAlias = tableconfig.get("tablealias").toString();
                if (!searchData.has(columnValue)) continue;
                String columnSearchValue = searchData.get(columnValue).toString();
                tableconfig.put("searchValue", searchData.get(columnValue).toString());
                if (columnSearchValue == null || columnSearchValue.equalsIgnoreCase("")) continue;
                if (criteria == null) {
                    criteria = new Criteria(Column.getColumn((String)tableAlias, (String)columnValue), (Object)columnSearchValue, 12);
                    continue;
                }
                criteria = criteria.and(new Criteria(Column.getColumn((String)tableAlias, (String)columnValue), (Object)columnSearchValue, 12));
            }
        }
        return criteria;
    }

    public Integer getExcludeDataCount(JSONObject excludeTableInputParams, ArrayList<HashMap<String, Object>> tableAllColumnList) throws Exception {
        Integer count = 0;
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"AUDExcludeRules"));
        Criteria criteria = GlobalExcludeConfig.getSearchCriteria(excludeTableInputParams, tableAllColumnList);
        if (criteria != null) {
            query.setCriteria(criteria);
            excludeTableInputParams.put("isSearch", true);
        } else {
            excludeTableInputParams.put("isSearch", false);
        }
        query.addSelectColumn(Column.getColumn((String)"AUDExcludeRules", (String)"*"));
        DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
        count = dataObj.size("AUDExcludeRules");
        return count;
    }

    public ArrayList<HashMap<String, Object>> getExcludeData(JSONObject excludeTableInputParams, ArrayList<HashMap<String, Object>> tableAllColumnList) throws Exception {
        ArrayList<HashMap<String, Object>> serverList = new ArrayList<HashMap<String, Object>>();
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"AUDExcludeRules"));
        Criteria criteria = GlobalExcludeConfig.getSearchCriteria(excludeTableInputParams, tableAllColumnList);
        if (criteria != null) {
            query.setCriteria(criteria);
        }
        SortColumn sortCol = null;
        if (excludeTableInputParams.has("sortColumn") && excludeTableInputParams.has("sortOrder")) {
            sortCol = excludeTableInputParams.getString("sortOrder").equalsIgnoreCase("desc") ? new SortColumn(Column.getColumn((String)excludeTableInputParams.getString("sortTableName"), (String)excludeTableInputParams.getString("sortColumn")), false) : new SortColumn(Column.getColumn((String)excludeTableInputParams.getString("sortTableName"), (String)excludeTableInputParams.getString("sortColumn")), true);
        }
        query.addSortColumn(sortCol);
        Integer count = excludeTableInputParams.getInt("totalCount");
        Integer range = excludeTableInputParams.getInt("rangeValue");
        Integer fromIndex = excludeTableInputParams.getInt("startValue");
        Integer innerTopVal = fromIndex - 1 + range;
        if (count > 0 && count < innerTopVal) {
            range = count % range;
        }
        Range obj = new Range(fromIndex.intValue(), range.intValue());
        query.addSortColumn(sortCol);
        query.setRange(obj);
        query.addSelectColumn(Column.getColumn((String)"AUDExcludeRules", (String)"*"));
        DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
        try {
            Iterator iter = dataObj.getRows("AUDExcludeRules");
            while (iter.hasNext()) {
                Row row = (Row)iter.next();
                HashMap<String, Object> msProps = new HashMap<String, Object>();
                msProps.put("RULE_ID", (Long)row.get("RULE_ID"));
                msProps.put("EVENT_NUMBER", (Integer)row.get("EVENT_NUMBER"));
                msProps.put("VARIABLE_NAME", rb.getString((String)row.get("VARIABLE_NAME")));
                msProps.put("VARIABLE_ID", (String)row.get("VARIABLE_NAME"));
                msProps.put("VALUE", (String)row.get("VALUE"));
                msProps.put("OPERATOR", (Integer)row.get("OPERATOR"));
                msProps.put("MACHINE_TYPE", (Integer)row.get("MACHINE_TYPE"));
                serverList.add(msProps);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return serverList;
    }

    public JSONArray getVariableList() throws Exception {
        JSONArray variablesList = new JSONArray();
        Table table = Table.getTable((String)"AUDRuleVariables");
        SelectQueryImpl selectQuery = new SelectQueryImpl(table);
        selectQuery.addSelectColumn(Column.getColumn((String)"AUDRuleVariables", (String)"*"));
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
        Iterator iterator = dataObject.getRows("AUDRuleVariables");
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            JSONObject hashtable = new JSONObject();
            hashtable.put("name", (Object)rb.getString((String)row.get("VARIABLE_DISPLAY_NAME")));
            hashtable.put("value", (Object)((String)row.get("VARIABLE_NAME")));
            variablesList.put((Object)hashtable);
        }
        return variablesList;
    }

    public JSONArray getEventNumberist() throws Exception {
        JSONArray variablesList = new JSONArray();
        Table table = Table.getTable((String)"AUDEventId");
        SelectQueryImpl selectQuery = new SelectQueryImpl(table);
        selectQuery.addSelectColumn(Column.getColumn((String)"AUDEventId", (String)"*"));
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
        Iterator iterator = dataObject.getRows("AUDEventId");
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            JSONObject hashtable = new JSONObject();
            hashtable.put("name", row.get("EVENT_NUMBER"));
            hashtable.put("value", row.get("EVENT_NUMBER"));
            variablesList.put((Object)hashtable);
        }
        return variablesList;
    }

    public JSONArray getOperatorList() throws Exception {
        JSONArray variablesList = new JSONArray();
        for (int i = 0; i < this.operatorStrings.length; ++i) {
            JSONObject hashtable = new JSONObject();
            hashtable.put("name", (Object)this.operatorStrings[i]);
            hashtable.put("value", (Object)this.operatorIds[i]);
            variablesList.put((Object)hashtable);
        }
        return variablesList;
    }

    public JSONArray getMachineTypeList() throws Exception {
        JSONArray variablesList = new JSONArray();
        for (int i = 0; i < this.machineTypeStrings.length; ++i) {
            JSONObject hashtable = new JSONObject();
            hashtable.put("name", (Object)this.machineTypeIds[i]);
            hashtable.put("value", (Object)this.machineTypeStrings[i]);
            hashtable.put("selected", true);
            variablesList.put((Object)hashtable);
        }
        return variablesList;
    }
}

