/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.config;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.sym.adsm.auditing.server.delegation.AuditDelegationUtil;
import com.adventnet.sym.adsm.auditing.server.fileaudit.FileServerHandler;
import com.adventnet.sym.adsm.auditing.server.fileaudit.emc.EMCHandler;
import com.adventnet.sym.adsm.auditing.server.fileaudit.netapp.NetAppHandler;
import com.adventnet.sym.adsm.auditing.server.fileaudit.netapp.NetAppVserverDBHandler;
import com.adventnet.sym.adsm.common.server.EventCollectorHandler;
import com.adventnet.sym.adsm.common.server.sql.ADAPSQLQueryUtil;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;

public class ServerConfigAPI {
    public static final String COMP_DETAILS_TABLE = "ADSMComputerGeneralDetails";
    public static final String EVENT_DETAILS_TABLE = "AUDComputerEventRead";
    private static final String[] TABLE_NAMES = new String[]{"AUDComputerEventRead", "AUDComputerEventRead", "AUDComputerEventRead", "AUDComputerEventRead", "AUDComputerEventRead", "AUDComputerEventRead", "AUDComputerEventRead", "AUDComputerEventRead", "AUDComputerEventRead", "ADSMComputerGeneralDetails", "ADSMComputerGeneralDetails", "ADSMComputerGeneralDetails", "ADSMComputerGeneralDetails", "ADSMComputerGeneralDetails"};
    private static final String[] COLUMN_NAMES = new String[]{"RECENT_EVENT_TIME", "SCHEDULE_ID", "STATUS", "TIME_PERIOD", "TIME_READ", "COMPUTER_ID", "MESSAGE", "MACHINE_TYPE", "ISINHERITED", "DOMAIN_NAME", "NAME", "OBJECT_GUID", "SID_STRING", "DISTINGUISHED_NAME"};

    public static int getConfiguredServerCount(int[] machineType, boolean isAdapAlone) {
        int count = 0;
        StringBuilder queryBuilder = new StringBuilder("SELECT COUNT(*) FROM AUDComputerEventRead WHERE (");
        for (int i = 0; i < machineType.length; ++i) {
            if (i > 0) {
                queryBuilder.append(" OR ");
            }
            queryBuilder.append("MACHINE_TYPE&");
            queryBuilder.append(machineType[i]);
            queryBuilder.append("=");
            queryBuilder.append(machineType[i]);
            if (!isAdapAlone) continue;
            queryBuilder.append(" AND ISINHERITED=0");
        }
        queryBuilder.append(")");
        count = QueryUtil.getRowsCount(queryBuilder.toString());
        return count;
    }

    public static int getConfiguredServerCount(int[] machineType) {
        return ServerConfigAPI.getConfiguredServerCount(machineType, true);
    }

    public static boolean isConfiguredSyncedDevice(String objectGuid) {
        boolean isSyncedDevice = false;
        String query = "SELECT COUNT(*) FROM AUDComputerEventRead WHERE OBJECT_GUID='" + objectGuid + "'  AND (MACHINE_TYPE &16=16) AND ISINHERITED=1";
        if (QueryUtil.getRowsCount(query) > 0) {
            isSyncedDevice = true;
        }
        return isSyncedDevice;
    }

    public static int getConfiguredInheritedHostCount(int[] machineType, Object sourceProduct) {
        int count = 0;
        StringBuilder queryBuilder = new StringBuilder("SELECT COUNT(*) FROM AUDComputerEventRead WHERE (");
        for (int i = 0; i < machineType.length; ++i) {
            if (i > 0) {
                queryBuilder.append(" OR ");
            }
            queryBuilder.append("MACHINE_TYPE&");
            queryBuilder.append(machineType[i]);
            queryBuilder.append("=");
            queryBuilder.append(machineType[i]);
            queryBuilder.append(" AND ISINHERITED=1");
            queryBuilder.append(" AND SOURCE_PRODUCT='" + sourceProduct + "'");
        }
        queryBuilder.append(")");
        count = QueryUtil.getRowsCount(queryBuilder.toString());
        return count;
    }

    public static int getPrintMemberServerCount(int machineType, boolean isAdapAlone) {
        int count = 0;
        try {
            String dbServerName = CommonUtil.getDBServerName();
            StringBuilder queryBuilder = new StringBuilder("SELECT COUNT(*) FROM AUDComputerEventRead WHERE MACHINE_TYPE&" + machineType + "=" + machineType + " AND OBJECT_GUID IN (SELECT OBJECT_GUID FROM AUDPrinterDetails ");
            queryBuilder.append("WHERE IS_ENABLED=" + (dbServerName.equalsIgnoreCase("mssql") ? "1" : "TRUE") + ")");
            if (isAdapAlone) {
                queryBuilder.append(" AND ISINHERITED=0");
            }
            count = QueryUtil.getRowsCount(queryBuilder.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return count;
    }

    public static int getPrintMemberServerCount(int machineType) {
        return ServerConfigAPI.getPrintMemberServerCount(machineType, true);
    }

    public static int getPrintServerCount() {
        int count = 0;
        try {
            String dbServerName = CommonUtil.getDBServerName();
            StringBuilder queryBuilder = new StringBuilder("SELECT COUNT(DISTINCT(OBJECT_GUID)) FROM AUDPrinterDetails WHERE IS_ENABLED=" + (dbServerName.equalsIgnoreCase("mssql") ? "1" : "TRUE"));
            count = QueryUtil.getRowsCount(queryBuilder.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return count;
    }

    public static int getConfiguredServerCount(String domainName, String searchCriteria, String searchMsgCriteria, int[] machineType, Boolean gpoStatus) {
        int count = 0;
        StringBuilder queryBuilder = new StringBuilder("SELECT COUNT(*) FROM AUDComputerEventRead JOIN ADSMComputerGeneralDetails ON AUDComputerEventRead.OBJECT_GUID = ADSMComputerGeneralDetails.OBJECT_GUID WHERE(");
        for (int i = 0; i < machineType.length; ++i) {
            if (i > 0) {
                queryBuilder.append(" OR ");
            }
            queryBuilder.append("AUDComputerEventRead.MACHINE_TYPE&");
            queryBuilder.append(machineType[i]);
            queryBuilder.append("=");
            queryBuilder.append(machineType[i]);
        }
        queryBuilder.append(")");
        queryBuilder.append(" AND (ADSMComputerGeneralDetails.DOMAIN_NAME='");
        queryBuilder.append(domainName);
        queryBuilder.append("')");
        if (searchCriteria != null) {
            queryBuilder.append(" AND (ADSMComputerGeneralDetails.");
            queryBuilder.append(searchCriteria);
            queryBuilder.append(")");
        }
        if (searchMsgCriteria != null) {
            queryBuilder.append(" AND (AUDComputerEventRead.");
            queryBuilder.append(searchMsgCriteria);
            queryBuilder.append(")");
        }
        if (gpoStatus != null) {
            queryBuilder.append(" AND (AUDComputerEventRead.GPO_STATUS='");
            queryBuilder.append(gpoStatus);
            queryBuilder.append("') ");
        }
        count = QueryUtil.getRowsCount(queryBuilder.toString());
        return count;
    }

    public static boolean isConfiguredMemberServer(String objectGuid) {
        return ServerConfigAPI.isConfiguredMemberServer(objectGuid, true);
    }

    public static boolean isConfiguredMemberServer(String objectGuid, boolean isAdapAlone) {
        boolean isMemberServer = false;
        String query = "SELECT COUNT(*) FROM AUDComputerEventRead WHERE OBJECT_GUID='" + objectGuid + "' AND (MACHINE_TYPE &16=16 OR MACHINE_TYPE&32=32)";
        if (isAdapAlone) {
            query = query + " AND ISINHERITED=0";
        }
        if (QueryUtil.getRowsCount(query) > 0) {
            isMemberServer = true;
        }
        return isMemberServer;
    }

    public static boolean isEnabledPrintServer(Object msId) {
        boolean isPrintServer = false;
        String dbServerName = CommonUtil.getDBServerName();
        String query = "SELECT COUNT(DISTINCT(OBJECT_GUID)) FROM AUDPrinterDetails WHERE OBJECT_GUID IN (SELECT OBJECT_GUID  FROM AUDComputerEventRead WHERE COMPUTER_ID=" + msId + ") AND IS_ENABLED=" + (dbServerName.equalsIgnoreCase("mssql") ? "1" : "TRUE");
        if (QueryUtil.getRowsCount(query) > 0) {
            isPrintServer = true;
        }
        return isPrintServer;
    }

    public static boolean isEnableddMemberServer(String objectGuid, boolean isAdapAlone) {
        boolean isMemberServer = false;
        String query = "SELECT COUNT(*) FROM AUDComputerEventRead WHERE OBJECT_GUID='" + objectGuid + "' AND (MACHINE_TYPE &16=16)";
        if (isAdapAlone) {
            query = query + " AND ISINHERITED=0";
        }
        if (QueryUtil.getRowsCount(query) > 0) {
            isMemberServer = true;
        }
        return isMemberServer;
    }

    public static boolean isEnableddMemberServer(String objectGuid) {
        return ServerConfigAPI.isEnableddMemberServer(objectGuid, true);
    }

    public static boolean isConfiguredPrintServer(String objectGuid) {
        boolean isPrintServer = false;
        String dbServerName = CommonUtil.getDBServerName();
        String query = "SELECT COUNT(*) FROM AUDPrinterDetails WHERE OBJECT_GUID='" + objectGuid + "' AND  IS_ENABLED=" + (dbServerName.equalsIgnoreCase("mssql") ? "1" : "TRUE");
        if (QueryUtil.getRowsCount(query) > 0) {
            isPrintServer = true;
        }
        return isPrintServer;
    }

    public static boolean isConfiguredFileServer(String objectGuid) {
        return ServerConfigAPI.isConfiguredFileServer(objectGuid, true);
    }

    public static boolean isConfiguredFileServer(String objectGuid, boolean isAdapAlone) {
        boolean isMemberServer = false;
        String query = "SELECT COUNT(*) FROM AUDComputerEventRead WHERE OBJECT_GUID='" + objectGuid + "' AND (MACHINE_TYPE&4=4 OR MACHINE_TYPE&8=8)";
        if (isAdapAlone) {
            query = query + " AND ISINHERITED=0";
        }
        if (QueryUtil.getRowsCount(query) > 0) {
            isMemberServer = true;
        }
        return isMemberServer;
    }

    public static boolean isConfiguredClusterServer(String objectGuid) {
        boolean isMemberServer = false;
        String query = "SELECT COUNT(*) FROM AUDComputerEventRead WHERE OBJECT_GUID='" + objectGuid + "' AND (MACHINE_TYPE &64=64 OR MACHINE_TYPE&128=128)";
        if (QueryUtil.getRowsCount(query) > 0) {
            isMemberServer = true;
        }
        return isMemberServer;
    }

    public static boolean isConfiguredNetAppFiler(String objectGuid) {
        boolean isMemberServer = false;
        String query = "SELECT COUNT(*) FROM AUDComputerEventRead WHERE OBJECT_GUID='" + objectGuid + "' AND (MACHINE_TYPE &256=256 OR MACHINE_TYPE&512=512)";
        if (QueryUtil.getRowsCount(query) > 0) {
            isMemberServer = true;
        }
        return isMemberServer;
    }

    public static boolean isConfiguredEMCServer(String objectGuid) {
        boolean isMemberServer = false;
        String query = "SELECT COUNT(*) FROM AUDComputerEventRead WHERE OBJECT_GUID='" + objectGuid + "' AND (MACHINE_TYPE&131072=131072 OR MACHINE_TYPE&262144=262144)";
        if (QueryUtil.getRowsCount(query) > 0) {
            isMemberServer = true;
        }
        return isMemberServer;
    }

    public static boolean isConfiguredEvntCollector(String objectGuid) {
        boolean isMemberServer = false;
        String query = "SELECT COUNT(*) FROM AUDComputerEventRead WHERE OBJECT_GUID='" + objectGuid + "' AND (MACHINE_TYPE&1024=1024 OR MACHINE_TYPE&2048=2048)";
        if (QueryUtil.getRowsCount(query) > 0) {
            isMemberServer = true;
        }
        return isMemberServer;
    }

    public static boolean isFileServerEnabled(String serverName) {
        boolean isFileServerEnabled = false;
        String query = "SELECT COUNT(*) FROM AUDComputerEventRead JOIN ADSMComputerGeneralDetails on AUDComputerEventRead.OBJECT_GUID = ADSMComputerGeneralDetails.OBJECT_GUID WHERE ADSMComputerGeneralDetails.NAME='" + serverName + "' AND (AUDComputerEventRead.MACHINE_TYPE&4=4 OR AUDComputerEventRead.MACHINE_TYPE&256=256 " + "OR AUDComputerEventRead.MACHINE_TYPE&" + 524288 + "=" + 524288 + ")";
        if (QueryUtil.getRowsCount(query) > 0) {
            isFileServerEnabled = true;
        }
        return isFileServerEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getRecentMSScheduleId(int[] machineType) {
        long scheduleId = 0L;
        StringBuilder queryBuilder = new StringBuilder("SELECT MAX(SCHEDULE_ID) FROM AUDComputerEventRead WHERE (");
        for (int i = 0; i < machineType.length; ++i) {
            if (i > 0) {
                queryBuilder.append(" OR ");
            }
            queryBuilder.append("MACHINE_TYPE&");
            queryBuilder.append(machineType[i]);
            queryBuilder.append("=");
            queryBuilder.append(machineType[i]);
        }
        queryBuilder.append(" AND MACHINE_TYPE&4!=4 AND MACHINE_TYPE&8!=8 AND MACHINE_TYPE&64!=64 AND MACHINE_TYPE&128!=128");
        queryBuilder.append(")");
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = RelationalAPI.getInstance().getConnection();
            statement = connection.createStatement();
            resultSet = QueryUtil.executeQuery("Getting Latest Schedule Id from Computer Configuration", statement, queryBuilder.toString());
            while (resultSet.next()) {
                scheduleId = resultSet.getLong(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException se) {}
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException se) {}
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {}
        }
        return scheduleId;
    }

    public static ArrayList getConfiguredServersExceptSyncedDevice(String domainName, HashMap addnParamsMap, String searchCriteria, String searchMsgCriteria, Long scheduleId, int[] machineTypes, Integer count) {
        return ServerConfigAPI.getConfiguredServers(domainName, addnParamsMap, searchCriteria, searchMsgCriteria, scheduleId, machineTypes, count, true);
    }

    public static ArrayList getConfiguredServers(String domainName, HashMap addnParamsMap, String searchCriteria, String searchMsgCriteria, Long scheduleId, int[] machineTypes, Integer count) {
        return ServerConfigAPI.getConfiguredServers(domainName, addnParamsMap, searchCriteria, searchMsgCriteria, scheduleId, machineTypes, count, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getConfiguredServers(String domainName, HashMap addnParamsMap, String searchCriteria, String searchMsgCriteria, Long scheduleId, int[] machineTypes, Integer count, boolean skipSyncedDevice) {
        ArrayList<Properties> serverList = new ArrayList<Properties>();
        String query = ServerConfigAPI.buildQuery(domainName, addnParamsMap, searchCriteria, searchMsgCriteria, scheduleId, machineTypes, null, skipSyncedDevice);
        if (CommonUtil.getDBServerName().equalsIgnoreCase("mssql") && addnParamsMap != null && !addnParamsMap.isEmpty()) {
            query = ServerConfigAPI.buildMssqlQuery(query, addnParamsMap, count);
        }
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = RelationalAPI.getInstance().getConnection();
            statement = connection.createStatement();
            resultSet = QueryUtil.executeQuery("Getting Configured Servers", statement, query);
            while (resultSet.next()) {
                Properties netApp;
                Properties msProps = new Properties();
                String name = resultSet.getString("NAME");
                msProps.put("COMPUTER_NAME", name);
                msProps.put("DOMAIN_NAME", resultSet.getString("DOMAIN_NAME"));
                msProps.put("COMPUTER_ID", (Object)resultSet.getLong("COMPUTER_ID"));
                msProps.put("TIME_READ", (Object)resultSet.getLong("TIME_READ"));
                msProps.put("RECENT_EVENT_TIME", (Object)resultSet.getLong("RECENT_EVENT_TIME"));
                msProps.put("TIME_PERIOD", (Object)resultSet.getLong("TIME_PERIOD"));
                msProps.put("SCHEDULE_ID", (Object)resultSet.getLong("SCHEDULE_ID"));
                msProps.put("OBJECT_GUID", resultSet.getString("OBJECT_GUID"));
                msProps.put("ISINHERITED", (Object)resultSet.getInt("ISINHERITED"));
                String msg = resultSet.getString("MESSAGE");
                if (msg == null) {
                    msg = "-";
                }
                msProps.put("MESSAGE", msg);
                int machineType = resultSet.getInt("MACHINE_TYPE");
                msProps.put("MACHINE_TYPE", (Object)machineType);
                if (((machineType & 4) == 4 | (machineType & 8) == 8 || (machineType & 0x100) == 256 | (machineType & 0x200) == 512 || (machineType & 0x20000) == 131072 | (machineType & 0x40000) == 262144 || (machineType & 0x80000) == 524288 | (machineType & 0x100000) == 0x100000) && addnParamsMap != null && !addnParamsMap.isEmpty()) {
                    ArrayList shareList = FileServerHandler.getConfiguredShares(name, domainName);
                    shareList = AuditDelegationUtil.getShareSACLStatus(name, domainName, shareList);
                    msProps.put("SHARE_LIST", shareList);
                }
                if ((machineType & 0x100) == 256 | (machineType & 0x200) == 512) {
                    netApp = NetAppHandler.getNetAppDetails((String)msProps.get("OBJECT_GUID"));
                    msProps.put("NETAPP_DETAILS", netApp);
                }
                if ((machineType & 0x80000) == 524288 || (machineType & 0x100000) == 0x100000) {
                    netApp = NetAppVserverDBHandler.getProperties((String)msProps.get("OBJECT_GUID"));
                    msProps.put("NETAPP_DETAILS", netApp);
                }
                if ((machineType & 0x20000) == 131072 | (machineType & 0x40000) == 262144) {
                    Hashtable<String, Object> cifsTable = EMCHandler.getCifsDetails((String)msProps.get("OBJECT_GUID"), (String)msProps.get("COMPUTER_NAME"), (String)msProps.get("DOMAIN_NAME"));
                    EMCHandler.getCifsDMDetails(cifsTable);
                    msProps.put("EMC_CIFS_DETAILS", cifsTable);
                }
                if ((machineType & 0x400) == 1024 | (machineType & 0x800) == 2048) {
                    EventCollectorHandler.getCollectorDetails(msProps);
                }
                serverList.add(msProps);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException se) {}
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException se) {}
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {}
        }
        return serverList;
    }

    public static String buildQuery(String domainName, HashMap addnParamsMap, String searchCriteria, String searchMsgCriteria, Long scheduleId, int[] machineTypes, Boolean gpoStatus) {
        return ServerConfigAPI.buildQuery(domainName, addnParamsMap, searchCriteria, searchMsgCriteria, scheduleId, machineTypes, gpoStatus, false);
    }

    public static String buildQuery(String domainName, HashMap addnParamsMap, String searchCriteria, String searchMsgCriteria, Long scheduleId, int[] machineTypes, Boolean gpoStatus, boolean skipSynceddevice) {
        int i;
        StringBuilder queryBuilder = new StringBuilder();
        String dbServerName = CommonUtil.getDBServerName();
        if (dbServerName.equalsIgnoreCase("mssql") && addnParamsMap != null && !addnParamsMap.isEmpty()) {
            queryBuilder.append("SELECT ${TOPVAL} ");
        } else {
            queryBuilder.append("SELECT ");
        }
        for (i = 0; i < TABLE_NAMES.length; ++i) {
            if (i > 0) {
                queryBuilder.append(", ");
            }
            queryBuilder.append(TABLE_NAMES[i]);
            queryBuilder.append(".");
            queryBuilder.append(COLUMN_NAMES[i]);
        }
        queryBuilder.append(" FROM AUDComputerEventRead JOIN ADSMComputerGeneralDetails ON AUDComputerEventRead.OBJECT_GUID = ADSMComputerGeneralDetails.OBJECT_GUID WHERE");
        queryBuilder.append(" (");
        for (i = 0; i < machineTypes.length; ++i) {
            if (i > 0) {
                queryBuilder.append(" OR ");
            }
            queryBuilder.append("AUDComputerEventRead.MACHINE_TYPE&");
            queryBuilder.append(machineTypes[i]);
            queryBuilder.append("=");
            queryBuilder.append(machineTypes[i]);
        }
        queryBuilder.append(") ");
        if (null != domainName) {
            queryBuilder.append(" AND (ADSMComputerGeneralDetails.DOMAIN_NAME='");
            queryBuilder.append(domainName);
            queryBuilder.append("')");
        }
        if (searchCriteria != null) {
            queryBuilder.append(" AND (ADSMComputerGeneralDetails.");
            queryBuilder.append(searchCriteria);
            queryBuilder.append(")");
        }
        if (searchMsgCriteria != null) {
            queryBuilder.append(" AND (AUDComputerEventRead.");
            queryBuilder.append(searchMsgCriteria);
            queryBuilder.append(")");
        }
        if (scheduleId != null) {
            queryBuilder.append(" AND (AUDComputerEventRead.SCHEDULE_ID=");
            queryBuilder.append(scheduleId);
            queryBuilder.append(") ");
        }
        if (gpoStatus != null) {
            queryBuilder.append(" AND (AUDComputerEventRead.GPO_STATUS='");
            queryBuilder.append(gpoStatus);
            queryBuilder.append("') ");
        }
        if (skipSynceddevice) {
            queryBuilder.append(" AND (AUDComputerEventRead.ISINHERITED=0) ");
        }
        if (!dbServerName.equalsIgnoreCase("mssql") && addnParamsMap != null && !addnParamsMap.isEmpty()) {
            String tableName = (String)addnParamsMap.get("tableName");
            if (tableName == null) {
                tableName = COMP_DETAILS_TABLE;
            }
            queryBuilder.append(" ORDER BY ");
            queryBuilder.append(tableName);
            queryBuilder.append(".");
            queryBuilder.append((String)addnParamsMap.get("sortColumn"));
            queryBuilder.append(" ");
            queryBuilder.append((String)addnParamsMap.get("sortOrder"));
            int startIndex = (Integer)addnParamsMap.get("startIndex");
            String orderBy = ADAPSQLQueryUtil.getLimitValue(startIndex, (Integer)addnParamsMap.get("noOfObjects"));
            queryBuilder.append(orderBy);
        }
        return queryBuilder.toString();
    }

    public static String buildMssqlQuery(String query, HashMap addnParamsMap, Integer count) {
        String constructedSQL = null;
        try {
            if (query.length() > 0) {
                int startIndex = (Integer)addnParamsMap.get("startIndex");
                Integer noOfObjects = (Integer)addnParamsMap.get("noOfObjects");
                Integer innerTopVal = startIndex - 1 + noOfObjects;
                if (count > 0 && count < innerTopVal) {
                    noOfObjects = count % noOfObjects;
                }
                String sortColumn = (String)addnParamsMap.get("sortColumn");
                String sortOrder = (String)addnParamsMap.get("sortOrder");
                String changeOrder = "";
                if (sortOrder.equalsIgnoreCase("DESC")) {
                    changeOrder = "ASC";
                }
                if (sortOrder.equalsIgnoreCase("ASC")) {
                    changeOrder = "DESC";
                }
                constructedSQL = query.replace("${TOPVAL}", " TOP " + innerTopVal.toString()) + " ORDER BY " + sortColumn + " " + sortOrder;
                constructedSQL = "SELECT TOP " + noOfObjects.toString() + " * FROM ( " + constructedSQL + " ) as tempTable ORDER BY " + sortColumn + " " + changeOrder;
                constructedSQL = "SELECT TOP " + noOfObjects.toString() + " * FROM ( " + constructedSQL + " ) as finelTable ORDER BY " + sortColumn + " " + sortOrder;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return constructedSQL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<HashMap<String, Object>> getConfiguredServersEmber(String domainName, HashMap addnParamsMap, String searchCriteria, String searchMsgCriteria, Long scheduleId, int[] machineTypes, Integer count) {
        ArrayList<HashMap<String, Object>> serverList = new ArrayList<HashMap<String, Object>>();
        String query = ServerConfigAPI.buildQuery(domainName, addnParamsMap, searchCriteria, searchMsgCriteria, scheduleId, machineTypes, null);
        if (CommonUtil.getDBServerName().equalsIgnoreCase("mssql") && addnParamsMap != null && !addnParamsMap.isEmpty()) {
            query = ServerConfigAPI.buildMssqlQuery(query, addnParamsMap, count);
        }
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = RelationalAPI.getInstance().getConnection();
            statement = connection.createStatement();
            resultSet = QueryUtil.executeQuery("Getting Configured Servers", statement, query);
            while (resultSet.next()) {
                Properties netApp;
                HashMap<String, Object> msProps = new HashMap<String, Object>();
                String name = resultSet.getString("NAME");
                msProps.put("COMPUTER_NAME", name);
                msProps.put("NAME", name);
                msProps.put("DOMAIN_NAME", resultSet.getString("DOMAIN_NAME"));
                msProps.put("COMPUTER_ID", resultSet.getLong("COMPUTER_ID"));
                msProps.put("TIME_READ", resultSet.getLong("TIME_READ"));
                msProps.put("RECENT_EVENT_TIME", resultSet.getLong("RECENT_EVENT_TIME"));
                msProps.put("TIME_PERIOD", resultSet.getLong("TIME_PERIOD"));
                msProps.put("SCHEDULE_ID", resultSet.getLong("SCHEDULE_ID"));
                msProps.put("OBJECT_GUID", resultSet.getString("OBJECT_GUID"));
                msProps.put("ISINHERITED", resultSet.getLong("ISINHERITED"));
                String msg = resultSet.getString("MESSAGE");
                if (msg == null) {
                    msg = "-";
                }
                msProps.put("MESSAGE", msg);
                int machineType = resultSet.getInt("MACHINE_TYPE");
                msProps.put("MACHINE_TYPE", machineType);
                if (((machineType & 4) == 4 | (machineType & 8) == 8 || (machineType & 0x100) == 256 | (machineType & 0x200) == 512 || (machineType & 0x20000) == 131072 | (machineType & 0x40000) == 262144 || (machineType & 0x80000) == 524288 | (machineType & 0x100000) == 0x100000) && addnParamsMap != null && !addnParamsMap.isEmpty()) {
                    ArrayList shareList = FileServerHandler.getConfiguredShares(name, domainName);
                    shareList = AuditDelegationUtil.getShareSACLStatus(name, domainName, shareList);
                    msProps.put("SHARE_LIST", shareList);
                }
                if ((machineType & 0x100) == 256 | (machineType & 0x200) == 512) {
                    netApp = NetAppHandler.getNetAppDetails((String)msProps.get("OBJECT_GUID"));
                    msProps.put("NETAPP_DETAILS", netApp);
                }
                if ((machineType & 0x80000) == 524288 || (machineType & 0x100000) == 0x100000) {
                    netApp = NetAppVserverDBHandler.getProperties((String)msProps.get("OBJECT_GUID"));
                    msProps.put("NETAPP_DETAILS", netApp);
                    msProps.put("isNetAppCifsVserver", true);
                }
                if ((machineType & 0x20000) == 131072 | (machineType & 0x40000) == 262144) {
                    Hashtable<String, Object> cifsTable = EMCHandler.getCifsDetails((String)msProps.get("OBJECT_GUID"), (String)msProps.get("COMPUTER_NAME"), (String)msProps.get("DOMAIN_NAME"));
                    EMCHandler.getCifsDMDetails(cifsTable);
                    msProps.put("EMC_CIFS_DETAILS", cifsTable);
                }
                if ((machineType & 0x400) == 1024 | (machineType & 0x800) == 2048) {
                    EventCollectorHandler.getCollectorDetailsEmber(msProps);
                }
                serverList.add(msProps);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
        return serverList;
    }
}

