/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.delegation;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.delegation.GpoHandler;
import com.adventnet.sym.adsm.common.server.export.AuditGPOCsvWriter;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AdvancedGpoHandler {
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private static Logger logger = Logger.getLogger(GpoHandler.class.getName());
    private static final String ADVANCEGPOTABLE = "AUDAdvancedAuditPolicyEntries";
    private static AdvancedGpoHandler advancedGpoHandler = null;
    public static String[] advancedSubGpoGuids = null;
    public static String[] advancedSubGpoGuidsFS = null;
    public static String[] advancedSubGpoGuidsWS = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AdvancedGpoHandler getInstance() {
        if (advancedGpoHandler != null) return advancedGpoHandler;
        Class<AdvancedGpoHandler> clazz = AdvancedGpoHandler.class;
        synchronized (AdvancedGpoHandler.class) {
            advancedGpoHandler = new AdvancedGpoHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return advancedGpoHandler;
        }
    }

    public static void constructAdvancedPolicyEntries(String policyString, String gpoGUID, String domainName, String machineType) {
        try {
            String[] headers = new String[]{"MACHINE_NAME", "POLICY_TARGET", "SUB_CATEGORY", "SUB_CATEGORY_GUID", "INCLUSION_SETTING", "EXCLUSION_SETTING", "SETTING_VALUE"};
            if (!policyString.equalsIgnoreCase("")) {
                String[] policyRow = policyString.split("\n");
                Criteria crit = new Criteria(Column.getColumn((String)ADVANCEGPOTABLE, (String)"GPO_GUID"), (Object)gpoGUID, 0);
                crit = crit.and(new Criteria(Column.getColumn((String)ADVANCEGPOTABLE, (String)"DOMAIN_NAME"), (Object)domainName, 0));
                DataObject polDO = CommonUtil.getPersistence(new boolean[0]).get(ADVANCEGPOTABLE, crit);
                if (!polDO.isEmpty()) {
                    CommonUtil.getPersistenceLite().delete(crit);
                }
                HashMap<String, Integer> policySettingsMap = AdvancedGpoHandler.getPolicySettingsValue(machineType);
                for (int i = 0; i < policyRow.length; ++i) {
                    int configuredCsvValue;
                    int settingsValue;
                    String rowString = policyRow[i];
                    Row row = new Row(ADVANCEGPOTABLE);
                    String[] rowStringPolicy = rowString.split(",");
                    row.set("AUDITING_TYPE", (Object)machineType);
                    row.set("GPO_GUID", (Object)gpoGUID);
                    row.set("DOMAIN_NAME", (Object)domainName);
                    for (int i1 = 0; i1 < headers.length; ++i1) {
                        row.set(headers[i1], (Object)(rowStringPolicy[i1].length() > 0 ? rowStringPolicy[i1] : "-"));
                    }
                    boolean policyValue = true;
                    if (policySettingsMap.get((String)row.get("SUB_CATEGORY_GUID")) != null && (settingsValue = policySettingsMap.get((String)row.get("SUB_CATEGORY_GUID")).intValue()) != (configuredCsvValue = Integer.parseInt((String)row.get("SETTING_VALUE"))) && configuredCsvValue != 3) {
                        policyValue = false;
                    }
                    row.set("POLICY_SET", (Object)policyValue);
                    logger.log(Level.INFO, "Policy Row -> " + row);
                    polDO.addRow(row);
                }
                CommonUtil.getPersistence(new boolean[0]).update(polDO);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static HashMap<String, Integer> getPolicySettingsValue(String machineType) {
        HashMap<String, Integer> policySettingsMap = new HashMap<String, Integer>();
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDAdvancedAuditPolicy", (String)"AUDITING_TYPE"), (Object)("*" + machineType + "*"), 2);
            DataObject polDO = CommonUtil.getPersistence(new boolean[0]).get("AUDAdvancedAuditPolicy", criteria);
            if (!polDO.isEmpty()) {
                Iterator ie = polDO.getRows("AUDAdvancedAuditPolicy");
                while (ie.hasNext()) {
                    Row rw = (Row)ie.next();
                    policySettingsMap.put((String)rw.get("SUB_CATEGORY_GUID"), Integer.parseInt((String)rw.get("SETTING_VALUE")));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return policySettingsMap;
    }

    public static boolean getAuditPolicy(String domainName, String gpoGUID, String machineType) {
        boolean policyset = false;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)ADVANCEGPOTABLE, (String)"DOMAIN_NAME"), (Object)domainName, 0);
            criteria = criteria.and(new Criteria(Column.getColumn((String)ADVANCEGPOTABLE, (String)"GPO_GUID"), (Object)gpoGUID, 0));
            String[] guidArray = machineType.equalsIgnoreCase("DC") ? advancedSubGpoGuids : (machineType.equalsIgnoreCase("FS") ? advancedSubGpoGuidsFS : advancedSubGpoGuidsWS);
            criteria = criteria.and(new Criteria(Column.getColumn((String)ADVANCEGPOTABLE, (String)"SUB_CATEGORY_GUID"), (Object)guidArray, 8));
            criteria = criteria.and(new Criteria(Column.getColumn((String)ADVANCEGPOTABLE, (String)"POLICY_SET"), (Object)true, 0));
            DataObject polDO = CommonUtil.getPersistence(new boolean[0]).get(ADVANCEGPOTABLE, criteria);
            if (!polDO.isEmpty() && polDO.size(ADVANCEGPOTABLE) == guidArray.length) {
                return true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return policyset;
    }

    public static void loadAudAuditPolicyEntries(String auditingType, String filePath, String domainName, String gpoGuid) {
        try {
            String policyString = AuditGPOCsvWriter.readFromCsv(filePath);
            AdvancedGpoHandler.constructAdvancedPolicyEntries(policyString, gpoGuid, domainName, auditingType);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getAdvancedAuditPolicies(String auditingType, String filePath, String domainName, String gpoGuid) {
        String auditPolicyString = "Machine Name,Policy Target,Subcategory,Subcategory GUID,Inclusion Setting,Exclusion Setting,Setting Value";
        Properties auditPolicyDetails = new Properties();
        try {
            AdvancedGpoHandler.loadAudAuditPolicyEntries(auditingType, filePath, domainName, gpoGuid);
            String tableName = "AUDAdvancedAuditPolicy";
            Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"AUDITING_TYPE"), (Object)("*" + auditingType + "*"), 2);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get(tableName, crit);
            Iterator ie = obj.getRows("AUDAdvancedAuditPolicy");
            while (ie.hasNext()) {
                Row row = (Row)ie.next();
                auditPolicyString = auditPolicyString + "\n," + (String)row.get("POLICY_TARGET") + "," + rb.getString((String)row.get("SUB_CATEGORY")) + "," + (String)row.get("SUB_CATEGORY_GUID") + "," + rb.getString((String)row.get("INCLUSION_SETTING")) + ",," + (String)row.get("SETTING_VALUE");
            }
            auditPolicyString = auditPolicyString + AdvancedGpoHandler.getPolicyString(ADVANCEGPOTABLE, "AUDAdvancedAuditPolicy", auditingType);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return auditPolicyString;
    }

    public static List<String> getGpoSubGuids(String machineType) {
        ArrayList<String> subGuidList = new ArrayList<String>();
        try {
            String tableName = "AUDAdvancedAuditPolicy";
            Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"AUDITING_TYPE"), (Object)("*" + machineType + "*"), 2);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get(tableName, crit);
            Iterator ie = obj.getRows("AUDAdvancedAuditPolicy");
            while (ie.hasNext()) {
                Row row = (Row)ie.next();
                subGuidList.add((String)row.get("SUB_CATEGORY_GUID"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return subGuidList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPolicyString(String table1, String table2, String auditingType) {
        String auditPolicyString = "";
        auditPolicyString = table1.equalsIgnoreCase("AUDAdvancedAuditpolicy") ? auditPolicyString : "";
        StringBuilder queryBuilder = new StringBuilder();
        String dbServerName = CommonUtil.getDBServerName();
        queryBuilder.append("select * from AUDAdvancedAuditpolicyEntries where sub_category_guid not in (select sub_category_guid from AUDAdvancedAuditpolicy where auditing_type like '%" + auditingType + "%' ) and auditing_type like '%" + auditingType + "%'");
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = RelationalAPI.getInstance().getConnection();
            statement = connection.createStatement();
            String query = queryBuilder.toString();
            resultSet = QueryUtil.executeQuery("Getting ReportId From CvName", statement, query);
            HashMap<String, String> advancedAuditMap = new HashMap<String, String>();
            while (resultSet.next()) {
                auditPolicyString = auditPolicyString + "\n," + resultSet.getString("POLICY_TARGET") + "," + resultSet.getString("SUB_CATEGORY") + "," + resultSet.getString("SUB_CATEGORY_GUID") + "," + resultSet.getString("INCLUSION_SETTING") + ",," + resultSet.getString("SETTING_VALUE");
                advancedAuditMap.put(resultSet.getString("SUB_CATEGORY"), auditPolicyString);
                auditPolicyString = "";
            }
            Set keyset = advancedAuditMap.keySet();
            for (Object string : keyset) {
                auditPolicyString = auditPolicyString + (String)advancedAuditMap.get((String)string);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
        return auditPolicyString;
    }

    static {
        advancedSubGpoGuids = AdvancedGpoHandler.getGpoSubGuids("DC").toArray(new String[AdvancedGpoHandler.getGpoSubGuids("DC").size()]);
        advancedSubGpoGuidsFS = AdvancedGpoHandler.getGpoSubGuids("FS").toArray(new String[AdvancedGpoHandler.getGpoSubGuids("FS").size()]);
        advancedSubGpoGuidsWS = AdvancedGpoHandler.getGpoSubGuids("WS").toArray(new String[AdvancedGpoHandler.getGpoSubGuids("WS").size()]);
    }
}

