/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.delegation;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.delegation.AuditDelegationUtil;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainDetailsAPI;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AuditDelegationHandler {
    public static final int ADS_ACEFLAG_INHERIT_ACE = 2;
    public static final int ADS_ACEFLAG_NO_PROPAGATE_INHERIT_ACE = 4;
    public static final int ADS_ACEFLAG_INHERIT_ONLY_ACE = 8;
    public static final int ADS_ACEFLAG_INHERITED_ACE = 16;
    public static final int ADS_ACEFLAG_VALID_INHERIT_FLAGS = 31;
    public static final int ADS_ACEFLAG_SUCCESSFUL_ACCESS = 64;
    public static final int ADS_ACEFLAG_FAILED_ACCESS = 128;
    private static Logger logger = Logger.getLogger("DelegLogger");
    private static String[] audSACLDBColumns = new String[]{"ACCESS_MASK", "ACE_TYPE", "ACE_FLAGS", "FLAGS", "OBJECT_TYPE", "INHERITED_OBJECT_TYPE"};
    private static String[] audSACLProps = new String[]{"AccessMask", "AceType", "AceFlags", "Flags", "Trustee", "ObjectType", "InheritedObjectType"};
    private static String[] audDelegationProps = new String[]{"ACCESS_MASK", "ACE_TYPE", "ACE_FLAGS", "FLAGS", "SECURITY_PRINCIPAL_NAME", "OBJECT_TYPE", "INHERITED_OBJECT_TYPE"};
    private static String[] audSACLDataType = new String[]{"INTEGER", "INTEGER", "INTEGER", "INTEGER", "STRING", "STRING", "STRING"};
    private String domainName = null;
    private String defaultNamingContext = null;
    private String schemaNamingContext = null;
    private String configurationNamingContext = null;
    private String domainDNSZones = null;
    private String forestDNSZones = null;

    public AuditDelegationHandler(String domainName) {
        this.domainName = domainName;
        this.defaultNamingContext = DomainDetailsAPI.getDefaultNamingContext(domainName);
        this.schemaNamingContext = DomainDetailsAPI.getSchemaNamingContext(domainName);
        this.configurationNamingContext = DomainDetailsAPI.getConfigurationNamingContext(domainName);
        this.domainDNSZones = DomainDetailsAPI.getDomainDNSZone(domainName);
        this.forestDNSZones = DomainDetailsAPI.getForestDNSZone(domainName);
    }

    public void setSystemACLForDS() throws Exception {
        Hashtable<String, ArrayList> delegationTable = this.getSystemACEEntries();
        Set<String> delegationPathSet = delegationTable.keySet();
        for (String delegationPath : delegationPathSet) {
            ArrayList aceList = delegationTable.get(delegationPath);
            ArrayList<String> trusteeList = new ArrayList<String>();
            trusteeList.add("S-1-1-0");
            ArrayList resultList = ADHandler.manageSystemACL(this.domainName, 1L, aceList, trusteeList, delegationPath);
            logger.log(Level.INFO, "resultList" + resultList);
            if (resultList == null || resultList.size() == 0 || resultList.isEmpty()) {
                logger.log(Level.FINE, "Error while applying SystemACL for OU & GPO auditing");
                throw new Exception("Error while applying SystemACL for OU & GPO auditing");
            }
            for (int i = 0; i < trusteeList.size(); ++i) {
                String trusteeSid = (String)trusteeList.get(i);
                Properties resultProp = null;
                for (int j = 0; j < resultList.size(); ++j) {
                    Hashtable resultHashtable = (Hashtable)resultList.get(j);
                    resultProp = (Properties)resultHashtable.get(trusteeSid);
                    if (resultProp == null) continue;
                    resultList.remove(j);
                    break;
                }
                if (resultProp != null) {
                    for (int k = 0; k < aceList.size(); ++k) {
                        Properties aceProp = (Properties)aceList.get(k);
                        Long aceId = (Long)aceProp.get("ACL_ID");
                        String resultValue = (String)resultProp.get(aceId);
                        logger.log(Level.FINE, "ACE_ID is" + aceId);
                        logger.log(Level.FINE, "Value of AceID is" + resultValue);
                        if (resultValue != null) {
                            if (resultValue.equals("4")) {
                                aceProp.put("IS_DELEGATED", (Object)false);
                                continue;
                            }
                            aceProp.put("IS_DELEGATED", (Object)true);
                            continue;
                        }
                        aceProp.put("IS_DELEGATED", (Object)false);
                    }
                } else {
                    logger.log(Level.FINE, "resultProp is null. so properties is found for trustee" + trusteeSid);
                    throw new Exception("Error while applying SystemACL for OU & GPO auditing");
                }
                logger.log(Level.FINE, "aceList value is:" + aceList);
                AuditDelegationUtil.updateSystemACLStatus(this.domainName, aceList);
                logger.log(Level.FINE, "finished trustee");
            }
        }
    }

    private Hashtable<String, ArrayList> getSystemACEEntries() throws Exception {
        Hashtable<String, ArrayList> delegationTable = new Hashtable<String, ArrayList>();
        DataObject dataObject = AuditDelegationUtil.getDomainDelegationDO(this.domainName);
        if (dataObject.isEmpty()) {
            this.addDelegationEntries();
        }
        dataObject = AuditDelegationUtil.getDomainDelegationDO(this.domainName);
        Iterator iterator = dataObject.getRows("AudDelegationDetails");
        while (iterator.hasNext()) {
            Row delegationRow = (Row)iterator.next();
            Long aclId = (Long)delegationRow.get("ACL_ID");
            Criteria criteria2 = new Criteria(Column.getColumn((String)"AudSACL", (String)"ACL_ID"), (Object)aclId, 0);
            Row aclRow = dataObject.getRow("AudSACL", criteria2);
            Properties sacMap = new Properties();
            sacMap.put("ACL_ID", aclId);
            String delegationPath = (String)delegationRow.get("DELEGATION_PATH");
            for (String string : audSACLDBColumns) {
                if (aclRow.get(string) == null) continue;
                sacMap.put(string, aclRow.get(string));
            }
            sacMap.put("DELEGATION_ID", delegationRow.get("DELEGATION_ID"));
            sacMap.put("DELEGATION_PATH", delegationPath);
            sacMap.put("SECURITY_PRINCIPAL", delegationRow.get("SECURITY_PRINCIPAL"));
            sacMap.put("SECURITY_PRINCIPAL_NAME", delegationRow.get("SECURITY_PRINCIPAL_NAME"));
            sacMap.put("IS_DELEGATED", delegationRow.get("IS_DELEGATED"));
            sacMap.put("OPERATION", "add");
            ArrayList delegSacList = delegationTable.get(delegationPath) != null ? delegationTable.get(delegationPath) : new ArrayList();
            delegSacList.add(sacMap);
            delegationTable.put(delegationPath, delegSacList);
        }
        return delegationTable;
    }

    public void updateDelegationStatus() {
        try {
            ArrayList domainSACList = ADHandler.getSACLForObject(this.domainName, this.defaultNamingContext);
            ArrayList schemaSACList = ADHandler.getSACLForObject(this.domainName, this.schemaNamingContext);
            ArrayList configurationSACList = ADHandler.getSACLForObject(this.domainName, this.configurationNamingContext);
            ArrayList domainDNSZonesSACList = ADHandler.getSACLForObject(this.domainName, this.domainDNSZones);
            ArrayList forestDNSZonesSACList = ADHandler.getSACLForObject(this.domainName, this.forestDNSZones);
            logger.log(Level.INFO, "SACL for domain object {0} : {1}", new Object[]{this.domainName, domainSACList});
            logger.log(Level.INFO, "SACL for schema object {0} : {1}", new Object[]{this.domainName, schemaSACList});
            logger.log(Level.INFO, "SACL for configuration object {0} : {1}", new Object[]{this.domainName, configurationSACList});
            logger.log(Level.INFO, "SACL for Domain DNS Zones {0} : {1}", new Object[]{this.domainName, domainDNSZonesSACList});
            logger.log(Level.INFO, "SACL for Forest DNS Zones {0} : {1}", new Object[]{this.domainName, forestDNSZonesSACList});
            ArrayList delegSacList = this.getDelegationEntries();
            if (domainSACList == null || domainSACList.isEmpty()) {
                logger.log(Level.WARNING, "Not able to get SACL for Domain {0}. The list is empty", new Object[]{this.domainName});
                return;
            }
            for (Object object : delegSacList) {
                HashMap sacMap = (HashMap)object;
                String delegationPath = (String)sacMap.get("DELEGATION_PATH");
                ArrayList toCheckDomainSACList = null;
                toCheckDomainSACList = delegationPath.equalsIgnoreCase(this.schemaNamingContext) ? schemaSACList : (delegationPath.equalsIgnoreCase(this.configurationNamingContext) ? configurationSACList : (delegationPath.equalsIgnoreCase(this.domainDNSZones) ? domainDNSZonesSACList : (delegationPath.equalsIgnoreCase(this.forestDNSZones) ? forestDNSZonesSACList : domainSACList)));
                if (toCheckDomainSACList == null || toCheckDomainSACList.isEmpty()) {
                    sacMap.put("IS_DELEGATED", false);
                    continue;
                }
                logger.log(Level.INFO, "Started SACL check for  {0}:", new Object[]{sacMap});
                boolean status = this.checkForDelegation(sacMap, toCheckDomainSACList);
                if (!status) {
                    HashMap genericSacMap = (HashMap)sacMap.clone();
                    genericSacMap.put("INHERITED_OBJECT_TYPE", null);
                    genericSacMap.put("OBJECT_TYPE", null);
                    genericSacMap.put("ACE_TYPE", 2);
                    genericSacMap.put("ACE_FLAGS", 66);
                    genericSacMap.put("FLAGS", 0);
                    logger.log(Level.INFO, "Started Alternate Generic SACL check for  {0}:", new Object[]{genericSacMap});
                    status = this.checkForDelegation(genericSacMap, toCheckDomainSACList);
                }
                toCheckDomainSACList = null;
                sacMap.put("IS_DELEGATED", status);
                logger.log(Level.INFO, "SACL check Status is {0}:", new Object[]{status});
            }
            AuditDelegationUtil.updateDelegationStatus(this.domainName, delegSacList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean checkForDelegation(HashMap sacMap, ArrayList sacList) {
        boolean flag = false;
        try {
            for (Object object : sacList) {
                Hashtable aceTable = (Hashtable)object;
                logger.log(Level.FINE, "The Hashtable is {0}", new Object[]{aceTable});
                for (int i = 0; i < audSACLProps.length; ++i) {
                    Object propertyValue = aceTable.get(audSACLProps[i]);
                    if (audSACLDataType[i].equalsIgnoreCase("INTEGER")) {
                        int value = (Integer)propertyValue;
                        int valueFromDB = (Integer)sacMap.get(audDelegationProps[i]);
                        logger.log(Level.FINE, "Integer value from DB is {0} and from Native is {1}", new Object[]{valueFromDB, value});
                        if ((valueFromDB & value) == valueFromDB) {
                            flag = true;
                            continue;
                        }
                        flag = false;
                        break;
                    }
                    String value = (String)propertyValue;
                    String valueFromDB = (String)sacMap.get(audDelegationProps[i]);
                    logger.log(Level.FINE, "String value from DB is {0} and from Native is {1}", new Object[]{valueFromDB, propertyValue});
                    if (valueFromDB == null && value == null) {
                        flag = true;
                        continue;
                    }
                    if (valueFromDB == null && value != null || valueFromDB != null && value == null) {
                        flag = false;
                        break;
                    }
                    if (valueFromDB.equalsIgnoreCase(value)) {
                        flag = true;
                        continue;
                    }
                    flag = false;
                    break;
                }
                if (!flag) continue;
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    private ArrayList getDelegationEntries() throws Exception {
        ArrayList delegSacList = new ArrayList();
        DataObject dataObject = AuditDelegationUtil.getDomainDelegationDO(this.domainName);
        if (dataObject.isEmpty()) {
            this.addDelegationEntries();
        }
        dataObject = AuditDelegationUtil.getDomainDelegationDO(this.domainName);
        Iterator iterator = dataObject.getRows("AudDelegationDetails");
        while (iterator.hasNext()) {
            Row delegationRow = (Row)iterator.next();
            Long aclId = (Long)delegationRow.get("ACL_ID");
            Criteria criteria2 = new Criteria(Column.getColumn((String)"AudSACL", (String)"ACL_ID"), (Object)aclId, 0);
            Row aclRow = dataObject.getRow("AudSACL", criteria2);
            HashMap<String, Object> sacMap = new HashMap<String, Object>();
            sacMap.put("ACL_ID", aclId);
            for (String string : audSACLDBColumns) {
                sacMap.put(string, aclRow.get(string));
            }
            sacMap.put("DELEGATION_ID", delegationRow.get("DELEGATION_ID"));
            sacMap.put("DELEGATION_PATH", delegationRow.get("DELEGATION_PATH"));
            sacMap.put("SECURITY_PRINCIPAL", delegationRow.get("SECURITY_PRINCIPAL"));
            sacMap.put("SECURITY_PRINCIPAL_NAME", delegationRow.get("SECURITY_PRINCIPAL_NAME"));
            sacMap.put("IS_DELEGATED", delegationRow.get("IS_DELEGATED"));
            delegSacList.add(sacMap);
        }
        return delegSacList;
    }

    public ArrayList getSACL() throws Exception {
        ArrayList sacList = new ArrayList();
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AudSACL", (Row)null);
        Iterator iterator = dataObject.getRows("AudSACL");
        while (iterator.hasNext()) {
            String[] basePathArray;
            Row row = (Row)iterator.next();
            Long aclId = (Long)row.get("ACL_ID");
            String basePaths = (String)row.get("BASE_PATHS");
            for (String basePathString : basePathArray = basePaths.split(",")) {
                HashMap<String, Object> sacMap = new HashMap<String, Object>();
                sacMap.put("ACL_ID", aclId);
                for (String columnName : audSACLDBColumns) {
                    sacMap.put(columnName, row.get(columnName));
                }
                sacMap.put("DELEGATION_PATH", basePathString);
                sacList.add(sacMap);
            }
        }
        return sacList;
    }

    public void addDelegationEntries() throws Exception {
        try {
            ArrayList sacList = this.getSACL();
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            for (Object object : sacList) {
                HashMap sacMap = (HashMap)object;
                Long aceId = (Long)sacMap.get("ACL_ID");
                Row row = new Row("AudDelegationDetails");
                row.set("ACL_ID", (Object)aceId);
                row.set("DOMAIN_NAME", (Object)this.domainName);
                row.set("DELEGATION_PATH", (Object)DomainDetailsAPI.getContext(this.domainName, (String)sacMap.get("DELEGATION_PATH")));
                row.set("SECURITY_PRINCIPAL", (Object)"S-1-1-0");
                row.set("SECURITY_PRINCIPAL_NAME", (Object)"Everyone");
                dataObject.addRow(row);
            }
            CommonUtil.getPersistence(new boolean[0]).add(dataObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

