/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.delegation;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import com.adventnet.sym.adsm.common.server.util.EscapeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AuditDelegationUtil {
    private static Logger logger = Logger.getLogger("DelegLogger");
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private static String[] audFileSACLDBColumns = new String[]{"ACCESS_PERMISSION", "INHERITENCE", "ACCESS_MODE"};
    private static String[] audFileSACLDataType = new String[]{"LONG", "LONG", "LONG"};
    private static String[] shareAuditACEIdsForWindows = new String[]{"AudFileSACL:acl_id:1003", "AudFileSACL:acl_id:1004", "AudFileSACL:acl_id:1005", "AudFileSACL:acl_id:1006", "AudFileSACL:acl_id:1007", "AudFileSACL:acl_id:1008", "AudFileSACL:acl_id:1009"};

    public static boolean getDelegationStatus(String domainName, String objectClass) {
        boolean isDelegated = false;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AudSACL", (String)"OBJECT_CLASS"), (Object)objectClass, 0);
            criteria = criteria.and(Column.getColumn((String)"AudDelegationDetails", (String)"IS_DELEGATED"), (Object)false, 0);
            criteria = criteria.and(Column.getColumn((String)"AudDelegationDetails", (String)"DOMAIN_NAME"), (Object)domainName, 0);
            ArrayList<String> tableList = new ArrayList<String>();
            tableList.add("AudDelegationDetails");
            tableList.add("AudSACL");
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(tableList, criteria);
            logger.log(Level.INFO, "Delegation Status DO Size : {0}", new Object[]{dataObject.size("AudDelegationDetails")});
            logger.log(Level.INFO, "Delegation Status Check DO : {0}", new Object[]{dataObject});
            if (dataObject.isEmpty()) {
                isDelegated = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isDelegated;
    }

    public static DataObject getDomainDelegationDO(String domainName) throws Exception {
        Criteria criteria = new Criteria(Column.getColumn((String)"AudDelegationDetails", (String)"DOMAIN_NAME"), (Object)domainName, 0);
        ArrayList<String> tableList = new ArrayList<String>();
        tableList.add("AudDelegationDetails");
        tableList.add("AudSACL");
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(tableList, criteria);
        return dataObject;
    }

    public static void updateDelegationStatus(String domainName, ArrayList delegSacList) throws Exception {
        DataObject dataObject = AuditDelegationUtil.getDomainDelegationDO(domainName);
        for (Object object : delegSacList) {
            HashMap sacMap = (HashMap)object;
            logger.log(Level.FINE, "sacMap : {0}", new Object[]{sacMap});
            Long delegationId = (Long)sacMap.get("DELEGATION_ID");
            logger.log(Level.FINE, "delegationId : {0}", new Object[]{delegationId});
            Criteria criteria = new Criteria(Column.getColumn((String)"AudDelegationDetails", (String)"DELEGATION_ID"), (Object)delegationId, 0);
            Row row = dataObject.getRow("AudDelegationDetails", criteria);
            if (row == null) continue;
            row.set("IS_DELEGATED", (Object)((Boolean)sacMap.get("IS_DELEGATED")));
            dataObject.updateRow(row);
        }
        CommonUtil.getPersistence(new boolean[0]).update(dataObject);
    }

    public static void updateSystemACLStatus(String domainName, ArrayList delegSacList) throws Exception {
        DataObject dataObject = AuditDelegationUtil.getDomainDelegationDO(domainName);
        for (Object object : delegSacList) {
            Properties sacMap = (Properties)object;
            logger.log(Level.FINE, "sacMap : {0}", new Object[]{sacMap});
            Long delegationId = (Long)sacMap.get("DELEGATION_ID");
            logger.log(Level.FINE, "delegationId : {0}", new Object[]{delegationId});
            Criteria criteria = new Criteria(Column.getColumn((String)"AudDelegationDetails", (String)"DELEGATION_ID"), (Object)delegationId, 0);
            Row row = dataObject.getRow("AudDelegationDetails", criteria);
            if (row == null) continue;
            row.set("IS_DELEGATED", (Object)((Boolean)sacMap.get("IS_DELEGATED")));
            dataObject.updateRow(row);
        }
        CommonUtil.getPersistence(new boolean[0]).update(dataObject);
    }

    public static void updateSaclStatusForShare(Object saclDetails1) {
        Hashtable saclDetails = (Hashtable)saclDetails1;
        try {
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            String shareName = (String)saclDetails.get("SHARE_NAME");
            if (CommonUtil.getDBServerName().equalsIgnoreCase("mssql")) {
                shareName = EscapeUtil.escSplCharsAsMSSQL(shareName);
            }
            logger.log(Level.INFO, "Name in AuditDelegationUtil :: " + shareName);
            Criteria c1 = new Criteria(Column.getColumn((String)"AUDShareSaclDetails", (String)"HOST_COMPUTER"), (Object)((String)saclDetails.get("HOST_NAME")), 0);
            Criteria c2 = new Criteria(Column.getColumn((String)"AUDShareSaclDetails", (String)"SHARE_NAME"), (Object)shareName, 0);
            Criteria c3 = new Criteria(Column.getColumn((String)"AUDShareSaclDetails", (String)"DOMAIN_NAME"), (Object)((String)saclDetails.get("DOMAIN_NAME")), 0);
            c1 = c1.and(c2);
            c1 = c1.and(c3);
            dataObj = CommonUtil.getPersistence(new boolean[0]).get("AUDShareSaclDetails", c1);
            if (dataObj.isEmpty()) {
                Row msRow = new Row("AUDShareSaclDetails");
                msRow.set("SHARE_NAME", (Object)((String)saclDetails.get("SHARE_NAME")));
                msRow.set("HOST_COMPUTER", (Object)((String)saclDetails.get("HOST_NAME")));
                msRow.set("DOMAIN_NAME", (Object)((String)saclDetails.get("DOMAIN_NAME")));
                msRow.set("LOCATION", (Object)((String)saclDetails.get("LOCATION")));
                msRow.set("STRING_SD", (Object)((String)saclDetails.get("STRING_SD")));
                msRow.set("SACL_STATUS", (Object)((Integer)saclDetails.get("SACL_STATUS")).longValue());
                dataObj.addRow(msRow);
                CommonUtil.getPersistence(new boolean[0]).add(dataObj);
            } else {
                Row shareRow = dataObj.getRow("AUDShareSaclDetails");
                Long saclStatus = (Long)shareRow.get("SACL_STATUS");
                if (saclStatus != 0L) {
                    shareRow.set("STRING_SD", (Object)((String)saclDetails.get("STRING_SD")));
                    shareRow.set("SACL_STATUS", (Object)((Integer)saclDetails.get("SACL_STATUS")).longValue());
                } else {
                    shareRow.set("SACL_STATUS", (Object)((Integer)saclDetails.get("SACL_STATUS")).longValue());
                }
                dataObj.updateRow(shareRow);
                CommonUtil.getPersistence(new boolean[0]).update(dataObj);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static ArrayList getAccessControlEntries(int machineType) throws Exception {
        ArrayList<Properties> ACEList = new ArrayList<Properties>();
        try {
            Long[] uvhValues = null;
            uvhValues = DBObjectUtil.getUVHValues("AudFileSACL", shareAuditACEIdsForWindows);
            Criteria criteria = new Criteria(Column.getColumn((String)"AudFileSACL", (String)"ACL_ID"), (Object)uvhValues, 8);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AudFileSACL", criteria);
            if (!dataObject.isEmpty()) {
                Iterator iterator = dataObject.getRows("AudFileSACL");
                while (iterator.hasNext()) {
                    Row ACERow = (Row)iterator.next();
                    Properties ACEMap = new Properties();
                    int i = 0;
                    String[] stringArray = audFileSACLDBColumns;
                    int n = audFileSACLDBColumns.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String string = stringArray[n2];
                        Object DBValue = ACERow.get(string);
                        if (audFileSACLDataType[i].equalsIgnoreCase("LONG")) {
                            ACEMap.put(string, (Long)DBValue);
                        } else if (audFileSACLDataType[i].equalsIgnoreCase("INTEGER")) {
                            ACEMap.put(string, (Integer)DBValue);
                        } else if (audFileSACLDataType[i].equalsIgnoreCase("STRING")) {
                            ACEMap.put(string, (String)DBValue);
                        }
                        ++i;
                        ++n2;
                    }
                    ACEMap.put("TRUSTEE_SID", "S-1-1-0");
                    ACEMap.put("TRUSTEE_TYPE", (Object)5L);
                    ACEList.add(ACEMap);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
        return ACEList;
    }

    public static ArrayList getShareSACLStatus(String hostName, String domainName, ArrayList shareList) throws Exception {
        ArrayList SACLStatus = new ArrayList();
        if (shareList.size() > 0) {
            ArrayList<String> tempList = new ArrayList<String>();
            Criteria cri1 = new Criteria(Column.getColumn((String)"AUDShareSaclDetails", (String)"LOCATION"), (Object)shareList.toArray(new String[shareList.size()]), 8);
            Criteria cri2 = new Criteria(Column.getColumn((String)"AUDShareSaclDetails", (String)"HOST_COMPUTER"), (Object)hostName, 0);
            Criteria cri3 = new Criteria(Column.getColumn((String)"AUDShareSaclDetails", (String)"DOMAIN_NAME"), (Object)domainName, 0);
            cri1 = cri2.and(cri1);
            cri1 = cri3.and(cri1);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("AUDShareSaclDetails", cri1);
            try {
                if (!dataObj.isEmpty()) {
                    Iterator iterator = dataObj.getRows("AUDShareSaclDetails");
                    while (iterator.hasNext()) {
                        Row shareSACLRow = (Row)iterator.next();
                        HashMap<String, Object> shareSACL = new HashMap<String, Object>();
                        shareSACL.put("LOCATION", (String)shareSACLRow.get("LOCATION"));
                        shareSACL.put("SACL_STATUS", (Long)shareSACLRow.get("SACL_STATUS"));
                        shareSACL.put("SHARE_NAME", (String)shareSACLRow.get("SHARE_NAME"));
                        if ((Long)shareSACLRow.get("SACL_STATUS") != 0L) {
                            shareSACL.put("saclMsg", String.valueOf(rb.getString("adap_serverconfig_error_while_enabling_audit_settings_errorCode")) + (Long)shareSACLRow.get("SACL_STATUS"));
                            shareSACL.put("saclStatus", false);
                            shareSACL.put("saclClass", "text-danger");
                        } else {
                            shareSACL.put("saclStatus", true);
                            shareSACL.put("saclClass", "text-primary");
                            shareSACL.put("saclMsg", rb.getString("adap_serverconfig_successfully_enabled_audit_settings"));
                        }
                        SACLStatus.add(shareSACL);
                        tempList.add((String)shareSACLRow.get("LOCATION"));
                    }
                }
                if (SACLStatus.size() < shareList.size()) {
                    Integer i = 0;
                    while (i < shareList.size()) {
                        if (!tempList.contains(shareList.get(i))) {
                            HashMap<String, Object> map = new HashMap<String, Object>();
                            map.put("LOCATION", (String)shareList.get(i));
                            map.put("SACL_STATUS", 11111L);
                            map.put("saclMsg", rb.getString("adap_serverconfig_audit_settings_not_configured"));
                            map.put("saclStatus", false);
                            map.put("saclClass", "text-danger");
                            String location = shareList.get(i).toString();
                            int index = location.lastIndexOf(92);
                            map.put("SHARE_NAME", shareList.get(i).toString().substring(index + 1, shareList.get(i).toString().length()));
                            SACLStatus.add(map);
                        }
                        i = i + 1;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return SACLStatus;
    }

    public static void removeSaclDetails(String domainName, String hostName, ArrayList shareLocations) throws Exception {
        try {
            String tableSACL = "AUDShareSaclDetails";
            Criteria criteria = new Criteria(Column.getColumn((String)tableSACL, (String)"DOMAIN_NAME"), (Object)domainName, 0);
            criteria = criteria.and(new Criteria(Column.getColumn((String)tableSACL, (String)"HOST_COMPUTER"), (Object)hostName, 0));
            criteria = criteria.and(new Criteria(Column.getColumn((String)tableSACL, (String)"LOCATION"), (Object)shareLocations.toArray(new String[shareLocations.size()]), 8));
            System.out.println("Criteria  in removeSaclDetails" + criteria);
            CommonUtil.getPersistenceLite().delete(criteria);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

