/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.delegation;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.config.ServerConfigAPI;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.MSHandler;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AuditPolicyHandler {
    private static Logger logger = Logger.getLogger(AuditPolicyHandler.class.getName());
    public static String gpoTableName = "AUDGpoDetails";

    public static void updateExistingGpo(Properties gpoProp, String gpoName, String domainName, Integer machineType) throws Exception {
        ArrayList displayNameList = (ArrayList)gpoProp.get("displayName");
        ArrayList gpoGuidList = (ArrayList)gpoProp.get("name");
        String displayName = (String)displayNameList.get(0);
        String gpoGuid = (String)gpoGuidList.get(0);
        if (!gpoName.equals(displayName)) {
            throw new Exception("Error while searching existence of GPO");
        }
        Hashtable<String, Object> gpoDetails = new Hashtable<String, Object>();
        gpoDetails.put("GPO_NAME", displayName);
        gpoDetails.put("GPO_GUID", gpoGuid);
        gpoDetails.put("GPO_FLAGS", 1);
        gpoDetails.put("DOMAIN_NAME", domainName);
        AuditPolicyHandler.updateGpoDetails(gpoDetails);
        AuditPolicyHandler.updateGpoStatus(domainName, machineType);
    }

    public static void updateGpoDetails(Hashtable<String, Object> gpoDetails) throws Exception {
        try {
            logger.log(Level.FINE, "gpoDetails is" + gpoDetails);
            Long currentTime = System.currentTimeMillis();
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Criteria c1 = new Criteria(Column.getColumn((String)gpoTableName, (String)"GPO_NAME"), (Object)((String)gpoDetails.get("GPO_NAME")), 0);
            Criteria c2 = new Criteria(Column.getColumn((String)gpoTableName, (String)"DOMAIN_NAME"), (Object)((String)gpoDetails.get("DOMAIN_NAME")), 0);
            c1 = c1.and(c2);
            dataObj = CommonUtil.getPersistence(new boolean[0]).get(gpoTableName, c1);
            if (dataObj.isEmpty()) {
                logger.log(Level.FINE, "Data object is empty so going to add firsttime");
                Row gpoRow = new Row(gpoTableName);
                gpoRow.set("GPO_NAME", (Object)((String)gpoDetails.get("GPO_NAME")));
                gpoRow.set("DOMAIN_NAME", (Object)((String)gpoDetails.get("DOMAIN_NAME")));
                gpoRow.set("GPO_GUID", (Object)((String)gpoDetails.get("GPO_GUID")));
                gpoRow.set("GPO_FILE_SYS_PATH", (Object)((String)gpoDetails.get("GPO_FILE_SYS_PATH")));
                gpoRow.set("GPO_DS_PATH", (Object)((String)gpoDetails.get("GPO_DS_PATH")));
                gpoRow.set("CREATION_TIME", (Object)currentTime);
                gpoRow.set("MODIFIED_TIME", (Object)currentTime);
                gpoRow.set("MESSAGE", (Object)((String)gpoDetails.get("MESSAGE")));
                gpoRow.set("GPO_FLAGS", (Object)((Integer)gpoDetails.get("GPO_FLAGS")));
                dataObj.addRow(gpoRow);
                CommonUtil.getPersistence(new boolean[0]).add(dataObj);
            } else {
                logger.log(Level.FINE, "Data object is not empty so going to update");
                Row gpoRow = dataObj.getRow(gpoTableName);
                if (gpoDetails.get("GPO_DS_PATH") != null) {
                    gpoRow.set("GPO_DS_PATH", (Object)((String)gpoDetails.get("GPO_DS_PATH")));
                }
                if (gpoDetails.get("GPO_FILE_SYS_PATH") != null) {
                    gpoRow.set("GPO_FILE_SYS_PATH", (Object)((String)gpoDetails.get("GPO_FILE_SYS_PATH")));
                }
                gpoRow.set("MODIFIED_TIME", (Object)currentTime);
                if (gpoDetails.get("MESSAGE") != null) {
                    gpoRow.set("MESSAGE", (Object)((String)gpoDetails.get("MESSAGE")));
                }
                if (gpoDetails.get("GPO_GROUP_DN") != null) {
                    gpoRow.set("GPO_GROUP_DN", (Object)((String)gpoDetails.get("GPO_GROUP_DN")));
                }
                if (gpoDetails.get("GPO_GROUP_SID") != null) {
                    gpoRow.set("GPO_GROUP_SID", (Object)((String)gpoDetails.get("GPO_GROUP_SID")));
                }
                gpoRow.set("GPO_FLAGS", (Object)((Integer)gpoDetails.get("GPO_FLAGS")));
                dataObj.updateRow(gpoRow);
                CommonUtil.getPersistence(new boolean[0]).update(dataObj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.log(Level.FINE, "**************Leaving updateGpoDetails**************");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateGpoStatus(String domainName, Integer machineType) {
        ArrayList<String> guidList = new ArrayList<String>();
        int[] machineTypes = (machineType & 0x1000) == 4096 ? new int[]{4096, 8192} : new int[]{4, 8, 16, 32, 64, 128, 131072, 262144};
        String query = ServerConfigAPI.buildQuery(domainName, null, null, null, null, machineTypes, null);
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = RelationalAPI.getInstance().getConnection();
            statement = connection.createStatement();
            resultSet = QueryUtil.executeQuery("Getting Configured Servers", statement, query);
            while (resultSet.next()) {
                guidList.add(resultSet.getString("OBJECT_GUID"));
            }
            if (!guidList.isEmpty() && guidList.size() > 0) {
                DataObject dobj1 = CommonUtil.getPersistence(new boolean[0]).get(MSHandler.tableMSName, new Criteria(Column.getColumn((String)MSHandler.tableMSName, (String)"OBJECT_GUID"), (Object)guidList.toArray(new String[guidList.size()]), 8));
                Iterator iter = dobj1.getRows(MSHandler.tableMSName);
                while (iter.hasNext()) {
                    Row row = (Row)iter.next();
                    row.set("GPO_STATUS", (Object)false);
                    dobj1.updateRow(row);
                }
                CommonUtil.getPersistence(new boolean[0]).update(dobj1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
    }

    public static boolean isConfiguredFileORMemberServer(String objectGuid) {
        boolean isConfiguredServer = false;
        String query = "SELECT COUNT(*) FROM AUDComputerEventRead WHERE OBJECT_GUID='" + objectGuid + "' AND (MACHINE_TYPE &4=4 OR MACHINE_TYPE&8=8 OR MACHINE_TYPE &16=16 OR MACHINE_TYPE&32=32 " + "OR MACHINE_TYPE &64=64 OR MACHINE_TYPE &128=128 OR MACHINE_TYPE &131072=131072 OR MACHINE_TYPE &262144=262144)";
        logger.log(Level.FINE, "Query is " + query);
        if (QueryUtil.getRowsCount(query) > 0) {
            isConfiguredServer = true;
        }
        return isConfiguredServer;
    }

    public static void updateServerGPOStatus(ArrayList<String> objectGuids, boolean delegated) throws Exception {
        try {
            String tableName = "AUDComputerEventRead";
            String basetableName = "ADSMComputerGeneralDetails";
            String[] objectGuid = objectGuids.toArray(new String[objectGuids.size()]);
            Criteria c1 = new Criteria(Column.getColumn((String)basetableName, (String)"DISTINGUISHED_NAME"), (Object)objectGuid, 8);
            Join join = new Join(basetableName, tableName, new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 2);
            Table baseTable = Table.getTable((String)basetableName);
            SelectQueryImpl query = new SelectQueryImpl(baseTable);
            query.addJoin(join);
            query.setCriteria(c1);
            query.addSelectColumn(Column.getColumn((String)basetableName, (String)"*"));
            query.addSelectColumn(Column.getColumn((String)tableName, (String)"*"));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            if (dataObject.size(tableName) > 0) {
                dataObject.set(tableName, "GPO_STATUS", (Object)delegated);
            }
            CommonUtil.getPersistence(new boolean[0]).update(dataObject);
        }
        catch (Exception ex) {
            logger.log(Level.FINE, "Exception ex" + ex);
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getConfiguredServerSidList(String domainName, HashMap addnParamsMap, int count, Boolean gpoStatus, Integer machineType) throws Exception {
        ArrayList guidSidList = new ArrayList();
        int[] machineTypes = (machineType & 0x1000) == 4096 ? new int[]{4096, 8192} : new int[]{4, 8, 16, 32, 64, 128, 131072, 262144};
        String query = ServerConfigAPI.buildQuery(domainName, addnParamsMap, null, null, null, machineTypes, gpoStatus);
        if (CommonUtil.getDBServerName().equalsIgnoreCase("mssql") && addnParamsMap != null && !addnParamsMap.isEmpty()) {
            query = ServerConfigAPI.buildMssqlQuery(query, addnParamsMap, count);
        }
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = RelationalAPI.getInstance().getConnection();
            statement = connection.createStatement();
            resultSet = QueryUtil.executeQuery("Getting Configured Servers", statement, query);
            while (resultSet.next()) {
                Hashtable<String, String> sidGuidMap = new Hashtable<String, String>();
                if (resultSet.getString("SID_STRING") != null) {
                    sidGuidMap.put("OBJECT_GUID", resultSet.getString("OBJECT_GUID"));
                    sidGuidMap.put("DISTINGUISHED_NAME", resultSet.getString("DISTINGUISHED_NAME"));
                }
                guidSidList.add(sidGuidMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
        return guidSidList;
    }

    public static void updateSecurityFilterStatus(DataObject dataObj, String objectGuid, boolean delegated) throws Exception {
        try {
            logger.log(Level.FINE, "objectGuid" + objectGuid);
            logger.log(Level.FINE, "delegation Status" + delegated);
            String tableName = "AUDComputerEventRead";
            Criteria c1 = new Criteria(Column.getColumn((String)tableName, (String)"OBJECT_GUID"), (Object)objectGuid, 0);
            Row computerRow = dataObj.getRow(tableName, c1);
            if (computerRow != null) {
                computerRow.set("GPO_STATUS", (Object)delegated);
                dataObj.updateRow(computerRow);
            }
        }
        catch (Exception ex) {
            logger.log(Level.FINE, "Exception ex" + ex);
            ex.printStackTrace();
        }
    }

    public static Hashtable<String, Object> getGpoEntries(String domainName, String gpoName) throws Exception {
        Hashtable<String, Object> gpoEntries = new Hashtable<String, Object>();
        try {
            String gpoGuid = null;
            String gpoDsPath = null;
            Integer gpoFlags = null;
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)gpoTableName));
            Column column = Column.getColumn((String)gpoTableName, (String)"*");
            query.addSelectColumn(column);
            Criteria criteria = new Criteria(Column.getColumn((String)gpoTableName, (String)"DOMAIN_NAME"), (Object)domainName, 0);
            Criteria criteria1 = new Criteria(Column.getColumn((String)gpoTableName, (String)"GPO_NAME"), (Object)gpoName, 0);
            criteria = criteria.and(criteria1);
            query.setCriteria(criteria);
            dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            if (!dataObj.isEmpty()) {
                Row gpoRow = dataObj.getRow(gpoTableName);
                gpoGuid = (String)gpoRow.get("GPO_GUID");
                gpoName = (String)gpoRow.get("GPO_NAME");
                gpoDsPath = (String)gpoRow.get("GPO_DS_PATH");
                gpoFlags = (Integer)gpoRow.get("GPO_FLAGS");
                gpoEntries.put("GPO_GUID", gpoGuid);
                gpoEntries.put("DOMAIN_NAME", (String)gpoRow.get("DOMAIN_NAME"));
                if (gpoDsPath != null) {
                    gpoEntries.put("GPO_DS_PATH", gpoDsPath);
                }
                if (gpoRow.get("GPO_GROUP_DN") != null) {
                    gpoEntries.put("GPO_GROUP_DN", (String)gpoRow.get("GPO_GROUP_DN"));
                }
                if (gpoRow.get("GPO_GROUP_SID") != null) {
                    gpoEntries.put("GPO_GROUP_SID", (String)gpoRow.get("GPO_GROUP_SID"));
                }
                gpoEntries.put("GPO_FLAGS", gpoFlags);
            }
            gpoEntries.put("GPO_NAME", gpoName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        logger.log(Level.FINE, "GpoEntries is" + gpoEntries);
        return gpoEntries;
    }

    public static ArrayList getStringSid(String[] objectGuids) throws Exception {
        String tableName = "ADSMComputerGeneralDetails";
        ArrayList stringSids = new ArrayList();
        DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)tableName));
        Column column = Column.getColumn((String)tableName, (String)"*");
        query.addSelectColumn(column);
        Criteria guidCriteria = new Criteria(Column.getColumn((String)tableName, (String)"OBJECT_GUID"), (Object)objectGuids, 8);
        query.setCriteria(guidCriteria);
        dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
        Iterator iterator = dataObj.getRows(tableName);
        while (iterator.hasNext()) {
            Hashtable<String, String> sidMap = new Hashtable<String, String>();
            Row computerRow = (Row)iterator.next();
            sidMap.put("OBJECT_GUID", (String)computerRow.get("OBJECT_GUID"));
            sidMap.put("DISTINGUISHED_NAME", (String)computerRow.get("DISTINGUISHED_NAME"));
            stringSids.add(sidMap);
        }
        logger.log(Level.FINE, "stringSids is:" + stringSids);
        return stringSids;
    }

    public static void setOrRemoveGpoFlags(String domainName, String gpoGuid, Integer gpoFlag, boolean flag) throws Exception {
        try {
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Criteria c1 = new Criteria(Column.getColumn((String)gpoTableName, (String)"GPO_GUID"), (Object)gpoGuid, 0);
            Criteria c2 = new Criteria(Column.getColumn((String)gpoTableName, (String)"DOMAIN_NAME"), (Object)domainName, 0);
            c1 = c1.and(c2);
            dataObj = CommonUtil.getPersistence(new boolean[0]).get(gpoTableName, c1);
            if (dataObj.isEmpty()) {
                logger.log(Level.FINE, "Data object is empty so going to add firsttime");
            } else {
                Row gpoRow = dataObj.getRow(gpoTableName);
                Integer gpoFlags = (Integer)gpoRow.get("GPO_FLAGS");
                logger.log(Level.INFO, "Gpo flags before modification" + gpoFlags);
                gpoFlags = flag ? Integer.valueOf(gpoFlags | gpoFlag) : Integer.valueOf(gpoFlags & ~gpoFlag.intValue());
                logger.log(Level.INFO, "Gpo flags after modification" + gpoFlags);
                gpoRow.set("GPO_FLAGS", (Object)gpoFlags);
                dataObj.updateRow(gpoRow);
                CommonUtil.getPersistence(new boolean[0]).update(dataObj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void checkGPOGroupStatus(String domainName, Integer machineType) {
        boolean status = true;
        try {
            String gpoName = (machineType & 0x1000) == 4096 ? domainName + "_" + "ADAuditPlusWSPolicy" : domainName + "_" + "ADAuditPlusPolicy";
            Hashtable<String, Object> gpoEntries = AuditPolicyHandler.getGpoEntries(domainName, gpoName);
            String gpoGuid = (String)gpoEntries.get("GPO_GUID");
            logger.log(Level.INFO, "CheckGPOStatus gpoentries is:" + gpoEntries);
            if (gpoGuid != null) {
                if ((String)gpoEntries.get("GPO_GROUP_DN") == null) {
                    logger.log(Level.INFO, "CheckGPOStatus group_dn null");
                    status = false;
                } else {
                    Properties domainDetails = DomainHandler.getConfiguredValues(domainName, 1L);
                    String searchString = "(&(objectClass=group)(distinguishedName=" + (String)gpoEntries.get("GPO_GROUP_DN") + "))";
                    ArrayList<String> list = new ArrayList<String>();
                    list.add("distinguishedName");
                    ArrayList objectsList = ADHandler.getObjectsWithOutListener(domainDetails, domainDetails.getProperty("DEFAULT_NAMING_CONTEXT"), list, searchString);
                    if (objectsList == null || objectsList.isEmpty()) {
                        logger.log(Level.INFO, "CheckGPOStatus group is not present");
                        status = false;
                    }
                }
                logger.log(Level.INFO, "CheckGPOStatus gpo flag:" + (Integer)gpoEntries.get("GPO_FLAGS"));
                AuditPolicyHandler.setOrRemoveGpoFlags(domainName, gpoGuid, 48, status);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static boolean isGroupCreated(String gpoName, String domainName, int flag) {
        boolean isGroup = false;
        try {
            logger.log(Level.FINE, "GpoName is:" + gpoName);
            logger.log(Level.FINE, "domainName is:" + domainName);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Criteria c1 = new Criteria(new Column(gpoTableName, "GPO_NAME"), (Object)gpoName, 0);
            Criteria c2 = new Criteria(new Column(gpoTableName, "DOMAIN_NAME"), (Object)domainName, 0);
            c1 = c1.and(c2);
            dataObj = CommonUtil.getPersistence(new boolean[0]).get(gpoTableName, c1);
            if (dataObj.isEmpty()) {
                isGroup = false;
            } else {
                Row gpoRow = dataObj.getRow(gpoTableName);
                Integer gpoFlags = (Integer)gpoRow.get("GPO_FLAGS");
                if ((gpoFlags & flag) == flag) {
                    logger.log(Level.FINE, "group is created");
                    isGroup = true;
                } else {
                    isGroup = false;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isGroup;
    }

    public static void alreadyConfiguredMemberAdd(Properties domainDetails, String grpName, String grpDN, boolean isConfigured) {
        try {
            int machineType;
            int[] machineTypes;
            String domainName = (String)domainDetails.get("DOMAIN_NAME");
            if (grpName.contains("ADAuditPlusWS")) {
                machineTypes = new int[]{4096, 8192};
                machineType = 4096;
            } else {
                machineTypes = new int[]{4, 8, 16, 32, 64, 128, 131072, 262144};
                machineType = 8;
            }
            int serverCount = ServerConfigAPI.getConfiguredServerCount(domainName, null, null, machineTypes, isConfigured);
            int noOfObjects = 500;
            int div = serverCount / noOfObjects;
            if (serverCount % noOfObjects > 0) {
                ++div;
            }
            for (int i = 0; i < div; ++i) {
                HashMap<String, Object> addnParamsMap = new HashMap<String, Object>();
                addnParamsMap.put("tableName", "ADSMComputerGeneralDetails");
                addnParamsMap.put("sortColumn", "DISTINGUISHED_NAME");
                addnParamsMap.put("sortOrder", "desc");
                addnParamsMap.put("startIndex", i * noOfObjects + 1);
                addnParamsMap.put("noOfObjects", noOfObjects);
                ArrayList sidList = AuditPolicyHandler.getConfiguredServerSidList(domainName, addnParamsMap, serverCount, isConfigured, machineType);
                ArrayList memList = new ArrayList();
                memList = AuditPolicyHandler.addOrRemoveMembers(domainDetails, grpDN, sidList, 1, 2);
                if (memList == null || memList.size() <= 0) continue;
                AuditPolicyHandler.updateServerGPOStatus(memList, false);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static synchronized Hashtable nativeGroupCreation(Properties domainDetails, String groupName, ArrayList sidList) {
        Hashtable result = new Hashtable();
        result.put("objectExist", false);
        try {
            String domainName = (String)domainDetails.get("DOMAIN_NAME");
            ArrayList<String> list = new ArrayList<String>();
            list.add("distinguishedName");
            list.add("objectSid");
            String searchBase = "(&(objectClass=group)(sAMAccountName=" + groupName + "))";
            result = AuditPolicyHandler.nativeSearchObject(domainDetails, searchBase, list);
            if (!((Boolean)result.get("objectExist")).booleanValue()) {
                if (AuditPolicyHandler.addGroup(domainName, groupName, "ADAudit Plus", (String)domainDetails.get("DEFAULT_NAMING_CONTEXT"))) {
                    result = AuditPolicyHandler.nativeSearchObject(domainDetails, searchBase, list);
                    result.put("GROUP_CREATION", true);
                    AuditPolicyHandler.alreadyConfiguredMemberAdd(domainDetails, groupName, (String)result.get("GPO_GROUP_DN"), true);
                } else {
                    result.put("GROUP_CREATION", false);
                }
            }
            if (((Boolean)result.get("objectExist")).booleanValue() && sidList != null && !sidList.isEmpty()) {
                ArrayList memList = new ArrayList();
                memList = AuditPolicyHandler.addOrRemoveMembers(domainDetails, (String)result.get("GPO_GROUP_DN"), sidList, 1, 1);
                if (memList != null && !memList.isEmpty()) {
                    AuditPolicyHandler.updateServerGPOStatus(memList, true);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (result.get("GROUP_CREATION") == null) {
            result.put("GROUP_CREATION", false);
        }
        return result;
    }

    public static ArrayList addOrRemoveMembers(Properties domainDetails, String grpDn, ArrayList sidList, int action, int res) {
        ArrayList memList = new ArrayList();
        int lim = sidList.size();
        ArrayList<String> dnList = new ArrayList<String>();
        for (int i = 0; i < lim; ++i) {
            Hashtable sidMap = (Hashtable)sidList.get(i);
            dnList.add((String)sidMap.get("DISTINGUISHED_NAME"));
        }
        if (dnList != null && !dnList.isEmpty()) {
            memList = ADHandler.addOrRemoveMembers(domainDetails, grpDn, dnList, action, res);
        }
        return memList;
    }

    public static Hashtable nativeSearchObject(Properties domainDetails, String searchString, ArrayList attributeList) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        result.put("objectExist", false);
        ArrayList objectsList = ADHandler.getObjectsWithOutListener(domainDetails, domainDetails.getProperty("DEFAULT_NAMING_CONTEXT"), attributeList, searchString);
        if (objectsList != null && !objectsList.isEmpty()) {
            Properties properties = (Properties)objectsList.get(0);
            ArrayList grpDnList = (ArrayList)properties.get("distinguishedName");
            result.put("GPO_GROUP_DN", (String)grpDnList.get(0));
            ArrayList sidList = (ArrayList)properties.get("objectSid");
            result.put("SID_STRING", (String)sidList.get(0));
            result.put("objectExist", true);
        }
        return result;
    }

    public static boolean addGroup(String domainName, String grpName, String description, String namingContext) {
        ArrayList<Properties> propList = new ArrayList<Properties>();
        Properties prop1 = new Properties();
        prop1.put("DATA_HANDLER_TYPE", (Object)3L);
        prop1.put("ATTRIB_LDAP_NAME", "sAMAccountName");
        prop1.put("ATTRIB_VALUE", grpName);
        prop1.put("ATTRIB_VALUE_COUNT", (Object)1L);
        prop1.put("DW_CONTROL_CODE", (Object)2L);
        propList.add(prop1);
        Properties prop2 = new Properties();
        prop2.put("DATA_HANDLER_TYPE", (Object)7L);
        prop2.put("ATTRIB_LDAP_NAME", "groupType");
        prop2.put("ATTRIB_VALUE", "-2147483644");
        prop2.put("ATTRIB_VALUE_COUNT", (Object)1L);
        prop2.put("DW_CONTROL_CODE", (Object)2L);
        propList.add(prop2);
        Properties prop3 = new Properties();
        prop3.put("DATA_HANDLER_TYPE", (Object)3L);
        prop3.put("ATTRIB_LDAP_NAME", "description");
        prop3.put("ATTRIB_VALUE", description);
        prop3.put("ATTRIB_VALUE_COUNT", (Object)1L);
        prop3.put("DW_CONTROL_CODE", (Object)2L);
        propList.add(prop3);
        try {
            ADHandler.addGroup(domainName, 1L, "CN=Users," + namingContext, grpName, propList, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean getBuildType() {
        boolean status = false;
        try {
            String table = "SystemParams";
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)table));
            Criteria criteria = new Criteria(Column.getColumn((String)table, (String)"PARAM_NAME"), (Object)"ppmbuild", 0);
            query.setCriteria(criteria);
            query.addSelectColumn(Column.getColumn((String)table, (String)"*"));
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            if (!dataObj.isEmpty()) {
                Row row = dataObj.getRow(table);
                String val = (String)row.get("PARAM_VALUE");
                logger.log(Level.INFO, "ppm build:" + val);
                if (val.equals("true")) {
                    status = true;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return status;
    }

    public static void systemParamsEntryRemover() {
        boolean remove = false;
        try {
            if (AuditPolicyHandler.getBuildType()) {
                SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)gpoTableName));
                query.addSelectColumn(Column.getColumn((String)gpoTableName, (String)"*"));
                DataObject dataObj1 = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
                if (dataObj1.isEmpty()) {
                    remove = true;
                } else {
                    remove = true;
                    Iterator ie = dataObj1.getRows(gpoTableName);
                    while (ie.hasNext()) {
                        Row rw = (Row)ie.next();
                        if ((String)rw.get("GPO_DS_PATH") == null || (String)rw.get("GPO_GROUP_DN") != null) continue;
                        remove = false;
                        break;
                    }
                }
                if (remove) {
                    String table = "SystemParams";
                    DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                    Criteria criteria = new Criteria(Column.getColumn((String)table, (String)"PARAM_NAME"), (Object)"ppmbuild", 0);
                    dataObj = CommonUtil.getPersistence(new boolean[0]).get(table, criteria);
                    if (!dataObj.isEmpty()) {
                        Row row = dataObj.getRow(table);
                        dataObj.deleteRow(row);
                        CommonUtil.getPersistence(new boolean[0]).update(dataObj);
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

