/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.delegation;

import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.schema.Attribute;
import com.adventnet.sym.adsm.common.server.schema.PropertySet;
import com.adventnet.sym.adsm.common.server.schema.SchemaAPI;
import com.adventnet.sym.adsm.common.server.schema.SchemaClass;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public final class DelegationConstants {
    private static final AdventNetResourceBundle RB = ResourceBundleMgr.getInstance().getBundle();
    private static final SchemaAPI SCHEMA_API = SchemaAPI.getInstance();
    public static final int ACCESS_ALLOWED_ACE_TYPE = 0;
    public static final int ACCESS_DENIED_ACE_TYPE = 1;
    public static final int SYSTEM_AUDIT_ACE_TYPE = 2;
    public static final int SYSTEM_ALARM_ACE_TYPE = 3;
    public static final int ACCESS_ALLOWED_COMPOUND_ACE_TYPE = 4;
    public static final int ACCESS_ALLOWED_OBJECT_ACE_TYPE = 5;
    public static final int ACCESS_DENIED_OBJECT_ACE_TYPE = 6;
    public static final int SYSTEM_AUDIT_OBJECT_ACE_TYPE = 7;
    public static final int SYSTEM_ALARM_OBJECT_ACE_TYPE = 8;
    public static final int ADS_ACEFLAG_INHERIT_ACE = 2;
    public static final int ADS_ACEFLAG_NO_PROPAGATE_INHERIT_ACE = 4;
    public static final int ADS_ACEFLAG_INHERIT_ONLY_ACE = 8;
    public static final int ADS_ACEFLAG_INHERITED_ACE = 16;
    public static final int ADS_ACEFLAG_VALID_INHERIT_FLAGS = 31;
    public static final int ADS_ACEFLAG_SUCCESSFUL_ACCESS = 64;
    public static final int ADS_ACEFLAG_FAILED_ACCESS = 128;
    public static final int OBJECT_INHERIT_ACE = 1;
    public static final int CONTAINER_INHERIT_ACE = 2;
    public static final int NO_PROPAGATE_INHERIT_ACE = 4;
    public static final int INHERIT_ONLY_ACE = 8;
    public static final int INHERITED_ACE = 16;
    public static final int VALID_INHERIT_FLAGS = 31;
    public static final int SUCCESSFUL_ACCESS_ACE_FLAG = 64;
    public static final int FAILED_ACCESS_ACE_FLAG = 128;
    private static final Long FILE_ALL_ACCESS = 0x1F01FFL;

    public static String getFileAceTypeString(Integer aceType, Integer aceFlag) {
        if (aceType == 0 || aceType == 5) {
            return RB.getString("adap.DelegationConstants.Allow");
        }
        if (aceType == 1 || aceType == 6) {
            return RB.getString("adap.DelegationConstants.Deny");
        }
        if (aceType == 2 || aceType == 7) {
            if ((aceFlag & 0x40) == 64 && (aceFlag & 0x80) == 128) {
                return RB.getString("adap.DelegationConstants.All");
            }
            if ((aceFlag & 0x40) == 64) {
                return RB.getString("adap.DomainAction.Success");
            }
            if ((aceFlag & 0x80) == 128) {
                return RB.getString("adap.DefaultCategoryListener.Failure");
            }
            return RB.getString("adap.DelegationConstants.Unknown_sacl_type");
        }
        return RB.getString("adap.DelegationConstants.Unknown_dacl_type");
    }

    public static String getFileAppliesToString(Integer aceFlag) {
        if ((aceFlag & 2) == 2 && (aceFlag & 1) == 1 && (aceFlag & 8) == 8) {
            return RB.getString("adap.DelegationConstants.Subfolders_and_files_only");
        }
        if ((aceFlag & 2) == 2 && (aceFlag & 1) == 1) {
            return RB.getString("adap.DelegationConstants.This_folder_subfolders_and_files");
        }
        if ((aceFlag & 2) == 2 && (aceFlag & 8) == 8) {
            return RB.getString("adap.DelegationConstants.Subfolders_only");
        }
        if ((aceFlag & 2) == 2) {
            return RB.getString("adap.DelegationConstants.This_folder_and_subfolders");
        }
        if ((aceFlag & 1) == 1 && (aceFlag & 8) == 8) {
            return RB.getString("adap.DelegationConstants.Files_only");
        }
        if ((aceFlag & 1) == 1) {
            return RB.getString("adap.DelegationConstants.This_folder_and_files_only");
        }
        return RB.getString("adap.DelegationConstants.This_object_only");
    }

    public static String getDSAppliesToString(Integer aceFlag) {
        if (aceFlag == 0) {
            return RB.getString("adap.DelegationConstants.This_object_only");
        }
        if ((aceFlag & 2) == 2 && (aceFlag & 8) == 8) {
            return RB.getString("adap.DelegationConstants.All_descendant_objects");
        }
        if ((aceFlag & 2) == 2) {
            return RB.getString("adap.DelegationConstants.This_object_all_descendant_objects");
        }
        return RB.getString("adap.DelegationConstants.This_object_only");
    }

    public static String isInheritedString(Integer aceFlag) {
        if ((aceFlag & 0x10) == 16) {
            return "true";
        }
        return "false";
    }

    public static String getAccessMaskString(String accessMask, String objectType) {
        StringBuilder accessMaskString = new StringBuilder();
        try {
            Long accessMaskLong = Long.decode(accessMask);
            if (accessMaskLong.equals(FILE_ALL_ACCESS)) {
                accessMaskString = new StringBuilder(RB.getString("adap.AccessMask.display_name.Full_Control"));
            } else {
                Hashtable accessMaskMap = SCHEMA_API.getAccessMaskMap(objectType);
                Enumeration enumeration = accessMaskMap.keys();
                while (enumeration.hasMoreElements()) {
                    Long accMask = (Long)enumeration.nextElement();
                    if ((accessMaskLong & accMask) != accMask) continue;
                    if (!accessMaskString.toString().equals("")) {
                        accessMaskString.append(",");
                    }
                    accessMaskString.append(accessMaskMap.get(accMask));
                }
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return accessMaskString.toString();
    }

    public static String getPermissionString(Hashtable aceTable, String domainName) {
        String permission = "";
        String type = "DS";
        try {
            PropertySet propertySet = null;
            SchemaClass schemaClass = null;
            Attribute attribute = null;
            String objectType = (String)aceTable.get("ObjectType");
            if (objectType != null) {
                propertySet = null;
                String guid = objectType.substring(1, objectType.length() - 1).toLowerCase();
                propertySet = SCHEMA_API.getPropertySetMap(guid);
                if (propertySet != null) {
                    if (SCHEMA_API.isExtendedAttribute(propertySet.getRightsGuid())) {
                        permission = propertySet.getDisplayName();
                    } else {
                        StringTokenizer st = new StringTokenizer(DelegationConstants.getAccessMaskString(aceTable.get("AccessMask").toString(), type), ",");
                        while (st.hasMoreTokens()) {
                            String value = st.nextToken();
                            permission = permission + value + " - " + propertySet.getDisplayName() + ",";
                        }
                    }
                } else {
                    attribute = null;
                    attribute = SCHEMA_API.getAttribute(guid);
                    if (attribute != null) {
                        StringTokenizer st = new StringTokenizer(DelegationConstants.getAccessMaskString(aceTable.get("AccessMask").toString(), type), ",");
                        while (st.hasMoreTokens()) {
                            String value = st.nextToken();
                            permission = permission + value + " - " + attribute.getCommonName() + ",";
                        }
                    } else {
                        schemaClass = null;
                        schemaClass = SCHEMA_API.getSchemaClass(guid);
                        if (schemaClass != null) {
                            StringTokenizer st = new StringTokenizer(DelegationConstants.getAccessMaskString(aceTable.get("AccessMask").toString(), type), ",");
                            while (st.hasMoreTokens()) {
                                String value = st.nextToken();
                                permission = permission + value + " - " + schemaClass.getCommonName() + ",";
                            }
                        } else {
                            String convertedGuid = DelegationConstants.guidConversionForLdapQuery(guid);
                            ArrayList schemaProps = ADHandler.getSchemaObjectFromGuid(domainName, 1L, "(&(objectClass=attributeSchema)(schemaIDGUID=" + convertedGuid + "))");
                            Properties prop = null;
                            if (schemaProps.size() == 0) {
                                schemaProps = ADHandler.getSchemaObjectFromGuid(domainName, 1L, "(&(objectClass=classSchema)(schemaIDGUID=" + convertedGuid + "))");
                                if (schemaProps.size() == 0) {
                                    permission = objectType;
                                } else {
                                    prop = (Properties)schemaProps.get(0);
                                    SchemaAPI.updateSchemaClasses(prop);
                                }
                            } else {
                                prop = (Properties)schemaProps.get(0);
                                SchemaAPI.updateAttributes(prop);
                            }
                            StringTokenizer st = new StringTokenizer(DelegationConstants.getAccessMaskString(aceTable.get("AccessMask").toString(), type), ",");
                            while (st.hasMoreTokens()) {
                                String value = st.nextToken();
                                permission = permission + value + " - " + prop != null ? prop.get("name").toString() : "-,";
                            }
                        }
                    }
                }
            } else {
                permission = DelegationConstants.getAccessMaskString(aceTable.get("AccessMask").toString(), type);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return permission;
    }

    public static String getAppliesToString(Hashtable aceTable, String domainName) {
        String appliesTo = "-";
        try {
            Object propertySet = null;
            SchemaClass schemaClass = null;
            Object attribute = null;
            Integer aceFlags = (Integer)aceTable.get("AceFlags");
            String inheritedObjectType = (String)aceTable.get("InheritedObjectType");
            if (inheritedObjectType != null) {
                String guid = inheritedObjectType.substring(1, inheritedObjectType.length() - 1).toLowerCase();
                schemaClass = null;
                schemaClass = SchemaAPI.getInstance().getSchemaClass(inheritedObjectType.substring(1, inheritedObjectType.length() - 1).toLowerCase());
                if (schemaClass != null) {
                    appliesTo = RB.handleGetObject("adap.DelegationConstants.Descendant_objects", new String[]{schemaClass.getCommonName()});
                } else {
                    String convertedGuid = DelegationConstants.guidConversionForLdapQuery(inheritedObjectType.substring(1, inheritedObjectType.length() - 1).toLowerCase());
                    ArrayList l = ADHandler.getSchemaObjectFromGuid(domainName, 1L, "(&(objectClass=classSchema)(schemaIDGUID=" + convertedGuid + "))");
                    if (l != null && l.size() > 0) {
                        Properties prop = (Properties)l.get(0);
                        appliesTo = RB.handleGetObject("adap.DelegationConstants.Descendant_objects", new String[]{(String)((ArrayList)prop.get("name")).get(0)});
                        SchemaAPI.updateSchemaClasses(prop);
                    }
                }
            } else {
                appliesTo = DelegationConstants.getDSAppliesToString(aceFlags);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return appliesTo;
    }

    public static String guidConversionForLdapQuery(String schemaGuid) {
        char[] id = schemaGuid.toCharArray();
        String guid = null;
        guid = "\\" + id[6] + id[7] + "\\" + id[4] + id[5] + "\\" + id[2] + id[3] + "\\" + id[0] + id[1];
        guid = guid + "\\" + id[11] + id[12] + "\\" + id[9] + id[10];
        guid = guid + "\\" + id[16] + id[17] + "\\" + id[14] + id[15];
        guid = guid + "\\" + id[19] + id[20] + "\\" + id[21] + id[22];
        guid = guid + "\\" + id[24] + id[25] + "\\" + id[26] + id[27] + "\\" + id[28] + id[29] + "\\" + id[30] + id[31] + "\\" + id[32] + id[33] + "\\" + id[34] + id[35];
        return guid;
    }
}

