/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.delegation;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.config.ServerConfigAPI;
import com.adventnet.sym.adsm.auditing.server.delegation.AdvancedGpoHandler;
import com.adventnet.sym.adsm.auditing.server.delegation.AuditPolicyHandler;
import com.adventnet.sym.adsm.auditing.server.delegation.GpoThread;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.export.AuditGPOCsvWriter;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GpoHandler {
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private static Logger logger = Logger.getLogger(GpoHandler.class.getName());
    public static String gpoTableName = "AUDGpoDetails";
    public static String gpoForFs = "ADAuditPlusPolicy";
    public static String gpoForWs = "ADAuditPlusWSPolicy";
    public static String gpoSecurityFilterTable = "AUDGpoSecurityFilter";
    public static String gpoWsGroup = "ADAuditPlusWS";
    public static String gpoFsGroup = "ADAuditPlusFS";
    private static String[] audGpoSecurityFilterDBColumns = new String[]{"ACE_ID", "ACCESS_MASK", "ACE_TYPE", "INHERIT_TYPE_FLAG", "PERMISSION_GUID", "APPLIES_GUID"};
    private static String[] gpoACEIdsForAuthUsers = new String[]{"AUDGpoSecurityFilter:ace_id:1006"};
    private static String[] gpoSecurityFilterACEIds = new String[]{"AUDGpoSecurityFilter:ace_id:1005", "AUDGpoSecurityFilter:ace_id:1006"};
    private static String[] policyCategoriesMS = new String[]{"AuditLogonEvents", "AuditAccountManage", "AuditObjectAccess", "AuditProcessTracking", "AuditSystemEvents", "AuditPolicyChange"};
    private static String[] settingValuesMS = new String[]{"3", "3", "3", "1", "1", "1"};
    private static String[] policyCategoriesDC = new String[]{"AuditAccountLogon", "AuditLogonEvents", "AuditAccountManage", "AuditDSAccess", "AuditObjectAccess", "AuditProcessTracking", "AuditSystemEvents", "AuditPolicyChange"};
    private static String[] settingValuesDC = new String[]{"3", "3", "3", "1", "1", "1", "1", "1"};
    private static String[] policyCategoriesWS = new String[]{"AuditLogonEvents"};
    private static String[] settingValuesWS = new String[]{"3"};
    private static final int GPO_CREATED = 1;
    private static final int GPO_LINKED = 2;
    private static final int GPO_APPLIED = 4;
    private static final int GPO_AUTH_USER_REMOVED = 8;
    private static final int GPO_GROUP_CREATED = 16;
    private static final int GPO_GROUP_ADDED = 32;

    public static String createGpoAndApplySecurityFilter(String domainName, String pdc, String[] objectGuid, Integer machineType) throws Exception {
        String gpoGrp;
        String gpoName;
        logger.log(Level.FINE, "****************Inside createGpoOrApplySecurityFilter*****************");
        String message = "";
        ArrayList<String> attList = new ArrayList<String>();
        attList.add("name");
        attList.add("displayName");
        if ((machineType & 0x1000) == 4096) {
            gpoName = domainName + "_" + gpoForWs;
            gpoGrp = gpoWsGroup;
        } else {
            gpoName = domainName + "_" + gpoForFs;
            gpoGrp = gpoFsGroup;
        }
        try {
            Properties domainDetails = DomainHandler.getConfiguredValues(domainName, 1L);
            String isLocalDomain = "true";
            isLocalDomain = domainDetails.get("USER_NAME") == null ? "true" : "false";
            if (pdc == null) {
                Hashtable pdcTable = (Hashtable)ADHandler.getPrimaryDC(domainName);
                if (pdcTable == null || pdcTable.get("PDC_FLAT_NAME") == null) {
                    String msg = rb.getString("adap.GPOHandler.Error_while_enabling_audit_policy_via_GPO") + ":" + rb.getString("adap.GPOHandler.Not_able_to_find_PDC");
                    throw new Exception(msg);
                }
                pdc = (String)pdcTable.get("PDC_FLAT_NAME");
                pdc = pdc.replace("\\\\", "");
                pdc = pdc.trim();
            }
            boolean del = GpoHandler.corruptedGPOCleaner(domainName, pdc, isLocalDomain, machineType);
            boolean isGpo = GpoHandler.isGpoCreated(domainName, gpoName);
            logger.log(Level.FINE, "GpoCreated Status:" + isGpo);
            if (isGpo) {
                logger.log(Level.FINE, "Gpo is alreay created for domain:" + domainName);
                message = rb.getString("adap.GPOHandler.Gpo_is_already_created_successfully");
                boolean isGpoApplied = GpoHandler.isGpoApplied(domainName, gpoName);
                logger.log(Level.FINE, "GpoApplied Status" + isGpoApplied);
                boolean policyStatus = GpoHandler.getAuditPolicyStatus(domainName, gpoName, machineType);
                logger.log(Level.FINE, "policyStatus" + policyStatus);
                if (isGpoApplied && policyStatus) {
                    logger.log(Level.FINE, "Gpo is already applied successfully for domain");
                    message = rb.getString("adap.GPOHandler.ObjectAccess_Audit_LogonEvents_policy_is_enabled_via_GPO");
                } else {
                    message = GpoHandler.updateGroupPolicy(domainName, gpoName, pdc, machineType, isLocalDomain);
                    GpoHandler.removeAuthenticatedUsers(domainName, gpoName, pdc);
                }
            } else {
                Properties gpoProp = ADHandler.searchGpo(domainName, gpoName, pdc, attList);
                if (gpoProp != null && gpoProp.get("IS_GPO_FOUND") != null && gpoProp.get("IS_GPO_FOUND").equals("true")) {
                    AuditPolicyHandler.updateExistingGpo(gpoProp, gpoName, domainName, machineType);
                    message = GpoHandler.updateGroupPolicy(domainName, gpoName, pdc, machineType, isLocalDomain);
                } else if (gpoProp != null && gpoProp.get("IS_GPO_FOUND") != null && gpoProp.get("IS_GPO_FOUND").equals("false")) {
                    message = GpoHandler.createGroupPolicy(domainName, gpoName, pdc, machineType, isLocalDomain);
                } else {
                    throw new Exception("Error while searching existence of GPO");
                }
                GpoHandler.removeAuthenticatedUsers(domainName, gpoName, pdc);
            }
            boolean authUserStatus = GpoHandler.isAuthUserRemoved(gpoName, domainName);
            if (!authUserStatus) {
                GpoHandler.removeAuthenticatedUsers(domainName, gpoName, pdc);
            }
            if (objectGuid != null) {
                GpoHandler.applySecurityFilter(domainName, gpoName, pdc, objectGuid, gpoGrp);
            } else {
                logger.log(Level.INFO, "the call is from reCongigureGpo");
            }
        }
        catch (Exception ex) {
            message = ex.getMessage();
            ex.printStackTrace();
        }
        logger.log(Level.FINE, "Message is:" + message);
        logger.log(Level.FINE, "*****************Leaving createGpoOrApplySecurityFilter*********************");
        return message;
    }

    public static String reConfigureGpo(String domainName, Integer machineType) throws Exception {
        logger.log(Level.FINE, "****************Inside reCongigureGpo*****************");
        String message = "";
        try {
            int[] machineTypes;
            String gpoGrp;
            String gpoName;
            if ((machineType & 0x1000) == 4096) {
                gpoName = domainName + "_" + gpoForWs;
                gpoGrp = gpoWsGroup;
                machineTypes = new int[]{4096, 8192};
            } else {
                gpoName = domainName + "_" + gpoForFs;
                gpoGrp = gpoFsGroup;
                machineTypes = new int[]{4, 8, 16, 32, 64, 128, 131072, 262144};
            }
            Hashtable pdcTable = (Hashtable)ADHandler.getPrimaryDC(domainName);
            String pdc = null;
            if (pdcTable == null || pdcTable.get("PDC_FLAT_NAME") == null) {
                message = rb.getString("adap.GPOHandler.Not_able_to_find_PDC");
                throw new Exception(message);
            }
            pdc = (String)pdcTable.get("PDC_FLAT_NAME");
            pdc = pdc.replace("\\\\", "");
            pdc = pdc.trim();
            message = GpoHandler.createGpoAndApplySecurityFilter(domainName, pdc, null, machineType);
            Hashtable<String, Object> gpoEntries = AuditPolicyHandler.getGpoEntries(domainName, gpoName);
            ArrayList sidList = AuditPolicyHandler.getConfiguredServerSidList(domainName, null, 0, false, machineType);
            if (sidList.size() > 0 || (Integer)gpoEntries.get("GPO_FLAGS") != 63) {
                int serverCount;
                String gpoGuid = (String)gpoEntries.get("GPO_GUID");
                Properties domainDetails = DomainHandler.getConfiguredValues(domainName, 1L);
                Hashtable result = AuditPolicyHandler.nativeGroupCreation(domainDetails, gpoGrp, sidList);
                if (((Boolean)result.get("objectExist")).booleanValue()) {
                    Integer flag = (Integer)gpoEntries.get("GPO_FLAGS") | 0x10;
                    gpoEntries.put("GPO_GROUP_DN", (String)result.get("GPO_GROUP_DN"));
                    gpoEntries.put("GPO_GROUP_SID", (String)result.get("SID_STRING"));
                    gpoEntries.put("GPO_FLAGS", flag);
                    AuditPolicyHandler.updateGpoDetails(gpoEntries);
                    if ((flag & 0x20) != 32 || ((Boolean)result.get("GROUP_CREATION")).booleanValue()) {
                        AuditPolicyHandler.setOrRemoveGpoFlags(domainName, gpoGuid, 32, false);
                        ArrayList<Hashtable> grpSid = new ArrayList<Hashtable>();
                        grpSid.add(result);
                        ArrayList aceList = GpoHandler.getACESForGPO(GpoHandler.getGpoAcePattern(), "add");
                        GpoHandler.addSecurityFilter(domainName, pdc, aceList, grpSid, gpoGuid);
                    }
                }
                if ((serverCount = ServerConfigAPI.getConfiguredServerCount(domainName, null, null, machineTypes, false)) > 0) {
                    message = message + " " + rb.getString("adap.GPOHandler.and_error_in_securityfilter_of_GPO");
                }
            } else {
                logger.log(Level.INFO, "All the configured machines is already added in the security filter of GPO");
            }
        }
        catch (Exception ex) {
            message = ex.getMessage();
            ex.printStackTrace();
        }
        logger.log(Level.FINE, "Message is:" + message);
        logger.log(Level.FINE, "*****************Leaving reCongigureGpo*********************");
        return message;
    }

    public static void removeAuthenticatedUsers(String domainName, String gpoName, String pdc) throws Exception {
        Hashtable<String, Object> gpoEntries = AuditPolicyHandler.getGpoEntries(domainName, gpoName);
        String gpoGuid = (String)gpoEntries.get("GPO_GUID");
        ArrayList sidList = new ArrayList();
        Hashtable<String, String> sidMap = new Hashtable<String, String>();
        sidMap.put("OBJECT_GUID", "empty");
        sidMap.put("SID_STRING", "S-1-5-11");
        sidList.add(sidMap);
        ArrayList aceList = GpoHandler.getACESForGPO(gpoACEIdsForAuthUsers, "delete");
        GpoHandler.deleteSecurityFilter(domainName, pdc, aceList, sidList, gpoGuid, true);
    }

    public static ArrayList getACESForGPO(String[] uvhPattern, String operation) throws Exception {
        ArrayList<Properties> ACEList = new ArrayList<Properties>();
        try {
            logger.log(Level.FINE, "uvhPattern is" + uvhPattern);
            if (uvhPattern != null) {
                Long[] uvhValues = null;
                uvhValues = DBObjectUtil.getUVHValues("AUDGpoSecurityFilter", uvhPattern);
                Criteria criteria = new Criteria(Column.getColumn((String)"AUDGpoSecurityFilter", (String)"ACE_ID"), (Object)uvhValues, 8);
                DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDGpoSecurityFilter", criteria);
                if (!dataObject.isEmpty()) {
                    Iterator iterator = dataObject.getRows("AUDGpoSecurityFilter");
                    while (iterator.hasNext()) {
                        Row ACERow = (Row)iterator.next();
                        Properties ACEMap = new Properties();
                        for (String string : audGpoSecurityFilterDBColumns) {
                            Object DBValue = ACERow.get(string);
                            if (DBValue == null) continue;
                            ACEMap.put(string, DBValue);
                        }
                        ACEMap.put("operation", operation);
                        ACEList.add(ACEMap);
                    }
                }
            }
            logger.log(Level.FINE, "AceList is" + ACEList);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return ACEList;
    }

    public static void applySecurityFilter(String domainName, String gpoName, String pdc, String[] objectGuid, String gpoGrp) throws Exception {
        try {
            logger.log(Level.FINE, "***************Inside applySecurityFilter******************");
            Hashtable<String, Object> gpoDetails = new Hashtable<String, Object>();
            ArrayList stringSids = AuditPolicyHandler.getStringSid(objectGuid);
            gpoDetails.put("DOMAIN_NAME", domainName);
            gpoDetails.put("GPO_NAME", gpoName);
            gpoDetails.put("GUID_SID", stringSids);
            gpoDetails.put("PDC", pdc);
            gpoDetails.put("GPO_GRP", gpoGrp);
            new GpoThread("AddGpoSecurityFilter", gpoDetails, domainName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        logger.log(Level.FINE, "***************Leaving applySecurityFilter******************");
    }

    public static void removeSecurityFilter(String domainName, String gpoName, String[] objectGuid) throws Exception {
        try {
            logger.log(Level.FINE, "***************Inside removeSecurityFilter******************");
            Hashtable<String, Object> gpoDetails = new Hashtable<String, Object>();
            ArrayList stringSids = AuditPolicyHandler.getStringSid(objectGuid);
            gpoName = domainName + "_" + gpoName;
            gpoDetails.put("DOMAIN_NAME", domainName);
            gpoDetails.put("GPO_NAME", gpoName);
            gpoDetails.put("GUID_SID", stringSids);
            new GpoThread("RemoveGpoSecurityFilter", gpoDetails, domainName);
            logger.log(Level.FINE, "***************Leaving removeSecurityFilter******************");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void checkAuditPolicy(String domainName, Integer machineType) throws Exception {
        try {
            logger.log(Level.FINE, "************Inside checkAuditPolicy*******************");
            String gpoName = (machineType & 0x1000) == 4096 ? domainName + "_" + gpoForWs : domainName + "_" + gpoForFs;
            Hashtable<String, Object> gpoEntries = AuditPolicyHandler.getGpoEntries(domainName, gpoName);
            GpoHandler.getAuditPolicy(domainName, (String)gpoEntries.get("GPO_GUID"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        logger.log(Level.FINE, "************Leaving checkAuditPolicy*******************");
    }

    public static void getAuditPolicy(String domainName, String gpoGuid) {
        logger.log(Level.FINE, "****************Inside getAuditPolicy***************************" + domainName);
        String polTblName = "AUDAuditPolicy";
        try {
            if (gpoGuid == null || "".equals(gpoGuid)) {
                logger.log(Level.FINE, "GpoGuid is null.it means that gpo is yet created");
            } else {
                try {
                    Hashtable policyTable = ADHandler.getPolicyStatus(domainName, "Event Audit", "GET", gpoGuid, AuditGPOCsvWriter.getInstance(), "true");
                    String policyString = (String)policyTable.get("policyStatusKey");
                    GpoHandler.updateAuditPolicy(domainName, gpoGuid, policyTable);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    AuditPolicyHandler.setOrRemoveGpoFlags(domainName, gpoGuid, 4, false);
                }
            }
        }
        catch (Exception ex) {
            logger.log(Level.FINE, "Error while adding policy status -> ");
            ex.printStackTrace();
        }
    }

    public static String createGroupPolicy(String domainName, String gpoName, String pdc, Integer machineType, String isLocalDomain) throws Exception {
        String message = rb.getString("adap.GPOHandler.Error_while_enabling_audit_policy_via_GPO");
        try {
            logger.log(Level.FINE, "*********************Inside createGroupPolicy**************");
            Hashtable gpoDetails = null;
            gpoDetails = ADHandler.createAndUpdateGpo(domainName, null, gpoName, pdc, machineType, 0, isLocalDomain);
            if (gpoDetails != null) {
                if ((String)gpoDetails.get("MESSAGE") != null) {
                    message = (String)gpoDetails.get("MESSAGE");
                    logger.log(Level.FINE, "gpoDetails from Native is:" + gpoDetails);
                    if (!message.equalsIgnoreCase("SUCCESS")) {
                        logger.log(Level.FINE, "Error while Creating GPO" + gpoDetails.get("MESSAGE"));
                        message = rb.getString("adap.GPOHandler.Error_while_enabling_audit_policy_via_GPO") + ":" + (String)gpoDetails.get("MESSAGE");
                    } else {
                        message = rb.getString("adap.GPOHandler.ObjectAccess_and_Audit_LogonEvents_auditing_is_enabled_via_GPO");
                    }
                }
                AuditPolicyHandler.updateGpoDetails(gpoDetails);
                Hashtable<String, Object> gpotable = new Hashtable<String, Object>();
                gpotable.put("policyStatusKey", (String)gpoDetails.get("AUDIT_POLICY"));
                if (gpoDetails.get("AdvpolicyStatusKey") != null) {
                    gpotable.put("AdvpolicyStatusKey", (String)gpoDetails.get("AdvpolicyStatusKey"));
                }
                GpoHandler.updateAuditPolicy((String)gpoDetails.get("DOMAIN_NAME"), (String)gpoDetails.get("GPO_GUID"), gpotable);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        logger.log(Level.FINE, "Message is:" + message);
        logger.log(Level.FINE, "*********************Leaving createGroupPolicy**************");
        return message;
    }

    public static String updateGroupPolicy(String domainName, String gpoName, String pdc, Integer machineType, String isLocalDomain) throws Exception {
        String message = rb.getString("adap.GPOHandler.Error_while_enabling_audit_policy_via_GPO");
        try {
            logger.log(Level.FINE, "*********************Inside updateGroupPolicy**************");
            Hashtable gpoDetails = null;
            Hashtable<String, Object> gpoEntries = AuditPolicyHandler.getGpoEntries(domainName, gpoName);
            if ((String)gpoEntries.get("GPO_GUID") != null && domainName != null && (String)gpoEntries.get("GPO_NAME") != null) {
                gpoDetails = ADHandler.createAndUpdateGpo(domainName, (String)gpoEntries.get("GPO_GUID"), (String)gpoEntries.get("GPO_NAME"), pdc, machineType, (Integer)gpoEntries.get("GPO_FLAGS"), isLocalDomain);
            }
            if (gpoDetails != null) {
                if ((String)gpoDetails.get("MESSAGE") != null) {
                    message = (String)gpoDetails.get("MESSAGE");
                    logger.log(Level.FINE, "gpoDetails from Native is:" + gpoDetails);
                    if (!message.equalsIgnoreCase("SUCCESS")) {
                        logger.log(Level.FINE, "Error while updating GPO" + gpoDetails.get("MESSAGE"));
                        message = rb.getString("adap.GPOHandler.Error_while_enabling_audit_policy_via_GPO") + " (" + (String)gpoDetails.get("MESSAGE") + ")";
                    } else {
                        message = rb.getString("adap.GPOHandler.ObjectAccess_and_Audit_LogonEvents_auditing_is_enabled_via_GPO");
                    }
                }
                AuditPolicyHandler.updateGpoDetails(gpoDetails);
                Hashtable<String, Object> gpotable = new Hashtable<String, Object>();
                gpotable.put("policyStatusKey", (String)gpoDetails.get("AUDIT_POLICY"));
                gpotable.put("AdvpolicyStatusKey", (String)gpoDetails.get("AdvpolicyStatusKey"));
                gpotable.put("machineType", (machineType & 0x1000) == 4096 ? "WS" : "FS");
                GpoHandler.updateAuditPolicy((String)gpoDetails.get("DOMAIN_NAME"), (String)gpoDetails.get("GPO_GUID"), gpotable);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        logger.log(Level.FINE, "Message is:" + message);
        logger.log(Level.FINE, "*********************Leaving updateGroupPolicy**************");
        return message;
    }

    public static boolean isGpoCreated(String domainName, String gpoName) throws Exception {
        boolean isGpo = true;
        DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
        Criteria c1 = new Criteria(Column.getColumn((String)gpoTableName, (String)"GPO_NAME"), (Object)gpoName, 0);
        Criteria c2 = new Criteria(Column.getColumn((String)gpoTableName, (String)"DOMAIN_NAME"), (Object)domainName, 0);
        c1 = c1.and(c2);
        dataObj = CommonUtil.getPersistence(new boolean[0]).get(gpoTableName, c1);
        if (dataObj.isEmpty()) {
            isGpo = false;
        }
        logger.log(Level.FINE, "IsGpo:" + isGpo);
        return isGpo;
    }

    public static boolean isGpoApplied(String domainName, String gpoName) throws Exception {
        boolean isGpoApplied = true;
        DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
        Criteria c1 = new Criteria(Column.getColumn((String)gpoTableName, (String)"GPO_NAME"), (Object)gpoName, 0);
        Criteria c2 = new Criteria(Column.getColumn((String)gpoTableName, (String)"DOMAIN_NAME"), (Object)domainName, 0);
        c1 = c1.and(c2);
        dataObj = CommonUtil.getPersistence(new boolean[0]).get(gpoTableName, c1);
        if (dataObj.isEmpty()) {
            isGpoApplied = false;
        } else {
            Row gpoRow = dataObj.getRow(gpoTableName);
            Integer gpoFlags = (Integer)gpoRow.get("GPO_FLAGS");
            logger.log(Level.INFO, "gpoFlags :" + gpoFlags);
            if ((gpoFlags & 2) == 2 && (gpoFlags & 4) == 4) {
                logger.log(Level.INFO, "Gpo is already applied");
                isGpoApplied = true;
            } else {
                isGpoApplied = false;
            }
        }
        logger.log(Level.FINE, "isGpoApplied:" + isGpoApplied);
        return isGpoApplied;
    }

    public static boolean isAuthUserRemoved(String gpoName, String domainName) throws Exception {
        boolean isAuthUser = false;
        try {
            logger.log(Level.FINE, "GpoName is:" + gpoName);
            logger.log(Level.FINE, "domainName is:" + domainName);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Criteria c1 = new Criteria(new Column(gpoTableName, "GPO_NAME"), (Object)gpoName, 0);
            Criteria c2 = new Criteria(new Column(gpoTableName, "DOMAIN_NAME"), (Object)domainName, 0);
            c1 = c1.and(c2);
            dataObj = CommonUtil.getPersistence(new boolean[0]).get(gpoTableName, c1);
            if (dataObj.isEmpty()) {
                isAuthUser = false;
            } else {
                Row gpoRow = dataObj.getRow(gpoTableName);
                Integer gpoFlags = (Integer)gpoRow.get("GPO_FLAGS");
                if ((gpoFlags & 8) == 8) {
                    logger.log(Level.FINE, "Auth user is removed successfully");
                    isAuthUser = true;
                } else {
                    isAuthUser = false;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.log(Level.FINE, "isAuthUser:" + isAuthUser);
        return isAuthUser;
    }

    public static void updateAuditPolicy(String domainName, String gpoGuid, Hashtable<String, Object> policyTable) throws Exception {
        logger.log(Level.FINE, "****************Inside updateAuditPolicy***************************" + domainName);
        String polTblName = "AUDAuditPolicy";
        try {
            String policyString = (String)policyTable.get("policyStatusKey");
            if (policyString == null || "".equals(policyString) || gpoGuid == null) {
                logger.log(Level.FINE, "Return policy string from native is empty!");
                AuditPolicyHandler.setOrRemoveGpoFlags(domainName, gpoGuid, 4, false);
                return;
            }
            logger.log(Level.FINE, "Return -> " + policyString);
            String[] att = policyString.split("%");
            logger.log(Level.FINE, "att -> " + att);
            logger.log(Level.FINE, "att length -> " + att.length);
            Criteria domainCrit = new Criteria(Column.getColumn((String)polTblName, (String)"DOMAIN_NAME"), (Object)domainName, 0);
            Criteria crit = domainCrit.and(new Criteria(Column.getColumn((String)polTblName, (String)"GPO_GUID"), (Object)gpoGuid, 0));
            DataObject polDO = CommonUtil.getPersistence(new boolean[0]).get(polTblName, crit);
            if (!polDO.isEmpty()) {
                polDO.deleteRows(polTblName, crit);
            }
            for (int i = 0; i < att.length; ++i) {
                Row row = new Row(polTblName);
                row.set("DOMAIN_NAME", (Object)domainName);
                String[] s = att[i].split("=");
                row.set("ATTRIB_NAME", (Object)s[0]);
                row.set("ATTRIB_VALUE", (Object)s[1]);
                row.set("GPO_GUID", (Object)gpoGuid);
                polDO.addRow(row);
            }
            if (policyTable.get("AdvpolicyStatusKey") != null) {
                String machineType = (String)policyTable.get("machineType");
                AdvancedGpoHandler.constructAdvancedPolicyEntries((String)policyTable.get("AdvpolicyStatusKey"), gpoGuid, domainName, machineType != null ? machineType : "FS");
            }
            CommonUtil.getPersistence(new boolean[0]).update(polDO);
        }
        catch (Exception ex) {
            logger.log(Level.FINE, "Error while adding policy status -> ");
            ex.printStackTrace();
        }
        logger.log(Level.FINE, "************Leaving updateAuditPolicy*******************");
    }

    public static String[] getGpoAcePattern() throws Exception {
        return gpoSecurityFilterACEIds;
    }

    public static boolean getAuditPolicyStatus(String domainName, String gpoName, Integer machineType) throws DataAccessException {
        boolean r = false;
        String polTblName = "AUDAuditPolicy";
        Properties polProp = new Properties();
        try {
            Hashtable<String, Object> gpoEntries = AuditPolicyHandler.getGpoEntries(domainName, gpoName);
            if (gpoEntries.get("GPO_GUID") != null) {
                Criteria criteria = new Criteria(Column.getColumn((String)polTblName, (String)"DOMAIN_NAME"), (Object)domainName, 0);
                criteria = criteria.and(new Criteria(Column.getColumn((String)polTblName, (String)"GPO_GUID"), (Object)((String)gpoEntries.get("GPO_GUID")), 0));
                DataObject polDO = CommonUtil.getPersistence(new boolean[0]).get(polTblName, criteria);
                if (!polDO.isEmpty()) {
                    Iterator ie = polDO.getRows(polTblName);
                    while (ie.hasNext()) {
                        Row rw = (Row)ie.next();
                        polProp.put(rw.get("ATTRIB_NAME"), rw.get("ATTRIB_VALUE"));
                    }
                    String[] policyCategories = null;
                    String[] settingValues = null;
                    if ((machineType & 0x1000) == 4096) {
                        policyCategories = policyCategoriesWS;
                        settingValues = settingValuesWS;
                    } else if ((machineType & 1) == 1) {
                        policyCategories = policyCategoriesDC;
                        settingValues = settingValuesDC;
                    } else {
                        policyCategories = policyCategoriesMS;
                        settingValues = settingValuesMS;
                    }
                    r = true;
                    for (int i = 0; i < policyCategories.length; ++i) {
                        String value = (String)polProp.get(policyCategories[i]);
                        if (value != null && value.equals(settingValues[i])) continue;
                        r = false;
                        break;
                    }
                }
                if (r) {
                    r = AdvancedGpoHandler.getAuditPolicy(domainName, (String)gpoEntries.get("GPO_GUID"), (machineType & 0x1000) == 4096 ? "WS" : "FS");
                } else {
                    logger.log(Level.FINE, "Data object is Empty");
                }
            } else {
                logger.log(Level.FINE, "Gpo Guid is null so Gpo Is not yet created");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        logger.log(Level.FINE, "AuditPolicyStatus is " + r);
        return r;
    }

    public static boolean getGpoStatus(String domainName, Integer machineType) throws Exception {
        logger.log(Level.FINE, "****************Inside getGpoStatus****************");
        boolean gpoStatus = false;
        String gpoName = "";
        try {
            int[] machineTypes = null;
            if ((machineType & 0x1000) == 4096 || (machineType & 0x2000) == 8192) {
                machineTypes = new int[]{4096, 8192};
                gpoName = domainName + "_" + gpoForWs;
            } else {
                machineTypes = new int[]{4, 8, 16, 32, 64, 128, 131072, 262144};
                gpoName = domainName + "_" + gpoForFs;
            }
            int serverCount = ServerConfigAPI.getConfiguredServerCount(domainName, null, null, machineTypes, null);
            logger.log(Level.FINE, "Server count is" + serverCount);
            if (serverCount > 0) {
                boolean isSfApplied = true;
                boolean isGpoApplied = GpoHandler.isGpoApplied(domainName, gpoName);
                boolean isAuRemoved = GpoHandler.isAuthUserRemoved(gpoName, domainName);
                serverCount = ServerConfigAPI.getConfiguredServerCount(domainName, null, null, machineTypes, false);
                logger.log(Level.FINE, "Server count is" + serverCount);
                if (serverCount > 0) {
                    isSfApplied = false;
                }
                boolean isPPMBuild = AuditPolicyHandler.getBuildType();
                if (isGpoApplied && isSfApplied && isAuRemoved && isPPMBuild) {
                    return true;
                }
                boolean isGroupCreated = AuditPolicyHandler.isGroupCreated(gpoName, domainName, 48);
                boolean policyStatus = GpoHandler.getAuditPolicyStatus(domainName, gpoName, machineType);
                logger.log(Level.FINE, "isGpoApplid" + isGpoApplied);
                logger.log(Level.FINE, "isSecurityFilter" + isSfApplied);
                logger.log(Level.FINE, "policyStatus" + policyStatus);
                logger.log(Level.FINE, "isAuRemoved" + isAuRemoved);
                gpoStatus = isGpoApplied && isSfApplied && policyStatus && isAuRemoved && isGroupCreated;
            } else {
                gpoStatus = true;
                logger.log(Level.FINE, "No File/Member server is configured");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        logger.log(Level.FINE, "gpoStatus is " + gpoStatus);
        logger.log(Level.FINE, "****************Leaving getGpoStatus****************");
        return gpoStatus;
    }

    private static DataObject getAudComputerEventReadDO(ArrayList guidSidList) throws Exception {
        ArrayList guidList = new ArrayList();
        for (int i = 0; i < guidSidList.size(); ++i) {
            Hashtable tempHash = (Hashtable)guidSidList.get(i);
            guidList.add(tempHash.get("OBJECT_GUID"));
        }
        String tableName = "AUDComputerEventRead";
        Table table = Table.getTable((String)tableName);
        SelectQueryImpl query = new SelectQueryImpl(table);
        Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"OBJECT_GUID"), (Object)guidList.toArray(), 8);
        query.setCriteria(criteria);
        query.addSelectColumn(Column.getColumn((String)tableName, (String)"*"));
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
        return dataObject;
    }

    public static void addSecurityFilter(String domainName, String pdc, ArrayList aceList, ArrayList sidList, String gpoGuid) throws Exception {
        try {
            logger.log(Level.FINE, "************Inside addSecurityFilter***************");
            if (sidList.size() > 0 && aceList.size() > 0 && gpoGuid != null) {
                ArrayList<String> trusteeList = new ArrayList<String>();
                ArrayList tempList = new ArrayList();
                for (int i = 0; i < sidList.size(); ++i) {
                    Hashtable sidMap = (Hashtable)sidList.get(i);
                    if (sidMap == null) continue;
                    Hashtable<String, String> tempHash = new Hashtable<String, String>();
                    tempHash.put("GPO_GROUP_DN", (String)sidMap.get("GPO_GROUP_DN"));
                    tempHash.put("SID_STRING", (String)sidMap.get("SID_STRING"));
                    trusteeList.add((String)sidMap.get("SID_STRING"));
                    tempList.add(tempHash);
                }
                logger.log(Level.FINE, "trusteeList" + trusteeList);
                logger.log(Level.INFO, "tempList" + tempList);
                if (trusteeList.size() > 0 && !trusteeList.isEmpty()) {
                    ArrayList resultAceList = ADHandler.applySecurityFilterInGPO(domainName, aceList, trusteeList, gpoGuid, pdc);
                    if (resultAceList != null) {
                        logger.log(Level.FINE, "resultAceList" + resultAceList);
                        logger.log(Level.FINE, "resultAceList size" + resultAceList.size());
                        logger.log(Level.FINE, "aceList size" + aceList.size());
                        boolean delegated = false;
                        if (resultAceList.size() == 0 || resultAceList.isEmpty()) {
                            logger.log(Level.FINE, "The Delegation is failed");
                            delegated = false;
                        } else {
                            for (int j = 0; j < tempList.size(); ++j) {
                                delegated = false;
                                Hashtable sidGuidTable = (Hashtable)tempList.get(j);
                                Properties resultProp = null;
                                for (int k = 0; k < resultAceList.size(); ++k) {
                                    Hashtable resultHashtable = (Hashtable)resultAceList.get(k);
                                    resultProp = (Properties)resultHashtable.get((String)sidGuidTable.get("SID_STRING"));
                                    if (resultProp == null) continue;
                                    resultAceList.remove(k);
                                    break;
                                }
                                logger.log(Level.FINE, "resultAceList.size()" + resultAceList.size());
                                logger.log(Level.FINE, "resultAceList" + resultAceList);
                                logger.log(Level.FINE, "resultProp" + resultProp);
                                if (resultProp != null) {
                                    for (int l = 0; l < aceList.size(); ++l) {
                                        Properties aceProp = (Properties)aceList.get(l);
                                        Long aceId = (Long)aceProp.get("ACE_ID");
                                        String resultValue = (String)resultProp.get(aceId);
                                        logger.log(Level.FINE, "ACE_ID is" + aceId);
                                        logger.log(Level.FINE, "Value of AceID is" + resultValue);
                                        if (resultValue != null) {
                                            if (resultValue.equalsIgnoreCase("4")) {
                                                delegated = false;
                                                break;
                                            }
                                        } else {
                                            delegated = false;
                                            break;
                                        }
                                        delegated = true;
                                    }
                                    logger.log(Level.FINE, "Delegated value is:" + delegated);
                                    AuditPolicyHandler.setOrRemoveGpoFlags(domainName, gpoGuid, 32, delegated);
                                    logger.log(Level.FINE, "finished trustee");
                                    continue;
                                }
                                logger.log(Level.FINE, "resultProp is null. so properties is found for trustee" + (String)sidGuidTable.get("SID_STRING"));
                                AuditPolicyHandler.setOrRemoveGpoFlags(domainName, gpoGuid, 32, delegated);
                            }
                        }
                    } else {
                        logger.log(Level.INFO, "resultAceList is null");
                    }
                } else {
                    logger.log(Level.FINE, "trusteeList is Empty");
                }
            } else {
                logger.log(Level.FINE, "Gpo is not yet created");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        logger.log(Level.FINE, "************Leaving addSecurityFilter***************");
    }

    public static void deleteSecurityFilter(String domainName, String pdc, ArrayList aceList, ArrayList sidList, String gpoGuid, Boolean isAuthUser) throws Exception {
        try {
            logger.log(Level.FINE, "************Inside deleteSecurityFilter***************");
            if (sidList.size() > 0 && aceList.size() > 0 && gpoGuid != null) {
                ArrayList<String> trusteeList = new ArrayList<String>();
                ArrayList tempList = new ArrayList();
                for (int i = 0; i < sidList.size(); ++i) {
                    Hashtable sidMap = (Hashtable)sidList.get(i);
                    boolean isConfigured = AuditPolicyHandler.isConfiguredFileORMemberServer((String)sidMap.get("OBJECT_GUID"));
                    if (!isConfigured) {
                        Hashtable<String, String> tempHash = new Hashtable<String, String>();
                        tempHash.put("OBJECT_GUID", (String)sidMap.get("OBJECT_GUID"));
                        tempHash.put("SID_STRING", (String)sidMap.get("SID_STRING"));
                        tempList.add(tempHash);
                        trusteeList.add((String)sidMap.get("SID_STRING"));
                        continue;
                    }
                    logger.log(Level.INFO, "The deleted server is configured ad File/Member server");
                }
                logger.log(Level.INFO, "trusteeList" + trusteeList);
                logger.log(Level.INFO, "tempList" + tempList);
                if (trusteeList.size() > 0 && !trusteeList.isEmpty()) {
                    Hashtable sidGuidTable;
                    ArrayList resultAceList = ADHandler.applySecurityFilterInGPO(domainName, aceList, trusteeList, gpoGuid, pdc);
                    if (resultAceList != null) {
                        logger.log(Level.INFO, "resultAceList" + resultAceList);
                        logger.log(Level.FINE, "resultAceList size" + resultAceList.size());
                        logger.log(Level.FINE, "aceList size" + aceList.size());
                    }
                    if (isAuthUser.booleanValue()) {
                        if (resultAceList != null) {
                            if (resultAceList.size() == 0 || resultAceList.isEmpty()) {
                                AuditPolicyHandler.setOrRemoveGpoFlags(domainName, gpoGuid, 8, false);
                                logger.log(Level.FINE, "The Delegation is failed");
                            } else {
                                for (int j = 0; j < tempList.size(); ++j) {
                                    boolean delegatedRemoved = false;
                                    sidGuidTable = (Hashtable)tempList.get(j);
                                    Properties resultProp = null;
                                    for (int k = 0; k < resultAceList.size(); ++k) {
                                        Hashtable resultHashtable = (Hashtable)resultAceList.get(k);
                                        resultProp = (Properties)resultHashtable.get((String)sidGuidTable.get("SID_STRING"));
                                        if (resultProp == null) continue;
                                        resultAceList.remove(k);
                                        break;
                                    }
                                    logger.log(Level.FINE, "resultAceList.size()" + resultAceList.size());
                                    logger.log(Level.FINE, "resultAceList" + resultAceList);
                                    logger.log(Level.FINE, "resultProp" + resultProp);
                                    if (resultProp != null) {
                                        for (int l = 0; l < aceList.size(); ++l) {
                                            Properties aceProp = (Properties)aceList.get(l);
                                            Long aceId = (Long)aceProp.get("ACE_ID");
                                            String resultValue = (String)resultProp.get(aceId);
                                            logger.log(Level.FINE, "ACE_ID is" + aceId);
                                            logger.log(Level.FINE, "Value of AceID is" + resultValue);
                                            if (resultValue != null) {
                                                if (!resultValue.equalsIgnoreCase("0") && !resultValue.equalsIgnoreCase("3")) {
                                                    delegatedRemoved = false;
                                                    break;
                                                }
                                            } else {
                                                delegatedRemoved = false;
                                                break;
                                            }
                                            delegatedRemoved = true;
                                        }
                                        logger.log(Level.FINE, "Delegated value is:" + delegatedRemoved);
                                        if (delegatedRemoved) {
                                            AuditPolicyHandler.setOrRemoveGpoFlags(domainName, gpoGuid, 8, true);
                                        } else {
                                            AuditPolicyHandler.setOrRemoveGpoFlags(domainName, gpoGuid, 8, false);
                                        }
                                        logger.log(Level.FINE, "finished trustee");
                                        continue;
                                    }
                                    logger.log(Level.FINE, "resultProp is null. so properties is found for trustee" + (String)sidGuidTable.get("SID_STRING"));
                                    AuditPolicyHandler.setOrRemoveGpoFlags(domainName, gpoGuid, 8, false);
                                }
                            }
                        } else {
                            AuditPolicyHandler.setOrRemoveGpoFlags(domainName, gpoGuid, 8, false);
                            logger.log(Level.INFO, "Result AceList is empty");
                        }
                    }
                    DataObject dataObj = GpoHandler.getAudComputerEventReadDO(tempList);
                    for (int i = 0; i < tempList.size(); ++i) {
                        sidGuidTable = (Hashtable)tempList.get(i);
                        AuditPolicyHandler.updateSecurityFilterStatus(dataObj, (String)sidGuidTable.get("OBJECT_GUID"), false);
                    }
                    if (!dataObj.isEmpty()) {
                        CommonUtil.getPersistence(new boolean[0]).update(dataObj);
                    }
                } else {
                    logger.log(Level.INFO, "trusteeList is Empty");
                }
            } else {
                logger.log(Level.INFO, "Gpo is not yet created");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        logger.log(Level.FINE, "************Leaving deleteSecurityFilter***************");
    }

    public static boolean corruptedGPOCleaner(String domainName, String pdc, String isLocalDomain, Integer machineType) {
        boolean isGpoDeleted = true;
        try {
            String gpoName = (machineType & 0x1000) == 4096 ? domainName + "_" + gpoForWs : domainName + "_" + gpoForFs;
            Hashtable<String, Object> gpoEntries = AuditPolicyHandler.getGpoEntries(domainName, gpoName);
            String dsPath = (String)gpoEntries.get("GPO_DS_PATH");
            boolean isPPMBuild = AuditPolicyHandler.getBuildType();
            if ((String)gpoEntries.get("GPO_GROUP_DN") != null || !isPPMBuild || dsPath == null) {
                logger.log(Level.INFO, "No need to Delete GPO");
                return true;
            }
            String newDsPath = dsPath = dsPath.toUpperCase();
            int ind = 0;
            ind = dsPath.indexOf("LDAP://");
            if (ind != -1) {
                newDsPath = dsPath.substring(ind, ind + 7);
                ind = dsPath.indexOf("CN=");
                if (ind != -1) {
                    newDsPath = newDsPath + dsPath.substring(ind, dsPath.length());
                }
            }
            String gpoGuid = (String)gpoEntries.get("GPO_GUID");
            logger.log(Level.INFO, "GPO DS Path:" + dsPath);
            if (dsPath != null && gpoGuid != null) {
                ADHandler.deleteGPO(isLocalDomain, domainName, newDsPath, dsPath, gpoGuid, pdc);
            }
            try {
                Properties domainDetails = DomainHandler.getConfiguredValues(domainName, 1L);
                ArrayList<String> attList = new ArrayList<String>();
                attList.add("name");
                attList.add("displayName");
                String search = "(&(objectClass=groupPolicyContainer)(distinguishedName=" + newDsPath.replace("LDAP://", "") + "))";
                ArrayList objectsList = ADHandler.getObjectsWithOutListener(domainDetails, domainDetails.getProperty("DEFAULT_NAMING_CONTEXT"), attList, search);
                if (objectsList != null && !objectsList.isEmpty()) {
                    isGpoDeleted = false;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                isGpoDeleted = false;
            }
            if (!isGpoDeleted) {
                return isGpoDeleted;
            }
            GpoHandler.deleteGpoDetails(domainName, gpoName);
            logger.log(Level.INFO, "GPO is deleted");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        logger.log(Level.FINE, "**************Leaving corruptedGpoCleaner**************");
        return isGpoDeleted;
    }

    public static void deleteGpoDetails(String domainName, String gpoName) throws Exception {
        try {
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Criteria c1 = new Criteria(Column.getColumn((String)gpoTableName, (String)"GPO_NAME"), (Object)gpoName, 0);
            Criteria c2 = new Criteria(Column.getColumn((String)gpoTableName, (String)"DOMAIN_NAME"), (Object)domainName, 0);
            c1 = c1.and(c2);
            dataObj = CommonUtil.getPersistence(new boolean[0]).get(gpoTableName, c1);
            if (!dataObj.isEmpty()) {
                Row row = dataObj.getRow(gpoTableName);
                dataObj.deleteRow(row);
                CommonUtil.getPersistence(new boolean[0]).update(dataObj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.log(Level.FINE, "**************Leaving deleteGpoDetails**************");
    }

    public static void checkGPOExist(String domainName, int machineType) {
        boolean status = false;
        try {
            String gpoName = (machineType & 0x1000) == 4096 ? domainName + "_" + "ADAuditPlusWSPolicy" : domainName + "_" + "ADAuditPlusPolicy";
            logger.log(Level.INFO, "**************checking gpoExist**************");
            System.out.println("Check gpo Exist");
            Hashtable<String, Object> gpoEntries = AuditPolicyHandler.getGpoEntries(domainName, gpoName);
            String dsPath = (String)gpoEntries.get("GPO_DS_PATH");
            if (dsPath != null) {
                String newDsPath = dsPath = dsPath.toUpperCase();
                int ind = 0;
                ind = dsPath.indexOf("LDAP://");
                if (ind != -1) {
                    newDsPath = dsPath.substring(ind, ind + 7);
                    ind = dsPath.indexOf("CN=");
                    if (ind != -1) {
                        newDsPath = newDsPath + dsPath.substring(ind, dsPath.length());
                    }
                }
                Properties domainDetails = DomainHandler.getConfiguredValues(domainName, 1L);
                ArrayList<String> attList = new ArrayList<String>();
                attList.add("name");
                attList.add("displayName");
                String search = "(&(objectClass=groupPolicyContainer)(distinguishedName=" + newDsPath.replace("LDAP://", "") + "))";
                ArrayList gpoProp = ADHandler.getObjectsWithOutListener(domainDetails, domainDetails.getProperty("DEFAULT_NAMING_CONTEXT"), attList, search);
                if (gpoProp == null || gpoProp.isEmpty()) {
                    System.out.println("gpo is not found");
                    status = true;
                }
            }
            if (status) {
                logger.log(Level.INFO, "GPO is not Exist");
                GpoHandler.deleteGpoDetails(domainName, gpoName);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

