/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.delegation;

import com.adventnet.sym.adsm.auditing.server.delegation.AuditPolicyHandler;
import com.adventnet.sym.adsm.auditing.server.delegation.GpoHandler;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;

public class GpoThread
extends Thread {
    public String action = null;
    public Hashtable gpoDetails = null;
    public String domainName = null;

    @Override
    public void run() {
        try {
            this.gpoAction();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public GpoThread(String action, Hashtable gpoDetails, String domainName) {
        this.action = action;
        this.gpoDetails = gpoDetails;
        this.domainName = domainName;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gpoAction() throws Exception {
        try {
            String domainName = (String)this.gpoDetails.get("DOMAIN_NAME");
            String gpoName = (String)this.gpoDetails.get("GPO_NAME");
            Hashtable<String, Object> gpoEntries = AuditPolicyHandler.getGpoEntries(domainName, gpoName);
            String gpoGuid = (String)gpoEntries.get("GPO_GUID");
            String gpoDsPath = (String)gpoEntries.get("GPO_DS_PATH");
            String gpoGrpDN = null;
            if ((String)gpoEntries.get("GPO_GROUP_DN") != null) {
                gpoGrpDN = (String)gpoEntries.get("GPO_GROUP_DN");
            }
            String pdc = (String)this.gpoDetails.get("PDC");
            String gpoGrp = (String)this.gpoDetails.get("GPO_GRP");
            ArrayList sidList = (ArrayList)this.gpoDetails.get("GUID_SID");
            Properties domainDetails = DomainHandler.getConfiguredValues(domainName, 1L);
            if (this.action.equalsIgnoreCase("AddGpoSecurityFilter")) {
                Hashtable result = AuditPolicyHandler.nativeGroupCreation(domainDetails, gpoGrp, sidList);
                if (((Boolean)result.get("objectExist")).booleanValue()) {
                    Integer flag = (Integer)gpoEntries.get("GPO_FLAGS") | 0x10;
                    gpoEntries.put("GPO_GROUP_DN", (String)result.get("GPO_GROUP_DN"));
                    gpoEntries.put("GPO_GROUP_SID", (String)result.get("SID_STRING"));
                    gpoEntries.put("GPO_FLAGS", flag);
                    AuditPolicyHandler.updateGpoDetails(gpoEntries);
                    if ((flag & 0x20) != 32 || ((Boolean)result.get("GROUP_CREATION")).booleanValue()) {
                        AuditPolicyHandler.setOrRemoveGpoFlags(domainName, gpoGuid, 32, false);
                        ArrayList<Hashtable> grpSid = new ArrayList<Hashtable>();
                        grpSid.add(result);
                        ArrayList aceList = GpoHandler.getACESForGPO(GpoHandler.getGpoAcePattern(), "add");
                        GpoHandler.addSecurityFilter(domainName, pdc, aceList, grpSid, gpoGuid);
                    }
                }
            } else if (this.action.equalsIgnoreCase("RemoveGpoSecurityFilter")) {
                if (pdc == null) {
                    Hashtable pdcTable = (Hashtable)ADHandler.getPrimaryDC(domainName);
                    pdc = (String)pdcTable.get("PDC_FLAT_NAME");
                    if (pdc == null) {
                        throw new Exception("Not able to find PDC");
                    }
                    pdc = pdc.replace("\\\\", "");
                    pdc = pdc.trim();
                }
                if (gpoGrpDN == null) {
                    throw new Exception("Group DN is empty");
                }
                ArrayList memList = new ArrayList();
                memList = AuditPolicyHandler.addOrRemoveMembers(domainDetails, gpoGrpDN, sidList, 2, 2);
                if (memList != null && memList.size() > 0) {
                    AuditPolicyHandler.updateServerGPOStatus(memList, false);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Exception is" + e);
            e.printStackTrace();
        }
        finally {
            System.out.println("Leaving thread");
        }
    }
}

