/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.eventcollection;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.AuditEventAPI;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class EventCollectionUtil {
    private static Logger logger = Logger.getLogger("EventLogger");

    public static String getWMIQueryFor2k8(Long recordNumber, int machineType) {
        String query = null;
        int[] event2k8 = AuditEventAPI.getInstance().getAuditEvents(new String[]{"6"}, machineType);
        query = "select * from Win32_NTLogEvent where LogFile = 'Security' and (EventCode = " + event2k8[0];
        for (int i = 1; i < event2k8.length; ++i) {
            query = query + " or EventCode = " + event2k8[i];
        }
        query = query + ") and RecordNumber >= " + recordNumber;
        logger.log(Level.INFO, "2k8 Query -> " + query);
        return query;
    }

    public static String getWMIQueryFor2k8(String cimDateTime, int machineType) {
        String query = null;
        int[] event2k8 = AuditEventAPI.getInstance().getAuditEvents(new String[]{"6"}, machineType);
        query = "select * from Win32_NTLogEvent where LogFile = 'Security' and (EventCode = " + event2k8[0];
        for (int i = 1; i < event2k8.length; ++i) {
            query = query + " or EventCode = " + event2k8[i];
        }
        query = query + ") and TimeGenerated > '" + cimDateTime + "'";
        logger.log(Level.INFO, "2k8 Query -> " + query);
        return query;
    }

    public static String getWMIQueryForGPO(String fromDateTime, String toDateTime, int[] eventCode) {
        String query = null;
        query = "select * from Win32_NTLogEvent where LogFile = 'Security' and (EventCode = " + eventCode[0];
        for (int i = 1; i < eventCode.length; ++i) {
            query = query + " or EventCode = " + eventCode[i];
        }
        query = query + ") and TimeGenerated >= '" + fromDateTime + "' and TimeGenerated <= '" + toDateTime + "'";
        logger.log(Level.INFO, "WMIQuery for GPO AUDIT -> " + query);
        return query;
    }

    public static String getEVTQueryForGPO(String fromDateTime, String toDateTime, int eventCode) {
        String query = null;
        Object eventIds = null;
        query = "<QueryList> <Query Id=\"0\" Path=\"Security\"><Select Path=\"Security\">*[System[ (EventID=" + eventCode + ") and TimeCreated[@SystemTime &gt;= '" + fromDateTime + "'] and TimeCreated[@SystemTime &lt;= '" + toDateTime + "']]]</Select></Query></QueryList>";
        logger.log(Level.INFO, "EVTQuery for GPO AUDIT -> " + query);
        return query;
    }

    public static String useRemoteMessageDLL() {
        String message = "";
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"SystemParams", (String)"PARAM_NAME"), (Object)"USE_LOCAL_MSG_DLL", 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("SystemParams", criteria);
            if (!dataObject.isEmpty()) {
                CommonUtil.getPersistenceLite().delete(criteria);
                message = "AD AuditPlus is now using remote message resource";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            message = e.getMessage();
        }
        return message;
    }

    public static String useOwnMsgDll() {
        String message = "ADAudit Plus is now using its own message resources";
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"SystemParams", (String)"PARAM_NAME"), (Object)"USE_LOCAL_MSG_DLL", 0);
            DataObject symParamDO = CommonUtil.getPersistence(new boolean[0]).get("SystemParams", criteria);
            if (symParamDO.isEmpty()) {
                Row symParamRow = new Row("SystemParams");
                symParamRow.set("PARAM_NAME", (Object)"USE_LOCAL_MSG_DLL");
                symParamRow.set("PARAM_VALUE", (Object)"true");
                symParamDO.addRow(symParamRow);
                CommonUtil.getPersistence(new boolean[0]).add(symParamDO);
            } else {
                Row symParamRow = symParamDO.getFirstRow("SystemParams");
                symParamRow.set("PARAM_VALUE", (Object)"true");
                symParamDO.updateRow(symParamRow);
                CommonUtil.getPersistence(new boolean[0]).update(symParamDO);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            message = ex.getMessage();
        }
        return message;
    }

    public static String useLocalMessage(Properties domainDetails) {
        String localWindowsDir = "";
        String localSystemDir = "";
        String message = null;
        String osName = null;
        String osArch = null;
        String userName = null;
        String passwd = null;
        String[] prop = new String[]{"Name", "WindowsDirectory", "Version", "OSArchitecture"};
        String domainName = domainDetails.getProperty("DOMAIN_NAME");
        Properties properties = null;
        try {
            Row row;
            Criteria criteria = new Criteria(Column.getColumn((String)"SystemParams", (String)"PARAM_NAME"), (Object)"LOCAL_WIN_DIR", 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("SystemParams", criteria);
            if (dataObject.isEmpty()) {
                ArrayList list = ADHandler.getWindowsDirectory("localhost", domainName, userName, passwd, prop, "select * from Win32_OperatingSystem", null, 0, 0);
                if (list != null && list.size() > 0) {
                    properties = (Properties)list.get(0);
                }
                logger.log(Level.INFO, "Local Windows Properties " + properties);
                localWindowsDir = properties.getProperty("WindowsDirectory");
                osArch = properties.getProperty("OSArchitecture");
                osName = properties.getProperty("Name");
                if (osArch != null && (osArch.contains("64") || osArch.contains("32"))) {
                    if (osArch.contains("64")) {
                        localSystemDir = localWindowsDir.concat("\\syswow64");
                    } else if (osArch.contains("32")) {
                        localSystemDir = localWindowsDir.concat("\\system32");
                    }
                } else {
                    localSystemDir = osName.contains("x64") ? localWindowsDir.concat("\\syswow64") : localWindowsDir.concat("\\system32");
                }
                DataObject newDataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                row = new Row("SystemParams");
                row.set("PARAM_NAME", (Object)"LOCAL_WIN_DIR");
                row.set("PARAM_VALUE", (Object)localSystemDir);
                newDataObject.addRow(row);
                CommonUtil.getPersistence(new boolean[0]).add(newDataObject);
                message = "AD AuditPlus is now using \"" + localSystemDir + "\"" + " for message resource";
            }
            Criteria criteria1 = new Criteria(Column.getColumn((String)"SystemParams", (String)"PARAM_NAME"), (Object)"USE_LOCAL_MSG_DLL", 0);
            DataObject dataObject1 = CommonUtil.getPersistence(new boolean[0]).get("SystemParams", criteria1);
            if (dataObject1.isEmpty()) {
                row = new Row("SystemParams");
                row.set("PARAM_NAME", (Object)"USE_LOCAL_MSG_DLL");
                row.set("PARAM_VALUE", (Object)"true");
                dataObject1.addRow(row);
                CommonUtil.getPersistence(new boolean[0]).add(dataObject1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            message = e.getMessage();
        }
        logger.log(Level.INFO, "Local windows Dir " + localWindowsDir);
        return message;
    }

    public static Integer getWorkerThreads() {
        Integer workerThreads = 1;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"SystemParams", (String)"PARAM_NAME"), (Object)"WORKER_THREAD_COUNT", 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("SystemParams", criteria);
            if (!dataObject.isEmpty()) {
                Row row = dataObject.getRow("SystemParams");
                String workerThreadSting = (String)row.get("PARAM_VALUE");
                workerThreads = Integer.parseInt(workerThreadSting);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return workerThreads;
    }

    public static void updateWorkerThreads(Integer threadCount) {
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"SystemParams", (String)"PARAM_NAME"), (Object)"WORKER_THREAD_COUNT", 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("SystemParams", criteria);
            Row row = dataObject.getRow("SystemParams");
            row.set("PARAM_VALUE", (Object)threadCount.toString());
            dataObject.updateRow(row);
            CommonUtil.getPersistence(new boolean[0]).update(dataObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean useLocalMessageDLL() {
        boolean useLocalMsgDll = false;
        try {
            Row row;
            String useLocalMessageDLL;
            Criteria criteria = new Criteria(Column.getColumn((String)"SystemParams", (String)"PARAM_NAME"), (Object)"USE_LOCAL_MSG_DLL", 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("SystemParams", criteria);
            if (!dataObject.isEmpty() && (useLocalMessageDLL = (String)(row = dataObject.getRow("SystemParams")).get("PARAM_VALUE")).equalsIgnoreCase("true")) {
                useLocalMsgDll = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return useLocalMsgDll;
    }
}

