/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.eventcollection;

import com.adventnet.sym.adsm.common.server.util.ADSMPersUtil;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EventFetchThreadPool {
    private static Logger logger = Logger.getLogger("EventLogger");
    private ExecutorService executorService = null;
    private static EventFetchThreadPool threadPool = null;
    private static EventFetchThreadPool threadPool2k8 = null;
    private static EventFetchThreadPool threadPoolArchiveEvent = null;
    private static Integer thread2k3Count = 5;
    private static Integer thread2k8Count = 3;
    private static Integer threadArchiveCount = 3;

    public static synchronized EventFetchThreadPool getInstance(int osType) {
        if (osType == 1) {
            if (threadPool == null) {
                String threadCount = ADSMPersUtil.getSyMParameter("2003_THREAD_COUNT");
                if (threadCount != null) {
                    thread2k3Count = Integer.parseInt(threadCount);
                }
                logger.log(Level.INFO, "Creating 2003 threadpool with [{0}] core threads", new Object[]{thread2k3Count});
                threadPool = new EventFetchThreadPool(thread2k3Count);
            }
            return threadPool;
        }
        if (osType == 2) {
            if (threadPool2k8 == null) {
                String threadCount = ADSMPersUtil.getSyMParameter("2008_THREAD_COUNT");
                if (threadCount != null) {
                    thread2k8Count = Integer.parseInt(threadCount);
                }
                logger.log(Level.INFO, "Creating 2008 threadpool with [{0}] core threads", new Object[]{thread2k8Count});
                threadPool2k8 = new EventFetchThreadPool(thread2k8Count);
            }
            return threadPool2k8;
        }
        if (osType == 3) {
            if (threadPoolArchiveEvent == null) {
                String threadCount = ADSMPersUtil.getSyMParameter("ARCHIVE_THREAD_COUNT");
                if (threadCount != null) {
                    threadArchiveCount = Integer.parseInt(threadCount);
                }
                logger.log(Level.INFO, "Creating archive threadpool with [{0}] core threads", new Object[]{threadArchiveCount});
                threadPoolArchiveEvent = new EventFetchThreadPool(threadArchiveCount);
            }
            return threadPoolArchiveEvent;
        }
        return null;
    }

    private EventFetchThreadPool(int noOfActiveThreads) {
        this.executorService = Executors.newFixedThreadPool(noOfActiveThreads);
    }

    public synchronized void runTask(Runnable task) {
        logger.log(Level.INFO, "Adding Task to Threadpool: " + task);
        logger.log(Level.INFO, "Active Thread Count: " + ((ThreadPoolExecutor)this.executorService).getActiveCount());
        logger.log(Level.INFO, "Completed Thread Count: " + ((ThreadPoolExecutor)this.executorService).getCompletedTaskCount());
        logger.log(Level.FINE, "Thread Pool Queue: " + ((ThreadPoolExecutor)this.executorService).getQueue());
        this.executorService.execute(task);
    }

    public void shutDown() {
        this.executorService.shutdown();
    }
}

