/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.eventcollection;

import com.adventnet.sym.adsm.auditing.server.EventDataHandler;
import com.adventnet.sym.adsm.auditing.server.eventcollection.FetchMsEventData;
import com.adventnet.sym.adsm.auditing.server.util.EventDataUtil;
import com.adventnet.sym.adsm.common.server.admin.EventErrorAlert;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FetchEventDataWMI
extends Thread {
    private static Logger logger = Logger.getLogger("EventLogger");
    private Properties domainDetails = null;
    private String computerName = null;
    public String message = null;
    private Long recordNumber = 0L;
    private long readRecord = 0L;
    private Long timeGenerated = 0L;
    private Properties windowsProps = null;
    private int machineType = 1;
    private String windowsVersion = null;
    private String objectGuid = null;
    private Boolean isLocalDll;
    String[] properties = new String[]{"Category", "ComputerName", "EventCode", "Message", "RecordNumber", "SourceName", "TimeGenerated", "EventType", "Type", "User"};
    private boolean isCompleted = false;

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public FetchEventDataWMI(Properties domDetails, String computerName, Long recordNo, Long timeGenerated, Properties windowsProps, int machineType, String windowsVersion, String objectGuid, Boolean isLocalDll) {
        this.domainDetails = domDetails;
        this.computerName = computerName;
        this.recordNumber = recordNo;
        this.timeGenerated = timeGenerated;
        this.readRecord = 0L;
        this.windowsProps = windowsProps;
        this.machineType = machineType;
        this.windowsVersion = windowsVersion;
        this.objectGuid = objectGuid;
        this.isLocalDll = isLocalDll;
        this.setName(computerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String domainName = this.domainDetails.getProperty("DOMAIN_NAME");
        try {
            FetchMsEventData fetchEventDataWmi = new FetchMsEventData(this.domainDetails, this.computerName, (long)this.recordNumber, this.timeGenerated, this.windowsProps, this.machineType, this.windowsVersion, this.objectGuid, this.isLocalDll, 0);
            fetchEventDataWmi.fetchEventDataWMI();
        }
        catch (Exception ex) {
            if (ex.getMessage() != null) {
                logger.log(Level.INFO, "Error while fetching event from [{0}] is [{1}]", new Object[]{this.computerName, ex.getMessage()});
            } else {
                ex.printStackTrace();
            }
            this.message = ex.getMessage();
            if ((this.machineType & 0x1000) != 4096) {
                EventErrorAlert.sendMail(domainName, this.computerName, this.message, this.machineType);
            }
            EventDataUtil.updateEventLogMessage(this.message, this.computerName, domainName);
        }
        finally {
            EventDataHandler.getInstance().dcStatusP.put(this.computerName, 0);
        }
    }
}

