/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.eventcollection;

import com.adventnet.persistence.DataAccessException;
import com.adventnet.sym.adsm.auditing.server.AuditEventAPI;
import com.adventnet.sym.adsm.auditing.server.EventDataHandler;
import com.adventnet.sym.adsm.auditing.server.accountLockout.AccountLockoutHistory;
import com.adventnet.sym.adsm.auditing.server.eventcollection.EventCollectionUtil;
import com.adventnet.sym.adsm.auditing.server.fileaudit.emc.EMCHandler;
import com.adventnet.sym.adsm.auditing.server.fileaudit.netapp.NetAppHandler;
import com.adventnet.sym.adsm.auditing.server.fileaudit.netapp.NetAppVserver;
import com.adventnet.sym.adsm.auditing.server.fileaudit.netapp.NetAppVserverDBHandler;
import com.adventnet.sym.adsm.auditing.server.util.EventDataUtil;
import com.adventnet.sym.adsm.auditing.server.util.WindowsDirUtil;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.EventCollectorHandler;
import com.adventnet.sym.adsm.common.server.admin.ADSMPersUtil;
import com.adventnet.sym.adsm.common.server.admin.EventErrorAlert;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.TimeUtil;
import com.adventnet.tools.prevalent.ConsoleOut;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FetchMsEventData {
    private static Logger logger = Logger.getLogger("EventLogger");
    private Properties domainDetails = null;
    private String computerName = null;
    public String message = null;
    private Long recordNumber = 0L;
    private Long readRecord = 0L;
    private Long timeGenerated = 0L;
    private Properties windowsProps = null;
    private Integer machineType = 1;
    private String windowsVersion = null;
    private String objectGuid = null;
    private Boolean isLocalDll;
    private String[] properties = new String[]{"Category", "ComputerName", "EventCode", "Message", "RecordNumber", "SourceName", "TimeGenerated", "EventType", "Type", "User"};
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private Integer fetchMode = 1;

    public FetchMsEventData(Properties domDetails, String computerName, Long recordNo, Long timeGenerated, Properties windowsProps, int machineType, String windowsVersion, String objectGuid, Boolean isLocalDll, int fetchmode) {
        this.domainDetails = domDetails;
        String userDNName = (String)this.domainDetails.get("USER_DISTINGUISHED_NAME");
        String userDomain = (String)this.domainDetails.get("DOMAIN_NAME");
        String userName = "";
        if (userDNName != null) {
            if (userDNName.contains("@")) {
                int pos = userDNName.indexOf(64);
                userName = userDNName.substring(0, pos);
                userDomain = userDNName.substring(pos + 1, userDNName.length());
                this.domainDetails.put("USER_NAME", userName);
            } else if (userDNName.contains("\\")) {
                int pos = userDNName.indexOf(92);
                userDomain = userDNName.substring(0, pos);
                userName = userDNName.substring(pos + 1, userDNName.length());
                userDNName = userDomain + "\\" + userName;
                this.domainDetails.put("USER_NAME", userName);
            } else {
                this.domainDetails.put("USER_NAME", userDNName);
            }
        }
        this.domainDetails.put("USER_DOMAIN_NAME", userDomain);
        this.computerName = computerName;
        this.recordNumber = recordNo;
        this.timeGenerated = timeGenerated;
        this.readRecord = 0L;
        this.windowsProps = windowsProps;
        this.machineType = machineType;
        this.windowsVersion = windowsVersion;
        this.objectGuid = objectGuid;
        this.isLocalDll = isLocalDll;
        this.fetchMode = fetchmode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchEventData() {
        String domainName = this.domainDetails.getProperty("DOMAIN_NAME");
        try {
            if ((this.machineType & 0x400) == 1024) {
                this.fetchDataFromForwardedLog();
                if ((this.machineType & 0x10) == 16 || (this.machineType & 0x40) == 64 || (this.machineType & 4) == 4) {
                    this.fetchDataFromSecurityLog();
                }
            } else {
                this.fetchDataFromSecurityLog();
            }
            if ((this.machineType & 0x10) == 16) {
                this.fetchDataFromTerminalGatewayLog();
            }
        }
        catch (Exception ex) {
            if (ex.getMessage() != null) {
                logger.log(Level.INFO, "Error while fetching event from [{0}] is [{1}]", new Object[]{this.computerName, ex.getMessage()});
            } else {
                ex.printStackTrace();
            }
            this.message = ex.getMessage();
            if ((this.machineType & 0x1000) != 4096) {
                EventErrorAlert.sendMail(domainName, this.computerName, this.message, this.machineType);
            }
            EventDataUtil.updateEventLogMessage(this.message, this.computerName, domainName);
        }
        finally {
            EventDataHandler.getInstance().dcStatusP.put(this.computerName, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchEventDataWMI() {
        String domainName = this.domainDetails.getProperty("DOMAIN_NAME");
        try {
            if ((this.machineType & 0x400) == 1024) {
                this.fetchDataFromForwardedLog();
                if ((this.machineType & 0x10) == 16 || (this.machineType & 0x40) == 64 || (this.machineType & 4) == 4) {
                    this.fetchDataFromSecurityLogWMI();
                }
            } else {
                this.fetchDataFromSecurityLogWMI();
            }
        }
        catch (Exception ex) {
            if (ex.getMessage() != null) {
                logger.log(Level.INFO, "Error while fetching event from [{0}] is [{1}]", new Object[]{this.computerName, ex.getMessage()});
            } else {
                ex.printStackTrace();
            }
            this.message = ex.getMessage();
            if ((this.machineType & 0x1000) != 4096) {
                EventErrorAlert.sendMail(domainName, this.computerName, this.message, this.machineType);
            }
            EventDataUtil.updateEventLogMessage(this.message, this.computerName, domainName);
        }
        finally {
            EventDataHandler.getInstance().dcStatusP.put(this.computerName, 0);
        }
    }

    public String getEventVersion(String osVersion) {
        String eventVersion = "5";
        if (osVersion.equals("2k8") || osVersion.equals("2k8r2")) {
            eventVersion = "6";
        } else if (osVersion.equals("2k12")) {
            eventVersion = "6.2";
        }
        return eventVersion;
    }

    public String getOsVersion() {
        String osVersion = null;
        osVersion = this.windowsVersion.startsWith("5.0") ? "2k" : (this.windowsVersion.startsWith("5.") ? "2k3" : (this.windowsVersion.startsWith("6.0") ? "2k8" : (this.windowsVersion.startsWith("6.1") ? "2k8r2" : (this.windowsVersion.startsWith("6.2") ? "2k12" : "2k12"))));
        return osVersion;
    }

    public void fetchDataFromTerminalGatewayLog() {
        block3: {
            try {
                String domainName = this.domainDetails.getProperty("DOMAIN_NAME");
                int terminal = EventDataUtil.getTerminalServerConfigured(domainName, this.computerName);
                if (terminal != 1) break block3;
                String localWinVer = System.getProperty("os.version");
                if (localWinVer != null && localWinVer.startsWith("6.")) {
                    Properties netAppDetails = null;
                    String osVersion = this.getOsVersion();
                    String eventVersion = this.getEventVersion(osVersion);
                    int[] eventIDArray = AuditEventAPI.getInstance().getAuditEvents(new String[]{eventVersion}, 0x200000);
                    Hashtable retHash = ADHandler.get2k8EventData(this.domainDetails, this.computerName, EventDataUtil.getTerminalRecord(domainName, this.computerName), eventIDArray, 0x200000, osVersion, EventDataUtil.getTerminalTimeGenerated(domainName, this.computerName), netAppDetails, "Microsoft-Windows-TerminalServices-Gateway/Operational");
                    EventDataUtil.updateTerminalServerRecord(retHash, domainName, this.computerName, this.objectGuid);
                    break block3;
                }
                throw new Exception(rb.getString("adap.FetchMsEventData.the_installation_must_be_vista_and_later"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchDataFromSecurityLogWMI() {
        String userName = null;
        String password = null;
        String domainName = this.domainDetails.getProperty("DOMAIN_NAME");
        try {
            if (!this.domainDetails.getProperty("IS_AUTHENTICATION_REQUIRED").equalsIgnoreCase("false")) {
                logger.log(Level.INFO, "Inside setting username details..");
                userName = (String)this.domainDetails.get("USER_NAME");
                password = (String)this.domainDetails.get("PASSWORD");
            }
            String cimDateTime = TimeUtil.getWMIEventTime(this.timeGenerated);
            String wmiClass = EventCollectionUtil.getWMIQueryFor2k8(cimDateTime, (int)this.machineType);
            this.message = rb.getString("adap.common.text.status_msg.running");
            EventDataUtil.updateEventLogMessage(this.message, this.computerName, domainName);
            logger.info("Started fetching event from machine : " + this.computerName);
            Hashtable retHash = new Hashtable();
            Integer tempMType = this.machineType & 0xFFFFFBFF;
            ADHandler.getWindowsDirectory(this.computerName, domainName, userName, password, this.properties, wmiClass, retHash, tempMType, 0);
            logger.log(Level.INFO, "retHash for " + this.computerName + "is" + retHash);
            String timeHash = (String)retHash.get("TimeWritten");
            if (timeHash != null) {
                Long recHash = (Long)retHash.get("RecordNumber");
                EventDataUtil.updateRecordNumber(TimeUtil.getEventTime(timeHash), recHash, this.computerName, domainName);
                logger.info("Completed fetching event from machine : " + this.computerName);
            }
            this.message = rb.getString("adap.common.text.status_msg.success");
            EventDataUtil.updateEventLogMessage(this.message, this.computerName, domainName);
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                logger.log(Level.INFO, "Error while fetching event from [{0}] is [{1}]", new Object[]{this.computerName, e.getMessage()});
            } else {
                e.printStackTrace();
            }
            this.message = e.getMessage();
            if ((this.machineType & 0x1000) != 4096) {
                EventErrorAlert.sendMail(domainName, this.computerName, this.message, this.machineType);
            }
            if (this.message.contains("80070008")) {
                logger.log(Level.SEVERE, "Restaring the product for Not Enough Resources");
                ConsoleOut.println((String)"ADAP-OUTOFMEMORY");
            }
        }
        finally {
            EventDataUtil.updateEventLogMessage(this.message, this.computerName, domainName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchDataFromSecurityLog() throws Exception {
        String domainName = this.domainDetails.getProperty("DOMAIN_NAME");
        try {
            Boolean netAppLargeServerSupport;
            Hashtable retHash;
            block39: {
                this.message = rb.getString("adap.common.text.status_msg.running");
                EventDataUtil.updateEventLogMessage(this.message, this.computerName, domainName);
                String s = "C:\\Windows\\System32";
                if (!this.isLocalDll.booleanValue()) {
                    String sysDir = this.windowsProps.getProperty("WindowsDirectory");
                    String OSArchitecture = this.windowsProps.getProperty("OSArchitecture");
                    s = OSArchitecture.contains("64-bit") ? sysDir.concat("\\syswow64") : sysDir.concat("\\system32");
                }
                String osVersion = this.getOsVersion();
                String eventVersion = this.getEventVersion(osVersion);
                Properties netAppDetails = null;
                String localWinVer = null;
                String localWinDir = null;
                retHash = null;
                logger.log(Level.INFO, "SystemDir:" + s);
                logger.log(Level.INFO, "Version:" + this.windowsVersion);
                int[] eventIDArray = null;
                Integer tempMType = this.machineType & 0xFFFFFBFF;
                localWinVer = System.getProperty("os.version");
                netAppLargeServerSupport = Boolean.valueOf(ADSMPersUtil.getSyMParameter("NetAppLargeServerSupport"));
                if ((this.machineType & 0x100) == 256) {
                    eventIDArray = AuditEventAPI.getInstance().getAuditEvents(new String[]{"5"}, this.machineType);
                    netAppDetails = NetAppHandler.getNetAppOptions(this.objectGuid);
                    localWinDir = System.getProperty("server.dir") + File.separator + "lib" + File.separator + "native";
                    logger.log(Level.INFO, "localWinVer:" + localWinVer);
                    if (netAppDetails == null || localWinVer == null) {
                        throw new Exception("Exception While Getting NetApp Filer Details");
                    }
                    netAppDetails.put("RECENT_EVENT_TIME", this.timeGenerated);
                    netAppDetails.put("NETAPP_LARGE_SERVER_SUPPORT", netAppLargeServerSupport.toString());
                    logger.log(Level.INFO, "Local windows Details is" + localWinVer);
                    if (netAppLargeServerSupport.booleanValue()) {
                        String localNetAppDir = System.getProperty("server.dir") + File.separator + "webapps" + File.separator + "adap" + File.separator + "NetApp" + File.separator + this.computerName + File.separator;
                        netAppDetails.put("EVT_FILE_SHARE_PATH", localNetAppDir);
                        netAppDetails.put("LAST_READ_EVT_FILE_TIME", "0");
                    }
                    if ((retHash = localWinVer.startsWith("6.") ? ADHandler.getNetAppEventData(this.domainDetails, this.computerName, this.recordNumber + 1L, eventIDArray, tempMType, osVersion, this.timeGenerated, netAppDetails) : ADHandler.getEventData(this.domainDetails, this.computerName, this.recordNumber + 1L, this.timeGenerated, eventIDArray, localWinDir, tempMType, osVersion, netAppDetails)).get("ERROR_CODE") != null && (((String)retHash.get("ERROR_CODE")).equals("12") || ((String)retHash.get("ERROR_CODE")).equals("2"))) {
                        try {
                            NetAppHandler.generateEvtFile(this.objectGuid);
                            Thread.sleep(10000L);
                            if (localWinVer.startsWith("6.")) {
                                retHash = ADHandler.getNetAppEventData(this.domainDetails, this.computerName, this.recordNumber + 1L, eventIDArray, tempMType, osVersion, this.timeGenerated, netAppDetails);
                                break block39;
                            }
                            retHash = ADHandler.getEventData(this.domainDetails, this.computerName, this.recordNumber + 1L, this.timeGenerated, eventIDArray, localWinDir, tempMType, osVersion, netAppDetails);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            if (ex.getMessage() != null) {
                                String msg = rb.getString("adap.NetAppHandler.Error_while_generating_netapp_evt_file") + ex.getMessage();
                                retHash.put("ERROR_MESSAGE", msg);
                            }
                        }
                    }
                } else if ((this.machineType & 0x80000) == 524288) {
                    eventIDArray = AuditEventAPI.getInstance().getAuditEvents(new String[]{"6"}, this.machineType);
                    netAppDetails = NetAppVserverDBHandler.getProperties(this.objectGuid);
                    localWinDir = System.getProperty("server.dir") + File.separator + "lib" + File.separator + "native";
                    if (netAppDetails == null || localWinVer == null) {
                        throw new Exception("Exception While Getting NetApp VServer Details");
                    }
                    netAppDetails.put("EVT_QUERY_TIME", TimeUtil.getEVTQueryEventTime(this.timeGenerated * 1000L + 1L));
                    netAppDetails.put("NETAPP_LARGE_SERVER_SUPPORT", "false");
                    netAppDetails.put("RECENT_EVENT_TIME", this.timeGenerated);
                    NetAppVserver naVserver = new NetAppVserver(null, domainName, this.computerName);
                    NetAppHandler.setNaVserverVolPaths(domainName, this.computerName, naVserver.fetchVolumeJuncPaths());
                    retHash = ADHandler.getNetAppEventData(this.domainDetails, this.computerName, this.recordNumber + 1L, eventIDArray, tempMType, osVersion, this.timeGenerated, netAppDetails);
                } else if (localWinVer.startsWith("6.") && this.fetchMode == 2) {
                    eventIDArray = AuditEventAPI.getInstance().getAuditEvents(new String[]{eventVersion}, this.machineType);
                    if (!eventVersion.startsWith("5")) {
                        AccountLockoutHistory.getInstance();
                        if (AccountLockoutHistory.workstationStatus.get(this.computerName.toUpperCase()) != null) {
                            AccountLockoutHistory.getInstance();
                            if (AccountLockoutHistory.workstationStatus.get(this.computerName.toUpperCase()) == 1) {
                                eventIDArray = this.accountLockoutEventAdd(eventIDArray);
                            }
                        }
                    }
                    logger.log(Level.INFO, "Local win version is compatible with evt query. Proceeding to fetch via evtquery");
                    retHash = ADHandler.get2k8EventData(this.domainDetails, this.computerName, this.recordNumber + 1L, eventIDArray, tempMType, osVersion, this.timeGenerated, netAppDetails, "security");
                } else if ((this.machineType & 0x20000) == 131072) {
                    retHash = this.fetchDataFromEMC(osVersion, localWinVer);
                } else {
                    eventIDArray = AuditEventAPI.getInstance().getAuditEvents(new String[]{eventVersion}, this.machineType);
                    if (!eventVersion.startsWith("5")) {
                        AccountLockoutHistory.getInstance();
                        if (AccountLockoutHistory.workstationStatus.get(this.computerName.toUpperCase()) != null) {
                            AccountLockoutHistory.getInstance();
                            if (AccountLockoutHistory.workstationStatus.get(this.computerName.toUpperCase()) == 1) {
                                eventIDArray = this.accountLockoutEventAdd(eventIDArray);
                            }
                        }
                    }
                    retHash = ADHandler.getEventData(this.domainDetails, this.computerName, this.recordNumber + 1L, this.timeGenerated, eventIDArray, s, tempMType, osVersion, netAppDetails);
                }
            }
            if ((this.machineType & 0x20000) != 131072) {
                logger.log(Level.INFO, "retHash for " + this.computerName + "is" + retHash);
                Integer timeHash = (Integer)retHash.get("TimeWritten");
                Long recHash = (Long)retHash.get("RecordNumber");
                EventDataUtil.updateRecordNumber(timeHash.intValue(), recHash, this.computerName, domainName);
                if ((this.machineType & 0x100) == 256 || (this.machineType & 0x80000) == 524288) {
                    if ((this.machineType & 0x80000) == 524288) {
                        NetAppVserverDBHandler.updateLastReadEvtFileTime(this.objectGuid, (String)retHash.get("ReadEvtFileTime"));
                    } else if (!netAppLargeServerSupport.booleanValue()) {
                        NetAppHandler.updateLastReadEvtFileTime(this.objectGuid, (String)retHash.get("ReadEvtFileTime"));
                    }
                    if (retHash.get("ERROR_MESSAGE") != null && !((String)retHash.get("ERROR_CODE")).equals("12")) {
                        logger.log(Level.INFO, "Error while Reading NetApp Filer" + (String)retHash.get("ERROR_MESSAGE"));
                        throw new Exception((String)retHash.get("ERROR_MESSAGE"));
                    }
                    logger.log(Level.INFO, "Error while Reading NetApp Filer" + (String)retHash.get("ERROR_MESSAGE"));
                }
            }
            this.message = rb.getString("adap.common.text.status_msg.success");
        }
        catch (DataAccessException dae) {
            logger.log(Level.SEVERE, "Exception while udpating record number for " + this.computerName);
            dae.printStackTrace();
        }
        catch (Exception ex) {
            if (ex.getMessage() != null) {
                logger.log(Level.INFO, "Error while fetching event from [{0}] is [{1}]", new Object[]{this.computerName, ex.getMessage()});
            } else {
                ex.printStackTrace();
            }
            ex.printStackTrace();
            this.message = ex.getMessage();
            if ((this.machineType & 0x1000) != 4096) {
                EventErrorAlert.sendMail(domainName, this.computerName, this.message, this.machineType);
            }
        }
        finally {
            EventDataUtil.updateEventLogMessage(this.message, this.computerName, domainName);
        }
    }

    private int[] accountLockoutEventAdd(int[] eventIDArray) {
        int[] eventIDs = new int[eventIDArray.length + 1];
        for (int i = 0; i < eventIDArray.length; ++i) {
            eventIDs[i] = eventIDArray[i];
        }
        eventIDs[eventIDArray.length] = 4648;
        return eventIDs;
    }

    public Hashtable fetchDataFromEMC(String osVersion, String localWinVer) throws Exception {
        int[] eventIDArray = null;
        String localWinDir = null;
        Hashtable retHash = null;
        Properties emcDetails = null;
        Integer tempMType = this.machineType & 0xFFFFFBFF;
        String domainName = this.domainDetails.getProperty("DOMAIN_NAME");
        Hashtable<String, Object> dmTable = EMCHandler.getDMAuditSettings(this.objectGuid, this.computerName, domainName, false);
        try {
            int i;
            if (dmTable == null) {
                throw new Exception(rb.getString("adap.FetchMsEventData.Exception_While_Getting_EMC_CIFS_DM_Details"));
            }
            Boolean isEFRunning = EMCHandler.isEFRunnningOnDM(dmTable);
            if (isEFRunning.booleanValue()) {
                throw new Exception(rb.getString("adap.FetchMsEventData.Already_an_event_fetch_is_running_on_this_Data_Mover"));
            }
            emcDetails = new Properties();
            String evtLocalPath = (String)dmTable.get("EVT_FILE_SHARE_PATH");
            String evtSharePath = "\\\\" + this.computerName + "\\" + evtLocalPath.charAt(0) + "$" + evtLocalPath.substring(2, evtLocalPath.length());
            emcDetails.put("IS_ARCHIVE_ENABLED", (Boolean)dmTable.get("IS_ARCHIVE_ENABLED"));
            emcDetails.put("EVT_FILE_SHARE_PATH", evtSharePath);
            emcDetails.put("EVT_FILE_NAME", (String)dmTable.get("EVT_FILE_NAME"));
            String msgDllLocalPath = (String)dmTable.get("MSG_DLL_SHARE_PATH");
            String msDllSharePath = "\\\\" + this.computerName + "\\" + msgDllLocalPath.charAt(0) + "$" + msgDllLocalPath.substring(2, msgDllLocalPath.length()) + (String)dmTable.get("MSG_DLL_NAME");
            emcDetails.put("MSG_DLL_SHARE_PATH", msDllSharePath);
            emcDetails.put("MSG_DLL_NAME", (String)dmTable.get("MSG_DLL_NAME"));
            emcDetails.put("LAST_READ_EVT_FILE_TIME", dmTable.get("LAST_READ_EVT_FILE_TIME").toString());
            emcDetails.put("EMC_STATION_IP_ADDRESS", (String)dmTable.get("EMC_STATION_IP_ADDRESS"));
            emcDetails.put("EMC_DM_ID", (Long)dmTable.get("EMC_DM_ID"));
            emcDetails.put("IS_VDM", (Boolean)dmTable.get("IS_VDM"));
            emcDetails.put("IS_AUTO_SAVE_REQUIRED", "true");
            emcDetails.put("EVT_FILE_EXTENSION", "timestamp");
            emcDetails.put("EVT_FILE_LIMIT", (Object)0L);
            logger.log(Level.INFO, "EMC DM Details is" + emcDetails);
            eventIDArray = AuditEventAPI.getInstance().getAuditEvents(new String[]{"5"}, this.machineType);
            localWinDir = System.getProperty("server.dir") + File.separator + "lib" + File.separator + "native";
            ArrayList<String> cifsServerList = EMCHandler.getCIFSServerDetails(domainName, (String)dmTable.get("EMC_STATION_IP_ADDRESS"), (Long)dmTable.get("EMC_DM_ID"), null, (Boolean)dmTable.get("IS_VDM"));
            logger.log(Level.INFO, "EMC CIFS Details is" + cifsServerList);
            logger.log(Level.INFO, "Time Generated EMC:" + this.timeGenerated);
            logger.log(Level.INFO, "Record Number EMC:" + this.recordNumber);
            if (((Boolean)emcDetails.get("IS_ARCHIVE_ENABLED")).booleanValue()) {
                for (i = 0; i < cifsServerList.size(); ++i) {
                    Long time = EventDataUtil.getEventTime(cifsServerList.get(i), domainName);
                    if (time <= this.timeGenerated) continue;
                    this.timeGenerated = time;
                }
                logger.log(Level.INFO, "Time Generated EMC After compare with other CIFS servers:" + this.timeGenerated);
                emcDetails.put("IS_ARCHIVE_ENABLED", Boolean.TRUE.toString());
                retHash = localWinVer.startsWith("6.") ? ADHandler.getNetAppEventData(this.domainDetails, this.computerName, this.recordNumber, eventIDArray, tempMType, osVersion, this.timeGenerated, emcDetails) : ADHandler.getEventData(this.domainDetails, this.computerName, this.recordNumber, this.timeGenerated, eventIDArray, localWinDir, tempMType, osVersion, emcDetails);
                EMCHandler.updateLastReadEvtFileTime(dmTable, (String)retHash.get("ReadEvtFileTime"));
            } else {
                for (i = 0; i < cifsServerList.size(); ++i) {
                    Long recordNo = EventDataUtil.getRecordNumber(cifsServerList.get(i), domainName);
                    if (recordNo <= this.recordNumber) continue;
                    this.recordNumber = recordNo;
                }
                logger.log(Level.INFO, "Record Number EMC After compare with other CIFS servers:" + this.recordNumber);
                emcDetails.put("IS_ARCHIVE_ENABLED", Boolean.FALSE.toString());
                retHash = ADHandler.getEventData(this.domainDetails, this.computerName, this.recordNumber, this.timeGenerated, eventIDArray, localWinDir, tempMType, osVersion, emcDetails);
            }
            logger.log(Level.INFO, "retHash for EMC" + this.computerName + "is" + retHash);
            Integer timeHash = (Integer)retHash.get("TimeWritten");
            Long recHash = (Long)retHash.get("RecordNumber");
            for (int i2 = 0; i2 < cifsServerList.size(); ++i2) {
                EventDataUtil.updateRecordNumber(timeHash.intValue(), recHash, cifsServerList.get(i2), domainName);
            }
            if (retHash.get("ERROR_MESSAGE") != null) {
                logger.log(Level.INFO, "Error while Reading EMC Server" + (String)retHash.get("ERROR_MESSAGE"));
                throw new Exception((String)retHash.get("ERROR_MESSAGE"));
            }
        }
        catch (Exception ex) {
            if (ex.getMessage() != null) {
                throw new Exception(ex.getMessage());
            }
            throw new Exception(ex);
        }
        finally {
            EMCHandler.updateEFROnDM(dmTable);
        }
        return retHash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchDataFromForwardedLog() throws Exception {
        String domainName = this.domainDetails.getProperty("DOMAIN_NAME");
        this.message = rb.getString("adap.common.text.status_msg.running");
        EventCollectorHandler.updateStatus(this.objectGuid, this.message);
        try {
            Hashtable retHash = null;
            Properties netAppDetails = null;
            String osVersion = this.getOsVersion();
            String localWinVer = System.getProperty("os.version");
            logger.log(Level.INFO, "localWinVer:" + localWinVer);
            if (!localWinVer.startsWith("6.")) {
                throw new Exception(rb.getString("adap.FetchMsEventData.the_installation_must_be_vista_and_later"));
            }
            if (this.windowsVersion.startsWith("5.")) {
                throw new Exception(rb.getString("adap.FetchMsEventData.event_subscription_2k3_not_supported"));
            }
            this.windowsProps = WindowsDirUtil.getWindowsDirectory(this.computerName, this.domainDetails);
            String sysDir = this.windowsProps.getProperty("WindowsDirectory");
            int[] eventIDArray = AuditEventAPI.getInstance().getAuditEvents(new String[]{"5", "6"}, 1024);
            String collectorEvtDir = null;
            collectorEvtDir = System.getProperty("server.dir") + File.separator + "webapps" + File.separator + "adap" + File.separator + "EventForwarding" + File.separator + "EventCollectors" + File.separator + this.computerName.toLowerCase();
            if (!new File(collectorEvtDir).isDirectory()) {
                new File(collectorEvtDir).mkdirs();
            }
            logger.log(Level.INFO, "Using local message dll");
            String fileName = collectorEvtDir + "\\ForwardedEvents.evtx";
            File file = new File(fileName);
            boolean exists = file.exists();
            if (!exists) {
                EventCollectorHandler.resetRecordNumber(this.objectGuid);
            }
            Long recordNum = EventCollectorHandler.getRecordNumber(this.objectGuid);
            retHash = ADHandler.getEventFromCollector(this.domainDetails, this.computerName, recordNum, eventIDArray, this.machineType, osVersion, this.timeGenerated, sysDir, netAppDetails);
            this.message = rb.getString("adap.common.text.status_msg.success");
            logger.log(Level.INFO, "retHash for " + this.computerName + "(EventCollector)is" + retHash);
            retHash.put("OBJECT_GUID", this.objectGuid);
            retHash.put("DomainName", domainName);
            EventCollectorHandler.updateRecordNumber(retHash);
            if (retHash.get("ERROR_MESSAGE") != null) {
                logger.log(Level.INFO, "Error while Reading Event From Event Collector" + (String)retHash.get("ERROR_MESSAGE"));
                throw new Exception((String)retHash.get("ERROR_MESSAGE"));
            }
        }
        catch (Throwable ex) {
            if (ex.getMessage() != null) {
                logger.log(Level.INFO, "Error while fetching event from [{0}] is [{1}]", new Object[]{this.computerName, ex.getMessage()});
            } else {
                ex.printStackTrace();
            }
            this.message = ex.getMessage();
            EventErrorAlert.sendMail(domainName, this.computerName, this.message, this.machineType);
        }
        finally {
            EventCollectorHandler.updateStatus(this.objectGuid, this.message);
        }
    }
}

