/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.eventcollection.realtime;

import com.adventnet.sym.adsm.auditing.server.AuditEventAPI;
import com.adventnet.sym.adsm.auditing.server.EventDataHandler;
import com.adventnet.sym.adsm.auditing.server.eventcollection.realtime.RealTimeEventController;
import com.adventnet.sym.adsm.auditing.server.eventcollection.realtime.RealTimeEventUtil;
import com.adventnet.sym.adsm.auditing.server.util.EventDataUtil;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.admin.EventErrorAlert;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RealTimeEventCollector
extends Thread {
    private Long uniqueId = 0L;
    public int retryCount = 0;
    private Long waitTime = 30000L;
    private Long recordNumber = 0L;
    private Long timeGenerated = 0L;
    private Integer machineType = 0;
    public boolean shutDown = false;
    public boolean shutDownOnly = false;
    private String domainName = null;
    public boolean stopThread = false;
    private String computerName = null;
    private String windowsVersion = null;
    private Properties domainDetails = null;
    private final Logger event_logger = Logger.getLogger("EventLogger");
    private AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();

    public RealTimeEventCollector(Properties domainDetails, String computerName, Long recordNumber, Long timeGenerated, Integer machineType, String windowsVersion, Long uniqueId) {
        super("RealTimeThread ::  " + computerName);
        this.uniqueId = uniqueId;
        this.machineType = machineType;
        this.recordNumber = recordNumber;
        this.computerName = computerName;
        this.timeGenerated = timeGenerated;
        this.domainDetails = domainDetails;
        this.windowsVersion = windowsVersion;
        this.domainName = domainDetails.get("DOMAIN_NAME").toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean watchEventLog() {
        Boolean retVal = true;
        String message = null;
        HashMap resultMap = new HashMap();
        try {
            String osVersion = "";
            String eventVersion = "6";
            if (this.windowsVersion.startsWith("6.0")) {
                osVersion = "2k8";
            } else if (this.windowsVersion.startsWith("6.1")) {
                osVersion = "2k8r2";
            } else if (this.windowsVersion.startsWith("6.2")) {
                osVersion = "2k12";
                eventVersion = "6.2";
            } else {
                osVersion = "2k12";
                eventVersion = "6.2";
            }
            this.event_logger.log(Level.INFO, "RealTimeEventCollector.watchEventLog  starts" + this.computerName);
            int[] eventIDList = AuditEventAPI.getInstance().getAuditEvents(new String[]{eventVersion}, this.machineType);
            this.domainDetails = DomainHandler.getConfiguredValues(this.domainName, 1L);
            EventDataHandler.getInstance().checkDomainMonitorCount(this.domainName);
            this.timeGenerated = EventDataUtil.getEventTime(this.computerName, this.domainName);
            resultMap = ADHandler.watch2k8EventLog(this.domainDetails, this.computerName, this.recordNumber, eventIDList, this.machineType, osVersion, this.timeGenerated, this.uniqueId);
            this.event_logger.log(Level.INFO, "RealTimeEventCollector.watchEventLog ends" + this.computerName);
            this.event_logger.log(Level.INFO, "RESULT MAP IS  :: " + resultMap);
            if (resultMap.containsKey("errorMessage")) {
                this.event_logger.log(Level.INFO, "RealTimeEventCollector.watchEventLog - severe error" + resultMap.get("errorMessage"));
                retVal = false;
                ++this.retryCount;
                Thread.sleep(this.waitTime * (long)this.retryCount);
                message = (String)resultMap.get("errorMessage");
            } else if (resultMap.containsKey("result")) {
                Hashtable table = (Hashtable)resultMap.get("result");
                Integer timeWritten = (Integer)table.get("TimeWritten");
                EventDataUtil.updateRecordNumber(timeWritten.intValue(), (Long)table.get("RecordNumber"), this.computerName, this.domainName);
                if (table != null && table.get("StopRealTime") != null && Boolean.valueOf(table.get("StopRealTime").toString()).equals(true)) {
                    message = this.rb.getString("adap.common.text.status_msg.success");
                    this.event_logger.log(Level.INFO, "RealTimeEventCollector.watchEventLog - else is called thread stoped" + this.computerName);
                    this.stopThread = true;
                }
            }
        }
        catch (Exception ex) {
            retVal = false;
            ++this.retryCount;
            message = "Nullpointerexception";
            if (ex.getMessage() != null) {
                message = ex.getMessage();
            }
            ex.printStackTrace();
        }
        finally {
            try {
                if (this.retryCount == 5 || this.shutDown) {
                    if (!this.shutDownOnly) {
                        RealTimeEventUtil.getInstance().changeDcFetchMode(this.uniqueId, 4);
                        if (null != message && !message.equalsIgnoreCase(this.rb.getString("adap.common.text.status_msg.success"))) {
                            this.sendErrorMail(message);
                        }
                    }
                    EventDataUtil.getComputerDetails(this.domainName, this.computerName);
                    this.stopThread = true;
                }
                EventDataUtil.updateEventLogMessage(message, this.computerName, this.domainName);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return retVal;
    }

    public void sendErrorMail(String errorMessage) {
        try {
            Boolean b;
            RealTimeEventController.getInstance();
            if (RealTimeEventController.mailDetailsMap.get(this.computerName) == null && (b = EventErrorAlert.sendMail(this.domainName, this.computerName, errorMessage, this.machineType)).booleanValue()) {
                RealTimeEventController.getInstance();
                RealTimeEventController.mailDetailsMap.put(this.computerName, true);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void run() {
        try {
            String message = this.rb.getString("adap.common.text.status_msg.listening");
            EventDataUtil.updateEventLogMessage(message, this.computerName, this.domainName);
            Stack<RealTimeEventCollector> stack = new Stack<RealTimeEventCollector>();
            stack.push(this);
            while (!stack.isEmpty()) {
                RealTimeEventCollector collector = (RealTimeEventCollector)stack.pop();
                if (collector.watchEventLog().booleanValue() || collector.checkAndProcess()) continue;
                this.event_logger.log(Level.INFO, "RealTimeEventCollector run method - readEvents failed");
                stack.push(collector);
            }
            RealTimeEventController.getInstance();
            RealTimeEventController.dcStatus.put(this.computerName, 0);
            RealTimeEventController.getInstance();
            if (RealTimeEventController.realTimeEventCollectors.get(this.uniqueId) != null) {
                RealTimeEventController.getInstance();
                RealTimeEventController.realTimeEventCollectors.remove(this.uniqueId);
            }
            this.event_logger.log(Level.INFO, "RealTimeEventCollector run method - ends" + this.computerName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void shutDown() {
        this.shutDown = true;
    }

    public void shutDownOnly(boolean val) {
        this.shutDownOnly = val;
    }

    public boolean checkAndProcess() {
        return this.stopThread;
    }

    public synchronized void waitForUpdate(long t) {
        try {
            super.wait(t);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getComputerName() {
        return this.computerName;
    }
}

