/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.eventcollection.realtime;

import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.eventcollection.realtime.RealTimeEventCollector;
import com.adventnet.sym.adsm.auditing.server.eventcollection.realtime.RealTimeEventUtil;
import com.adventnet.sym.adsm.auditing.server.util.EventDataUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RealTimeEventController {
    public static HashMap<String, Integer> dcStatus = null;
    public static HashMap<String, Boolean> mailDetailsMap = null;
    private static RealTimeEventController realTimeEventController = null;
    private static final Logger EVENT_LOGGER = Logger.getLogger("EventLogger");
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    public static ConcurrentHashMap<Long, RealTimeEventCollector> realTimeEventCollectors = null;

    private RealTimeEventController() {
        try {
            dcStatus = new HashMap();
            mailDetailsMap = new HashMap();
            realTimeEventCollectors = new ConcurrentHashMap();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RealTimeEventController getInstance() {
        if (realTimeEventController != null) return realTimeEventController;
        Class<RealTimeEventController> clazz = RealTimeEventController.class;
        synchronized (RealTimeEventController.class) {
            realTimeEventController = new RealTimeEventController();
            // ** MonitorExit[var0] (shouldn't be in output)
            return realTimeEventController;
        }
    }

    public void runRealTimeEventFetch() {
        try {
            ArrayList<HashMap<String, Object>> list = RealTimeEventUtil.getInstance().getConfiguredServers();
            Iterator<HashMap<String, Object>> i$ = list.iterator();
            while (i$.hasNext()) {
                HashMap<String, Object> object;
                HashMap<String, Object> map = object = i$.next();
                Long uniqueId = (Long)map.get("DOMAIN_CONTROLLER_ID");
                Integer machineType = (Integer)map.get("MACHINE_TYPE");
                String computerName = map.get("DOMAIN_CONTROLLER_NAME").toString();
                Properties domainProp = (Properties)map.get("DOMAIN_DETAILS");
                this.start(domainProp, uniqueId, computerName, machineType);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void start(Properties domainDetails, Long uniqueId, String computerName, int machineType) throws Exception {
        if (dcStatus.get(computerName) != null && dcStatus.get(computerName) == 1) {
            EVENT_LOGGER.log(Level.INFO, "Event fetching is already on for in RealTimeEventController: " + computerName);
            throw new Exception(rb.handleGetObject("adap.EventDataHandler.Fetching_data_for_", new String[]{computerName}));
        }
        dcStatus.put(computerName, 1);
        EVENT_LOGGER.log(Level.INFO, "Initializing RealTime EventFetch in RealTimeEventController-> " + computerName);
        String domainName = domainDetails.get("DOMAIN_NAME").toString();
        Long recordNumber = EventDataUtil.getRecordNumber(computerName, domainName);
        Long timeGenerated = EventDataUtil.getEventTime(computerName, domainName);
        String osVersion = EventDataUtil.getComputerOsVersion(computerName, domainName);
        if (osVersion == null || osVersion.equals("")) {
            osVersion = DirectoryObjectAPI.getInstance().getComputerOsVersion(domainName, null, computerName, "computer");
        }
        if (uniqueId == null) {
            TreeMap<String, String> map = new TreeMap<String, String>();
            map.put("DOMAIN_NAME", domainName);
            map.put("DOMAIN_CONTROLLER_NAME", computerName);
            Row row = RealTimeEventUtil.getInstance().getDCRow(map);
            uniqueId = (Long)row.get("DOMAIN_CONTROLLER_ID");
        }
        RealTimeEventCollector collector = new RealTimeEventCollector(domainDetails, computerName, recordNumber, timeGenerated, machineType, osVersion, uniqueId);
        realTimeEventCollectors.put(uniqueId, collector);
        collector.start();
    }

    public void stop(Long uniqueId, boolean shutDownOnly) {
        try {
            RealTimeEventCollector collector;
            if (!realTimeEventCollectors.isEmpty() && uniqueId != null && (collector = realTimeEventCollectors.get(uniqueId)) != null) {
                collector.shutDown();
                collector.shutDownOnly(shutDownOnly);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static boolean getDCStatus(Long uniqueId) {
        boolean b = false;
        try {
            if (!realTimeEventCollectors.isEmpty() && uniqueId != null) {
                RealTimeEventCollector collector = realTimeEventCollectors.get(uniqueId);
                b = collector.shutDown;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return b;
    }

    public static boolean resetRetryCount(Long uniqueId) {
        boolean b = false;
        try {
            if (!realTimeEventCollectors.isEmpty() && uniqueId != null) {
                RealTimeEventCollector collector = realTimeEventCollectors.get(uniqueId);
                EVENT_LOGGER.log(Level.INFO, "RetryCount value   :: " + collector.retryCount);
                if (collector.retryCount != 0) {
                    collector.retryCount = 0;
                    b = true;
                }
                EVENT_LOGGER.log(Level.INFO, "RetryCount value  after :: " + collector.retryCount);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return b;
    }

    public static boolean updateDCMessage(Long uniqueId) {
        boolean b = false;
        try {
            if (!realTimeEventCollectors.isEmpty() && uniqueId != null) {
                RealTimeEventCollector collector = realTimeEventCollectors.get(uniqueId);
                EventDataUtil.updateEventLogMessage(rb.getString("adap.common.text.status_msg.listening"), collector.getComputerName(), collector.getDomainName());
                EVENT_LOGGER.log(Level.INFO, "Update Domaincontroller Id :: " + uniqueId);
                b = true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return b;
    }
}

