/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.eventcollection.realtime;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.eventcollection.realtime.RealTimeEventController;
import com.adventnet.sym.adsm.auditing.server.fileintegrity.FileIntegrityManager;
import com.adventnet.sym.adsm.auditing.server.util.EventDataUtil;
import com.adventnet.sym.adsm.common.server.DCHandler;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;

public class RealTimeEventUtil {
    private static RealTimeEventUtil realTimeEventUtil = null;
    private static final FileIntegrityManager FILE_INTEGRITY_MANAGER = FileIntegrityManager.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RealTimeEventUtil getInstance() {
        if (realTimeEventUtil != null) return realTimeEventUtil;
        Class<RealTimeEventUtil> clazz = RealTimeEventUtil.class;
        synchronized (RealTimeEventUtil.class) {
            realTimeEventUtil = new RealTimeEventUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return realTimeEventUtil;
        }
    }

    public ArrayList<HashMap<String, Object>> getConfiguredServers() {
        ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
        try {
            Table table = Table.getTable((String)"ADSMDCConfiguration");
            SelectQueryImpl query = new SelectQueryImpl(table);
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDDCEventRead", (String)"EVENT_FETCH_MODE"), (Object)3, 0);
            Join join = new Join("ADSMDCConfiguration", "AUDDCEventRead", new String[]{"DOMAIN_CONTROLLER_ID"}, new String[]{"DOMAIN_CONTROLLER_ID"}, 2);
            query.addJoin(join);
            query.setCriteria(criteria);
            query.addSelectColumn(Column.getColumn((String)"ADSMDCConfiguration", (String)"*"));
            query.addSelectColumn(Column.getColumn((String)"AUDDCEventRead", (String)"*"));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            Iterator iterator = dataObject.getRows("ADSMDCConfiguration");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                Long dcId = new Long(row.get("DOMAIN_CONTROLLER_ID").toString());
                DataObject scheduleDO = DCHandler.getDCEventSchedulerDO(dcId);
                Row scheduledRow = scheduleDO.getRow("Scheduled_Task");
                if ((Integer)scheduledRow.get("ADMIN_STATUS") != 3) continue;
                HashMap<String, Object> dcMap = new HashMap<String, Object>();
                String domainName = row.get("DOMAIN_NAME").toString();
                Properties domainDetails = DomainHandler.getConfiguredValues(domainName, 1L);
                int machineType = 1;
                Integer isFIMEnabled = EventDataUtil.isFIMEnabled(row.get("DOMAIN_CONTROLLER_NAME").toString(), domainName);
                if (isFIMEnabled == 1 && FILE_INTEGRITY_MANAGER.isFIMEnabledInDomain(domainName) && FILE_INTEGRITY_MANAGER.isFIMEnabledForMachineType(domainName, machineType)) {
                    machineType += 16384;
                }
                dcMap.put("MACHINE_TYPE", machineType);
                dcMap.put("DOMAIN_NAME", domainName);
                dcMap.put("DOMAIN_DETAILS", domainDetails);
                dcMap.put("DOMAIN_CONTROLLER_ID", dcId);
                dcMap.put("DOMAIN_CONTROLLER_NAME", row.get("DOMAIN_CONTROLLER_NAME").toString());
                list.add(dcMap);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return list;
    }

    public Row getDCRow(TreeMap map) {
        Row row = null;
        try {
            Criteria criteria = null;
            Set keys = map.keySet();
            for (Object key : keys) {
                Object val = map.get(key);
                if (criteria == null) {
                    criteria = new Criteria(Column.getColumn((String)"ADSMDCConfiguration", (String)key.toString()), val, 0);
                    continue;
                }
                criteria = criteria.and(new Criteria(Column.getColumn((String)"ADSMDCConfiguration", (String)key.toString()), val, 0));
            }
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADSMDCConfiguration", criteria);
            row = dataObject.getRow("ADSMDCConfiguration");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return row;
    }

    public void stopRealTimeCollection(Long scheduleId, boolean shutDownOnly) {
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDDCEventRead", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
            criteria = criteria.and(new Criteria(Column.getColumn((String)"AUDDCEventRead", (String)"EVENT_FETCH_MODE"), (Object)3, 0));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDDCEventRead", criteria);
            Row row = dataObject.getRow("AUDDCEventRead");
            if (row != null) {
                Long dcId = (Long)row.get("DOMAIN_CONTROLLER_ID");
                RealTimeEventController.getInstance().stop(dcId, shutDownOnly);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void changeDcFetchMode(Long dcId, Integer fetchMode) {
        try {
            if (dcId != null) {
                Criteria crit = new Criteria(Column.getColumn((String)"AUDDCEventRead", (String)"DOMAIN_CONTROLLER_ID"), (Object)dcId, 0);
                DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDDCEventRead", crit);
                Row row = dataObject.getRow("AUDDCEventRead");
                Long scheduleId = 0L;
                if (row != null) {
                    scheduleId = (Long)row.get("SCHEDULE_ID");
                    row.set("EVENT_FETCH_MODE", (Object)fetchMode);
                    dataObject.updateRow(row);
                    CommonUtil.getPersistence(new boolean[0]).update(dataObject);
                    this.updateTaskInput(scheduleId, fetchMode);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void updateTaskInput(Long scheduleId, Integer fetchMode) {
        try {
            if (scheduleId != null) {
                Criteria crit = new Criteria(Column.getColumn((String)"Task_Input", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
                DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("Task_Input", crit);
                Row row = dataObject.getRow("Task_Input");
                if (row != null) {
                    row.set("ADMIN_STATUS", (Object)(fetchMode == 3 ? 4 : 3));
                }
                dataObject.updateRow(row);
                CommonUtil.getPersistence(new boolean[0]).update(dataObject);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void checkAndUpdate(Long dcId, Integer fetchMode) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"AUDDCEventRead", (String)"DOMAIN_CONTROLLER_ID"), (Object)dcId, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)"AUDDCEventRead", (String)"EVENT_FETCH_MODE"), (Object)fetchMode, 0));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDDCEventRead", crit);
            Row row = dataObject.getRow("AUDDCEventRead");
            if (row != null) {
                this.changeDcFetchMode(dcId, fetchMode);
                if (fetchMode == 3) {
                    TreeMap<String, Long> map = new TreeMap<String, Long>();
                    map.put("DOMAIN_CONTROLLER_ID", dcId);
                    Row dcRow = this.getDCRow(map);
                    String dcName = dcRow.get("DOMAIN_CONTROLLER_NAME").toString();
                    String domainName = dcRow.get("DOMAIN_NAME").toString();
                    Properties domainDetails = DomainHandler.getConfiguredValues(domainName, 1L);
                    RealTimeEventController.getInstance().start(domainDetails, dcId, dcName, 1);
                } else {
                    RealTimeEventController.getInstance().stop(dcId, true);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void startEventFetchAddedDC(DataObject dataObject) {
        try {
            Iterator iterator = dataObject.getRows("ADSMDCConfiguration");
            while (iterator.hasNext()) {
                Row dcRow = (Row)iterator.next();
                Long dcId = (Long)dcRow.get("DOMAIN_CONTROLLER_ID");
                DataObject schedulerDO = DCHandler.getDCEventSchedulerDO(dcId);
                Row scheduleRow = schedulerDO.getRow("Scheduled_Task");
                Row eventReadRow = schedulerDO.getRow("AUDDCEventRead");
                if (scheduleRow == null || (Integer)scheduleRow.get("ADMIN_STATUS") != 3 || (Integer)eventReadRow.get("EVENT_FETCH_MODE") != 3) continue;
                Properties domainDetails = DomainHandler.getConfiguredValues(dcRow.get("DOMAIN_NAME").toString(), 1L);
                RealTimeEventController.getInstance().start(domainDetails, dcId, dcRow.get("DOMAIN_CONTROLLER_NAME").toString(), 1);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void stopRealTimeDeletedDomain(Long[] list) {
        try {
            for (Long dcId : list) {
                this.stopRealTimeCollection(dcId, false);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

