/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.fileaudit;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.GroupByClause;
import com.adventnet.ds.query.GroupByColumn;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.EventDataHandler;
import com.adventnet.sym.adsm.auditing.server.config.ServerConfigAPI;
import com.adventnet.sym.adsm.auditing.server.delegation.GpoHandler;
import com.adventnet.sym.adsm.auditing.server.fileaudit.ModifySaclThread;
import com.adventnet.sym.adsm.auditing.server.monitor.AudFileMonitorCriteriaHandler;
import com.adventnet.sym.adsm.auditing.server.monitor.AuditMonitorAPI;
import com.adventnet.sym.adsm.auditing.server.util.EventDataUtil;
import com.adventnet.sym.adsm.auditing.server.util.EventSchedulerUtil;
import com.adventnet.sym.adsm.auditing.server.util.FileAuditIpResolverUtil;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainDetailsAPI;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.MSHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.ntfs.FileSystemAPI;
import com.adventnet.sym.adsm.common.server.ntfs.NTFSTableUtil;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import com.adventnet.sym.adsm.common.server.util.EscapeUtil;
import com.adventnet.sym.adsm.common.server.util.SchedulerUtil;
import com.adventnet.taskengine.util.PersistenceUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileServerHandler {
    private static Logger logger = Logger.getLogger("ReportLogger");
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();

    public static DataObject checkIsMemberServer(String hostGuid, Integer machineType) throws Exception {
        Criteria c1 = new Criteria(Column.getColumn((String)"AUDComputerEventRead", (String)"OBJECT_GUID"), (Object)hostGuid, 0);
        Criteria c2 = new Criteria(Column.getColumn((String)"AUDComputerEventRead", (String)"MACHINE_TYPE"), (Object)machineType, 0);
        c1 = c1.and(c2);
        DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("AUDComputerEventRead", c1);
        return dataObj;
    }

    public static boolean checkIsDomainController(String domainName, String hostGuid) throws Exception {
        boolean isDomainController = false;
        Row row = DirectoryObjectAPI.getInstance().getObjectRow(domainName, hostGuid, "computer");
        if (row != null) {
            String role = (String)row.get("ROLE");
            isDomainController = role.contains("DomainController");
        }
        return isDomainController;
    }

    public static void addFileServers(String domainName, ArrayList<String> serverList) throws Exception {
        System.out.println("serverList from Auto discover : " + serverList);
        for (String serverName : serverList) {
            Hashtable<String, Object> fsDetails = new Hashtable<String, Object>();
            ArrayList<Row> rowList = FileSystemAPI.getInstance().getSharesForServer(domainName, serverName, "true");
            if (rowList.isEmpty()) continue;
            fsDetails.put("serverName", serverName);
            fsDetails.put("domainName", domainName);
            ArrayList<Long> shareIDList = new ArrayList<Long>();
            for (Row row : rowList) {
                Long shareId = (Long)row.get("SHARE_ID");
                shareIDList.add(shareId);
            }
            if (shareIDList.isEmpty()) continue;
            fsDetails.put("SHARE_IDS", shareIDList);
            Row computerRow = DirectoryObjectAPI.getInstance().getObjectRow(domainName, serverName, "NAME", "computer");
            if (computerRow == null) continue;
            fsDetails.put("OBJECT_GUID", computerRow.get("OBJECT_GUID"));
            FileServerHandler.addFileServer(fsDetails, "no");
        }
    }

    public static Row getFileServerRow(DataObject dataObj, Hashtable fsDetails, Integer fileServerType) throws Exception {
        Row fsRow;
        Long scheduleId = 0L;
        String msg = null;
        int enabledSchedulers = 0;
        Integer totalCount = 0;
        fsDetails.put("TIME_PERIOD", 120L);
        if ((fileServerType & 4) == 4 || (fileServerType & 0x40) == 64) {
            enabledSchedulers = ServerConfigAPI.getConfiguredServerCount(new int[]{4, 64});
            totalCount = MSHandler.getLicenseCount(4);
        } else if ((fileServerType & 0x100) == 256 || (fileServerType & 0x20000) == 131072 || (fileServerType & 0x80000) == 524288) {
            enabledSchedulers = ServerConfigAPI.getConfiguredServerCount(new int[]{256, 131072, 524288});
            totalCount = MSHandler.getLicenseCount(fileServerType);
            fsDetails.put("TIME_PERIOD", 30L);
        }
        Integer availableCount = totalCount - enabledSchedulers;
        Long scheduleStartTime = System.currentTimeMillis();
        fsDetails.put("adminStatus", 3);
        fsDetails.put("scheduleStartTime", scheduleStartTime);
        if (!dataObj.isEmpty()) {
            fsRow = dataObj.getRow(MSHandler.tableMSName);
        } else {
            fsRow = new Row(MSHandler.tableMSName);
            fsRow.set("MACHINE_TYPE", (Object)0);
        }
        fsRow.set("OBJECT_GUID", (Object)((String)fsDetails.get("OBJECT_GUID")));
        fsRow.set("TIME_PERIOD", (Object)((Long)fsDetails.get("TIME_PERIOD")));
        fsRow.set("UNIT_OF_TIME", (Object)"Minutes");
        int eventFetchMode = 1;
        try {
            Criteria c = new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"OBJECT_GUID"), (Object)((String)fsDetails.get("OBJECT_GUID")), 0);
            DataObject d = CommonUtil.getPersistence(new boolean[0]).get("ADSMComputerGeneralDetails", c);
            if (!d.isEmpty()) {
                Row r = d.getFirstRow("ADSMComputerGeneralDetails");
                String serverWinVer = (String)r.get("VERSION");
                if (serverWinVer == null || serverWinVer.length() == 0 || serverWinVer.equals("-")) {
                    serverWinVer = "0";
                }
                String localWinVer = System.getProperty("os.version");
                serverWinVer = serverWinVer.split("\\.")[0];
                localWinVer = localWinVer.split("\\.")[0];
                int sWinVer = Integer.parseInt(serverWinVer);
                int lWinVer = Integer.parseInt(localWinVer);
                if (sWinVer >= 6 && lWinVer >= 6) {
                    eventFetchMode = 2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        fsRow.set("EVENT_FETCH_MODE", (Object)eventFetchMode);
        int machineType = (Integer)fsRow.get("MACHINE_TYPE");
        if (availableCount > 0) {
            if ((fileServerType & 4) == 4) {
                machineType |= 4;
            } else if ((fileServerType & 0x40) == 64) {
                machineType |= 0x40;
            } else if ((fileServerType & 0x100) == 256) {
                machineType |= 0x100;
            } else if ((fileServerType & 0x20000) == 131072) {
                machineType |= 0x20000;
            } else if ((fileServerType & 0x80000) == 524288) {
                machineType |= 0x80000;
            }
        } else {
            fsDetails.put("adminStatus", 4);
            if ((fileServerType & 4) == 4) {
                machineType |= 8;
            } else if ((fileServerType & 0x40) == 64) {
                machineType |= 0x80;
            } else if ((fileServerType & 0x100) == 256) {
                machineType |= 0x200;
            } else if ((fileServerType & 0x20000) == 131072) {
                machineType |= 0x40000;
            } else if ((fileServerType & 0x80000) == 524288) {
                machineType |= 0x100000;
            }
            msg = totalCount > 0 ? ((fileServerType & 0x100) == 256 || (fileServerType & 0x20000) == 131072 || (fileServerType & 0x80000) == 524288 ? rb.handleGetObject("adap.EMCHandler.License_Level_Exceed_You_can_enable_only_limited_EMC_Server", new String[]{Integer.toString(totalCount)}) : rb.handleGetObject("adap.MSHandler.License_Level_Exceed_You_can_enable_only_limited_File_Servers", new String[]{Integer.toString(totalCount)})) : rb.getString("adap.LicenseUpgradeAction.You_are_using__licenseType");
        }
        scheduleId = EventSchedulerUtil.createEventScheduler(fsDetails, 4);
        logger.log(Level.INFO, "Schedule ID is ::: " + scheduleId);
        fsRow.set("MACHINE_TYPE", (Object)machineType);
        fsRow.set("SCHEDULE_ID", (Object)scheduleId);
        fsRow.set("INSTANCE_ID", FileServerHandler.getInstanceId(scheduleId));
        fsDetails.put("SCHEDULE_ID", scheduleId);
        if (msg != null) {
            fsDetails.put("MESSAGE", msg);
        }
        return fsRow;
    }

    public static void addFileUpdateDetails(Hashtable fsDetails, boolean isClusterCap) throws Exception {
        String serverName = (String)fsDetails.get("serverName");
        String domainName = (String)fsDetails.get("domainName");
        ArrayList shareNameList = (ArrayList)fsDetails.get("LOCATIONS");
        logger.log(Level.INFO, "Get Share Local Path for server : " + serverName);
        Criteria criteria = new Criteria(Column.getColumn((String)"ADSMShareGeneralDetails", (String)"LOCATION"), (Object)shareNameList.toArray(new Object[shareNameList.size()]), 8);
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADSMShareGeneralDetails", criteria);
        Properties properties = new Properties();
        Iterator rowIterator = dataObject.getRows("ADSMShareGeneralDetails");
        while (rowIterator.hasNext()) {
            Row shareRow = (Row)rowIterator.next();
            properties.setProperty((String)shareRow.get("LOCATION"), (String)shareRow.get("LOCAL_PATH"));
        }
        logger.log(Level.INFO, "After Getting Share Local Path for server : " + dataObject);
        FileServerHandler.addFolderSyncStatusEntry(domainName, serverName, properties);
        logger.log(Level.INFO, "Started fetching folders and files for server :" + serverName);
        logger.log(Level.INFO, "Finished fetching folders and files for server :" + serverName);
    }

    public static String addFileServer(Hashtable fsDetails, String userSelection) throws Exception {
        String message = "";
        String gpoStatus = "";
        String objectGuid = (String)fsDetails.get("OBJECT_GUID");
        String[] guidArray = new String[]{objectGuid};
        DataObject msObj = null;
        boolean isMemberServer = ServerConfigAPI.isConfiguredMemberServer(objectGuid);
        boolean isFileServer = ServerConfigAPI.isConfiguredFileServer(objectGuid);
        boolean isClusterServer = ServerConfigAPI.isConfiguredClusterServer(objectGuid);
        boolean isEvntCollector = ServerConfigAPI.isConfiguredEvntCollector(objectGuid);
        Criteria criteria = new Criteria(Column.getColumn((String)"AUDComputerEventRead", (String)"OBJECT_GUID"), (Object)objectGuid, 0);
        msObj = CommonUtil.getPersistence(new boolean[0]).get("AUDComputerEventRead", criteria);
        if (isFileServer) {
            ArrayList shareNameList = (ArrayList)fsDetails.get("LOCATIONS");
            ArrayList<String> conShareList = FileServerHandler.getConfiguredShares((String)fsDetails.get("serverName"), (String)fsDetails.get("domainName"));
            for (int i = 0; i < conShareList.size(); ++i) {
                if (!shareNameList.contains(conShareList.get(i))) continue;
                shareNameList.remove(conShareList.get(i));
            }
            fsDetails.put("LOCATIONS", shareNameList);
            message = rb.getString("adap.FileServerHandler.File_Shares_are_added_successfully_for_auditing");
        } else if (isClusterServer) {
            Row fsRow = msObj.getRow(MSHandler.tableMSName);
            int machineType = (Integer)fsRow.get("MACHINE_TYPE");
            machineType = (machineType & 0x40) == 64 ? (machineType |= 4) : ((machineType & 0x80) == 128 ? (machineType |= 8) : 128);
            fsRow.set("MACHINE_TYPE", (Object)machineType);
            msObj.updateRow(fsRow);
            CommonUtil.getPersistence(new boolean[0]).update(msObj);
            message = rb.getString("adap.FileServerHandler.Successfully_configured_File_Server");
        } else if (isMemberServer || isEvntCollector) {
            Row row = msObj.getRow("AUDComputerEventRead");
            Long instanceId = (Long)row.get("INSTANCE_ID");
            Row fsRow = FileServerHandler.getFileServerRow(msObj, fsDetails, new Integer(4));
            msObj.updateRow(fsRow);
            logger.log(Level.INFO, "Row is " + fsRow);
            CommonUtil.getPersistence(new boolean[0]).update(msObj);
            int fsMachineType = (Integer)fsRow.get("MACHINE_TYPE");
            if ((fsMachineType & 4) == 4) {
                FileServerHandler.runEventScheduler((Long)fsDetails.get("SCHEDULE_ID"));
            }
            MSHandler.removeTaskInstanceID(instanceId, new boolean[0]);
            message = rb.getString("adap.FileServerHandler.Successfully_configured_File_Server");
        } else if (msObj == null || msObj.isEmpty()) {
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Row fsRow = FileServerHandler.getFileServerRow(dataObj, fsDetails, 4);
            dataObj.addRow(fsRow);
            CommonUtil.getPersistence(new boolean[0]).add(dataObj);
            int fsMachineType = (Integer)fsRow.get("MACHINE_TYPE");
            if ((fsMachineType & 4) == 4) {
                FileServerHandler.runEventScheduler((Long)fsDetails.get("SCHEDULE_ID"));
            }
            message = rb.getString("adap.FileServerHandler.Successfully_configured_File_Server");
        } else {
            Row fsRow = FileServerHandler.getFileServerRow(msObj, fsDetails, 4);
            msObj.updateRow(fsRow);
            CommonUtil.getPersistence(new boolean[0]).update(msObj);
            int fsMachineType = (Integer)fsRow.get("MACHINE_TYPE");
            if ((fsMachineType & 4) == 4) {
                FileServerHandler.runEventScheduler((Long)fsDetails.get("SCHEDULE_ID"));
            }
            message = rb.getString("adap.FileServerHandler.Successfully_configured_File_Server");
        }
        if (isFileServer) {
            AudFileMonitorCriteriaHandler.addFileServersShares((String)fsDetails.get("domainName"), (String)fsDetails.get("serverName"), (ArrayList)fsDetails.get("LOCATIONS"));
        } else {
            AudFileMonitorCriteriaHandler.addFileServersShares(fsDetails);
        }
        if (userSelection != null) {
            if (userSelection.equalsIgnoreCase("yes")) {
                gpoStatus = GpoHandler.createGpoAndApplySecurityFilter((String)fsDetails.get("domainName"), null, guidArray, 4);
                message = gpoStatus.equalsIgnoreCase("Configuring audit policy for remote domain is currently not supported") ? message + rb.getString("adap.FileServerHandler.Configuring_audit_policy_for_remote_domain_is_currently_not_supported") : message + "," + gpoStatus;
                new ModifySaclThread(fsDetails);
            } else {
                message = message + rb.getString("adap.FileServerHandler.Object_Access_policy_and_auditing_permissions");
            }
        }
        if ((String)fsDetails.get("MESSAGE") != null) {
            message = (String)fsDetails.get("MESSAGE");
        }
        logger.log(Level.INFO, "Adding FS : " + fsDetails);
        FileServerHandler.addFileUpdateDetails(fsDetails, false);
        EventDataUtil.getComputerDetails(null, null);
        return message;
    }

    public static void addFolderSyncStatusEntry(String domainName, String serverName, Properties properties) {
        logger.log(Level.INFO, "Adding entry in foldersyncstatus table: ");
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDServerFolderSyncStatus", (String)"SERVERNAME"), (Object)serverName, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDServerFolderSyncStatus", criteria);
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String shareName = (String)enumeration.nextElement();
                Row row = dataObject.getRow("AUDServerFolderSyncStatus", new Criteria(Column.getColumn((String)"AUDServerFolderSyncStatus", (String)"SHARE_NAME"), (Object)shareName, 0));
                if (row == null) {
                    row = new Row("AUDServerFolderSyncStatus");
                    row.set("SERVERNAME", (Object)serverName);
                    row.set("DOMAIN_NAME", (Object)domainName);
                    row.set("SHARE_NAME", (Object)shareName);
                    row.set("UPDATE_COUNT", (Object)1);
                    row.set("LATEST_CREATED_FILE_TIME", (Object)System.currentTimeMillis());
                    dataObject.addRow(row);
                    continue;
                }
                row.set("UPDATE_COUNT", (Object)1);
                row.set("LATEST_CREATED_FILE_TIME", (Object)System.currentTimeMillis());
                dataObject.updateRow(row);
            }
            CommonUtil.getPersistence(new boolean[0]).update(dataObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.log(Level.INFO, "After Adding entry in foldersyncstatus table: ");
    }

    public static void getShareNames(Hashtable fsDetails) throws Exception {
        ArrayList<String> shareNameList = new ArrayList<String>();
        DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADSMShareGeneralDetails"));
        Column column = Column.getColumn((String)"ADSMShareGeneralDetails", (String)"*");
        query.addSelectColumn(column);
        Criteria criteria = new Criteria(Column.getColumn((String)"ADSMShareGeneralDetails", (String)"HOST_COMPUTER"), (Object)((String)fsDetails.get("serverName")), 0);
        Criteria criteria1 = new Criteria(Column.getColumn((String)"ADSMShareGeneralDetails", (String)"LOCATION"), (Object)((ArrayList)fsDetails.get("LOCATIONS")).toArray(new Object[((ArrayList)fsDetails.get("LOCATIONS")).size()]), 8);
        Criteria criteria2 = new Criteria(Column.getColumn((String)"ADSMShareGeneralDetails", (String)"DOMAIN_NAME"), (Object)((String)fsDetails.get("domainName")), 0);
        criteria = criteria.and(criteria1);
        criteria = criteria.and(criteria2);
        query.setCriteria(criteria);
        dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
        String dbName = CommonUtil.getDBServerName();
        Iterator iterator = dataObj.getRows("ADSMShareGeneralDetails");
        while (iterator.hasNext()) {
            Row shareRow = (Row)iterator.next();
            String shareName = (String)shareRow.get("SHARE_NAME");
            if (dbName.equalsIgnoreCase("mssql")) {
                shareName = EscapeUtil.escSplCharsAsMSSQL(shareName);
            }
            shareNameList.add(shareName);
        }
        logger.log(Level.INFO, "shareNameList in FileServerHandler is " + shareNameList);
        fsDetails.put("SHARE_NAMES", shareNameList);
    }

    public static String updateFileServers(String domainName, String action, ArrayList msIDs, String timePeriodText) throws Exception {
        String message = null;
        Criteria criteria = null;
        Long[] id = null;
        System.out.println("msIDs" + msIDs);
        if (msIDs == null) {
            criteria = new Criteria(Column.getColumn((String)"AUDComputerEventRead", (String)"COMPUTER_ID"), null, 1);
        } else {
            id = new Long[msIDs.size()];
            for (int i = 0; i < id.length; ++i) {
                id[i] = (Long)msIDs.get(i);
            }
            criteria = new Criteria(Column.getColumn((String)"AUDComputerEventRead", (String)"COMPUTER_ID"), (Object)id, 8);
        }
        DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("AUDComputerEventRead", criteria);
        if (!dataObj.isEmpty()) {
            if (action.equalsIgnoreCase("Enable")) {
                Integer licenseCount = MSHandler.getLicenseCount(4);
                System.out.println("licenseCount is " + licenseCount);
                int enableCount = ServerConfigAPI.getConfiguredServerCount(new int[]{4, 64});
                System.out.println("enableCount is " + enableCount);
                for (int i = 0; i < msIDs.size(); ++i) {
                    Criteria enableCrit = new Criteria(Column.getColumn((String)"AUDComputerEventRead", (String)"COMPUTER_ID"), msIDs.get(i), 0);
                    Row enableRow = dataObj.getRow("AUDComputerEventRead", enableCrit);
                    if (licenseCount > enableCount) {
                        int machineType = (Integer)enableRow.get("MACHINE_TYPE");
                        if ((machineType & 0x80) == 128) {
                            machineType |= 0x40;
                            machineType &= 0xFFFFFF7F;
                        } else if ((machineType & 0x100000) == 0x100000) {
                            machineType |= 0x80000;
                            machineType &= 0xFFEFFFFF;
                        }
                        machineType |= 4;
                        enableRow.set("MACHINE_TYPE", (Object)(machineType &= 0xFFFFFFF7));
                        message = rb.getString("adap.MSHandler.Successfully_enabled");
                        dataObj.updateRow(enableRow);
                        ++enableCount;
                        CommonUtil.getPersistence(new boolean[0]).update(dataObj);
                        EventSchedulerUtil.enableDisableScheduler((Long)enableRow.get("SCHEDULE_ID"), "Enable");
                        continue;
                    }
                    message = licenseCount > 0 ? rb.handleGetObject("adap.MSHandler.License_Level_Exceed_You_can_enable_only_limited_File_Servers", new String[]{Integer.toString(licenseCount)}) : rb.getString("adap.LicenseUpgradeAction.You_are_using__licenseType");
                }
            } else if (action.equalsIgnoreCase("Disable")) {
                Iterator iter = dataObj.getRows("AUDComputerEventRead");
                while (iter.hasNext()) {
                    Row row = (Row)iter.next();
                    int machineType = (Integer)row.get("MACHINE_TYPE");
                    if ((machineType & 0x40) == 64) {
                        machineType |= 0x80;
                        machineType &= 0xFFFFFFBF;
                    } else if ((machineType & 0x80000) == 524288) {
                        machineType |= 0x100000;
                        machineType &= 0xFFF7FFFF;
                    }
                    machineType |= 8;
                    row.set("MACHINE_TYPE", (Object)(machineType &= 0xFFFFFFFB));
                    dataObj.updateRow(row);
                    if ((machineType & 0x10) == 16 || (machineType & 0x400) == 1024) continue;
                    EventSchedulerUtil.enableDisableScheduler((Long)row.get("SCHEDULE_ID"), "Disable");
                }
                CommonUtil.getPersistence(new boolean[0]).update(dataObj);
                message = rb.getString("adap.MSHandler.Successfully_Disabled");
            } else if (action.equalsIgnoreCase("Delete")) {
                ArrayList<String> objectGuids = new ArrayList<String>();
                ArrayList<Long> deletedSchedule = new ArrayList<Long>();
                FileServerHandler.deleteSharesForServers(id);
                boolean isUpdate = false;
                Iterator iter = dataObj.getRows("AUDComputerEventRead");
                while (iter.hasNext()) {
                    Row row = (Row)iter.next();
                    int machineType = (Integer)row.get("MACHINE_TYPE");
                    String objectGUID = (String)row.get("OBJECT_GUID");
                    if ((machineType & 0x10) != 16 && (machineType & 0x20) != 32 && !FileServerHandler.checkIsDomainController(domainName, objectGUID)) {
                        Long instanceId = (Long)row.get("INSTANCE_ID");
                        logger.fine("Adding to instanceVsGUIDMap- instanceId:" + instanceId);
                        MSHandler.instanceVsGUIDMap.put(instanceId, objectGUID);
                    } else {
                        logger.fine("MachineType is a work station or domain controller");
                    }
                    machineType &= 0xFFFFFFFB;
                    logger.log(Level.INFO, "machineType:" + (machineType &= 0xFFFFFFF7));
                    if ((machineType & 0x40) == 64 || (machineType & 0x80) == 128) {
                        isUpdate = true;
                        row.set("MACHINE_TYPE", (Object)machineType);
                        dataObj.updateRow(row);
                        continue;
                    }
                    if ((machineType & 0x10) == 16 || (machineType & 0x20) == 32 || (machineType & 0x400) == 1024 || (machineType & 0x800) == 2048) {
                        deletedSchedule.add((Long)row.get("SCHEDULE_ID"));
                        isUpdate = true;
                        Row taskInputRow = MSHandler.addTaskInstanceID(DBObjectUtil.getUVHValues("Schedule", "Schedule:schedule_id:UVH@3484"), System.currentTimeMillis(), PersistenceUtil.getPoolID((String)"MemberServerThreadPool"));
                        dataObj.addRow(taskInputRow);
                        row.set("MACHINE_TYPE", (Object)machineType);
                        row.set("SCHEDULE_ID", (Object)DBObjectUtil.getUVHValues("Schedule", "Schedule:schedule_id:UVH@3484"));
                        row.set("INSTANCE_ID", taskInputRow.get("INSTANCE_ID"));
                        dataObj.updateRow(row);
                        continue;
                    }
                    objectGuids.add((String)row.get("OBJECT_GUID"));
                    deletedSchedule.add((Long)row.get("SCHEDULE_ID"));
                }
                if (isUpdate) {
                    CommonUtil.getPersistence(new boolean[0]).update(dataObj);
                }
                Criteria scheduleCrit = new Criteria(Column.getColumn((String)"Schedule", (String)"SCHEDULE_ID"), (Object)deletedSchedule.toArray(new Long[deletedSchedule.size()]), 8);
                CommonUtil.getPersistence(new boolean[0]).delete(scheduleCrit);
                GpoHandler.removeSecurityFilter(domainName, "ADAuditPlusPolicy", objectGuids.toArray(new String[objectGuids.size()]));
                message = rb.getString("adap.AdminHandler.Successfully_Deleted");
                MSHandler.synchronizeNow("File Server delete", true);
            } else if (action.equalsIgnoreCase("timePeriodChange")) {
                Long timePeriod = Long.parseLong(timePeriodText);
                ArrayList<Long> schedule_id = new ArrayList<Long>();
                Iterator iter = dataObj.getRows("AUDComputerEventRead");
                while (iter.hasNext()) {
                    Row row = (Row)iter.next();
                    row.set("TIME_PERIOD", (Object)timePeriod);
                    dataObj.updateRow(row);
                    schedule_id.add((Long)row.get("SCHEDULE_ID"));
                }
                CommonUtil.getPersistence(new boolean[0]).update(dataObj);
                message = rb.getString("adap.MSHandler.Successfully_Changed_the_Event_Fetch");
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("TIME_PERIOD", timePeriod);
                map.put("UNIT_OF_TIME", "Minutes");
                map.put("SCHEDULE_ID", schedule_id.toArray(new Long[schedule_id.size()]));
                SchedulerUtil.updatePeriodicScheduler(map);
            }
        } else {
            message = rb.getString("adap.FileServerHandler.Data_Object_is_empty");
        }
        EventDataUtil.getComputerDetails(null, null);
        return message;
    }

    public static void dropFileDetailsTable(String[] objectGuids, String domainName) {
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"OBJECT_GUID"), (Object)objectGuids, 8);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADSMComputerGeneralDetails", criteria);
            Iterator iterator = dataObject.getRows("ADSMComputerGeneralDetails");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                String computerName = (String)row.get("NAME");
                NTFSTableUtil.dropTable(computerName, domainName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void dropFileDetailsTable(ArrayList servers, String domainName) {
        try {
            for (int i = 0; i < servers.size(); ++i) {
                NTFSTableUtil.dropTable((String)servers.get(i), domainName);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static ArrayList<String> discoverFileServers(String domainName) {
        String distinguishedName = DomainDetailsAPI.getDefaultNamingContext(domainName);
        ArrayList<String> fileServerList = new ArrayList<String>();
        ArrayList<String> attributeList = new ArrayList<String>();
        attributeList.add("name");
        attributeList.add("remoteServerName");
        String searchString = "(objectClass=ftDfs)";
        try {
            Properties domainDetails = DomainHandler.getConfiguredValues(domainName, 1L);
            ArrayList nameSpaceList = ADHandler.getObjectsWithOutListener(domainDetails, distinguishedName, attributeList, searchString);
            if (nameSpaceList != null) {
                for (Object object : nameSpaceList) {
                    Properties properties = (Properties)object;
                    ArrayList remoteServerNameList = (ArrayList)properties.get("remoteServerName");
                    for (Object object2 : remoteServerNameList) {
                        String sharePath = (String)object2;
                        if (sharePath.equals("*") || !sharePath.startsWith("\\\\")) continue;
                        String serverName = sharePath.substring(2);
                        int index = serverName.indexOf("\\");
                        if (fileServerList.contains(serverName = serverName.substring(0, index))) continue;
                        fileServerList.add(serverName);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fileServerList;
    }

    public static void runEventScheduler(Long scheduleId) {
        try {
            int fetchMode;
            ArrayList<String> tableList = new ArrayList<String>();
            tableList.add("AUDComputerEventRead");
            tableList.add("ADSMComputerGeneralDetails");
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDComputerEventRead", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(tableList, criteria);
            Row row = dataObject.getRow("ADSMComputerGeneralDetails");
            String domainName = (String)row.get("DOMAIN_NAME");
            String dcName = (String)row.get("NAME");
            Row eventRow = dataObject.getRow("AUDComputerEventRead");
            Integer machineType = (Integer)eventRow.get("MACHINE_TYPE");
            if (FileServerHandler.checkIsDomainController(domainName, (String)row.get("OBJECT_GUID"))) {
                machineType = machineType | 1;
            }
            if ((fetchMode = ((Integer)eventRow.get("EVENT_FETCH_MODE")).intValue()) == 2 && ((machineType & 4) == 4 || (machineType & 0x40) == 64)) {
                FileAuditIpResolverUtil.getInstance().tableCountCheck(domainName, dcName);
            }
            EventDataHandler.getInstance().fillEventData(domainName, dcName, scheduleId, machineType, (String)eventRow.get("OBJECT_GUID"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void deleteConfiguredShares(ArrayList shareNameList, String serverName, String domainName) throws Exception {
        ArrayList<Long> criteriaIdList = FileServerHandler.getShareCriteriaId(serverName, domainName);
        if (!criteriaIdList.isEmpty()) {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDFileMonitorShares", (String)"CRITERIA_ID"), (Object)criteriaIdList.toArray(new Long[criteriaIdList.size()]), 8);
            criteria = criteria.and(new Criteria(Column.getColumn((String)"AUDFileMonitorShares", (String)"SHARE_NAME"), (Object)shareNameList.toArray(new Object[shareNameList.size()]), 8));
            CommonUtil.getPersistenceLite().delete(criteria);
        }
    }

    public static void deleteSharesForServers(Long[] ids) throws Exception {
        String tableName = "AUDComputerEventRead";
        Table table = Table.getTable((String)tableName);
        SelectQueryImpl query = new SelectQueryImpl(table);
        Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"COMPUTER_ID"), (Object)ids, 8);
        query.setCriteria(criteria);
        Join join = new Join(tableName, "ADSMComputerGeneralDetails", new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 2);
        query.addJoin(join);
        query.addSelectColumn(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"*"));
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
        Row row = dataObject.getRow("ADSMComputerGeneralDetails");
        String domainName = (String)row.get("DOMAIN_NAME");
        ArrayList<String> serverNameList = new ArrayList<String>();
        Iterator iterator = dataObject.getRows("ADSMComputerGeneralDetails");
        while (iterator.hasNext()) {
            Row serverRow = (Row)iterator.next();
            serverNameList.add((String)serverRow.get("NAME"));
        }
        FileServerHandler.deleteSharesForServer(serverNameList.toArray(new String[serverNameList.size()]), domainName);
    }

    public static void deleteSharesForServer(String[] serverNames, String domainName) throws Exception {
        try {
            ArrayList<Long> monitorList = AuditMonitorAPI.getInstance().getMonitorsForDomain(domainName, null, 2);
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDFileMonitorServers", (String)"MONITOR_ID"), (Object)monitorList.toArray(new Long[monitorList.size()]), 8);
            criteria = criteria.and(new Criteria(Column.getColumn((String)"AUDFileMonitorServers", (String)"SERVERNAME"), (Object)serverNames, 8));
            CommonUtil.getPersistenceLite().delete(criteria);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ArrayList<Long> getShareCriteriaId(String serverName, String domainName) {
        ArrayList<Long> criteriaIdList = new ArrayList<Long>();
        try {
            ArrayList<Long> monitorList = AuditMonitorAPI.getInstance().getMonitorsForDomain(domainName, null, 2);
            if (!monitorList.isEmpty()) {
                Criteria criteria = new Criteria(Column.getColumn((String)"AUDFileMonitorServers", (String)"MONITOR_ID"), (Object)monitorList.toArray(new Long[monitorList.size()]), 8);
                if (serverName != null) {
                    criteria = criteria.and(Column.getColumn((String)"AUDFileMonitorServers", (String)"SERVERNAME"), (Object)serverName, 0);
                }
                DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDFileMonitorServers", criteria);
                Iterator iterator = dataObject.getRows("AUDFileMonitorServers");
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    criteriaIdList.add((Long)row.get("CRITERIA_ID"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return criteriaIdList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap getConfiguredShares(String domainName) {
        HashMap<String, Properties> serverMap = new HashMap<String, Properties>();
        Connection connection = null;
        DataSet dataSet = null;
        logger.log(Level.INFO, "Getting Configured Servers and Shares for Domain " + domainName);
        try {
            ArrayList<Long> monitorList = AuditMonitorAPI.getInstance().getMonitorsForDomain(domainName, null, 2);
            String monitorServerTable = "AUDFileMonitorServers";
            String monitorShareTable = "AUDFileMonitorShares";
            Table serverTable = Table.getTable((String)monitorServerTable);
            SelectQueryImpl query = new SelectQueryImpl(serverTable);
            Criteria criteria = new Criteria(Column.getColumn((String)monitorServerTable, (String)"MONITOR_ID"), (Object)monitorList.toArray(new Long[monitorList.size()]), 8);
            logger.log(Level.INFO, "Getting Configured Servers and Shares for criteria " + criteria);
            Join shareJoin = new Join(monitorServerTable, monitorShareTable, new String[]{"CRITERIA_ID"}, new String[]{"CRITERIA_ID"}, 2);
            query.setCriteria(criteria);
            query.addJoin(shareJoin);
            query.addSelectColumn(Column.getColumn((String)monitorServerTable, (String)"CRITERIA_ID"));
            query.addSelectColumn(Column.getColumn((String)monitorServerTable, (String)"SERVERNAME"));
            query.addSelectColumn(Column.getColumn((String)monitorShareTable, (String)"CRITERIA_OBJECT_ID"));
            query.addSelectColumn(Column.getColumn((String)monitorShareTable, (String)"SHARE_NAME"));
            query.addSelectColumn(Column.getColumn((String)monitorShareTable, (String)"LOCAL_PATH"));
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)query, connection);
            GroupByColumn groupByColumn = new GroupByColumn(Column.getColumn((String)monitorShareTable, (String)"SHARE_NAME"), false);
            ArrayList<GroupByColumn> groupByList = new ArrayList<GroupByColumn>();
            groupByList.add(groupByColumn);
            GroupByClause groupByClause = new GroupByClause(groupByList);
            query.setGroupByClause(groupByClause);
            while (dataSet.next()) {
                String serverName = (String)dataSet.getValue("SERVERNAME");
                Properties shareProperties = (Properties)serverMap.get(serverName);
                if (shareProperties == null) {
                    shareProperties = new Properties();
                }
                shareProperties.setProperty((String)dataSet.getValue("SHARE_NAME"), (String)dataSet.getValue("LOCAL_PATH"));
                serverMap.put(serverName, shareProperties);
            }
            logger.log(Level.INFO, "Configured Servers and Shares " + serverMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (dataSet != null) {
                    dataSet.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return serverMap;
    }

    public static ArrayList<String> getConfiguredShares(String serverName, String domainName) {
        ArrayList<String> shareList = new ArrayList<String>();
        try {
            ArrayList<Long> criteriaIdList = FileServerHandler.getShareCriteriaId(serverName, domainName);
            Criteria criteria2 = new Criteria(Column.getColumn((String)"AUDFileMonitorShares", (String)"CRITERIA_ID"), (Object)criteriaIdList.toArray(new Long[criteriaIdList.size()]), 8);
            DataObject dataObject2 = CommonUtil.getPersistence(new boolean[0]).get("AUDFileMonitorShares", criteria2);
            String dbName = CommonUtil.getDBServerName();
            Iterator iterator = dataObject2.getRows("AUDFileMonitorShares");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                String shareName = (String)row.get("SHARE_NAME");
                if (shareList.contains(shareName)) continue;
                shareList.add(shareName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return shareList;
    }

    public static int getConfiguredFileServerCount() {
        int count = 0;
        try {
            String countQuery = "select count(*) from AUDComputerEventRead where MACHINE_TYPE=4";
            count = QueryUtil.getRowsCount(countQuery);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return count;
    }

    private static Object getInstanceId(Object scheduleId) throws Exception {
        Object instanceId = 0;
        Criteria criteria = new Criteria(Column.getColumn((String)"Task_Input", (String)"SCHEDULE_ID"), scheduleId, 0);
        DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("Task_Input", criteria);
        if (!dataObj.isEmpty()) {
            Row row = dataObj.getFirstRow("Task_Input");
            instanceId = row.get("INSTANCE_ID");
        }
        return instanceId;
    }

    public static HashMap<String, Object> addFileServerEmber(Hashtable<String, Object> fsDetails, Boolean isSACL, Boolean isAuditPolicy) throws Exception {
        String message = "";
        String gpoStatus = "";
        String saclMsg = null;
        String msgType = "success";
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        try {
            String auditPolicyMsg = null;
            String objectGuid = (String)fsDetails.get("OBJECT_GUID");
            String[] guidArray = new String[]{objectGuid};
            DataObject msObj = null;
            boolean isMemberServer = ServerConfigAPI.isConfiguredMemberServer(objectGuid);
            boolean isFileServer = ServerConfigAPI.isConfiguredFileServer(objectGuid);
            boolean isClusterServer = ServerConfigAPI.isConfiguredClusterServer(objectGuid);
            boolean isEvntCollector = ServerConfigAPI.isConfiguredEvntCollector(objectGuid);
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDComputerEventRead", (String)"OBJECT_GUID"), (Object)objectGuid, 0);
            msObj = CommonUtil.getPersistence(new boolean[0]).get("AUDComputerEventRead", criteria);
            if (isFileServer) {
                ArrayList shareNameList = (ArrayList)fsDetails.get("LOCATIONS");
                ArrayList<String> conShareList = FileServerHandler.getConfiguredShares((String)fsDetails.get("serverName"), (String)fsDetails.get("domainName"));
                for (int i = 0; i < conShareList.size(); ++i) {
                    if (!shareNameList.contains(conShareList.get(i))) continue;
                    shareNameList.remove(conShareList.get(i));
                }
                fsDetails.put("LOCATIONS", shareNameList);
                message = rb.getString("adap.FileServerHandler.File_Shares_are_added_successfully_for_auditing");
            } else if (isClusterServer) {
                Row fsRow = msObj.getRow(MSHandler.tableMSName);
                int machineType = (Integer)fsRow.get("MACHINE_TYPE");
                machineType = (machineType & 0x40) == 64 ? (machineType |= 4) : ((machineType & 0x80) == 128 ? (machineType |= 8) : 128);
                fsRow.set("MACHINE_TYPE", (Object)machineType);
                msObj.updateRow(fsRow);
                CommonUtil.getPersistence(new boolean[0]).update(msObj);
                message = rb.getString("adap.FileServerHandler.Successfully_configured_File_Server");
            } else if (isMemberServer || isEvntCollector) {
                Row row = msObj.getRow("AUDComputerEventRead");
                Long instanceId = (Long)row.get("INSTANCE_ID");
                Row fsRow = FileServerHandler.getFileServerRow(msObj, fsDetails, new Integer(4));
                msObj.updateRow(fsRow);
                logger.log(Level.INFO, "Row is " + fsRow);
                CommonUtil.getPersistence(new boolean[0]).update(msObj);
                int fsMachineType = (Integer)fsRow.get("MACHINE_TYPE");
                if ((fsMachineType & 4) == 4) {
                    FileServerHandler.runEventScheduler((Long)fsDetails.get("SCHEDULE_ID"));
                }
                MSHandler.removeTaskInstanceID(instanceId, new boolean[0]);
                message = rb.getString("adap.FileServerHandler.Successfully_configured_File_Server");
            } else if (msObj == null || msObj.isEmpty()) {
                DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                Row fsRow = FileServerHandler.getFileServerRow(dataObj, fsDetails, 4);
                dataObj.addRow(fsRow);
                CommonUtil.getPersistence(new boolean[0]).add(dataObj);
                int fsMachineType = (Integer)fsRow.get("MACHINE_TYPE");
                if ((fsMachineType & 4) == 4) {
                    FileServerHandler.runEventScheduler((Long)fsDetails.get("SCHEDULE_ID"));
                }
                message = rb.getString("adap.FileServerHandler.Successfully_configured_File_Server");
            } else {
                Row fsRow = FileServerHandler.getFileServerRow(msObj, fsDetails, 4);
                msObj.updateRow(fsRow);
                CommonUtil.getPersistence(new boolean[0]).update(msObj);
                int fsMachineType = (Integer)fsRow.get("MACHINE_TYPE");
                if ((fsMachineType & 4) == 4) {
                    FileServerHandler.runEventScheduler((Long)fsDetails.get("SCHEDULE_ID"));
                }
                message = rb.getString("adap.FileServerHandler.Successfully_configured_File_Server");
            }
            if (isFileServer) {
                AudFileMonitorCriteriaHandler.addFileServersShares((String)fsDetails.get("domainName"), (String)fsDetails.get("serverName"), (ArrayList)fsDetails.get("LOCATIONS"));
            } else {
                AudFileMonitorCriteriaHandler.addFileServersShares(fsDetails);
            }
            if (isSACL.booleanValue()) {
                new ModifySaclThread(fsDetails);
            } else {
                saclMsg = rb.getString("adap.ConfiguredFileServerAction.note_sacl_permissions");
            }
            if ((String)fsDetails.get("MESSAGE") != null) {
                message = (String)fsDetails.get("MESSAGE");
            }
            logger.log(Level.INFO, "Adding FS : " + fsDetails);
            FileServerHandler.addFileUpdateDetails(fsDetails, false);
            auditPolicyMsg = isAuditPolicy.booleanValue() ? ((gpoStatus = GpoHandler.createGpoAndApplySecurityFilter((String)fsDetails.get("domainName"), null, guidArray, 4)) != null ? "&nbsp;Note:&nbsp;" + gpoStatus : "&nbsp;Note:&nbsp;" + rb.getString("adap.GPOHandler.Error_while_enabling_audit_policy_via_GPO")) : rb.getString("adap.FileServerHandler.object_access_policy");
            if (!isSACL.booleanValue() && !isAuditPolicy.booleanValue()) {
                message = message + rb.getString("adap.FileServerHandler.Object_Access_policy_and_auditing_permissions");
                msgType = "info";
            } else {
                if (!isSACL.booleanValue()) {
                    message = message + saclMsg;
                    msgType = "info";
                }
                if ((message = message + auditPolicyMsg).contains("error") || message.contains("Error")) {
                    msgType = "failure";
                }
            }
            EventDataUtil.getComputerDetails(null, null);
        }
        catch (Exception ex) {
            message = ex.getMessage();
            msgType = "failure";
            ex.printStackTrace();
        }
        retMap.put("msgTxt", message);
        retMap.put("msgType", msgType);
        MSHandler.synchronizeNow("File Server add", true);
        return retMap;
    }
}

