/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.fileaudit;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.delegation.AuditDelegationUtil;
import com.adventnet.sym.adsm.auditing.server.fileaudit.FileServerHandler;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ModifySaclThread
extends Thread {
    private Hashtable fsDetails = null;
    private static Hashtable<String, Integer> shareSACLStatus = new Hashtable();
    private static Logger logger = Logger.getLogger("EventLogger");

    public ModifySaclThread(Hashtable fsDetails) {
        this.fsDetails = fsDetails;
        this.start();
    }

    @Override
    public void run() {
        try {
            this.setSACLForShares();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isNetAppFiler(String serverName) {
        boolean isNetAppFiler = false;
        String query = "SELECT COUNT(*) FROM AUDComputerEventRead JOIN ADSMComputerGeneralDetails on AUDComputerEventRead.OBJECT_GUID = ADSMComputerGeneralDetails.OBJECT_GUID WHERE ADSMComputerGeneralDetails.NAME='" + serverName + "' AND (AUDComputerEventRead.MACHINE_TYPE&256=256 OR AUDComputerEventRead.MACHINE_TYPE&512=512)";
        if (QueryUtil.getRowsCount(query) > 0) {
            isNetAppFiler = true;
        }
        return isNetAppFiler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSACLForShares() throws Exception {
        ArrayList shareLocationList = (ArrayList)this.fsDetails.get("LOCATIONS");
        LinkedList tmpLinkedList = new LinkedList(shareLocationList);
        try {
            Hashtable<String, Integer> hashtable = shareSACLStatus;
            synchronized (hashtable) {
                Iterator iter = tmpLinkedList.iterator();
                while (iter.hasNext()) {
                    String uncName = (String)iter.next();
                    if (shareSACLStatus.get(uncName) == null) {
                        shareSACLStatus.put(uncName, 1);
                        continue;
                    }
                    Integer state = shareSACLStatus.get(uncName);
                    if (state == 1) {
                        iter.remove();
                        continue;
                    }
                    shareSACLStatus.put(uncName, 1);
                }
            }
            shareLocationList.clear();
            shareLocationList.addAll(tmpLinkedList);
            this.fsDetails.put("LOCATIONS", shareLocationList);
            if (shareLocationList.size() > 0) {
                FileServerHandler.getShareNames(this.fsDetails);
                Cloneable shareNameList = new ArrayList();
                shareNameList = (ArrayList)this.fsDetails.get("SHARE_NAMES");
                DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"AUDShareSaclDetails"));
                Column column = Column.getColumn((String)"AUDShareSaclDetails", (String)"*");
                query.addSelectColumn(column);
                Criteria criteria = new Criteria(Column.getColumn((String)"AUDShareSaclDetails", (String)"HOST_COMPUTER"), (Object)((String)this.fsDetails.get("serverName")), 0);
                Criteria criteria1 = new Criteria(Column.getColumn((String)"AUDShareSaclDetails", (String)"SHARE_NAME"), (Object)((ArrayList)this.fsDetails.get("SHARE_NAMES")).toArray(new Object[((ArrayList)this.fsDetails.get("SHARE_NAMES")).size()]), 8);
                Criteria criteria2 = new Criteria(Column.getColumn((String)"AUDShareSaclDetails", (String)"SACL_STATUS"), (Object)0L, 0);
                Criteria criteria3 = new Criteria(Column.getColumn((String)"AUDShareSaclDetails", (String)"DOMAIN_NAME"), (Object)((String)this.fsDetails.get("domainName")), 0);
                criteria = criteria.and(criteria1);
                criteria = criteria.and(criteria2);
                criteria = criteria.and(criteria3);
                query.setCriteria(criteria);
                dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
                if (!dataObj.isEmpty()) {
                    Iterator iterator = dataObj.getRows("AUDShareSaclDetails");
                    while (iterator.hasNext()) {
                        Row shareRow = (Row)iterator.next();
                        String shareName = (String)shareRow.get("SHARE_NAME");
                        String uncName = (String)shareRow.get("LOCATION");
                        if (!((ArrayList)shareNameList).contains(shareName)) continue;
                        ((ArrayList)shareNameList).remove(shareName);
                    }
                }
                ArrayList<String> tmpList = new ArrayList<String>();
                for (int size = 0; size < ((ArrayList)shareNameList).size(); ++size) {
                    tmpList.add(((String)((ArrayList)shareNameList).get(size)).replaceAll("''", "'"));
                }
                shareNameList = tmpList;
                if (((ArrayList)shareNameList).size() > 0) {
                    if (this.fsDetails.get("MACHINE_TYPE") == null) {
                        logger.log(Level.INFO, "Machine Type is null:" + (String)this.fsDetails.get("serverName"));
                        boolean isNetApp = ModifySaclThread.isNetAppFiler((String)this.fsDetails.get("serverName"));
                        if (isNetApp) {
                            this.fsDetails.put("MACHINE_TYPE", 256);
                        } else {
                            this.fsDetails.put("MACHINE_TYPE", 4);
                        }
                    }
                    logger.log(Level.INFO, "Server:" + (String)this.fsDetails.get("serverName"));
                    Integer machineType = (Integer)this.fsDetails.get("MACHINE_TYPE");
                    logger.log(Level.INFO, "MachineType:" + machineType);
                    ArrayList aceList = AuditDelegationUtil.getAccessControlEntries(machineType);
                    logger.log(Level.INFO, "aceList :" + aceList);
                    if (aceList.size() > 0) {
                        ADHandler.setSAClForObject((String)this.fsDetails.get("domainName"), (ArrayList)shareNameList, aceList, (String)this.fsDetails.get("serverName"));
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            Hashtable<String, Integer> hashtable = shareSACLStatus;
            synchronized (hashtable) {
                for (int i = 0; i < shareLocationList.size(); ++i) {
                    String uncName = (String)shareLocationList.get(i);
                    shareSACLStatus.remove(uncName);
                }
            }
        }
        logger.log(Level.INFO, "*****Leaving setSACLForShares *******");
    }
}

