/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.fileaudit.cluster;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.config.ServerConfigAPI;
import com.adventnet.sym.adsm.auditing.server.delegation.AuditDelegationUtil;
import com.adventnet.sym.adsm.auditing.server.delegation.GpoHandler;
import com.adventnet.sym.adsm.auditing.server.fileaudit.FileServerHandler;
import com.adventnet.sym.adsm.auditing.server.fileaudit.ModifySaclThread;
import com.adventnet.sym.adsm.auditing.server.fileaudit.cluster.ClusterMonitorCriteria;
import com.adventnet.sym.adsm.auditing.server.fileaudit.cluster.ClusterUtil;
import com.adventnet.sym.adsm.auditing.server.monitor.AudFileMonitorCriteriaHandler;
import com.adventnet.sym.adsm.auditing.server.util.EventDataUtil;
import com.adventnet.sym.adsm.auditing.server.util.EventSchedulerUtil;
import com.adventnet.sym.adsm.common.server.MSHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import com.adventnet.sym.adsm.common.server.util.SchedulerUtil;
import com.adventnet.taskengine.util.PersistenceUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClusterHandler {
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private static Logger logger = Logger.getLogger("ReportLogger");
    public static final String CLUSTER_TABLE_NAME = "AUDClusterDetails";
    public static final String CLUSTER_NODE_TABLE_NAME = "AUDClusterNodeDetails";
    public static final String CLUSTER_CAP_TABLE_NAME = "AUDClusterCAPDetails";
    public static final String CLUSTER_CONFIG_TABLE_NAME = "AUDClusterConfiguration";
    public static final String CLUSTER_CAP_CONFIG_TABLE_NAME = "AUDClusterCAPConfiguration";
    public static final String CLUSTER_NODE_CONFIG_TABLE_NAME = "AUDClusterNodeConfiguration";

    public static void addCluster(String domainName, String clusterName, Long clusterId) throws Exception {
        DataObject clusterNameDO = null;
        clusterNameDO = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
        Row clusterNameRow = new Row(CLUSTER_CONFIG_TABLE_NAME);
        clusterNameRow.set("CLUSTER_ID", (Object)clusterId);
        clusterNameRow.set("MESSAGE", (Object)"success");
        clusterNameDO.addRow(clusterNameRow);
        CommonUtil.getPersistence(new boolean[0]).add(clusterNameDO);
    }

    public static String addClusterResources(String domainName, Long clusterId, String clusterResourceName, ArrayList fileShares, String isSacl) {
        String msg = null;
        try {
            Hashtable<String, Object> capDetails = new Hashtable<String, Object>();
            Boolean caseSensitivity = false;
            Criteria crit = new Criteria(Column.getColumn((String)CLUSTER_CAP_CONFIG_TABLE_NAME, (String)"CLUSTER_ID"), (Object)clusterId, 0, caseSensitivity.booleanValue());
            Criteria criteria = crit.and(new Criteria(Column.getColumn((String)CLUSTER_CAP_CONFIG_TABLE_NAME, (String)"CLUSTER_CAP_NAME"), (Object)clusterResourceName, 0, caseSensitivity.booleanValue()));
            DataObject clusterNameDO = CommonUtil.getPersistence(new boolean[0]).get(CLUSTER_CAP_CONFIG_TABLE_NAME, criteria);
            Row clusterNameRow = null;
            if (clusterNameDO.isEmpty()) {
                clusterNameDO = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                clusterNameRow = new Row(CLUSTER_CAP_CONFIG_TABLE_NAME);
                clusterNameRow.set("CLUSTER_ID", (Object)clusterId);
                clusterNameRow.set("CLUSTER_CAP_NAME", (Object)clusterResourceName);
                clusterNameRow.set("MESSAGE", (Object)"success");
                clusterNameDO.addRow(clusterNameRow);
                CommonUtil.getPersistence(new boolean[0]).add(clusterNameDO);
                capDetails.put("domainName", domainName);
                capDetails.put("serverName", clusterResourceName);
                capDetails.put("LOCATIONS", fileShares);
                AudFileMonitorCriteriaHandler.addFileServersShares(capDetails);
                FileServerHandler.addFileUpdateDetails(capDetails, true);
                msg = rb.getString("adap.ClusterHandler.Successfully_configured_cluster_CAP_and_cluster_share");
            } else {
                ArrayList<String> conShareList = FileServerHandler.getConfiguredShares(clusterResourceName, domainName);
                for (int i = 0; i < conShareList.size(); ++i) {
                    if (!fileShares.contains(conShareList.get(i))) continue;
                    fileShares.remove(conShareList.get(i));
                }
                capDetails.put("domainName", domainName);
                capDetails.put("serverName", clusterResourceName);
                capDetails.put("LOCATIONS", fileShares);
                capDetails.put("MACHINE_TYPE", 64);
                if (fileShares.size() > 0) {
                    AudFileMonitorCriteriaHandler.addFileServersShares(domainName, clusterResourceName, fileShares);
                    FileServerHandler.addFileUpdateDetails(capDetails, true);
                    msg = rb.getString("adap.ClusterHandler.The_CAP_is_configured_already_so_cluster_share_is_added_successfully");
                } else {
                    msg = rb.getString("adap.ClusterHandler.The_CAP_and_selected_cluster_share_is_already_configured_successfully");
                }
            }
            if (fileShares.size() > 0 && isSacl != null && isSacl.equals("true")) {
                new ModifySaclThread(capDetails);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return msg;
    }

    public static String addClusterNodes(String domainName, Long clusterId, ArrayList nodes) {
        String msg = "";
        try {
            for (int i = 0; i < nodes.size(); ++i) {
                Hashtable nodeDetails = new Hashtable();
                Hashtable nodeTable = (Hashtable)nodes.get(i);
                String objectGuid = (String)nodeTable.get("OBJECT_GUID");
                String nodeName = (String)nodeTable.get("NODE_NAME");
                Criteria crit = new Criteria(Column.getColumn((String)CLUSTER_NODE_CONFIG_TABLE_NAME, (String)"CLUSTER_ID"), (Object)clusterId, 0);
                Criteria criteria = crit.and(new Criteria(Column.getColumn((String)CLUSTER_NODE_CONFIG_TABLE_NAME, (String)"OBJECT_GUID"), (Object)objectGuid, 0));
                DataObject clusterNameDO = CommonUtil.getPersistence(new boolean[0]).get(CLUSTER_NODE_CONFIG_TABLE_NAME, criteria);
                Row clusterNameRow = null;
                if (clusterNameDO.isEmpty()) {
                    clusterNameDO = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                    clusterNameRow = new Row(CLUSTER_NODE_CONFIG_TABLE_NAME);
                    clusterNameRow.set("CLUSTER_ID", (Object)clusterId);
                    clusterNameRow.set("CLUSTER_NODE_NAME", (Object)nodeName);
                    clusterNameRow.set("OBJECT_GUID", (Object)objectGuid);
                    clusterNameRow.set("MESSAGE", (Object)"success");
                    clusterNameDO.addRow(clusterNameRow);
                    CommonUtil.getPersistence(new boolean[0]).add(clusterNameDO);
                    msg = rb.getString("adap.ClusterHandler.Successfully_configured_cluster_node");
                    continue;
                }
                msg = rb.getString("adap.ClusterHandler.The_Cluster_node_already_configured");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return msg;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String addClusterConfig(String domainName, String clusterName, Long clusterId, ArrayList clusterNodes, String clusterResourceName, ArrayList fileShares, String operation, String isSacl, String isGpo) throws Exception {
        String msg = "";
        try {
            if (clusterId == null || clusterId.equals("") || clusterName == null || clusterName.equals("") || domainName == null || domainName.equals("")) throw new Exception(rb.getString("adap.ClusterHandler.Error_occured_while_adding_cluster"));
            if (operation.equals("addnew") || operation.equals("new")) {
                boolean status = ClusterUtil.isClusterConfigured(domainName, clusterName, clusterId);
                if (status) throw new Exception(rb.getString("adap.ClusterHandler.The_Cluster_is_already_configured"));
                ClusterHandler.addCluster(domainName, clusterName, clusterId);
                msg = ClusterHandler.addClusterNodes(domainName, clusterId, clusterNodes);
                msg = ClusterHandler.addClusterNodes(domainName, clusterNodes, isGpo);
                ClusterHandler.addClusterResources(domainName, clusterId, clusterResourceName, fileShares, isSacl);
            } else if (operation.equals("addNode") || operation.equals("addnode")) {
                msg = ClusterHandler.addClusterNodes(domainName, clusterId, clusterNodes);
                msg = ClusterHandler.addClusterNodes(domainName, clusterNodes, isGpo);
            } else if (operation.equals("addCap") || operation.equals("addcap")) {
                msg = ClusterHandler.addClusterResources(domainName, clusterId, clusterResourceName, fileShares, isSacl);
            } else if (operation.equals("addShare") || operation.equals("addshare")) {
                Hashtable<String, Object> capDetails = new Hashtable<String, Object>();
                capDetails.put("domainName", domainName);
                capDetails.put("serverName", clusterResourceName);
                capDetails.put("LOCATIONS", fileShares);
                capDetails.put("MACHINE_TYPE", 64);
                AudFileMonitorCriteriaHandler.addFileServersShares(domainName, clusterResourceName, fileShares);
                if (isSacl != null && isSacl.equals("true")) {
                    new ModifySaclThread(capDetails);
                }
                FileServerHandler.addFileUpdateDetails(capDetails, true);
                msg = rb.getString("adap.ClusterHandler.Successfully_configured_cluster_file_Shares");
            }
            ClusterMonitorCriteria.getInstance().setConfiguredClusters();
            return msg;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static String addClusterNodes(String domainName, ArrayList nodeList, String isGpo) {
        String message = "";
        try {
            ArrayList<String> nodeGuids = new ArrayList<String>();
            for (int i = 0; i < nodeList.size(); ++i) {
                Hashtable<String, String> nodeDetails = new Hashtable<String, String>();
                Hashtable nodeTable = (Hashtable)nodeList.get(i);
                String objectGuid = (String)nodeTable.get("OBJECT_GUID");
                String nodeName = (String)nodeTable.get("NODE_NAME");
                nodeDetails.put("OBJECT_GUID", objectGuid);
                nodeDetails.put("serverName", nodeName);
                nodeDetails.put("domainName", domainName);
                nodeGuids.add(objectGuid);
                DataObject computerObj = null;
                boolean isMemberServer = ServerConfigAPI.isConfiguredMemberServer(objectGuid);
                boolean isFileServer = ServerConfigAPI.isConfiguredFileServer(objectGuid);
                boolean isClusterServer = ServerConfigAPI.isConfiguredClusterServer(objectGuid);
                boolean isEvntCollector = ServerConfigAPI.isConfiguredEvntCollector(objectGuid);
                Criteria criteria = new Criteria(Column.getColumn((String)"AUDComputerEventRead", (String)"OBJECT_GUID"), (Object)objectGuid, 0);
                computerObj = CommonUtil.getPersistence(new boolean[0]).get("AUDComputerEventRead", criteria);
                if (isClusterServer) {
                    logger.log(Level.INFO, "The cluster node(s) is already configured");
                    message = rb.getString("adap.ClusterHandler.The_Cluster_node_already_configured");
                    continue;
                }
                if (isFileServer) {
                    Row nodeRow = computerObj.getRow(MSHandler.tableMSName);
                    int machineType = (Integer)nodeRow.get("MACHINE_TYPE");
                    machineType = (machineType & 4) == 4 ? (machineType |= 0x40) : ((machineType & 8) == 8 ? (machineType |= 0x80) : 128);
                    nodeRow.set("MACHINE_TYPE", (Object)machineType);
                    computerObj.updateRow(nodeRow);
                    CommonUtil.getPersistence(new boolean[0]).update(computerObj);
                    message = rb.getString("adap.ClusterHandler.Successfully_configured_cluster_node");
                    continue;
                }
                if (isMemberServer || isEvntCollector) {
                    Row row = computerObj.getRow("AUDComputerEventRead");
                    Long instanceId = (Long)row.get("INSTANCE_ID");
                    Row nodeRow = FileServerHandler.getFileServerRow(computerObj, nodeDetails, new Integer(64));
                    computerObj.updateRow(nodeRow);
                    CommonUtil.getPersistence(new boolean[0]).update(computerObj);
                    int fsMachineType = (Integer)nodeRow.get("MACHINE_TYPE");
                    if ((fsMachineType & 0x40) == 64) {
                        FileServerHandler.runEventScheduler((Long)nodeDetails.get("SCHEDULE_ID"));
                    }
                    MSHandler.removeTaskInstanceID(instanceId, new boolean[0]);
                    message = rb.getString("adap.ClusterHandler.Successfully_configured_cluster_node");
                    continue;
                }
                if (computerObj == null || computerObj.isEmpty()) {
                    DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                    Row nodeRow = FileServerHandler.getFileServerRow(dataObj, nodeDetails, 64);
                    dataObj.addRow(nodeRow);
                    CommonUtil.getPersistence(new boolean[0]).add(dataObj);
                    int fsMachineType = (Integer)nodeRow.get("MACHINE_TYPE");
                    if ((fsMachineType & 0x40) == 64) {
                        FileServerHandler.runEventScheduler((Long)nodeDetails.get("SCHEDULE_ID"));
                    }
                    message = rb.getString("adap.ClusterHandler.Successfully_configured_cluster_node");
                    continue;
                }
                Row fsRow = FileServerHandler.getFileServerRow(computerObj, nodeDetails, 64);
                computerObj.updateRow(fsRow);
                CommonUtil.getPersistence(new boolean[0]).update(computerObj);
                int fsMachineType = (Integer)fsRow.get("MACHINE_TYPE");
                if ((fsMachineType & 0x40) == 64) {
                    FileServerHandler.runEventScheduler((Long)nodeDetails.get("SCHEDULE_ID"));
                }
                message = rb.getString("adap.FileServerHandler.Successfully_configured_File_Server");
            }
            if (isGpo != null && isGpo.equals("true")) {
                String gpoStatus = GpoHandler.createGpoAndApplySecurityFilter(domainName, null, nodeGuids.toArray(new String[nodeGuids.size()]), 64);
                if (gpoStatus != null) {
                    message = gpoStatus.equalsIgnoreCase("Configuring audit policy for remote domain is currently not supported") ? message + rb.getString("adap.ClusterHandler.Configuring_audit_policy_for_remote_domain_is_currently_not_supported") : message + "," + gpoStatus;
                }
            } else {
                message = message + rb.getString("adap.ClusterHandler.Object_Access_policy_and_auditing_permissions");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            message = ex.getMessage();
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getConfiguredClusterNodes(Long clusterId, Long clusterNodeId, String clusterNodeName, String objectGuid) throws Exception {
        int[] machineTypes = new int[]{64, 128};
        String query = ClusterUtil.buildClusterQuery(objectGuid, machineTypes);
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        Properties nodeProps = null;
        try {
            connection = RelationalAPI.getInstance().getConnection();
            statement = connection.createStatement();
            resultSet = QueryUtil.executeQuery("Getting Configured Servers", statement, query);
            while (resultSet.next()) {
                nodeProps = new Properties();
                nodeProps.put("COMPUTER_NAME", clusterNodeName);
                nodeProps.put("CLUSTER_ID", clusterId);
                nodeProps.put("CLUSTER_NODE_ID", clusterNodeId);
                nodeProps.put("COMPUTER_ID", (Object)resultSet.getLong("COMPUTER_ID"));
                nodeProps.put("TIME_READ", (Object)resultSet.getLong("TIME_READ"));
                nodeProps.put("TIME_PERIOD", (Object)resultSet.getLong("TIME_PERIOD"));
                nodeProps.put("RECENT_EVENT_TIME", (Object)resultSet.getLong("RECENT_EVENT_TIME"));
                nodeProps.put("SCHEDULE_ID", (Object)resultSet.getLong("SCHEDULE_ID"));
                nodeProps.put("OBJECT_GUID", resultSet.getString("OBJECT_GUID"));
                String msg = resultSet.getString("MESSAGE");
                if (msg == null) {
                    msg = "-";
                }
                nodeProps.put("MESSAGE", msg);
                int machineType = resultSet.getInt("MACHINE_TYPE");
                nodeProps.put("MACHINE_TYPE", (Object)machineType);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Properties properties = null;
            return properties;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException se) {}
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException se) {}
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {}
        }
        return nodeProps;
    }

    public static ArrayList getConfiguredClusters(String domainName) throws Exception {
        ArrayList<Properties> ret = new ArrayList<Properties>();
        try {
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)CLUSTER_CONFIG_TABLE_NAME));
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            Join clusterConfigJoin = new Join(CLUSTER_CONFIG_TABLE_NAME, CLUSTER_TABLE_NAME, new String[]{"CLUSTER_ID"}, new String[]{"CLUSTER_ID"}, 2);
            query.addJoin(clusterConfigJoin);
            Criteria cri = new Criteria(Column.getColumn((String)CLUSTER_TABLE_NAME, (String)"DOMAIN_NAME"), (Object)domainName, 0);
            query.setCriteria(cri);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            Iterator it = dataObject.getRows(CLUSTER_TABLE_NAME);
            while (it.hasNext()) {
                Row r = (Row)it.next();
                String clusterName = (String)r.get("CLUSTER_NAME");
                String domainNameCluster = (String)r.get("DOMAIN_NAME");
                Long clusterId = (Long)r.get("CLUSTER_ID");
                Properties p = new Properties();
                p.put("CLUSTER_NAME", clusterName);
                p.put("DOMAIN_NAME", domainNameCluster);
                p.put("CLUSTER_ID", clusterId);
                Criteria cri2 = new Criteria(Column.getColumn((String)CLUSTER_CAP_CONFIG_TABLE_NAME, (String)"CLUSTER_ID"), (Object)clusterId, 0);
                ArrayList<Properties> clusterCaps = new ArrayList<Properties>();
                DataObject capDataObj = CommonUtil.getPersistence(new boolean[0]).get(CLUSTER_CAP_CONFIG_TABLE_NAME, cri2);
                Iterator ite = capDataObj.getRows(CLUSTER_CAP_CONFIG_TABLE_NAME, cri2);
                while (ite.hasNext()) {
                    Row rw = (Row)ite.next();
                    Long clusterConfigId = (Long)rw.get("CLUSTER_CAP_CONFIG_ID");
                    Long clusterIdCap = (Long)rw.get("CLUSTER_ID");
                    String clusterCapName = (String)rw.get("CLUSTER_CAP_NAME");
                    Properties capProps = new Properties();
                    capProps.put("CLUSTER_CAP_CONFIG_ID", clusterConfigId);
                    capProps.put("CLUSTER_CAP_NAME", clusterCapName);
                    ArrayList shareList = FileServerHandler.getConfiguredShares(clusterCapName, domainName);
                    shareList = AuditDelegationUtil.getShareSACLStatus(clusterCapName, domainName, shareList);
                    if (shareList != null) {
                        capProps.put("SHARE_LIST", shareList);
                    }
                    clusterCaps.add(capProps);
                }
                p.put("CLUSTER_CAPS", clusterCaps);
                Criteria cri3 = new Criteria(Column.getColumn((String)CLUSTER_NODE_CONFIG_TABLE_NAME, (String)"CLUSTER_ID"), (Object)clusterId, 0);
                ArrayList<Properties> clusterNodes = new ArrayList<Properties>();
                DataObject nodeDataObj = CommonUtil.getPersistence(new boolean[0]).get(CLUSTER_NODE_CONFIG_TABLE_NAME, cri3);
                Iterator iter = nodeDataObj.getRows(CLUSTER_NODE_CONFIG_TABLE_NAME, cri3);
                while (iter.hasNext()) {
                    String nodeGuid;
                    String clusterNodeName;
                    Row row = (Row)iter.next();
                    Long clusterNodeId = (Long)row.get("CLUSTER_NODE_CONFIG_ID");
                    Long clusterIdNode = (Long)row.get("CLUSTER_ID");
                    Properties nodeProps = ClusterHandler.getConfiguredClusterNodes(clusterIdNode, clusterNodeId, clusterNodeName = (String)row.get("CLUSTER_NODE_NAME"), nodeGuid = (String)row.get("OBJECT_GUID"));
                    if (nodeProps == null) continue;
                    clusterNodes.add(nodeProps);
                }
                p.put("CLUSTER_NODES", clusterNodes);
                ret.add(p);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return ret;
    }

    public static String updateClusterNodes(String domainName, String clusterName, Long clusterId, ArrayList msIDs, String action, String timePeriodText) throws Exception {
        String message = "Error while updating cluster node(s)";
        Criteria criteria = null;
        Long[] id = null;
        if (msIDs != null) {
            id = new Long[msIDs.size()];
            for (int i = 0; i < id.length; ++i) {
                id[i] = (Long)msIDs.get(i);
            }
            criteria = new Criteria(Column.getColumn((String)"AUDComputerEventRead", (String)"COMPUTER_ID"), (Object)id, 8);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("AUDComputerEventRead", criteria);
            if (!dataObj.isEmpty()) {
                if (action.equalsIgnoreCase("Enable")) {
                    Integer licenseCount = MSHandler.getLicenseCount(4);
                    int enableCount = ServerConfigAPI.getConfiguredServerCount(new int[]{4, 64});
                    for (int i = 0; i < msIDs.size(); ++i) {
                        Criteria enableCrit = new Criteria(Column.getColumn((String)"AUDComputerEventRead", (String)"COMPUTER_ID"), msIDs.get(i), 0);
                        Row enableRow = dataObj.getRow("AUDComputerEventRead", enableCrit);
                        if (licenseCount > enableCount) {
                            int machineType = (Integer)enableRow.get("MACHINE_TYPE");
                            if ((machineType & 8) == 8) {
                                machineType |= 4;
                                machineType &= 0xFFFFFFF7;
                            }
                            machineType |= 0x40;
                            enableRow.set("MACHINE_TYPE", (Object)(machineType &= 0xFFFFFF7F));
                            message = rb.getString("adap.MSHandler.Successfully_enabled");
                            dataObj.updateRow(enableRow);
                            ++enableCount;
                            CommonUtil.getPersistence(new boolean[0]).update(dataObj);
                            EventSchedulerUtil.enableDisableScheduler((Long)enableRow.get("SCHEDULE_ID"), "Enable");
                            continue;
                        }
                        message = licenseCount > 0 ? rb.handleGetObject("adap.ClusterHandler.License_Level_Exceed_You_can_enable_only_limited_Cluster_Nodes", new String[]{licenseCount.toString()}) : rb.getString("adap.LicenseUpgradeAction.You_are_using__licenseType");
                    }
                } else if (action.equalsIgnoreCase("Disable")) {
                    Iterator iter = dataObj.getRows("AUDComputerEventRead");
                    while (iter.hasNext()) {
                        Row row = (Row)iter.next();
                        int machineType = (Integer)row.get("MACHINE_TYPE");
                        if ((machineType & 4) == 4) {
                            machineType |= 8;
                            machineType &= 0xFFFFFFFB;
                        }
                        machineType |= 0x80;
                        row.set("MACHINE_TYPE", (Object)(machineType &= 0xFFFFFFBF));
                        dataObj.updateRow(row);
                        if ((machineType & 0x10) == 16 || (machineType & 0x400) == 1024) continue;
                        EventSchedulerUtil.enableDisableScheduler((Long)row.get("SCHEDULE_ID"), "Disable");
                    }
                    CommonUtil.getPersistence(new boolean[0]).update(dataObj);
                    message = rb.getString("adap.MSHandler.Successfully_Disabled");
                } else if (action.equalsIgnoreCase("Delete")) {
                    ArrayList<String> objectGuids = new ArrayList<String>();
                    ArrayList<Long> deletedSchedule = new ArrayList<Long>();
                    boolean isUpdate = false;
                    Iterator iter = dataObj.getRows("AUDComputerEventRead");
                    while (iter.hasNext()) {
                        Row row = (Row)iter.next();
                        int machineType = (Integer)row.get("MACHINE_TYPE");
                        machineType &= 0xFFFFFFBF;
                        if (((machineType &= 0xFFFFFF7F) & 4) == 4 || (machineType & 8) == 8) {
                            isUpdate = true;
                            row.set("MACHINE_TYPE", (Object)machineType);
                            dataObj.updateRow(row);
                            continue;
                        }
                        if ((machineType & 0x10) == 16 || (machineType & 0x20) == 32 || (machineType & 0x400) == 1024 || (machineType & 0x800) == 2048) {
                            deletedSchedule.add((Long)row.get("SCHEDULE_ID"));
                            isUpdate = true;
                            Row taskInputRow = MSHandler.addTaskInstanceID(DBObjectUtil.getUVHValues("Schedule", "Schedule:schedule_id:UVH@3484"), System.currentTimeMillis(), PersistenceUtil.getPoolID((String)"MemberServerThreadPool"));
                            dataObj.addRow(taskInputRow);
                            row.set("MACHINE_TYPE", (Object)machineType);
                            row.set("SCHEDULE_ID", (Object)DBObjectUtil.getUVHValues("Schedule", "Schedule:schedule_id:UVH@3484"));
                            row.set("INSTANCE_ID", taskInputRow.get("INSTANCE_ID"));
                            dataObj.updateRow(row);
                            continue;
                        }
                        objectGuids.add((String)row.get("OBJECT_GUID"));
                        deletedSchedule.add((Long)row.get("SCHEDULE_ID"));
                    }
                    if (isUpdate) {
                        CommonUtil.getPersistence(new boolean[0]).update(dataObj);
                    }
                    Criteria scheduleCrit = new Criteria(Column.getColumn((String)"Schedule", (String)"SCHEDULE_ID"), (Object)deletedSchedule.toArray(new Long[deletedSchedule.size()]), 8);
                    CommonUtil.getPersistenceLite().delete(scheduleCrit);
                    ClusterHandler.deleteConfiguredClusterNodes(clusterId, objectGuids);
                    GpoHandler.removeSecurityFilter(domainName, "ADAuditPlusPolicy", objectGuids.toArray(new String[objectGuids.size()]));
                    ClusterMonitorCriteria.getInstance().setConfiguredClusters();
                    message = rb.getString("adap.MSHandler.Successfully_deleted");
                } else if (action.equalsIgnoreCase("timePeriodChange")) {
                    Long timePeriod = Long.parseLong(timePeriodText);
                    ArrayList<Long> schedule_id = new ArrayList<Long>();
                    Iterator iter = dataObj.getRows("AUDComputerEventRead");
                    while (iter.hasNext()) {
                        Row row = (Row)iter.next();
                        row.set("TIME_PERIOD", (Object)timePeriod);
                        dataObj.updateRow(row);
                        schedule_id.add((Long)row.get("SCHEDULE_ID"));
                    }
                    CommonUtil.getPersistence(new boolean[0]).update(dataObj);
                    message = rb.getString("adap.MSHandler.Successfully_Changed_the_Event_Fetch");
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("TIME_PERIOD", timePeriod);
                    map.put("UNIT_OF_TIME", "Minutes");
                    map.put("SCHEDULE_ID", schedule_id.toArray(new Long[schedule_id.size()]));
                    SchedulerUtil.updatePeriodicScheduler(map);
                }
            } else {
                message = "Data Object is empty";
            }
        }
        EventDataUtil.getComputerDetails(null, null);
        return message;
    }

    public static String updateClusterResources(String domainName, String clusterName, ArrayList capIds, String action) throws Exception {
        String message = "Error while updating cluster cap(s)";
        Criteria criteria = null;
        Long[] id = null;
        if (capIds != null) {
            id = new Long[capIds.size()];
            for (int i = 0; i < id.length; ++i) {
                id[i] = (Long)capIds.get(i);
            }
            criteria = new Criteria(Column.getColumn((String)CLUSTER_CAP_CONFIG_TABLE_NAME, (String)"CLUSTER_CAP_CONFIG_ID"), (Object)id, 8);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(CLUSTER_CAP_CONFIG_TABLE_NAME, criteria);
            if (!dataObj.isEmpty()) {
                if (action.equalsIgnoreCase("Delete")) {
                    ArrayList<String> capNames = new ArrayList<String>();
                    Iterator iter = dataObj.getRows(CLUSTER_CAP_CONFIG_TABLE_NAME);
                    while (iter.hasNext()) {
                        Row row = (Row)iter.next();
                        capNames.add((String)row.get("CLUSTER_CAP_NAME"));
                        Criteria capCrit = new Criteria(Column.getColumn((String)CLUSTER_CAP_CONFIG_TABLE_NAME, (String)"CLUSTER_CAP_CONFIG_ID"), (Object)((Long)row.get("CLUSTER_CAP_CONFIG_ID")), 0);
                        CommonUtil.getPersistenceLite().delete(capCrit);
                        message = rb.getString("adap.ClusterHandler.Successfully_deleted_cluster_cap");
                    }
                    FileServerHandler.deleteSharesForServer(capNames.toArray(new String[capNames.size()]), domainName);
                    FileServerHandler.dropFileDetailsTable(capNames, domainName);
                    ClusterMonitorCriteria.getInstance().setConfiguredClusters();
                }
            } else {
                message = "DO is Empty";
            }
        }
        return message;
    }

    public static void deleteConfiguredClusterNodes(Long clusterId, ArrayList objectGuids) throws Exception {
        Criteria criteria = new Criteria(Column.getColumn((String)CLUSTER_NODE_CONFIG_TABLE_NAME, (String)"CLUSTER_ID"), (Object)clusterId, 0);
        criteria = criteria.and(new Criteria(Column.getColumn((String)CLUSTER_NODE_CONFIG_TABLE_NAME, (String)"OBJECT_GUID"), (Object)objectGuids.toArray(new String[objectGuids.size()]), 8));
        CommonUtil.getPersistenceLite().delete(criteria);
    }

    public static String deleteCluster(String domainName, String clusterName, String clusterId) throws Exception {
        String message = null;
        Criteria criteria = null;
        criteria = new Criteria(Column.getColumn((String)CLUSTER_TABLE_NAME, (String)"CLUSTER_ID"), (Object)clusterId, 0);
        DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(CLUSTER_TABLE_NAME, criteria);
        if (!dataObj.isEmpty()) {
            CommonUtil.getPersistenceLite().delete(criteria);
            message = rb.getString("adap.ClusterHandler.Successfully_deleted_cluster");
        } else {
            message = "DO is Empty";
        }
        return message;
    }

    public static void deleteClusterNodes(String domainName, String clusterName, Long clusterId) throws Exception {
        int[] machineTypes = new int[]{64, 128};
        String query = ClusterUtil.buildClusterDeleteQuery(domainName, clusterName, clusterId, machineTypes);
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        Object nodeProps = null;
        ArrayList<Long> deletedClusterNodes = new ArrayList<Long>();
        try {
            connection = RelationalAPI.getInstance().getConnection();
            statement = connection.createStatement();
            resultSet = QueryUtil.executeQuery("Getting Configured Servers", statement, query);
            while (resultSet.next()) {
                deletedClusterNodes.add(resultSet.getLong("COMPUTER_ID"));
            }
            ClusterHandler.updateClusterNodes(domainName, clusterName, clusterId, deletedClusterNodes, "Delete", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException se) {}
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException se) {}
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {}
        }
    }

    public static void deleteClusterResources(String domainName, String clusterName, Long clusterId) throws Exception {
        String message = "";
        Criteria criteria = new Criteria(Column.getColumn((String)CLUSTER_CAP_CONFIG_TABLE_NAME, (String)"CLUSTER_ID"), (Object)clusterId, 0);
        DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(CLUSTER_CAP_CONFIG_TABLE_NAME, criteria);
        if (!dataObj.isEmpty()) {
            ArrayList<String> capNames = new ArrayList<String>();
            Iterator iter = dataObj.getRows(CLUSTER_CAP_CONFIG_TABLE_NAME);
            while (iter.hasNext()) {
                Row row = (Row)iter.next();
                capNames.add((String)row.get("CLUSTER_CAP_NAME"));
                Criteria capCrit = new Criteria(Column.getColumn((String)CLUSTER_CAP_CONFIG_TABLE_NAME, (String)"CLUSTER_CAP_CONFIG_ID"), (Object)((Long)row.get("CLUSTER_CAP_CONFIG_ID")), 0);
                CommonUtil.getPersistenceLite().delete(capCrit);
                message = "Successfully deleted";
            }
            FileServerHandler.deleteSharesForServer(capNames.toArray(new String[capNames.size()]), domainName);
            FileServerHandler.dropFileDetailsTable(capNames, domainName);
        } else {
            message = "No ClusterResources are found";
        }
    }

    public static ArrayList getConfiguredClusterNodes(String domainName, String capName) {
        ArrayList<Properties> clusterNodes = null;
        try {
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)CLUSTER_CONFIG_TABLE_NAME));
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            Join clusterConfigJoin = new Join(CLUSTER_CONFIG_TABLE_NAME, CLUSTER_TABLE_NAME, new String[]{"CLUSTER_ID"}, new String[]{"CLUSTER_ID"}, 2);
            Join clusterCapConfigJoin = new Join(CLUSTER_CONFIG_TABLE_NAME, CLUSTER_CAP_CONFIG_TABLE_NAME, new String[]{"CLUSTER_ID"}, new String[]{"CLUSTER_ID"}, 2);
            Join clusterNodeJoin = new Join(CLUSTER_CONFIG_TABLE_NAME, CLUSTER_NODE_CONFIG_TABLE_NAME, new String[]{"CLUSTER_ID"}, new String[]{"CLUSTER_ID"}, 2);
            query.addJoin(clusterConfigJoin);
            query.addJoin(clusterCapConfigJoin);
            query.addJoin(clusterNodeJoin);
            Criteria cri = new Criteria(Column.getColumn((String)CLUSTER_TABLE_NAME, (String)"DOMAIN_NAME"), (Object)domainName, 0);
            Criteria cri1 = new Criteria(Column.getColumn((String)CLUSTER_CAP_CONFIG_TABLE_NAME, (String)"CLUSTER_CAP_NAME"), (Object)capName, 0);
            cri = cri.and(cri1);
            query.setCriteria(cri);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            Iterator it = dataObject.getRows(CLUSTER_NODE_CONFIG_TABLE_NAME);
            while (it.hasNext()) {
                String nodeGuid;
                String clusterNodeName;
                Row row = (Row)it.next();
                Long clusterNodeId = (Long)row.get("CLUSTER_NODE_CONFIG_ID");
                Long clusterIdNode = (Long)row.get("CLUSTER_ID");
                Properties nodeProps = ClusterHandler.getConfiguredClusterNodes(clusterIdNode, clusterNodeId, clusterNodeName = (String)row.get("CLUSTER_NODE_NAME"), nodeGuid = (String)row.get("OBJECT_GUID"));
                if (nodeProps == null) continue;
                if (clusterNodes == null) {
                    clusterNodes = new ArrayList<Properties>();
                }
                clusterNodes.add(nodeProps);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return clusterNodes;
    }
}

