/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.fileaudit.cluster;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.fileaudit.cluster.ClusterHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ClusterMonitorCriteria {
    private static Logger logger = Logger.getLogger("ReportLogger");
    private static ClusterMonitorCriteria filesHandler = null;
    private static HashMap<String, ArrayList<Properties>> domainCluster = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClusterMonitorCriteria getInstance() {
        if (filesHandler != null) return filesHandler;
        Class<ClusterMonitorCriteria> clazz = ClusterMonitorCriteria.class;
        synchronized (ClusterMonitorCriteria.class) {
            if (filesHandler != null) return filesHandler;
            filesHandler = new ClusterMonitorCriteria();
            // ** MonitorExit[var0] (shouldn't be in output)
            return filesHandler;
        }
    }

    private ClusterMonitorCriteria() {
        this.setConfiguredClusters();
    }

    public static HashMap<String, ArrayList<Properties>> getConfiguredClustersMap() {
        return domainCluster;
    }

    public void setConfiguredClusters() {
        try {
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"AUDClusterConfiguration"));
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            Join clusterConfigJoin = new Join("AUDClusterConfiguration", "AUDClusterDetails", new String[]{"CLUSTER_ID"}, new String[]{"CLUSTER_ID"}, 2);
            query.addJoin(clusterConfigJoin);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            domainCluster = new HashMap();
            Iterator it = dataObject.getRows("AUDClusterDetails");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                String domainName = (String)r.get("DOMAIN_NAME");
                Long clusterId = (Long)r.get("CLUSTER_ID");
                Properties p = new Properties();
                p.put("CLUSTER_NAME", (String)r.get("CLUSTER_NAME"));
                p.put("DOMAIN_NAME", domainName);
                p.put("CLUSTER_ID", clusterId);
                Criteria cri2 = new Criteria(Column.getColumn((String)"AUDClusterCAPConfiguration", (String)"CLUSTER_ID"), (Object)clusterId, 0);
                ArrayList<Properties> clusterCaps = new ArrayList<Properties>();
                DataObject capDataObj = CommonUtil.getPersistence(new boolean[0]).get("AUDClusterCAPConfiguration", cri2);
                Iterator ite = capDataObj.getRows("AUDClusterCAPConfiguration", cri2);
                while (ite.hasNext()) {
                    Row rw = (Row)ite.next();
                    String clusterCapName = (String)rw.get("CLUSTER_CAP_NAME");
                    Properties capProps = new Properties();
                    capProps.put("CLUSTER_CAP_CONFIG_ID", (Long)rw.get("CLUSTER_CAP_CONFIG_ID"));
                    capProps.put("CLUSTER_ID", (Long)rw.get("CLUSTER_ID"));
                    capProps.put("CLUSTER_CAP_NAME", clusterCapName.toLowerCase());
                    clusterCaps.add(capProps);
                }
                p.put("CLUSTER_CAPS", clusterCaps);
                Criteria cri3 = new Criteria(Column.getColumn((String)"AUDClusterNodeConfiguration", (String)"CLUSTER_ID"), (Object)clusterId, 0);
                ArrayList<Properties> clusterNodes = new ArrayList<Properties>();
                DataObject nodeDataObj = CommonUtil.getPersistence(new boolean[0]).get("AUDClusterNodeConfiguration", cri3);
                Iterator iter = nodeDataObj.getRows("AUDClusterNodeConfiguration", cri3);
                while (iter.hasNext()) {
                    Row row = (Row)iter.next();
                    Long clusterNodeId = (Long)row.get("CLUSTER_NODE_CONFIG_ID");
                    Long clusterIdNode = (Long)row.get("CLUSTER_ID");
                    String clusterNodeName = (String)row.get("CLUSTER_NODE_NAME");
                    String nodeGuid = (String)row.get("OBJECT_GUID");
                    Properties nodeProps = ClusterHandler.getConfiguredClusterNodes(clusterIdNode, clusterNodeId, clusterNodeName.toLowerCase(), nodeGuid);
                    if (nodeProps == null) continue;
                    clusterNodes.add(nodeProps);
                }
                p.put("CLUSTER_NODES", clusterNodes);
                ArrayList<Properties> arrayList = domainCluster.get(domainName);
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.add(p);
                domainCluster.put(domainName, arrayList);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        logger.log(Level.INFO, "Cluster Criteria changed:" + domainCluster);
    }

    public ArrayList<Properties> getClusterCaps(String eventDomainName, String eventNodeName) {
        ArrayList clusterCapList = null;
        ArrayList<Properties> clusterList = domainCluster.get(eventDomainName);
        if (clusterList != null) {
            for (int i = 0; i < clusterList.size(); ++i) {
                Boolean isFound = false;
                Properties p = clusterList.get(i);
                ArrayList clusterNodeList = (ArrayList)p.get("CLUSTER_NODES");
                for (int j = 0; j < clusterNodeList.size(); ++j) {
                    Properties nodeProps = (Properties)clusterNodeList.get(j);
                    String nodeName = (String)nodeProps.get("COMPUTER_NAME");
                    if (!eventNodeName.equals(nodeName)) continue;
                    isFound = true;
                    break;
                }
                if (!isFound.booleanValue()) continue;
                clusterCapList = (ArrayList)p.get("CLUSTER_CAPS");
                break;
            }
        } else {
            logger.log(Level.FINE, "No cluster For domain or error in setConfiguredClusters:" + eventDomainName);
        }
        return clusterCapList;
    }
}

