/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.fileaudit.cluster;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClusterUtil {
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private static Logger logger = Logger.getLogger("ReportLogger");

    public static boolean isClusterConfigured(String domainName, String clusterName, Long clusterId) throws Exception {
        boolean isConfigured = false;
        if (clusterId != null) {
            String query = "SELECT COUNT(*) FROM AUDClusterConfiguration WHERE CLUSTER_ID=" + clusterId;
            if (QueryUtil.getRowsCount(query) > 0) {
                isConfigured = true;
            }
        } else {
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"AUDClusterConfiguration"));
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            Join clusterConfigJoin = new Join("AUDClusterConfiguration", "AUDClusterDetails", new String[]{"CLUSTER_ID"}, new String[]{"CLUSTER_ID"}, 2);
            query.addJoin(clusterConfigJoin);
            Criteria cri = new Criteria(Column.getColumn((String)"AUDClusterDetails", (String)"DOMAIN_NAME"), (Object)domainName, 0);
            Criteria cri1 = new Criteria(Column.getColumn((String)"AUDClusterDetails", (String)"CLUSTER_NAME"), (Object)clusterName, 0);
            cri = cri.and(cri1);
            query.setCriteria(cri);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            if (dataObject.isEmpty()) {
                logger.log(Level.FINE, "No data found for ClusteName:" + clusterName + " of domainName:" + domainName);
                isConfigured = false;
            } else {
                isConfigured = true;
            }
        }
        return isConfigured;
    }

    public static String buildClusterQuery(String objectGuid, int[] machineTypes) {
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append("SELECT *");
        queryBuilder.append(" FROM AUDComputerEventRead WHERE");
        queryBuilder.append(" (");
        for (int i = 0; i < machineTypes.length; ++i) {
            if (i > 0) {
                queryBuilder.append(" OR ");
            }
            queryBuilder.append("AUDComputerEventRead.MACHINE_TYPE&");
            queryBuilder.append(machineTypes[i]);
            queryBuilder.append("=");
            queryBuilder.append(machineTypes[i]);
        }
        queryBuilder.append(") ");
        if (null != objectGuid) {
            queryBuilder.append(" AND (AUDComputerEventRead.OBJECT_GUID='");
            queryBuilder.append(objectGuid);
            queryBuilder.append("')");
        }
        return queryBuilder.toString();
    }

    public static boolean deleteClusterResourcesForCluster(String domainName, Long clusterId) throws Exception {
        boolean isDeleted = false;
        try {
            Criteria criteria1 = new Criteria(Column.getColumn((String)"AUDClusterCAPDetails", (String)"CLUSTER_ID"), (Object)clusterId, 0);
            CommonUtil.getPersistenceLite().delete(criteria1);
            isDeleted = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isDeleted;
    }

    public static boolean deleteClusterNodesForCluster(String domainName, Long clusterId) throws Exception {
        boolean isDeleted = false;
        try {
            Criteria criteria1 = new Criteria(Column.getColumn((String)"AUDClusterNodeDetails", (String)"CLUSTER_ID"), (Object)clusterId, 0);
            CommonUtil.getPersistenceLite().delete(criteria1);
            isDeleted = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isDeleted;
    }

    public static boolean isClusterCapConfigured(String domainName, String capName) {
        boolean isConfigured = false;
        String query = "SELECT COUNT(*) FROM AUDClusterConfiguration JOIN AUDClusterDetails on AUDClusterConfiguration.CLUSTER_ID = AUDClusterDetails.CLUSTER_ID JOIN AUDClusterCAPConfiguration on AUDClusterConfiguration.CLUSTER_ID = AUDClusterCAPConfiguration.CLUSTER_ID WHERE AUDClusterDetails.DOMAIN_NAME='" + domainName + "' AND AUDClusterCAPConfiguration.CLUSTER_CAP_NAME='" + capName + "'";
        if (QueryUtil.getRowsCount(query) > 0) {
            isConfigured = true;
        }
        return isConfigured;
    }

    public static String buildClusterDeleteQuery(String domainName, String clusterName, Long clusterId, int[] machineTypes) throws Exception {
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append("SELECT *");
        queryBuilder.append(" FROM AUDClusterNodeConfiguration JOIN AUDComputerEventRead ON AUDClusterNodeConfiguration.OBJECT_GUID = AUDComputerEventRead.OBJECT_GUID WHERE");
        queryBuilder.append("(");
        for (int i = 0; i < machineTypes.length; ++i) {
            if (i > 0) {
                queryBuilder.append(" OR ");
            }
            queryBuilder.append("AUDComputerEventRead.MACHINE_TYPE&");
            queryBuilder.append(machineTypes[i]);
            queryBuilder.append("=");
            queryBuilder.append(machineTypes[i]);
        }
        queryBuilder.append(")");
        if (null != clusterId) {
            queryBuilder.append(" AND (AUDClusterNodeConfiguration.CLUSTER_ID=");
            queryBuilder.append(clusterId);
            queryBuilder.append(")");
        }
        return queryBuilder.toString();
    }

    public static ArrayList getClusterInfo(String domainName, String clusterName, String clusterClass) throws Exception {
        StringBuilder wmiQuery = new StringBuilder();
        if (clusterClass.equals("MSCluster_Resource")) {
            wmiQuery.append("select * from MSCluster_Resource where Type='Network Name'");
        } else if (clusterClass.equals("MSCluster_Node")) {
            wmiQuery.append("Select * from MSCluster_Node");
        } else if (clusterClass.equals("MSCluster_Cluster")) {
            wmiQuery.append("select * from MSCluster_Cluster");
            wmiQuery.append(" where Name='");
            wmiQuery.append(clusterName);
            wmiQuery.append("'");
        }
        logger.log(Level.INFO, "Wmi Query for " + clusterClass + " of clusterName:" + clusterName + " is:" + wmiQuery);
        Properties domainDetails = DomainHandler.getConfiguredValues(domainName, 1L);
        String userName = null;
        String passwd = null;
        if (!domainDetails.getProperty("IS_AUTHENTICATION_REQUIRED").equalsIgnoreCase("false")) {
            logger.log(Level.INFO, "Inside setting username details..");
            userName = (String)domainDetails.get("USER_NAME");
            passwd = (String)domainDetails.get("PASSWORD");
        }
        String[] prop = new String[]{"Name", "Description", "PrivateProperties"};
        String tempDomainName = domainDetails.getProperty("DOMAIN_NAME");
        ArrayList clusterDetails = ADHandler.getWindowsDirectory(clusterName, domainName, userName, passwd, prop, wmiQuery.toString(), null, 0, 0);
        logger.log(Level.INFO, "WMI Return :" + clusterDetails);
        return clusterDetails;
    }

    public static Properties getNodeGuid(String domainName, String name) throws Exception {
        Properties nodeProps = null;
        Criteria criteria = new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"NAME"), (Object)name, 0);
        Criteria criteria1 = criteria.or(new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"DNS_NAME"), (Object)name, 0));
        Criteria criteria2 = criteria1.and(new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"DOMAIN_NAME"), (Object)domainName, 0));
        DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("ADSMComputerGeneralDetails", criteria2);
        if (dataObj.isEmpty()) {
            logger.log(Level.INFO, "No data found for  Name:" + name);
            return null;
        }
        nodeProps = new Properties();
        Row guidRow = dataObj.getRow("ADSMComputerGeneralDetails");
        nodeProps.setProperty("nodeName", (String)guidRow.get("NAME"));
        nodeProps.setProperty("nodeGuid", (String)guidRow.get("OBJECT_GUID"));
        nodeProps.setProperty("osName", (String)guidRow.get("OPERATING_SYSTEM"));
        return nodeProps;
    }

    public static synchronized Long addClusterDetails(String domainName, String clusterName, Properties clusterNameProps) throws Exception {
        Long clusterId = null;
        Boolean caseSensitivity = false;
        Criteria crit = new Criteria(Column.getColumn((String)"AUDClusterDetails", (String)"DOMAIN_NAME"), (Object)domainName, 0, caseSensitivity.booleanValue());
        Criteria criteria = crit.and(new Criteria(Column.getColumn((String)"AUDClusterDetails", (String)"CLUSTER_NAME"), (Object)clusterName, 0, caseSensitivity.booleanValue()));
        DataObject clusterNameDO = CommonUtil.getPersistence(new boolean[0]).get("AUDClusterDetails", criteria);
        Row clusterNameRow = null;
        if (clusterNameDO.isEmpty()) {
            clusterNameDO = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            clusterNameRow = new Row("AUDClusterDetails");
            clusterNameRow.set("CLUSTER_NAME", clusterNameProps.get("Name"));
            clusterNameRow.set("DOMAIN_NAME", (Object)domainName);
            clusterNameRow.set("MESSAGE", (Object)"success");
            clusterNameDO.addRow(clusterNameRow);
            CommonUtil.getPersistence(new boolean[0]).add(clusterNameDO);
            clusterId = (Long)clusterNameRow.get("CLUSTER_ID");
        } else {
            clusterNameRow = clusterNameDO.getRow("AUDClusterDetails");
            clusterId = (Long)clusterNameRow.get("CLUSTER_ID");
        }
        return clusterId;
    }

    public static synchronized DataObject updateClusterNodes(String domainName, Long clusterId, ArrayList clusterNodeList) {
        DataObject clusterNodeDO = null;
        try {
            clusterNodeDO = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            if (clusterId != null && clusterNodeList != null && !clusterNodeList.isEmpty() && clusterNodeList.size() > 0 && ClusterUtil.deleteClusterNodesForCluster(domainName, clusterId)) {
                for (Object object : clusterNodeList) {
                    Row clusterNodeRow = new Row("AUDClusterNodeDetails");
                    Properties properties = (Properties)object;
                    String tempClusterName = (String)properties.get("CLUSTER_NAME");
                    String clusterNodeName = (String)properties.get("CLUSTER_NODE_NAME");
                    String clusterNodeGuid = (String)properties.get("OBJECT_GUID");
                    String tempDomainName = (String)properties.get("CLUSTER_NAME");
                    clusterNodeRow.set("CLUSTER_ID", (Object)clusterId);
                    clusterNodeRow.set("CLUSTER_NODE_NAME", (Object)clusterNodeName);
                    clusterNodeRow.set("OBJECT_GUID", (Object)clusterNodeGuid);
                    clusterNodeDO.addRow(clusterNodeRow);
                }
                CommonUtil.getPersistence(new boolean[0]).add(clusterNodeDO);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return clusterNodeDO;
    }

    public static synchronized DataObject updateClusterResources(String domainName, Long clusterId, ArrayList clusterResourceList) {
        DataObject clusterNodeDO = null;
        try {
            clusterNodeDO = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            if (clusterResourceList != null && !clusterResourceList.isEmpty() && ClusterUtil.deleteClusterResourcesForCluster(domainName, clusterId)) {
                for (Object object : clusterResourceList) {
                    Row clusterNodeRow = new Row("AUDClusterCAPDetails");
                    Properties properties = (Properties)object;
                    String clusterNodeName = (String)properties.get("CLUSTER_CAP_NAME");
                    clusterNodeRow.set("CLUSTER_ID", (Object)clusterId);
                    clusterNodeRow.set("CLUSTER_CAP_NAME", (Object)clusterNodeName);
                    clusterNodeDO.addRow(clusterNodeRow);
                }
                CommonUtil.getPersistence(new boolean[0]).add(clusterNodeDO);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return clusterNodeDO;
    }
}

