/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.fileaudit.emc;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import sun.net.www.protocol.http.HttpURLConnection;

public class CelerraConnector {
    private static Logger logger = Logger.getLogger(CelerraConnector.class.getName());
    public static final long TICKET_RENEW_PERIOD = 120000L;
    public static final String PROTOCOL_SERVLET_NAME = "/servlets/CelerraManagementServices";
    public static final String HTTP_VERSION = "1.1";
    public static final String HTTP_POST = "POST";
    public static final String HEADER_HOST = "Host";
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String HEADER_CONTENT_LENGTH = "Content-Length";
    public static final String HEADER_COOKIE = "Cookie";
    public static final String HEADER_SET_COOKIE = "Set-Cookie";
    public static final String HEADER_CONNECTOR_ID = "CelerraConnector-ID";
    public static final String HEADER_CONNECTOR_RC = "CelerraConnector-RC";
    public static final String HEADER_CONNECTOR_SESS = "CelerraConnector-Sess";
    public static final String HEADER_CONNECTOR_CTL = "CelerraConnector-Ctl";
    public static final String CONNECTOR_DISCONNECT = "DISCONNECT";
    public static final String CONNECTOR_ONE_TIME = "ONE-TIME-REQUEST";
    public static final int KEEP_HOT_INTERVAL = 60000;
    public static final int CLIENT_RETRIES = 3;
    private static SSLContext ctx;
    private String host;
    private int port;
    private String proxyHost;
    private int proxyPort;
    private String userName;
    private String password;
    private String authCookie;
    private long authCookieTime;
    private long lastRequestTime;
    private String jsessionCookie;
    private String connectorSession;
    private Object loginSyncObject = new Object();

    private CelerraConnector() {
    }

    public static CelerraResponse call(String request, String host, int port, String proxyHost, int proxyPort, String userName, String password) throws IOException, CelerraAuthenticationException {
        CelerraConnector c = new CelerraConnector();
        c.host = host;
        c.port = port;
        c.proxyHost = proxyHost;
        c.proxyPort = proxyPort;
        c.userName = userName;
        c.password = password;
        return c.quickCall(request);
    }

    private CelerraResponse quickCall(String request) throws IOException, CelerraAuthenticationException {
        CelerraResponse repl = null;
        for (int i = 0; i < 1 && ((repl = this.post(request, true)).getContent() == null || repl.getContent().length <= 0); ++i) {
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return repl;
    }

    private long login() throws IOException, CelerraAuthenticationException {
        Object object = this.loginSyncObject;
        synchronized (object) {
            long time = System.currentTimeMillis();
            if (time - this.authCookieTime > 60000L) {
                this.authCookie = null;
            }
            if (this.authCookie != null) {
                return time;
            }
            Socket sock = CelerraConnector.getSSLSocket(this.host, this.port, this.proxyHost, this.proxyPort);
            PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(sock.getOutputStream())));
            BufferedReader in = new BufferedReader(new InputStreamReader(sock.getInputStream()));
            out.println("POST http://" + this.host + "/Login" + " HTTP/" + HTTP_VERSION);
            out.println("Content-Type: application/x-www-form-urlencoded");
            out.println("Host: " + this.host);
            StringBuffer msg = new StringBuffer(128);
            msg.append("user=");
            msg.append(this.userName);
            msg.append("&password=");
            msg.append(this.password);
            msg.append("&Login=Login");
            out.println("Content-Length: " + msg.length());
            out.println();
            out.println(msg.toString());
            out.flush();
            String cookie = null;
            try {
                String line;
                while ((line = in.readLine()) != null) {
                    String cname;
                    int ix = line.indexOf(":");
                    if (ix <= 0 || ix >= line.length() - 1 || !(cname = line.substring(0, ix).trim()).equalsIgnoreCase(HEADER_SET_COOKIE)) continue;
                    cookie = line.substring(ix + 2).trim();
                    break;
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CelerraAuthenticationException(CelerraConnector.stackTraceToString(e));
            }
            this.returnSocket(sock);
            if (cookie != null) {
                this.authCookie = this.cookieWork(cookie);
                this.authCookieTime = System.currentTimeMillis();
                return time;
            }
            throw new CelerraAuthenticationException("Unable to login, cookie not found");
        }
    }

    private String cookieWork(String hdr) {
        int ix = hdr.indexOf(";");
        if (ix > 0) {
            hdr = hdr.substring(0, ix) + "; $Path=/";
        }
        return hdr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CelerraResponse post(String content, boolean disconnectOnExit) throws IOException, CelerraAuthenticationException {
        PrintWriter out = null;
        FilterInputStream in = null;
        int retries = 1;
        for (int r = 0; r < retries; ++r) {
            try {
                this.lastRequestTime = this.login();
                Socket sock = CelerraConnector.getSSLSocket(this.host, this.port, this.proxyHost, this.proxyPort);
                out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(sock.getOutputStream())));
                in = new DataInputStream(new BufferedInputStream(sock.getInputStream()));
                out.println("POST /servlets/CelerraManagementServices HTTP/1.1");
                out.println("Host: " + this.host + ':' + this.port);
                out.println("Content-Type: text/xml");
                out.println("Cookie: " + this.authCookie);
                if (this.connectorSession != null) {
                    out.println("CelerraConnector-Sess: " + this.connectorSession);
                }
                if (content == null) {
                    out.println("CelerraConnector-Ctl: DISCONNECT");
                    out.println();
                } else {
                    if (disconnectOnExit) {
                        out.println("CelerraConnector-Ctl: ONE-TIME-REQUEST");
                    }
                    out.println("Content-Length: " + content.length());
                    out.println();
                    out.println(content);
                }
                out.println();
                out.flush();
                logger.log(Level.INFO, "LOG_HTTP_POST===== Post: request sent.   Thread: " + Thread.currentThread());
                logger.log(Level.INFO, "content:" + content);
                int statusCode = 0;
                String statusString = null;
                logger.log(Level.INFO, "LOG_HTTP_POST===== Post: reply.");
                String line = ((DataInputStream)in).readLine();
                if (line == null) continue;
                try {
                    StringTokenizer st = new StringTokenizer(line);
                    st.nextToken();
                    statusCode = Integer.parseInt(st.nextToken());
                    StringBuffer sb = new StringBuffer();
                    while (st.hasMoreTokens()) {
                        sb.append(st.nextToken());
                        if (!st.hasMoreTokens()) continue;
                        sb.append(" ");
                    }
                    statusString = sb.toString();
                }
                catch (IOException ex) {
                    throw ex;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IllegalArgumentException("error parsing HTTP status line: " + e.getMessage());
                }
                if (statusCode == 401 || statusCode == 403) {
                    Object e = this.loginSyncObject;
                    synchronized (e) {
                        this.authCookie = null;
                        continue;
                    }
                }
                int respContentLength = -1;
                try {
                    String line2 = null;
                    while ((line2 = ((DataInputStream)in).readLine()) != null && line2.length() != 0) {
                        int colonIndex = line2.indexOf(58);
                        String fieldName = line2.substring(0, colonIndex);
                        String fieldValue = line2.substring(colonIndex + 1).trim();
                        if (fieldName.equalsIgnoreCase(HEADER_CONTENT_LENGTH)) {
                            respContentLength = Integer.parseInt(fieldValue);
                            continue;
                        }
                        if (fieldName.equalsIgnoreCase(HEADER_CONNECTOR_SESS)) {
                            if (this.connectorSession != null) continue;
                            this.connectorSession = fieldValue;
                            continue;
                        }
                        if (!fieldName.equalsIgnoreCase(HEADER_SET_COOKIE)) continue;
                        String cookieName = fieldValue.substring(0, fieldValue.indexOf("="));
                        if (cookieName.equalsIgnoreCase("JSESSIONID")) {
                            this.jsessionCookie = this.cookieWork(fieldValue) + "; $Secure";
                            continue;
                        }
                        if (!cookieName.equalsIgnoreCase("Ticket")) continue;
                        this.authCookie = this.cookieWork(fieldValue);
                    }
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException("error reading HTTP headers: " + e.getMessage());
                }
                if (respContentLength > 0) {
                    byte[] buf = new byte[respContentLength];
                    try {
                        int numBytes;
                        for (int offset = 0; offset < respContentLength && (numBytes = ((DataInputStream)in).read(buf, offset, respContentLength - offset)) > 0; offset += numBytes) {
                        }
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    this.returnSocket(sock);
                    CelerraResponse celerraResponse = new CelerraResponse(statusCode, statusString, buf);
                    return celerraResponse;
                }
                sock.close();
                CelerraResponse celerraResponse = new CelerraResponse(statusCode, statusString, null);
                return celerraResponse;
            }
            catch (IOException ex) {
                if (r != retries - 1) continue;
                throw ex;
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        throw new IOException("Unable to contact EMC Control Station:No more retries");
    }

    private void returnSocket(Socket sock) {
        try {
            sock.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static synchronized Socket getSSLSocket(String host, int port, String proxyHost, int proxyPort) throws IOException {
        for (int i = 0; i < 1; ++i) {
            try {
                SSLSocket sock;
                int tunnelPort;
                SSLSocketFactory factory = ctx.getSocketFactory();
                int n = tunnelPort = proxyPort <= 0 ? 443 : proxyPort;
                if (proxyHost != null) {
                    Socket tunnel = new Socket(proxyHost, tunnelPort);
                    tunnel.setSoLinger(false, 0);
                    tunnel.setSoTimeout(0);
                    tunnel.setKeepAlive(true);
                    CelerraConnector.doTunnelHandshake(tunnel, host, port);
                    sock = (SSLSocket)factory.createSocket(tunnel, host, port, true);
                } else {
                    sock = (SSLSocket)factory.createSocket(host, port);
                }
                sock.setSoLinger(false, 0);
                sock.setSoTimeout(0);
                sock.setKeepAlive(true);
                sock.startHandshake();
                return sock;
            }
            catch (Exception e) {
                e.printStackTrace();
                if (i < 0) continue;
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new IOException("Exception opening socket: " + e.toString());
            }
        }
        return null;
    }

    private static void doTunnelHandshake(Socket tunnel, String host, int port) throws IOException {
        String replyStr;
        byte[] b;
        OutputStream out = tunnel.getOutputStream();
        String msg = "CONNECT " + host + ":" + port + " HTTP/1.1\r\n" + "User-Agent: " + HttpURLConnection.userAgent + "\r\n" + "Proxy-Connection: keep-alive\r\n" + "Host: " + host + ":" + port + "\r\n" + "\r\n";
        try {
            b = msg.getBytes("ASCII7");
        }
        catch (UnsupportedEncodingException ignored) {
            b = msg.getBytes();
        }
        out.write(b);
        out.flush();
        byte[] reply = new byte[200];
        int replyLen = 0;
        int newlinesSeen = 0;
        boolean headerDone = false;
        InputStream in = tunnel.getInputStream();
        while (newlinesSeen < 2) {
            int i = in.read();
            if (i < 0) {
                throw new IOException("Unexpected EOF from proxy");
            }
            if (i == 10) {
                headerDone = true;
                ++newlinesSeen;
                continue;
            }
            if (i == 13) continue;
            newlinesSeen = 0;
            if (headerDone || replyLen >= reply.length) continue;
            reply[replyLen++] = (byte)i;
        }
        try {
            replyStr = new String(reply, 0, replyLen, "ASCII7");
        }
        catch (UnsupportedEncodingException ignored) {
            replyStr = new String(reply, 0, replyLen);
        }
        if ((replyStr.startsWith("HTTP/1.0") || replyStr.startsWith("HTTP/1.1")) && replyStr.indexOf(" 200") > 0) {
            return;
        }
        String message = "Unable to tunnel through " + tunnel.getInetAddress().getHostAddress() + ":" + tunnel.getPort() + ".\nProxy returns:\n \"" + replyStr + "\"";
        throw new IOException(message);
    }

    public static String stackTraceToString(Throwable exe) {
        try {
            ByteArrayOutputStream temp = new ByteArrayOutputStream(512);
            PrintStream ps = new PrintStream(temp);
            exe.printStackTrace(ps);
            ps.flush();
            return temp.toString("UTF-8");
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
            return "";
        }
    }

    static {
        TrustManager[] myTM = new TrustManager[]{new MyX509TrustManager()};
        try {
            ctx = SSLContext.getInstance("SSL");
            ctx.init(null, myTM, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(ctx.getSocketFactory());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public class CelerraAuthenticationException
    extends Exception {
        CelerraAuthenticationException(String message) {
            super(message);
        }

        CelerraAuthenticationException() {
        }
    }

    public class CelerraResponse {
        private int statusCode;
        private String statusString;
        private byte[] content;

        CelerraResponse(int statusCode, String statusString, byte[] content) {
            this.statusCode = statusCode;
            this.statusString = statusString;
            this.content = content;
        }

        public byte[] getContent() {
            return this.content;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getStatusString() {
            return this.statusString;
        }
    }

    private static class MyX509TrustManager
    implements X509TrustManager {
        MyX509TrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

