/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.fileaudit.emc;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.config.ServerConfigAPI;
import com.adventnet.sym.adsm.auditing.server.delegation.GpoHandler;
import com.adventnet.sym.adsm.auditing.server.fileaudit.FileServerHandler;
import com.adventnet.sym.adsm.auditing.server.fileaudit.ModifySaclThread;
import com.adventnet.sym.adsm.auditing.server.fileaudit.emc.CelerraConnector;
import com.adventnet.sym.adsm.auditing.server.monitor.AudFileMonitorCriteriaHandler;
import com.adventnet.sym.adsm.auditing.server.util.EventDataUtil;
import com.adventnet.sym.adsm.auditing.server.util.EventSchedulerUtil;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.MSHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.SchedulerUtil;
import java.io.StringReader;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class EMCHandler {
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private static Logger logger = Logger.getLogger(EMCHandler.class.getName());

    public static String addEMCServer(Hashtable<String, Object> fsDetails) throws Exception {
        int fsMachineType;
        String message;
        block14: {
            String gpoStatus;
            message = "";
            String divErrMsg = "<div id=\"commentForm\" style=\"display:block\"> <a class=\"greenlinktxt\" href=\"javascript:void(0)\" onclick=\"yreg_popLayer('updateNetAppDetails_";
            String divErrMsg1 = "',this, -75, 18) \">" + rb.getString("adap.common.text.policy_update_link.click_here") + "</a></div>";
            String objectGuid = (String)fsDetails.get("OBJECT_GUID");
            DataObject msObj = null;
            fsMachineType = 0;
            String[] guidArray = new String[]{objectGuid};
            boolean isEMCServer = ServerConfigAPI.isConfiguredEMCServer(objectGuid);
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDComputerEventRead", (String)"OBJECT_GUID"), (Object)objectGuid, 0);
            msObj = CommonUtil.getPersistence(new boolean[0]).get("AUDComputerEventRead", criteria);
            if (isEMCServer) {
                ArrayList shareNameList = (ArrayList)fsDetails.get("LOCATIONS");
                ArrayList<String> conShareList = FileServerHandler.getConfiguredShares((String)fsDetails.get("serverName"), (String)fsDetails.get("domainName"));
                for (int i = 0; i < conShareList.size(); ++i) {
                    if (!shareNameList.contains(conShareList.get(i))) continue;
                    shareNameList.remove(conShareList.get(i));
                }
                fsDetails.put("LOCATIONS", shareNameList);
                message = rb.getString("adap.FileServerHandler.File_Shares_are_added_successfully_for_auditing");
            } else if (msObj == null || msObj.isEmpty()) {
                DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                Row fsRow = FileServerHandler.getFileServerRow(dataObj, fsDetails, 131072);
                fsRow.set("OS_NAME", (Object)"EMC Cellera");
                fsRow.set("WINDOWS_DIR", (Object)"C:\\vol\\vol1\\etc");
                fsRow.set("OS_VERSION", (Object)"5.2");
                fsRow.set("OS_ARCHITECTURE", (Object)"32-bit");
                dataObj.addRow(fsRow);
                CommonUtil.getPersistence(new boolean[0]).add(dataObj);
                fsMachineType = (Integer)fsRow.get("MACHINE_TYPE");
                message = rb.getString("adap.EMCHandler.Successfully_configured_EMC_Server");
            } else {
                Row fsRow1 = msObj.getRow(MSHandler.tableMSName);
                Long instanceId = (Long)fsRow1.get("INSTANCE_ID");
                DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                Row fsRow = FileServerHandler.getFileServerRow(dataObj, fsDetails, 131072);
                fsRow.set("OS_NAME", (Object)"EMC Cellera");
                fsRow.set("WINDOWS_DIR", (Object)"C:\\vol\\vol1\\etc");
                fsRow.set("OS_VERSION", (Object)"5.2");
                fsRow.set("OS_ARCHITECTURE", (Object)"32-bit");
                MSHandler.removeTaskInstanceID(instanceId, new boolean[0]);
                dataObj.addRow(fsRow);
                CommonUtil.getPersistence(new boolean[0]).add(dataObj);
                fsMachineType = (Integer)fsRow.get("MACHINE_TYPE");
                message = rb.getString("adap.EMCHandler.Successfully_configured_EMC_Server");
            }
            if ((String)fsDetails.get("MESSAGE") != null) {
                message = (String)fsDetails.get("MESSAGE");
            }
            if (isEMCServer) {
                AudFileMonitorCriteriaHandler.addFileServersShares((String)fsDetails.get("domainName"), (String)fsDetails.get("serverName"), (ArrayList)fsDetails.get("LOCATIONS"));
            } else {
                AudFileMonitorCriteriaHandler.addFileServersShares(fsDetails);
            }
            if (((String)fsDetails.get("IS_SACL")).equalsIgnoreCase("true")) {
                new ModifySaclThread(fsDetails);
            }
            EventDataUtil.getComputerDetails(null, null);
            EMCHandler.addEMCCIFSDetails(objectGuid, fsDetails.get("serverName").toString(), fsDetails.get("domainName").toString(), fsDetails.get("EMC_CONTROL_STATION_IP").toString(), fsDetails.get("USER_NAME").toString(), fsDetails.get("PASSWORD").toString(), fsDetails.get("PORT_NO").toString());
            message = ((String)fsDetails.get("IS_POLICY")).equalsIgnoreCase("true") ? ((gpoStatus = GpoHandler.createGpoAndApplySecurityFilter((String)fsDetails.get("domainName"), null, guidArray, 131072)).equalsIgnoreCase("Configuring audit policy for remote domain is currently not supported") ? message + rb.getString("adap.FileServerHandler.Configuring_audit_policy_for_remote_domain_is_currently_not_supported") : message + "," + gpoStatus) : message + rb.getString("adap.FileServerHandler.Object_Access_policy_and_auditing_permissions");
            try {
                EMCHandler.addDMDetails(objectGuid, fsDetails.get("serverName").toString(), fsDetails.get("domainName").toString(), fsDetails.get("EMC_CONTROL_STATION_IP").toString(), fsDetails.get("USER_NAME").toString(), fsDetails.get("PASSWORD").toString(), fsDetails.get("PORT_NO").toString());
            }
            catch (ConnectException ex) {
                message = message + rb.getString("adap.EMCHandler.Unable_to_contact_EMC_Control_Station_Connection_Refused") + divErrMsg + objectGuid + divErrMsg1;
            }
            catch (UnknownHostException ex) {
                message = message + rb.getString("adap.ConfiguredNetAppFilers.Unable_to_contact_EMC_Control_Station_Incorrect_EMC_IP") + divErrMsg + objectGuid + divErrMsg1;
            }
            catch (Throwable ex) {
                if (ex.getMessage() == null) break block14;
                message = message + ":" + ex.getMessage() + divErrMsg + objectGuid + divErrMsg1;
            }
        }
        if ((fsMachineType & 0x20000) == 131072) {
            FileServerHandler.runEventScheduler((Long)fsDetails.get("SCHEDULE_ID"));
        }
        return message;
    }

    public static void addEMCCIFSDetails(String objectGuid, String cifsServer, String domainName, String emcControlStationIP, String userName, String password, String port) throws Exception {
        Criteria crit2 = new Criteria(Column.getColumn((String)"AUDEMCCIFSDetails", (String)"DOMAIN_NAME"), (Object)domainName, 0);
        Criteria crit = new Criteria(Column.getColumn((String)"AUDEMCCIFSDetails", (String)"OBJECT_GUID"), (Object)objectGuid, 0);
        crit = crit.and(crit2);
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDEMCCIFSDetails", crit);
        if (dataObject.isEmpty()) {
            Row fsRow = new Row("AUDEMCCIFSDetails");
            fsRow.set("EMC_STATION_IP_ADDRESS", (Object)emcControlStationIP);
            fsRow.set("USER_NAME", (Object)userName);
            fsRow.set("PASSWORD", (Object)password);
            fsRow.set("PORT_NO", (Object)Integer.parseInt(port));
            fsRow.set("CIFS_SERVER", (Object)cifsServer);
            fsRow.set("OBJECT_GUID", (Object)objectGuid);
            fsRow.set("DOMAIN_NAME", (Object)domainName);
            dataObject.addRow(fsRow);
            CommonUtil.getPersistence(new boolean[0]).add(dataObject);
        } else {
            Row fsRow = dataObject.getFirstRow("AUDEMCCIFSDetails");
            fsRow.set("EMC_STATION_IP_ADDRESS", (Object)emcControlStationIP);
            fsRow.set("USER_NAME", (Object)userName);
            fsRow.set("PASSWORD", (Object)password);
            fsRow.set("PORT_NO", (Object)Integer.parseInt(port));
            dataObject.updateRow(fsRow);
            CommonUtil.getPersistence(new boolean[0]).update(dataObject);
        }
    }

    public static void addDMDetails(String objectGuid, String cifsServer, String domainName, String emcControlStationIP, String userName, String password, String port) throws Exception {
        Row fsRow;
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<RequestPacket xmlns=\"http://www.emc.com/schemas/celerra/xml_api\" xmlns:meta=\"http://www.emc.com/schemas/celerra/xml_api_meta\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.emc.com/schemas/celerra/xml_api\">\n<Request>\n\t<Query>\n\t<CifsServerQueryParams/>\n\t</Query>\n</Request>\n</RequestPacket>";
        Hashtable<String, Object> cifsTable = new Hashtable<String, Object>();
        CelerraConnector.CelerraResponse cr = CelerraConnector.call(request, emcControlStationIP, Integer.parseInt(port), null, 0, userName, password);
        String s = new String(cr.getContent());
        logger.log(Level.INFO, "Reply from EMC Control Station:" + s);
        if (s.contains("Connection refused")) {
            throw new Exception(rb.getString("adap.EMCHandler.Unable_to_contact_EMC_Control_Station_Connection_Refused"));
        }
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(s));
        Document doc = dBuilder.parse(is);
        doc.getDocumentElement().normalize();
        NodeList nList = doc.getElementsByTagName("CifsServer");
        for (int temp = 0; temp < nList.getLength(); ++temp) {
            Node nNode = nList.item(temp);
            if (nNode.getNodeType() != 1) continue;
            Element eElement = (Element)nNode;
            String moverId = eElement.getAttribute("mover");
            String isVdm = eElement.getAttribute("moverIdIsVdm");
            String cifsIp = eElement.getAttribute("interfaces");
            NodeList nList1 = eElement.getElementsByTagName("W2KServerData");
            for (int temp1 = 0; temp1 < nList1.getLength(); ++temp1) {
                Node nNode1 = nList1.item(temp1);
                if (nNode1.getNodeType() != 1) continue;
                Element eElement1 = (Element)nNode1;
                String cifsServerName = eElement1.getAttribute("compName");
                String domain = eElement1.getAttribute("domain");
                if (!cifsServerName.equalsIgnoreCase(cifsServer)) continue;
                cifsTable.put("EMC_DM_ID", Long.parseLong(moverId));
                cifsTable.put("IS_VDM", Boolean.parseBoolean(isVdm));
                cifsTable.put("CIFS_SERVER_IP", cifsIp);
                cifsTable.put("CIFS_SERVER", cifsServerName);
                cifsTable.put("DOMAIN_NAME", domain);
            }
        }
        cifsTable.put("OBJECT_GUID", objectGuid);
        cifsTable.put("EMC_STATION_IP_ADDRESS", emcControlStationIP);
        cifsTable.put("CIFS_SERVER", cifsServer);
        cifsTable.put("DOMAIN_NAME", domainName);
        Criteria crit2 = new Criteria(Column.getColumn((String)"AUDEMCCIFSDetails", (String)"DOMAIN_NAME"), (Object)domainName, 0);
        Criteria crit = new Criteria(Column.getColumn((String)"AUDEMCCIFSDetails", (String)"OBJECT_GUID"), cifsTable.get("OBJECT_GUID"), 0);
        crit = crit.and(crit2);
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDEMCCIFSDetails", crit);
        logger.log(Level.INFO, "cifsTable:" + cifsTable);
        if (dataObject.isEmpty()) {
            fsRow = new Row("AUDEMCCIFSDetails");
            fsRow.set("EMC_STATION_IP_ADDRESS", cifsTable.get("EMC_STATION_IP_ADDRESS"));
            fsRow.set("USER_NAME", (Object)userName);
            fsRow.set("PASSWORD", (Object)password);
            fsRow.set("PORT_NO", (Object)Integer.parseInt(port));
            fsRow.set("CIFS_SERVER", cifsTable.get("CIFS_SERVER"));
            fsRow.set("OBJECT_GUID", cifsTable.get("OBJECT_GUID"));
            fsRow.set("DOMAIN_NAME", (Object)domainName);
            fsRow.set("EMC_DM_ID", cifsTable.get("EMC_DM_ID"));
            fsRow.set("IS_VDM", cifsTable.get("IS_VDM"));
            fsRow.set("CIFS_SERVER_IP_ADDRESS", cifsTable.get("CIFS_SERVER_IP"));
            dataObject.addRow(fsRow);
            CommonUtil.getPersistence(new boolean[0]).add(dataObject);
        } else {
            fsRow = dataObject.getFirstRow("AUDEMCCIFSDetails");
            fsRow.set("EMC_STATION_IP_ADDRESS", cifsTable.get("EMC_STATION_IP_ADDRESS"));
            fsRow.set("USER_NAME", (Object)userName);
            fsRow.set("PASSWORD", (Object)password);
            fsRow.set("PORT_NO", (Object)Integer.parseInt(port));
            fsRow.set("EMC_DM_ID", cifsTable.get("EMC_DM_ID"));
            fsRow.set("IS_VDM", cifsTable.get("IS_VDM"));
            fsRow.set("CIFS_SERVER_IP_ADDRESS", cifsTable.get("CIFS_SERVER_IP"));
            dataObject.updateRow(fsRow);
            CommonUtil.getPersistence(new boolean[0]).update(dataObject);
        }
    }

    public static Hashtable<String, Object> getCifsDetails(String objectGuid, String cifsServerName, String domainName) throws Exception {
        Criteria crit4 = new Criteria(Column.getColumn((String)"AUDEMCCIFSDetails", (String)"CIFS_SERVER"), (Object)cifsServerName, 0);
        Criteria crit2 = new Criteria(Column.getColumn((String)"AUDEMCCIFSDetails", (String)"DOMAIN_NAME"), (Object)domainName, 0);
        Criteria crit = new Criteria(Column.getColumn((String)"AUDEMCCIFSDetails", (String)"OBJECT_GUID"), (Object)objectGuid, 0);
        crit = crit.and(crit2);
        crit = crit.and(crit4);
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDEMCCIFSDetails", crit);
        Hashtable<String, Object> cifsTable = null;
        if (!dataObject.isEmpty()) {
            Row fsRow = dataObject.getFirstRow("AUDEMCCIFSDetails");
            cifsTable = new Hashtable<String, Object>();
            cifsTable.put("EMC_STATION_IP_ADDRESS", fsRow.get("EMC_STATION_IP_ADDRESS"));
            cifsTable.put("USER_NAME", fsRow.get("USER_NAME").toString());
            cifsTable.put("PASSWORD", fsRow.get("PASSWORD").toString());
            cifsTable.put("PORT_NO", (Integer)fsRow.get("PORT_NO"));
            cifsTable.put("CIFS_SERVER", fsRow.get("CIFS_SERVER").toString());
            cifsTable.put("OBJECT_GUID", fsRow.get("OBJECT_GUID").toString());
            cifsTable.put("DOMAIN_NAME", fsRow.get("DOMAIN_NAME").toString());
            if (fsRow.get("EMC_DM_ID") != null) {
                cifsTable.put("EMC_DM_ID", (Long)fsRow.get("EMC_DM_ID"));
            }
            if (fsRow.get("IS_VDM") != null) {
                cifsTable.put("IS_VDM", (Boolean)fsRow.get("IS_VDM"));
            }
            if (fsRow.get("CIFS_SERVER_IP_ADDRESS") != null) {
                cifsTable.put("CIFS_SERVER_IP_ADDRESS", (String)fsRow.get("CIFS_SERVER_IP_ADDRESS"));
            }
        }
        return cifsTable;
    }

    public static void getCifsDMDetails(Hashtable<String, Object> cifsTable) throws Exception {
        Criteria crit = new Criteria(Column.getColumn((String)"AUDEMCDMDetails", (String)"IS_VDM"), (Object)((Boolean)cifsTable.get("IS_VDM")), 0);
        Criteria crit2 = new Criteria(Column.getColumn((String)"AUDEMCDMDetails", (String)"DOMAIN_NAME"), (Object)((String)cifsTable.get("DOMAIN_NAME")), 0);
        Criteria crit3 = new Criteria(Column.getColumn((String)"AUDEMCDMDetails", (String)"EMC_STATION_IP_ADDRESS"), cifsTable.get("EMC_STATION_IP_ADDRESS"), 0);
        Criteria crit4 = new Criteria(Column.getColumn((String)"AUDEMCDMDetails", (String)"EMC_DM_ID"), cifsTable.get("EMC_DM_ID"), 0);
        crit = crit.and(crit2);
        crit = crit.and(crit3);
        crit = crit.and(crit4);
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDEMCDMDetails", crit);
        if (!dataObject.isEmpty()) {
            Row fsRow = dataObject.getFirstRow("AUDEMCDMDetails");
            cifsTable.put("IS_ARCHIVE_ENABLED", (Boolean)fsRow.get("IS_ARCHIVE_ENABLED"));
            cifsTable.put("EVT_FILE_SHARE_PATH", (String)fsRow.get("EVT_FILE_SHARE_PATH"));
            cifsTable.put("EVT_FILE_NAME", (String)fsRow.get("EVT_FILE_NAME"));
            cifsTable.put("MSG_DLL_SHARE_PATH", (String)fsRow.get("MSG_DLL_SHARE_PATH"));
            cifsTable.put("MSG_DLL_NAME", (String)fsRow.get("MSG_DLL_NAME"));
            cifsTable.put("LAST_READ_EVT_FILE_TIME", (Long)fsRow.get("LAST_READ_EVT_FILE_TIME"));
            if ((Boolean)fsRow.get("IS_EF_RUNNING") != null) {
                cifsTable.put("IS_EF_RUNNING", (Boolean)fsRow.get("IS_EF_RUNNING"));
            }
            if (fsRow.get("ARCHIVE_RETENTION_POLICY_SIZE") == null || fsRow.get("ARCHIVE_RETENTION_POLICY_SIZE").toString().equals("")) {
                cifsTable.put("ARCHIVE_RETENTION_POLICY_SIZE", "-");
            } else {
                cifsTable.put("ARCHIVE_RETENTION_POLICY_SIZE", (String)fsRow.get("ARCHIVE_RETENTION_POLICY_SIZE"));
            }
            if (fsRow.get("ARCHIVE_RETENTION_POLICY_TIME") == null || fsRow.get("ARCHIVE_RETENTION_POLICY_TIME").toString().equals("")) {
                cifsTable.put("ARCHIVE_RETENTION_POLICY_TIME", "-");
            } else {
                cifsTable.put("ARCHIVE_RETENTION_POLICY_TIME", (String)fsRow.get("ARCHIVE_RETENTION_POLICY_TIME"));
            }
            if (fsRow.get("ARCHIVE_TRIGGER_POLICY_SIZE") == null || fsRow.get("ARCHIVE_TRIGGER_POLICY_SIZE").toString().equals("")) {
                cifsTable.put("ARCHIVE_TRIGGER_POLICY_SIZE", "-");
            } else {
                cifsTable.put("ARCHIVE_TRIGGER_POLICY_SIZE", (String)fsRow.get("ARCHIVE_TRIGGER_POLICY_SIZE"));
            }
            if (fsRow.get("ARCHIVE_TRIGGER_POLICY_TIME") == null || fsRow.get("ARCHIVE_TRIGGER_POLICY_TIME").toString().equals("")) {
                cifsTable.put("ARCHIVE_TRIGGER_POLICY_TIME", "-");
            } else {
                cifsTable.put("ARCHIVE_TRIGGER_POLICY_TIME", (String)fsRow.get("ARCHIVE_TRIGGER_POLICY_TIME"));
            }
            if (fsRow.get("ARCHIVE_LAST_ARCHIVE_DATE") == null || fsRow.get("ARCHIVE_LAST_ARCHIVE_DATE").toString().equals("")) {
                cifsTable.put("ARCHIVE_LAST_ARCHIVE_DATE", "-");
            } else {
                cifsTable.put("ARCHIVE_LAST_ARCHIVE_DATE", (String)fsRow.get("ARCHIVE_LAST_ARCHIVE_DATE"));
            }
        }
    }

    public static Hashtable<String, Object> getDMAuditSettings(String objectGuid, String cifsServerName, String domainName, boolean isSync) throws Exception {
        Hashtable<String, Object> cifsTable = EMCHandler.getCifsDetails(objectGuid, cifsServerName, domainName);
        if (cifsTable == null || cifsTable.get("EMC_DM_ID") == null || cifsTable.get("IS_VDM") == null) {
            EMCHandler.addDMDetails(objectGuid, cifsServerName, domainName, (String)cifsTable.get("EMC_STATION_IP_ADDRESS"), (String)cifsTable.get("USER_NAME"), (String)cifsTable.get("PASSWORD"), cifsTable.get("PORT_NO").toString());
            cifsTable = EMCHandler.getCifsDetails(objectGuid, cifsServerName, domainName);
        }
        Hashtable<String, Object> dmTable = null;
        if (!isSync) {
            Criteria crit = new Criteria(Column.getColumn((String)"AUDEMCDMDetails", (String)"IS_VDM"), (Object)((Boolean)cifsTable.get("IS_VDM")), 0);
            Criteria crit3 = new Criteria(Column.getColumn((String)"AUDEMCDMDetails", (String)"EMC_STATION_IP_ADDRESS"), cifsTable.get("EMC_STATION_IP_ADDRESS"), 0);
            Criteria crit4 = new Criteria(Column.getColumn((String)"AUDEMCDMDetails", (String)"EMC_DM_ID"), cifsTable.get("EMC_DM_ID"), 0);
            crit = crit.and(crit3);
            crit = crit.and(crit4);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDEMCDMDetails", crit);
            if (!dataObject.isEmpty()) {
                dmTable = new Hashtable();
                Row fsRow = dataObject.getFirstRow("AUDEMCDMDetails");
                dmTable.put("IS_ARCHIVE_ENABLED", (Boolean)fsRow.get("IS_ARCHIVE_ENABLED"));
                dmTable.put("EVT_FILE_SHARE_PATH", (String)fsRow.get("EVT_FILE_SHARE_PATH"));
                dmTable.put("EVT_FILE_NAME", (String)fsRow.get("EVT_FILE_NAME"));
                dmTable.put("MSG_DLL_SHARE_PATH", (String)fsRow.get("MSG_DLL_SHARE_PATH"));
                dmTable.put("MSG_DLL_NAME", (String)fsRow.get("MSG_DLL_NAME"));
                dmTable.put("LAST_READ_EVT_FILE_TIME", (Long)fsRow.get("LAST_READ_EVT_FILE_TIME"));
                dmTable.put("EMC_STATION_IP_ADDRESS", (String)fsRow.get("EMC_STATION_IP_ADDRESS"));
                dmTable.put("EMC_DM_ID", (Long)fsRow.get("EMC_DM_ID"));
                dmTable.put("IS_VDM", (Boolean)fsRow.get("IS_VDM"));
            } else {
                dmTable = EMCHandler.getDMASFromNative(cifsTable);
                EMCHandler.addDMAuditSettings(dmTable);
            }
        } else {
            dmTable = EMCHandler.getDMASFromNative(cifsTable);
            EMCHandler.addDMAuditSettings(dmTable);
        }
        return dmTable;
    }

    public static Hashtable<String, Object> getDMASFromNative(Hashtable<String, Object> cifsTable) throws Exception {
        HashMap<String, Object> dmAuditMap = ADHandler.getEMCAuditSettings((String)cifsTable.get("DOMAIN_NAME"), (String)cifsTable.get("CIFS_SERVER"));
        logger.log(Level.INFO, "dmAuditMap from Native" + dmAuditMap);
        Hashtable dmAudit = (Hashtable)dmAuditMap.get("result");
        String error = (String)dmAuditMap.get("errorMessage");
        Hashtable<String, Object> dmAuditTable = null;
        if (dmAudit != null && !dmAudit.isEmpty()) {
            if (dmAudit.get("AutoArchiveEnabled") == null || dmAudit.get("File") == null || dmAudit.get("EventMessageFile") == null || (Integer)dmAudit.get("AutoArchiveEnabled") != 0 && (Integer)dmAudit.get("AutoArchiveEnabled") != 1) {
                if (error != null) {
                    throw new Exception(rb.getString("adap.EMCHandler.Unable_to_get_Data_Mover_audit_settings_from_CIFS_Server_Registry") + error);
                }
                throw new Exception(rb.getString("adap.EMCHandler.Unable_to_get_Data_Mover_audit_settings_from_CIFS_Server_Registry"));
            }
            dmAuditTable = new Hashtable<String, Object>();
            if ((Integer)dmAudit.get("AutoArchiveEnabled") == 1) {
                dmAuditTable.put("IS_ARCHIVE_ENABLED", Boolean.TRUE);
            } else if ((Integer)dmAudit.get("AutoArchiveEnabled") == 0) {
                dmAuditTable.put("IS_ARCHIVE_ENABLED", Boolean.FALSE);
            }
        } else {
            if (error != null) {
                throw new Exception(rb.getString("adap.EMCHandler.Unable_to_get_Data_Mover_audit_settings_from_CIFS_Server_Registry") + error);
            }
            throw new Exception(rb.getString("adap.EMCHandler.Unable_to_get_Data_Mover_audit_settings_from_CIFS_Server_Registry"));
        }
        String evtLocalPath = (String)dmAudit.get("File");
        int lastIndex = evtLocalPath.lastIndexOf("\\");
        String evtLocation = evtLocalPath.substring(0, lastIndex + 1);
        String evtFileName = evtLocalPath.substring(lastIndex + 1, evtLocalPath.length());
        dmAuditTable.put("EVT_FILE_SHARE_PATH", evtLocation);
        dmAuditTable.put("EVT_FILE_NAME", evtFileName);
        String msgDllLocalPath = (String)dmAudit.get("EventMessageFile");
        int lastIndex1 = msgDllLocalPath.lastIndexOf("\\");
        String msgDllLocation = msgDllLocalPath.substring(0, lastIndex1 + 1);
        String msgDllName = msgDllLocalPath.substring(lastIndex1 + 1, msgDllLocalPath.length());
        dmAuditTable.put("MSG_DLL_SHARE_PATH", msgDllLocation);
        dmAuditTable.put("MSG_DLL_NAME", msgDllName);
        dmAuditTable.put("EMC_STATION_IP_ADDRESS", (String)cifsTable.get("EMC_STATION_IP_ADDRESS"));
        dmAuditTable.put("EMC_DM_ID", (Long)cifsTable.get("EMC_DM_ID"));
        dmAuditTable.put("IS_VDM", (Boolean)cifsTable.get("IS_VDM"));
        dmAuditTable.put("DOMAIN_NAME", (String)cifsTable.get("DOMAIN_NAME"));
        dmAuditTable.put("LAST_READ_EVT_FILE_TIME", 0L);
        dmAuditTable.put("ARCHIVE_RETENTION_POLICY_SIZE", (String)dmAudit.get("AutoArchiveRetentionPolicySize"));
        dmAuditTable.put("ARCHIVE_RETENTION_POLICY_TIME", (String)dmAudit.get("AutoArchiveRetentionPolicyTime"));
        dmAuditTable.put("ARCHIVE_TRIGGER_POLICY_SIZE", (String)dmAudit.get("AutoArchiveTriggerPolicySize"));
        dmAuditTable.put("ARCHIVE_TRIGGER_POLICY_TIME", (String)dmAudit.get("AutoArchiveTriggerPolicyTime"));
        dmAuditTable.put("ARCHIVE_LAST_ARCHIVE_DATE", (String)dmAudit.get("AutoArchiveLastArchiveDate"));
        return dmAuditTable;
    }

    public static synchronized void addDMAuditSettings(Hashtable<String, Object> dmAuditTable) throws Exception {
        Criteria crit = new Criteria(Column.getColumn((String)"AUDEMCDMDetails", (String)"IS_VDM"), (Object)((Boolean)dmAuditTable.get("IS_VDM")), 0);
        Criteria crit3 = new Criteria(Column.getColumn((String)"AUDEMCDMDetails", (String)"EMC_STATION_IP_ADDRESS"), dmAuditTable.get("EMC_STATION_IP_ADDRESS"), 0);
        Criteria crit4 = new Criteria(Column.getColumn((String)"AUDEMCDMDetails", (String)"EMC_DM_ID"), dmAuditTable.get("EMC_DM_ID"), 0);
        crit = crit.and(crit3);
        crit = crit.and(crit4);
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDEMCDMDetails", crit);
        if (dataObject.isEmpty()) {
            Row fsRow = new Row("AUDEMCDMDetails");
            fsRow.set("EMC_STATION_IP_ADDRESS", dmAuditTable.get("EMC_STATION_IP_ADDRESS"));
            fsRow.set("IS_ARCHIVE_ENABLED", dmAuditTable.get("IS_ARCHIVE_ENABLED"));
            fsRow.set("EVT_FILE_SHARE_PATH", dmAuditTable.get("EVT_FILE_SHARE_PATH"));
            fsRow.set("EVT_FILE_NAME", dmAuditTable.get("EVT_FILE_NAME"));
            fsRow.set("MSG_DLL_SHARE_PATH", dmAuditTable.get("MSG_DLL_SHARE_PATH"));
            fsRow.set("MSG_DLL_NAME", dmAuditTable.get("MSG_DLL_NAME"));
            fsRow.set("LAST_READ_EVT_FILE_TIME", (Object)0L);
            fsRow.set("EMC_DM_ID", dmAuditTable.get("EMC_DM_ID"));
            fsRow.set("IS_VDM", dmAuditTable.get("IS_VDM"));
            fsRow.set("DOMAIN_NAME", dmAuditTable.get("DOMAIN_NAME"));
            fsRow.set("ARCHIVE_RETENTION_POLICY_SIZE", (Object)((String)dmAuditTable.get("ARCHIVE_RETENTION_POLICY_SIZE")));
            fsRow.set("ARCHIVE_RETENTION_POLICY_TIME", (Object)((String)dmAuditTable.get("ARCHIVE_RETENTION_POLICY_TIME")));
            fsRow.set("ARCHIVE_TRIGGER_POLICY_SIZE", (Object)((String)dmAuditTable.get("ARCHIVE_TRIGGER_POLICY_SIZE")));
            fsRow.set("ARCHIVE_TRIGGER_POLICY_TIME", (Object)((String)dmAuditTable.get("ARCHIVE_TRIGGER_POLICY_TIME")));
            fsRow.set("ARCHIVE_LAST_ARCHIVE_DATE", (Object)((String)dmAuditTable.get("ARCHIVE_LAST_ARCHIVE_DATE")));
            dataObject.addRow(fsRow);
            CommonUtil.getPersistence(new boolean[0]).add(dataObject);
        } else {
            Row fsRow = dataObject.getFirstRow("AUDEMCDMDetails");
            fsRow.set("IS_ARCHIVE_ENABLED", dmAuditTable.get("IS_ARCHIVE_ENABLED"));
            fsRow.set("EVT_FILE_SHARE_PATH", dmAuditTable.get("EVT_FILE_SHARE_PATH"));
            fsRow.set("EVT_FILE_NAME", dmAuditTable.get("EVT_FILE_NAME"));
            fsRow.set("MSG_DLL_SHARE_PATH", dmAuditTable.get("MSG_DLL_SHARE_PATH"));
            fsRow.set("MSG_DLL_NAME", dmAuditTable.get("MSG_DLL_NAME"));
            fsRow.set("ARCHIVE_RETENTION_POLICY_SIZE", (Object)((String)dmAuditTable.get("ARCHIVE_RETENTION_POLICY_SIZE")));
            fsRow.set("ARCHIVE_RETENTION_POLICY_TIME", (Object)((String)dmAuditTable.get("ARCHIVE_RETENTION_POLICY_TIME")));
            fsRow.set("ARCHIVE_TRIGGER_POLICY_SIZE", (Object)((String)dmAuditTable.get("ARCHIVE_TRIGGER_POLICY_SIZE")));
            fsRow.set("ARCHIVE_TRIGGER_POLICY_TIME", (Object)((String)dmAuditTable.get("ARCHIVE_TRIGGER_POLICY_TIME")));
            fsRow.set("ARCHIVE_LAST_ARCHIVE_DATE", (Object)((String)dmAuditTable.get("ARCHIVE_LAST_ARCHIVE_DATE")));
            dataObject.updateRow(fsRow);
            CommonUtil.getPersistence(new boolean[0]).update(dataObject);
        }
    }

    public static synchronized Boolean isEFRunnningOnDM(Hashtable<String, Object> dmAuditTable) throws Exception {
        Criteria crit = new Criteria(Column.getColumn((String)"AUDEMCDMDetails", (String)"IS_VDM"), (Object)((Boolean)dmAuditTable.get("IS_VDM")), 0);
        Criteria crit3 = new Criteria(Column.getColumn((String)"AUDEMCDMDetails", (String)"EMC_STATION_IP_ADDRESS"), dmAuditTable.get("EMC_STATION_IP_ADDRESS"), 0);
        Criteria crit4 = new Criteria(Column.getColumn((String)"AUDEMCDMDetails", (String)"EMC_DM_ID"), dmAuditTable.get("EMC_DM_ID"), 0);
        crit = crit.and(crit3);
        crit = crit.and(crit4);
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDEMCDMDetails", crit);
        Boolean isEFRunning = null;
        if (!dataObject.isEmpty()) {
            Row fsRow = dataObject.getFirstRow("AUDEMCDMDetails");
            if (fsRow.get("IS_EF_RUNNING") == null || !((Boolean)fsRow.get("IS_EF_RUNNING")).booleanValue()) {
                fsRow.set("IS_EF_RUNNING", (Object)true);
                isEFRunning = false;
                dataObject.updateRow(fsRow);
                CommonUtil.getPersistence(new boolean[0]).update(dataObject);
            } else {
                isEFRunning = (Boolean)fsRow.get("IS_EF_RUNNING");
            }
        }
        return isEFRunning;
    }

    public static void updateEFROnDM(Hashtable<String, Object> dmAuditTable) throws Exception {
        if (dmAuditTable != null) {
            Criteria crit = new Criteria(Column.getColumn((String)"AUDEMCDMDetails", (String)"IS_VDM"), (Object)((Boolean)dmAuditTable.get("IS_VDM")), 0);
            Criteria crit3 = new Criteria(Column.getColumn((String)"AUDEMCDMDetails", (String)"EMC_STATION_IP_ADDRESS"), dmAuditTable.get("EMC_STATION_IP_ADDRESS"), 0);
            Criteria crit4 = new Criteria(Column.getColumn((String)"AUDEMCDMDetails", (String)"EMC_DM_ID"), dmAuditTable.get("EMC_DM_ID"), 0);
            crit = crit.and(crit3);
            crit = crit.and(crit4);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDEMCDMDetails", crit);
            Row fsRow = dataObject.getFirstRow("AUDEMCDMDetails");
            fsRow.set("IS_EF_RUNNING", (Object)false);
            dataObject.updateRow(fsRow);
            CommonUtil.getPersistence(new boolean[0]).update(dataObject);
        } else {
            Criteria crit = new Criteria(Column.getColumn((String)"AUDEMCDMDetails", (String)"EMC_DM_ID"), null, 1);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDEMCDMDetails", crit);
            if (!dataObject.isEmpty()) {
                Iterator iter = dataObject.getRows("AUDEMCDMDetails");
                while (iter.hasNext()) {
                    Row fsRow = (Row)iter.next();
                    fsRow.set("IS_EF_RUNNING", (Object)false);
                    dataObject.updateRow(fsRow);
                }
                CommonUtil.getPersistence(new boolean[0]).update(dataObject);
            }
        }
    }

    public static void updateLastReadEvtFileTime(Hashtable<String, Object> dmAuditTable, String evtFileTime) throws Exception {
        Criteria crit = new Criteria(Column.getColumn((String)"AUDEMCDMDetails", (String)"IS_VDM"), (Object)((Boolean)dmAuditTable.get("IS_VDM")), 0);
        Criteria crit3 = new Criteria(Column.getColumn((String)"AUDEMCDMDetails", (String)"EMC_STATION_IP_ADDRESS"), dmAuditTable.get("EMC_STATION_IP_ADDRESS"), 0);
        Criteria crit4 = new Criteria(Column.getColumn((String)"AUDEMCDMDetails", (String)"EMC_DM_ID"), dmAuditTable.get("EMC_DM_ID"), 0);
        crit = crit.and(crit3);
        crit = crit.and(crit4);
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDEMCDMDetails", crit);
        Row fsRow = dataObject.getFirstRow("AUDEMCDMDetails");
        logger.log(Level.INFO, "Existing Time is " + fsRow.get("LAST_READ_EVT_FILE_TIME"));
        Long time = (Long)fsRow.get("LAST_READ_EVT_FILE_TIME");
        Long lastReadFileTime = Long.parseLong(evtFileTime);
        if (lastReadFileTime > time) {
            fsRow.set("LAST_READ_EVT_FILE_TIME", (Object)lastReadFileTime);
            dataObject.updateRow(fsRow);
            CommonUtil.getPersistence(new boolean[0]).update(dataObject);
        }
    }

    public static ArrayList<String> getCIFSServerDetails(String domainName, String emcIP, Long dmID, String dmName, Boolean isVdm) throws Exception {
        Criteria crit = new Criteria(Column.getColumn((String)"AUDEMCCIFSDetails", (String)"EMC_STATION_IP_ADDRESS"), (Object)emcIP, 0);
        Criteria crit2 = new Criteria(Column.getColumn((String)"AUDEMCCIFSDetails", (String)"EMC_DM_ID"), (Object)dmID, 0);
        Criteria crit3 = new Criteria(Column.getColumn((String)"AUDEMCCIFSDetails", (String)"IS_VDM"), (Object)isVdm, 0);
        crit = crit.and(crit2);
        crit = crit.and(crit3);
        ArrayList<String> cifsServerList = new ArrayList<String>();
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDEMCCIFSDetails", crit);
        Iterator iter = dataObject.getRows("AUDEMCCIFSDetails");
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            cifsServerList.add((String)row.get("CIFS_SERVER"));
        }
        return cifsServerList;
    }

    public static String updateEMCServers(String domainName, String action, ArrayList<Long> msIDs, String timePeriodText) throws Exception {
        String message = null;
        Criteria criteria = null;
        Long[] id = null;
        logger.log(Level.INFO, "msIDs" + msIDs);
        if (msIDs != null) {
            id = new Long[msIDs.size()];
            for (int i = 0; i < id.length; ++i) {
                id[i] = msIDs.get(i);
            }
            criteria = new Criteria(Column.getColumn((String)"AUDComputerEventRead", (String)"COMPUTER_ID"), (Object)id, 8);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("AUDComputerEventRead", criteria);
            if (!dataObj.isEmpty()) {
                if (action.equalsIgnoreCase("Enable")) {
                    Integer licenseCount = MSHandler.getLicenseCount(131072);
                    logger.log(Level.INFO, "licenseCount is " + licenseCount);
                    int enableCount = ServerConfigAPI.getConfiguredServerCount(new int[]{256, 131072, 524288});
                    logger.log(Level.INFO, "enableCount is " + enableCount);
                    for (int i = 0; i < msIDs.size(); ++i) {
                        Criteria enableCrit = new Criteria(Column.getColumn((String)"AUDComputerEventRead", (String)"COMPUTER_ID"), (Object)msIDs.get(i), 0);
                        Row enableRow = dataObj.getRow("AUDComputerEventRead", enableCrit);
                        if (licenseCount > enableCount) {
                            int machineType = (Integer)enableRow.get("MACHINE_TYPE");
                            machineType |= 0x20000;
                            enableRow.set("MACHINE_TYPE", (Object)(machineType &= 0xFFFBFFFF));
                            message = rb.getString("adap.EMCHandler.event_collection_from_the_selected_EMC_Server_has_been_started");
                            dataObj.updateRow(enableRow);
                            ++enableCount;
                            CommonUtil.getPersistence(new boolean[0]).update(dataObj);
                            EventSchedulerUtil.enableDisableScheduler((Long)enableRow.get("SCHEDULE_ID"), "Enable");
                            continue;
                        }
                        message = licenseCount > 0 ? rb.handleGetObject("adap.EMCHandler.License_Level_Exceed_You_can_enable_only_limited_EMC_Server", new String[]{Integer.toString(licenseCount)}) : rb.getString("adap.LicenseUpgradeAction.You_are_using__licenseType");
                    }
                } else if (action.equalsIgnoreCase("Disable")) {
                    Iterator iter = dataObj.getRows("AUDComputerEventRead");
                    while (iter.hasNext()) {
                        Row row = (Row)iter.next();
                        int machineType = (Integer)row.get("MACHINE_TYPE");
                        machineType |= 0x40000;
                        row.set("MACHINE_TYPE", (Object)(machineType &= 0xFFFDFFFF));
                        dataObj.updateRow(row);
                        EventSchedulerUtil.enableDisableScheduler((Long)row.get("SCHEDULE_ID"), "Disable");
                    }
                    CommonUtil.getPersistence(new boolean[0]).update(dataObj);
                    message = rb.getString("adap.EMCHandler.event_collection_from_the_selected_EMC_Server_has_been_stopped");
                } else if (action.equalsIgnoreCase("Delete")) {
                    ArrayList<String> objectGuids = new ArrayList<String>();
                    FileServerHandler.deleteSharesForServers(id);
                    ArrayList<Long> deletedSchedule = new ArrayList<Long>();
                    Iterator iter = dataObj.getRows("AUDComputerEventRead");
                    while (iter.hasNext()) {
                        Row row = (Row)iter.next();
                        objectGuids.add((String)row.get("OBJECT_GUID"));
                        int machineType = (Integer)row.get("MACHINE_TYPE");
                        machineType &= 0xFFFDFFFF;
                        logger.log(Level.INFO, "machineType:" + (machineType &= 0xFFFBFFFF));
                        deletedSchedule.add((Long)row.get("SCHEDULE_ID"));
                    }
                    Criteria scheduleCrit = new Criteria(Column.getColumn((String)"Schedule", (String)"SCHEDULE_ID"), (Object)deletedSchedule.toArray(new Long[deletedSchedule.size()]), 8);
                    CommonUtil.getPersistenceLite().delete(scheduleCrit);
                    Criteria emcCrit = new Criteria(Column.getColumn((String)"AUDEMCCIFSDetails", (String)"OBJECT_GUID"), (Object)objectGuids.toArray(new String[objectGuids.size()]), 8);
                    CommonUtil.getPersistenceLite().delete(emcCrit);
                    EMCHandler.deleteDMAuditSettings();
                    GpoHandler.removeSecurityFilter(domainName, "ADAuditPlusPolicy", objectGuids.toArray(new String[objectGuids.size()]));
                    message = rb.getString("adap.AdminHandler.Successfully_Deleted");
                } else if (action.equalsIgnoreCase("timePeriodChange")) {
                    Long timePeriod = Long.parseLong(timePeriodText);
                    ArrayList<Long> schedule_id = new ArrayList<Long>();
                    Iterator iter = dataObj.getRows("AUDComputerEventRead");
                    while (iter.hasNext()) {
                        Row row = (Row)iter.next();
                        row.set("TIME_PERIOD", (Object)timePeriod);
                        dataObj.updateRow(row);
                        schedule_id.add((Long)row.get("SCHEDULE_ID"));
                    }
                    CommonUtil.getPersistence(new boolean[0]).update(dataObj);
                    message = rb.getString("adap.MSHandler.Successfully_Changed_the_Event_Fetch");
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("TIME_PERIOD", timePeriod);
                    map.put("UNIT_OF_TIME", "Minutes");
                    map.put("SCHEDULE_ID", schedule_id.toArray(new Long[schedule_id.size()]));
                    SchedulerUtil.updatePeriodicScheduler(map);
                }
            } else {
                message = "Data Object is empty";
            }
        }
        EventDataUtil.getComputerDetails(null, null);
        return message;
    }

    public static void deleteDMAuditSettings() throws Exception {
        Criteria crit5 = new Criteria(Column.getColumn((String)"AUDEMCDMDetails", (String)"EMC_DM_ID"), null, 1);
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDEMCDMDetails", crit5);
        ArrayList<Long> dmIdList = new ArrayList<Long>();
        if (!dataObject.isEmpty()) {
            Iterator iter = dataObject.getRows("AUDEMCDMDetails");
            while (iter.hasNext()) {
                Row fsRow = (Row)iter.next();
                Criteria crit = new Criteria(Column.getColumn((String)"AUDEMCCIFSDetails", (String)"IS_VDM"), (Object)((Boolean)fsRow.get("IS_VDM")), 0);
                Criteria crit3 = new Criteria(Column.getColumn((String)"AUDEMCCIFSDetails", (String)"EMC_STATION_IP_ADDRESS"), (Object)((String)fsRow.get("EMC_STATION_IP_ADDRESS")), 0);
                Criteria crit4 = new Criteria(Column.getColumn((String)"AUDEMCCIFSDetails", (String)"EMC_DM_ID"), (Object)((Long)fsRow.get("EMC_DM_ID")), 0);
                crit = crit.and(crit3);
                crit = crit.and(crit4);
                DataObject dataObject1 = CommonUtil.getPersistence(new boolean[0]).get("AUDEMCCIFSDetails", crit);
                if (!dataObject1.isEmpty()) continue;
                dmIdList.add((Long)fsRow.get("EMC_DM_UNIQUE_ID"));
            }
        }
        if (dmIdList.size() > 0) {
            Criteria emcCrit = new Criteria(Column.getColumn((String)"AUDEMCDMDetails", (String)"EMC_DM_UNIQUE_ID"), (Object)dmIdList.toArray(new Long[dmIdList.size()]), 8);
            CommonUtil.getPersistenceLite().delete(emcCrit);
        }
    }

    public static ArrayList<HashMap<String, Object>> getCifsDMDetailsEmber(Hashtable<String, Object> cifsTable) throws Exception {
        Criteria crit = new Criteria(Column.getColumn((String)"AUDEMCDMDetails", (String)"IS_VDM"), (Object)((Boolean)cifsTable.get("IS_VDM")), 0);
        Criteria crit2 = new Criteria(Column.getColumn((String)"AUDEMCDMDetails", (String)"DOMAIN_NAME"), (Object)((String)cifsTable.get("DOMAIN_NAME")), 0);
        Criteria crit3 = new Criteria(Column.getColumn((String)"AUDEMCDMDetails", (String)"EMC_STATION_IP_ADDRESS"), cifsTable.get("EMC_STATION_IP_ADDRESS"), 0);
        Criteria crit4 = new Criteria(Column.getColumn((String)"AUDEMCDMDetails", (String)"EMC_DM_ID"), cifsTable.get("EMC_DM_ID"), 0);
        crit = crit.and(crit2);
        crit = crit.and(crit3);
        crit = crit.and(crit4);
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDEMCDMDetails", crit);
        ArrayList<HashMap<String, Object>> rowList = new ArrayList<HashMap<String, Object>>();
        if (!dataObject.isEmpty()) {
            Row fsRow = dataObject.getFirstRow("AUDEMCDMDetails");
            cifsTable.put("IS_ARCHIVE_ENABLED", (Boolean)fsRow.get("IS_ARCHIVE_ENABLED"));
            cifsTable.put("EVT_FILE_SHARE_PATH", (String)fsRow.get("EVT_FILE_SHARE_PATH"));
            cifsTable.put("EVT_FILE_NAME", (String)fsRow.get("EVT_FILE_NAME"));
            cifsTable.put("MSG_DLL_SHARE_PATH", (String)fsRow.get("MSG_DLL_SHARE_PATH"));
            cifsTable.put("MSG_DLL_NAME", (String)fsRow.get("MSG_DLL_NAME"));
            cifsTable.put("LAST_READ_EVT_FILE_TIME", (Long)fsRow.get("LAST_READ_EVT_FILE_TIME"));
            if ((Boolean)fsRow.get("IS_EF_RUNNING") != null) {
                cifsTable.put("IS_EF_RUNNING", (Boolean)fsRow.get("IS_EF_RUNNING"));
            }
            if (fsRow.get("ARCHIVE_RETENTION_POLICY_SIZE") == null || fsRow.get("ARCHIVE_RETENTION_POLICY_SIZE").toString().equals("")) {
                cifsTable.put("ARCHIVE_RETENTION_POLICY_SIZE", "-");
            } else {
                cifsTable.put("ARCHIVE_RETENTION_POLICY_SIZE", (String)fsRow.get("ARCHIVE_RETENTION_POLICY_SIZE"));
            }
            if (fsRow.get("ARCHIVE_RETENTION_POLICY_TIME") == null || fsRow.get("ARCHIVE_RETENTION_POLICY_TIME").toString().equals("")) {
                cifsTable.put("ARCHIVE_RETENTION_POLICY_TIME", "-");
            } else {
                cifsTable.put("ARCHIVE_RETENTION_POLICY_TIME", (String)fsRow.get("ARCHIVE_RETENTION_POLICY_TIME"));
            }
            if (fsRow.get("ARCHIVE_TRIGGER_POLICY_SIZE") == null || fsRow.get("ARCHIVE_TRIGGER_POLICY_SIZE").toString().equals("")) {
                cifsTable.put("ARCHIVE_TRIGGER_POLICY_SIZE", "-");
            } else {
                cifsTable.put("ARCHIVE_TRIGGER_POLICY_SIZE", (String)fsRow.get("ARCHIVE_TRIGGER_POLICY_SIZE"));
            }
            if (fsRow.get("ARCHIVE_TRIGGER_POLICY_TIME") == null || fsRow.get("ARCHIVE_TRIGGER_POLICY_TIME").toString().equals("")) {
                cifsTable.put("ARCHIVE_TRIGGER_POLICY_TIME", "-");
            } else {
                cifsTable.put("ARCHIVE_TRIGGER_POLICY_TIME", (String)fsRow.get("ARCHIVE_TRIGGER_POLICY_TIME"));
            }
            if (fsRow.get("ARCHIVE_LAST_ARCHIVE_DATE") == null || fsRow.get("ARCHIVE_LAST_ARCHIVE_DATE").toString().equals("")) {
                cifsTable.put("ARCHIVE_LAST_ARCHIVE_DATE", "-");
            } else {
                cifsTable.put("ARCHIVE_LAST_ARCHIVE_DATE", (String)fsRow.get("ARCHIVE_LAST_ARCHIVE_DATE"));
            }
        }
        HashMap<String, Object> row1 = new HashMap<String, Object>();
        row1.put("NAME", rb.getString("adap.NetAppEventLogViewer.IS_ARCHIVE_ENABLED"));
        row1.put("VALUE", cifsTable.get("IS_ARCHIVE_ENABLED") == null ? "-" : cifsTable.get("IS_ARCHIVE_ENABLED"));
        HashMap<String, Object> row2 = new HashMap<String, Object>();
        row2.put("NAME", rb.getString("adap.NetAppEventLogViewer.EVT_FILE_LOCAL_PATH"));
        row2.put("VALUE", cifsTable.get("EVT_FILE_SHARE_PATH") == null ? "-" : cifsTable.get("EVT_FILE_SHARE_PATH"));
        HashMap<String, Object> row3 = new HashMap<String, Object>();
        row3.put("NAME", rb.getString("adap.NetAppEventLogViewer.MSG_DLL_LOCAL_PATH"));
        row3.put("VALUE", cifsTable.get("MSG_DLL_SHARE_PATH") == null ? "-" : cifsTable.get("MSG_DLL_SHARE_PATH"));
        HashMap<String, Object> row4 = new HashMap<String, Object>();
        row4.put("NAME", rb.getString("adap.NetAppEventLogViewer.ARCHIVE_RETENTION_POLICY_SIZE"));
        row4.put("VALUE", cifsTable.get("ARCHIVE_RETENTION_POLICY_SIZE") == null ? "-" : cifsTable.get("ARCHIVE_RETENTION_POLICY_SIZE"));
        HashMap<String, Object> row5 = new HashMap<String, Object>();
        row5.put("NAME", rb.getString("adap.NetAppEventLogViewer.ARCHIVE_RETENTION_POLICY_TIME"));
        row5.put("VALUE", cifsTable.get("ARCHIVE_RETENTION_POLICY_TIME") == null ? "-" : cifsTable.get("ARCHIVE_RETENTION_POLICY_TIME"));
        HashMap<String, Object> row6 = new HashMap<String, Object>();
        row6.put("NAME", rb.getString("adap.NetAppEventLogViewer.ARCHIVE_TRIGGER_POLICY_SIZE"));
        row6.put("VALUE", cifsTable.get("ARCHIVE_TRIGGER_POLICY_SIZE") == null ? "-" : cifsTable.get("ARCHIVE_TRIGGER_POLICY_SIZE"));
        HashMap<String, Object> row7 = new HashMap<String, Object>();
        row7.put("NAME", rb.getString("adap.NetAppEventLogViewer.ARCHIVE_TRIGGER_POLICY_TIME"));
        row7.put("VALUE", cifsTable.get("ARCHIVE_TRIGGER_POLICY_SIZE") == null ? "-" : cifsTable.get("ARCHIVE_TRIGGER_POLICY_SIZE"));
        HashMap<String, Object> row8 = new HashMap<String, Object>();
        row8.put("NAME", rb.getString("adap.NetAppEventLogViewer.ARCHIVE_LAST_ARCHIVE_DATE"));
        row8.put("VALUE", cifsTable.get("ARCHIVE_LAST_ARCHIVE_DATE") == null ? "-" : cifsTable.get("ARCHIVE_LAST_ARCHIVE_DATE"));
        HashMap<String, Object> row9 = new HashMap<String, Object>();
        row9.put("NAME", rb.getString("adap.NetAppEventLogViewer.IS_EF_RUNNING"));
        row9.put("VALUE", cifsTable.get("IS_EF_RUNNING") == null ? "-" : cifsTable.get("IS_EF_RUNNING"));
        HashMap<String, Object> row10 = new HashMap<String, Object>();
        row10.put("NAME", rb.getString("adap.NetAppEventLogViewer.LAST_READ_EVT_FILE_TIME"));
        row10.put("VALUE", cifsTable.get("LAST_READ_EVT_FILE_TIME") == null ? "-" : cifsTable.get("LAST_READ_EVT_FILE_TIME"));
        HashMap<String, Object> row11 = new HashMap<String, Object>();
        row11.put("NAME", rb.getString("adap.NetAppEventLogViewer.EMC_STATION_IP_ADDRESS"));
        row11.put("VALUE", cifsTable.get("EMC_STATION_IP_ADDRESS") == null ? "-" : cifsTable.get("EMC_STATION_IP_ADDRESS"));
        HashMap<String, Object> row12 = new HashMap<String, Object>();
        row12.put("NAME", rb.getString("adap.NetAppEventLogViewer.IS_VDM"));
        row12.put("VALUE", cifsTable.get("IS_VDM") == null ? "-" : cifsTable.get("IS_VDM"));
        HashMap<String, Object> row13 = new HashMap<String, Object>();
        row13.put("NAME", rb.getString("adap.NetAppEventLogViewer.EMC_DM_ID"));
        row13.put("VALUE", cifsTable.get("EMC_DM_ID") == null ? "-" : cifsTable.get("EMC_DM_ID"));
        HashMap<String, Object> row14 = new HashMap<String, Object>();
        row14.put("NAME", rb.getString("adap.NetAppEventLogViewer.CIFS_SERVER_IP_ADDRESS"));
        row14.put("VALUE", cifsTable.get("CIFS_SERVER_IP_ADDRESS") == null ? "-" : cifsTable.get("CIFS_SERVER_IP_ADDRESS"));
        rowList.add(row1);
        rowList.add(row2);
        rowList.add(row3);
        rowList.add(row4);
        rowList.add(row5);
        rowList.add(row6);
        rowList.add(row7);
        rowList.add(row8);
        rowList.add(row9);
        rowList.add(row10);
        rowList.add(row11);
        rowList.add(row12);
        rowList.add(row13);
        rowList.add(row14);
        return rowList;
    }

    public static JSONObject getCifsDetailsEmber(String objectGuid, String cifsServerName, String domainName) throws Exception {
        Criteria crit4 = new Criteria(Column.getColumn((String)"AUDEMCCIFSDetails", (String)"CIFS_SERVER"), (Object)cifsServerName, 0);
        Criteria crit2 = new Criteria(Column.getColumn((String)"AUDEMCCIFSDetails", (String)"DOMAIN_NAME"), (Object)domainName, 0);
        Criteria crit = new Criteria(Column.getColumn((String)"AUDEMCCIFSDetails", (String)"OBJECT_GUID"), (Object)objectGuid, 0);
        crit = crit.and(crit2);
        crit = crit.and(crit4);
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDEMCCIFSDetails", crit);
        JSONObject cifsTable = null;
        if (!dataObject.isEmpty()) {
            Row fsRow = dataObject.getFirstRow("AUDEMCCIFSDetails");
            cifsTable = new JSONObject();
            cifsTable.put("EMC_STATION_IP_ADDRESS", fsRow.get("EMC_STATION_IP_ADDRESS"));
            cifsTable.put("USER_NAME", (Object)fsRow.get("USER_NAME").toString());
            cifsTable.put("PASSWORD", (Object)fsRow.get("PASSWORD").toString());
            cifsTable.put("PORT_NO", (Object)((Integer)fsRow.get("PORT_NO")));
            cifsTable.put("CIFS_SERVER", (Object)fsRow.get("CIFS_SERVER").toString());
            cifsTable.put("OBJECT_GUID", (Object)fsRow.get("OBJECT_GUID").toString());
            cifsTable.put("DOMAIN_NAME", (Object)fsRow.get("DOMAIN_NAME").toString());
            cifsTable.put("pFilerName", fsRow.get("EMC_STATION_IP_ADDRESS"));
            cifsTable.put("userName", (Object)fsRow.get("USER_NAME").toString());
            cifsTable.put("password", (Object)fsRow.get("PASSWORD").toString());
            cifsTable.put("portNo", (Object)((Integer)fsRow.get("PORT_NO")));
            cifsTable.put("isSyncNetApp", true);
            cifsTable.put("machineType", 131072);
            if (fsRow.get("EMC_DM_ID") != null) {
                cifsTable.put("EMC_DM_ID", (Object)((Long)fsRow.get("EMC_DM_ID")));
            }
            if (fsRow.get("IS_VDM") != null) {
                cifsTable.put("IS_VDM", (Object)((Boolean)fsRow.get("IS_VDM")));
            }
            if (fsRow.get("CIFS_SERVER_IP_ADDRESS") != null) {
                cifsTable.put("CIFS_SERVER_IP_ADDRESS", (Object)((String)fsRow.get("CIFS_SERVER_IP_ADDRESS")));
            }
        }
        return cifsTable;
    }
}

