/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.fileaudit.netapp;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.AuditEventAPI;
import com.adventnet.sym.adsm.auditing.server.fileaudit.netapp.NetAppHandler;
import com.adventnet.sym.adsm.auditing.server.util.EventDataUtil;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.admin.ADSMPersUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NetAppEvtFileCopyHandler {
    private static Logger reportLogger = Logger.getLogger("ReportLogger");
    private static volatile NetAppEvtFileCopyHandler netappEvtCopyHandler = null;
    private static Hashtable<String, Boolean> netappServerTable = new Hashtable();

    private NetAppEvtFileCopyHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NetAppEvtFileCopyHandler getInstance() {
        if (netappEvtCopyHandler != null) return netappEvtCopyHandler;
        Class<NetAppEvtFileCopyHandler> clazz = NetAppEvtFileCopyHandler.class;
        synchronized (NetAppEvtFileCopyHandler.class) {
            if (netappEvtCopyHandler != null) return netappEvtCopyHandler;
            netappEvtCopyHandler = new NetAppEvtFileCopyHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return netappEvtCopyHandler;
        }
    }

    public void startEvtFleCopyThread() {
        try {
            Boolean netAppLargeServerSupport = Boolean.valueOf(ADSMPersUtil.getSyMParameter("NetAppLargeServerSupport"));
            if (netAppLargeServerSupport.booleanValue()) {
                Criteria criteria = new Criteria(Column.getColumn((String)"AUDComputerEventRead", (String)"MACHINE_TYPE"), (Object)256, 0);
                DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDComputerEventRead", criteria);
                if (!dataObject.isEmpty()) {
                    Iterator iterator = dataObject.getRows("AUDComputerEventRead");
                    while (iterator.hasNext()) {
                        Row row = (Row)iterator.next();
                        String objectGuid = (String)row.get("OBJECT_GUID");
                        Boolean status = netappServerTable.get(objectGuid);
                        if (!status.booleanValue()) {
                            netappServerTable.put(objectGuid, Boolean.TRUE);
                            this.startEvtFleCopyThread(objectGuid);
                            continue;
                        }
                        reportLogger.log(Level.INFO, "File Copy already running for :" + objectGuid);
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void startEvtFleCopyThread(String objectGuid) {
        try {
            NetAppEvtFileCopyThread evtFileCopyThread = new NetAppEvtFileCopyThread(objectGuid);
            evtFileCopyThread.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    class NetAppEvtFileCopyThread
    extends Thread {
        private String objectGuid = null;

        public NetAppEvtFileCopyThread(String objectGuid) {
            this.objectGuid = objectGuid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Criteria criteria = new Criteria(new Column("AUDComputerEventRead", "OBJECT_GUID"), (Object)this.objectGuid, 0);
                ArrayList<String> list = new ArrayList<String>();
                list.add("ADSMComputerGeneralDetails");
                list.add("AUDComputerEventRead");
                DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(list, criteria);
                if (!dataObject.isEmpty()) {
                    Boolean isDirectoryCreated;
                    Row row = dataObject.getRow("ADSMComputerGeneralDetails");
                    Row eventRow = dataObject.getRow("AUDComputerEventRead");
                    String domainName = (String)row.get("DOMAIN_NAME");
                    String computerName = (String)row.get("NAME");
                    String osVersion = (String)eventRow.get("OS_VERSION");
                    Integer machineType = (Integer)eventRow.get("MACHINE_TYPE");
                    Long recordNumber = EventDataUtil.getRecordNumber(computerName, domainName);
                    Long timeGenerated = EventDataUtil.getEventTime(computerName, domainName);
                    Properties netAppDetails = NetAppHandler.getNetAppOptions(this.objectGuid);
                    int[] eventIDArray = null;
                    eventIDArray = AuditEventAPI.getInstance().getAuditEvents(new String[]{"5"}, machineType);
                    Properties domainDetails = DomainHandler.getConfiguredValues(domainName, 1L);
                    String localNetAppDir = System.getProperty("server.dir") + File.separator + "webapps" + File.separator + "adap" + File.separator + "NetApp" + File.separator + computerName;
                    File directory = new File(localNetAppDir);
                    if (!directory.exists() && !(isDirectoryCreated = Boolean.valueOf(directory.mkdirs())).booleanValue()) {
                        reportLogger.log(Level.INFO, "Failed to create netapp directory:" + localNetAppDir);
                    }
                    if (directory.exists()) {
                        Integer filesCount = directory.listFiles().length;
                        reportLogger.log(Level.INFO, "FilesCount in local netapp directory:" + filesCount);
                        Integer netAppEvtFilesCount = Integer.valueOf(ADSMPersUtil.getSyMParameter("NetAppEvtFilesCount"));
                        Integer requiredCount = null;
                        if (netAppEvtFilesCount != null && netAppEvtFilesCount >= 0) {
                            requiredCount = netAppEvtFilesCount - filesCount;
                            reportLogger.log(Level.INFO, "RequiredFilesCount to copy" + requiredCount);
                            if (requiredCount > 0) {
                                ADHandler.copyNetAppEvtFiles(domainDetails, computerName, recordNumber + 1L, eventIDArray, machineType, osVersion, timeGenerated, netAppDetails, this.objectGuid, requiredCount);
                            }
                        } else {
                            requiredCount = netAppEvtFilesCount;
                            if (netAppEvtFilesCount == null) {
                                requiredCount = -1;
                            }
                            ADHandler.copyNetAppEvtFiles(domainDetails, computerName, recordNumber + 1L, eventIDArray, machineType, osVersion, timeGenerated, netAppDetails, this.objectGuid, requiredCount);
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                netappServerTable.put(this.objectGuid, false);
            }
        }
    }
}

