/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.fileaudit.netapp;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.config.ServerConfigAPI;
import com.adventnet.sym.adsm.auditing.server.delegation.GpoHandler;
import com.adventnet.sym.adsm.auditing.server.fileaudit.FileServerHandler;
import com.adventnet.sym.adsm.auditing.server.fileaudit.ModifySaclThread;
import com.adventnet.sym.adsm.auditing.server.fileaudit.netapp.NetAppVserver;
import com.adventnet.sym.adsm.auditing.server.fileaudit.netapp.NetAppVserverDBHandler;
import com.adventnet.sym.adsm.auditing.server.monitor.AudFileMonitorCriteriaHandler;
import com.adventnet.sym.adsm.auditing.server.util.EventDataUtil;
import com.adventnet.sym.adsm.auditing.server.util.EventSchedulerUtil;
import com.adventnet.sym.adsm.common.server.MSHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import com.adventnet.sym.adsm.common.server.util.SchedulerUtil;
import java.io.BufferedReader;
import java.io.StringReader;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLException;
import netapp.manage.NaAuthenticationException;
import netapp.manage.NaElement;
import netapp.manage.NaProtocolException;
import netapp.manage.NaServer;
import org.json.JSONObject;

public class NetAppHandler {
    private static Logger logger = Logger.getLogger(NetAppHandler.class.getName());
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private static String[] netAppAuditOptions = new String[]{"AUDNetAppAuditSettings:netapp_filer_audit_id:1007"};
    private static String[] audNetAppAuditSettingsDBColumns = new String[]{"IS_AUDIT_ENABLED", "IS_FILE_AUDIT_ENABLED", "IS_AUTO_SAVE_SIZE", "AUTO_SAVE_ONSIZE_THRESHOLD", "IS_AUTO_SAVE_TIME", "AUTO_SAVE_TIME_INTERVAL", "EVT_FILE_EXTENSION", "EVT_FILE_LIMIT", "AUDIT_LOG_SIZE", "IS_LIVE_VIEW"};
    private static HashMap<String, String> naVserverDefaultAuditConfig = null;
    private static HashMap<String, HashMap<String, String>> naVserverVolPath = new HashMap();
    private static final AdventNetResourceBundle RB = ResourceBundleMgr.getInstance().getBundle();

    public static String addNetAppFiler(Hashtable fsDetails) throws Exception {
        HashMap<String, Object> auditOptions;
        int fsMachineType;
        String message;
        block26: {
            message = "";
            String netappAuditMsg = rb.getString("adap.NetAppHandler.Error_while_enabling_netapp_audit_options");
            String divErrMsg = "<div id=\"commentForm\" style=\"display:block\"> <a class=\"greenlinktxt\" href=\"javascript:void(0)\" onclick=\"yreg_popLayer('updateNetAppDetails_";
            String divErrMsg1 = "',this, -75, 18) \">Click Here</a></div>";
            String objectGuid = (String)fsDetails.get("OBJECT_GUID");
            DataObject msObj = null;
            fsMachineType = 0;
            boolean isNetAppServer = ServerConfigAPI.isConfiguredNetAppFiler(objectGuid);
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDComputerEventRead", (String)"OBJECT_GUID"), (Object)objectGuid, 0);
            msObj = CommonUtil.getPersistence(new boolean[0]).get("AUDComputerEventRead", criteria);
            if (isNetAppServer) {
                ArrayList shareNameList = (ArrayList)fsDetails.get("LOCATIONS");
                ArrayList<String> conShareList = FileServerHandler.getConfiguredShares((String)fsDetails.get("serverName"), (String)fsDetails.get("domainName"));
                for (int i = 0; i < conShareList.size(); ++i) {
                    if (!shareNameList.contains(conShareList.get(i))) continue;
                    shareNameList.remove(conShareList.get(i));
                }
                fsDetails.put("LOCATIONS", shareNameList);
                message = rb.getString("adap.NetAppHandler.File_Shares_are_added_successfully_for_auditing");
            } else if (msObj == null || msObj.isEmpty()) {
                DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                Row fsRow = FileServerHandler.getFileServerRow(dataObj, fsDetails, 256);
                fsRow.set("OS_NAME", (Object)"Data ONTAP");
                fsRow.set("WINDOWS_DIR", (Object)"C:\\vol\\vol1\\etc");
                fsRow.set("OS_VERSION", (Object)"5.2");
                fsRow.set("OS_ARCHITECTURE", (Object)"32-bit");
                dataObj.addRow(fsRow);
                CommonUtil.getPersistence(new boolean[0]).add(dataObj);
                fsMachineType = (Integer)fsRow.get("MACHINE_TYPE");
                message = rb.getString("adap.NetAppHandler.Successfully_configured_NetApp_Filer");
            } else {
                Row fsRow = FileServerHandler.getFileServerRow(msObj, fsDetails, 256);
                fsRow.set("OS_NAME", (Object)"Data ONTAP");
                fsRow.set("WINDOWS_DIR", (Object)"C:\\vol\\vol1\\etc");
                fsRow.set("OS_VERSION", (Object)"5.2");
                fsRow.set("OS_ARCHITECTURE", (Object)"32-bit");
                msObj.updateRow(fsRow);
                CommonUtil.getPersistence(new boolean[0]).update(msObj);
                fsMachineType = (Integer)fsRow.get("MACHINE_TYPE");
                message = rb.getString("adap.NetAppHandler.Successfully_configured_NetApp_Filer");
            }
            if ((String)fsDetails.get("MESSAGE") != null) {
                message = (String)fsDetails.get("MESSAGE");
            }
            if (isNetAppServer) {
                AudFileMonitorCriteriaHandler.addFileServersShares((String)fsDetails.get("domainName"), (String)fsDetails.get("serverName"), (ArrayList)fsDetails.get("LOCATIONS"));
            } else {
                AudFileMonitorCriteriaHandler.addFileServersShares(fsDetails);
            }
            try {
                NetAppHandler.addNetAppDetails(fsDetails);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                message = ex.getMessage();
            }
            if (((String)fsDetails.get("IS_POLICY")).equalsIgnoreCase("true")) {
                try {
                    NetAppHandler.SetAuditSettings((String)fsDetails.get("PFILER_NAME"), (String)fsDetails.get("VFILER_NAME"), (String)fsDetails.get("USER_NAME"), (String)fsDetails.get("PASSWORD"), (Boolean)fsDetails.get("IS_VFILER"), (Boolean)fsDetails.get("IS_HTTP"), (Integer)fsDetails.get("PORT_NO"));
                }
                catch (NaAuthenticationException na) {
                    message = netappAuditMsg + rb.getString("adap.NetAppHandler.Bad_username_or_password") + divErrMsg + objectGuid + divErrMsg1;
                }
                catch (SocketException se) {
                    message = netappAuditMsg + rb.getString("adap.NetAppHandler.Unable_to_connect_the_netapp_filer_through_mentioned_port_protocol") + divErrMsg + objectGuid + divErrMsg1;
                }
                catch (NaProtocolException nap) {
                    message = netappAuditMsg + rb.getString("adap.NetAppHandler.Unable_to_connect_the_netapp_filer_through_mentioned_port_protocol") + divErrMsg + objectGuid + divErrMsg1;
                }
                catch (Throwable ex) {
                    if (ex.getMessage() != null) {
                        message = netappAuditMsg + ex.getMessage();
                    }
                }
            } else {
                message = rb.getString("adap.NetAppHandler.Netapp_audit_options_and_auditing_permissions");
            }
            if (((String)fsDetails.get("IS_SACL")).equalsIgnoreCase("true")) {
                new ModifySaclThread(fsDetails);
            }
            auditOptions = null;
            try {
                auditOptions = NetAppHandler.getAuditSettings((String)fsDetails.get("OBJECT_GUID"), (String)fsDetails.get("PFILER_NAME"), (String)fsDetails.get("VFILER_NAME"), (String)fsDetails.get("USER_NAME"), (String)fsDetails.get("PASSWORD"), (Boolean)fsDetails.get("IS_VFILER"), (Boolean)fsDetails.get("IS_HTTP"), (Integer)fsDetails.get("PORT_NO"));
            }
            catch (NaAuthenticationException na) {
                message = netappAuditMsg + rb.getString("adap.NetAppHandler.Bad_username_or_password") + divErrMsg + objectGuid + divErrMsg1;
            }
            catch (SocketException se) {
                message = netappAuditMsg + rb.getString("adap.NetAppHandler.Unable_to_connect_the_netapp_filer_through_mentioned_port_protocol") + divErrMsg + objectGuid + divErrMsg1;
            }
            catch (NaProtocolException nap) {
                message = netappAuditMsg + rb.getString("adap.NetAppHandler.Unable_to_connect_the_netapp_filer_through_mentioned_port_protocol") + divErrMsg + objectGuid + divErrMsg1;
            }
            catch (Throwable ex) {
                if (ex.getMessage() == null) break block26;
                message = netappAuditMsg + ex.getMessage();
            }
        }
        if (auditOptions != null) {
            NetAppHandler.updateAuditOptions((String)fsDetails.get("OBJECT_GUID"), auditOptions);
        }
        if ((fsMachineType & 0x100) == 256) {
            FileServerHandler.runEventScheduler((Long)fsDetails.get("SCHEDULE_ID"));
        }
        FileServerHandler.addFileUpdateDetails(fsDetails, false);
        EventDataUtil.getComputerDetails(null, null);
        return message;
    }

    public static HashMap<String, Object> addNetAppVserverEmber(NetAppVserver naVserver) throws Exception {
        String message = "";
        String objectGuid = naVserver.guid;
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        String msgType = "success";
        String linkMsg = null;
        try {
            boolean isSuccess;
            DataObject msObj = null;
            int fsMachineType = 0;
            boolean isNetAppServer = ServerConfigAPI.isConfiguredNetAppFiler(objectGuid);
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDComputerEventRead", (String)"OBJECT_GUID"), (Object)objectGuid, 0);
            msObj = CommonUtil.getPersistence(new boolean[0]).get("AUDComputerEventRead", criteria);
            if (isNetAppServer) {
                ArrayList<String> shareNameList = naVserver.shareLocations;
                ArrayList<String> conShareList = FileServerHandler.getConfiguredShares(naVserver.cifsHostName, naVserver.domainName);
                for (int i = 0; i < conShareList.size(); ++i) {
                    if (!shareNameList.contains(conShareList.get(i))) continue;
                    shareNameList.remove(conShareList.get(i));
                }
                naVserver.setShareLocations(shareNameList);
                message = rb.getString("adap.NetAppHandler.File_Shares_are_added_successfully_for_auditing");
            } else if (msObj == null || msObj.isEmpty()) {
                DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                Row fsRow = NetAppHandler.getNaVserverRow(dataObj, naVserver);
                dataObj.addRow(fsRow);
                CommonUtil.getPersistence(new boolean[0]).add(dataObj);
                fsMachineType = (Integer)fsRow.get("MACHINE_TYPE");
                message = rb.getString("adap.NetAppHandler.Successfully_configured_NetApp_Filer");
            } else {
                Row fsRow = NetAppHandler.getNaVserverRow(msObj, naVserver);
                msObj.updateRow(fsRow);
                CommonUtil.getPersistence(new boolean[0]).update(msObj);
                fsMachineType = (Integer)fsRow.get("MACHINE_TYPE");
                message = rb.getString("adap.NetAppHandler.Successfully_configured_NetApp_Filer");
            }
            if (naVserver.getHashtable().get("MESSAGE") != null) {
                message = (String)naVserver.getHashtable().get("MESSAGE");
            }
            if (isNetAppServer) {
                AudFileMonitorCriteriaHandler.addFileServersShares(naVserver.domainName, naVserver.cifsHostName, naVserver.shareLocations);
            } else {
                AudFileMonitorCriteriaHandler.addFileServersShares(naVserver.getHashtable());
            }
            if (naVserver.isApplyDefaultSaclPolicy.booleanValue()) {
                new ModifySaclThread(naVserver.getHashtable());
            }
            if (isSuccess = naVserver.updateEntryInDB().booleanValue()) {
                if (naVserver.isApplyDefaultAuditPolicy.booleanValue()) {
                    isSuccess = naVserver.applyAuditPolicyInDevice(true, true);
                }
                if (isSuccess) {
                    naVserver.syncAuditPolicyWithDevice(true);
                }
            }
            message = naVserver.errMessage;
            if ((fsMachineType & 0x80000) == 524288) {
                FileServerHandler.runEventScheduler((Long)naVserver.getHashtable().get("SCHEDULE_ID"));
            }
            FileServerHandler.addFileUpdateDetails(naVserver.getHashtable(), false);
            EventDataUtil.getComputerDetails(null, null);
            if (!message.toLowerCase().contains("successfully")) {
                msgType = "failure";
                linkMsg = rb.getString("adap.common.text.policy_update_link.click_here");
                retMap.put("linkMsg", linkMsg);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            message = ex.getMessage();
            msgType = "failure";
        }
        retMap.put("msgTxt", message);
        retMap.put("msgType", msgType);
        return retMap;
    }

    public static String addNetAppVserver(NetAppVserver naVserver) throws Exception {
        boolean isSuccess;
        String message = "";
        String objectGuid = naVserver.guid;
        DataObject msObj = null;
        int fsMachineType = 0;
        boolean isNetAppServer = ServerConfigAPI.isConfiguredNetAppFiler(objectGuid);
        Criteria criteria = new Criteria(Column.getColumn((String)"AUDComputerEventRead", (String)"OBJECT_GUID"), (Object)objectGuid, 0);
        msObj = CommonUtil.getPersistence(new boolean[0]).get("AUDComputerEventRead", criteria);
        if (isNetAppServer) {
            ArrayList<String> shareNameList = naVserver.shareLocations;
            ArrayList<String> conShareList = FileServerHandler.getConfiguredShares(naVserver.cifsHostName, naVserver.domainName);
            for (int i = 0; i < conShareList.size(); ++i) {
                if (!shareNameList.contains(conShareList.get(i))) continue;
                shareNameList.remove(conShareList.get(i));
            }
            naVserver.setShareLocations(shareNameList);
            message = rb.getString("adap.NetAppHandler.File_Shares_are_added_successfully_for_auditing");
        } else if (msObj == null || msObj.isEmpty()) {
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Row fsRow = NetAppHandler.getNaVserverRow(dataObj, naVserver);
            dataObj.addRow(fsRow);
            CommonUtil.getPersistence(new boolean[0]).add(dataObj);
            fsMachineType = (Integer)fsRow.get("MACHINE_TYPE");
            message = rb.getString("adap.NetAppHandler.Successfully_configured_NetApp_Filer");
        } else {
            Row fsRow = NetAppHandler.getNaVserverRow(msObj, naVserver);
            msObj.updateRow(fsRow);
            CommonUtil.getPersistence(new boolean[0]).update(msObj);
            fsMachineType = (Integer)fsRow.get("MACHINE_TYPE");
            message = rb.getString("adap.NetAppHandler.Successfully_configured_NetApp_Filer");
        }
        if (naVserver.getHashtable().get("MESSAGE") != null) {
            message = (String)naVserver.getHashtable().get("MESSAGE");
        }
        if (isNetAppServer) {
            AudFileMonitorCriteriaHandler.addFileServersShares(naVserver.domainName, naVserver.cifsHostName, naVserver.shareLocations);
        } else {
            AudFileMonitorCriteriaHandler.addFileServersShares(naVserver.getHashtable());
        }
        if (naVserver.isApplyDefaultSaclPolicy.booleanValue()) {
            new ModifySaclThread(naVserver.getHashtable());
        }
        if (isSuccess = naVserver.updateEntryInDB().booleanValue()) {
            if (naVserver.isApplyDefaultAuditPolicy.booleanValue()) {
                isSuccess = naVserver.applyAuditPolicyInDevice(true, true);
            }
            if (isSuccess) {
                naVserver.syncAuditPolicyWithDevice(true);
            }
        }
        message = naVserver.errMessage;
        if ((fsMachineType & 0x80000) == 524288) {
            FileServerHandler.runEventScheduler((Long)naVserver.getHashtable().get("SCHEDULE_ID"));
        }
        FileServerHandler.addFileUpdateDetails(naVserver.getHashtable(), false);
        EventDataUtil.getComputerDetails(null, null);
        return message;
    }

    public static Row getNaVserverRow(DataObject dataObj, NetAppVserver naVserver) throws Exception {
        Row fsRow = FileServerHandler.getFileServerRow(dataObj, naVserver.getHashtable(), 524288);
        fsRow.set("OS_NAME", (Object)"Data ONTAP Cluster");
        fsRow.set("WINDOWS_DIR", (Object)("\\\\" + naVserver.cifsHostName + "\\c$\\"));
        fsRow.set("OS_VERSION", (Object)"6.0");
        fsRow.set("EVENT_FETCH_MODE", (Object)1);
        return fsRow;
    }

    public static HashMap<String, String> getNaVserverDefaultAuditConfig() {
        if (naVserverDefaultAuditConfig == null) {
            naVserverDefaultAuditConfig = new HashMap();
            naVserverDefaultAuditConfig.put("EVT_VOLUME_NAME", "cifs_audit_log");
            naVserverDefaultAuditConfig.put("EVT_VOLUME_SIZE", "3GB");
            naVserverDefaultAuditConfig.put("EVT_FILE_JUNCTION_PATH", "/cifs_audit_log");
            naVserverDefaultAuditConfig.put("EVT_FILE_FORMAT", "evtx");
            naVserverDefaultAuditConfig.put("EVT_FILE_NAME", "audit_.evtx");
            naVserverDefaultAuditConfig.put("MSG_DLL_FILE", "netappCMAuditMsg.dll");
            naVserverDefaultAuditConfig.put("ROTATE_TYPE", "size");
            naVserverDefaultAuditConfig.put("ROTATE_LIMIT", "10");
            naVserverDefaultAuditConfig.put("ROTATE_SIZE", "209715200");
            naVserverDefaultAuditConfig.put("ROTATE_SIZE_STR", "200MB");
        }
        return naVserverDefaultAuditConfig;
    }

    public static void addNetAppDetails(Hashtable netAppDetails) throws Throwable {
        try {
            String objectGuid = (String)netAppDetails.get("OBJECT_GUID");
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDNetAppFilerDetails", (String)"OBJECT_GUID"), (Object)objectGuid, 0);
            DataObject nfObj = CommonUtil.getPersistence(new boolean[0]).get("AUDNetAppFilerDetails", criteria);
            Row row = null;
            if (nfObj.isEmpty()) {
                row = new Row("AUDNetAppFilerDetails");
                row.set("OBJECT_GUID", netAppDetails.get("OBJECT_GUID"));
                row.set("USER_NAME", netAppDetails.get("USER_NAME"));
                row.set("PASSWORD", netAppDetails.get("PASSWORD"));
                row.set("EVT_FILE_SHARE_PATH", netAppDetails.get("EVT_FILE_SHARE_PATH"));
                row.set("EVT_FILE_NAME", netAppDetails.get("EVT_FILE_NAME"));
                row.set("MSG_DLL_SHARE_PATH", netAppDetails.get("MSG_DLL_SHARE_PATH"));
                row.set("MSG_DLL_NAME", netAppDetails.get("MSG_DLL_NAME"));
                row.set("PFILER_NAME", netAppDetails.get("PFILER_NAME"));
                row.set("VFILER_NAME", netAppDetails.get("VFILER_NAME"));
                row.set("IS_VFILER", (Object)((Boolean)netAppDetails.get("IS_VFILER")));
                row.set("PORT_NO", (Object)((Integer)netAppDetails.get("PORT_NO")));
                row.set("IS_HTTP", (Object)((Boolean)netAppDetails.get("IS_HTTP")));
                nfObj.addRow(row);
            } else {
                row = nfObj.getRow("AUDNetAppFilerDetails");
                row.set("USER_NAME", netAppDetails.get("USER_NAME"));
                row.set("PASSWORD", netAppDetails.get("PASSWORD"));
                row.set("EVT_FILE_SHARE_PATH", netAppDetails.get("EVT_FILE_SHARE_PATH"));
                row.set("EVT_FILE_NAME", netAppDetails.get("EVT_FILE_NAME"));
                row.set("MSG_DLL_SHARE_PATH", netAppDetails.get("MSG_DLL_SHARE_PATH"));
                row.set("MSG_DLL_NAME", netAppDetails.get("MSG_DLL_NAME"));
                row.set("PFILER_NAME", netAppDetails.get("PFILER_NAME"));
                row.set("VFILER_NAME", netAppDetails.get("VFILER_NAME"));
                row.set("IS_VFILER", (Object)((Boolean)netAppDetails.get("IS_VFILER")));
                row.set("PORT_NO", (Object)((Integer)netAppDetails.get("PORT_NO")));
                row.set("IS_HTTP", (Object)((Boolean)netAppDetails.get("IS_HTTP")));
                nfObj.updateRow(row);
            }
            CommonUtil.getPersistence(new boolean[0]).update(nfObj);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void updateLastReadEvtFileTime(String filerGuid, String evtFileTime) {
        try {
            Criteria criteria2 = new Criteria(Column.getColumn((String)"AUDNetAppFilerDetails", (String)"OBJECT_GUID"), (Object)filerGuid, 0);
            DataObject nfObj = CommonUtil.getPersistence(new boolean[0]).get("AUDNetAppFilerDetails", criteria2);
            if (!nfObj.isEmpty()) {
                Row row = nfObj.getRow("AUDNetAppFilerDetails");
                logger.log(Level.INFO, "Existing Time is " + row.get("LAST_READ_EVT_FILE_TIME"));
                Long time = (Long)row.get("LAST_READ_EVT_FILE_TIME");
                Long lastReadFileTime = Long.parseLong(evtFileTime);
                if (lastReadFileTime > time) {
                    row.set("LAST_READ_EVT_FILE_TIME", (Object)lastReadFileTime);
                    nfObj.updateRow(row);
                    CommonUtil.getPersistence(new boolean[0]).update(nfObj);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String updateNetAppFilers(String domainName, String action, ArrayList msIDs, String timePeriodText) throws Exception {
        String message = null;
        Criteria criteria = null;
        Long[] id = null;
        logger.log(Level.INFO, "msIDs" + msIDs);
        if (msIDs != null) {
            id = new Long[msIDs.size()];
            for (int i = 0; i < id.length; ++i) {
                id[i] = (Long)msIDs.get(i);
            }
            criteria = new Criteria(Column.getColumn((String)"AUDComputerEventRead", (String)"COMPUTER_ID"), (Object)id, 8);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("AUDComputerEventRead", criteria);
            if (!dataObj.isEmpty()) {
                if (action.equalsIgnoreCase("Enable")) {
                    Integer licenseCount = MSHandler.getLicenseCount(256);
                    logger.log(Level.INFO, "licenseCount is " + licenseCount);
                    int enableCount = ServerConfigAPI.getConfiguredServerCount(new int[]{256, 524288, 131072});
                    logger.log(Level.INFO, "enableCount is " + enableCount);
                    for (int i = 0; i < msIDs.size(); ++i) {
                        Criteria enableCrit = new Criteria(Column.getColumn((String)"AUDComputerEventRead", (String)"COMPUTER_ID"), msIDs.get(i), 0);
                        Row enableRow = dataObj.getRow("AUDComputerEventRead", enableCrit);
                        if (licenseCount > enableCount) {
                            int machineType = (Integer)enableRow.get("MACHINE_TYPE");
                            if ((machineType & 0x100000) == 0x100000) {
                                machineType |= 0x80000;
                                machineType &= 0xFFEFFFFF;
                            } else {
                                machineType |= 0x100;
                                machineType &= 0xFFFFFDFF;
                            }
                            enableRow.set("MACHINE_TYPE", (Object)machineType);
                            message = rb.getString("adap.NetAppHandler.event_collection_from_the_selected_NetApp_Filer_has_been_started");
                            dataObj.updateRow(enableRow);
                            ++enableCount;
                            CommonUtil.getPersistence(new boolean[0]).update(dataObj);
                            EventSchedulerUtil.enableDisableScheduler((Long)enableRow.get("SCHEDULE_ID"), "Enable");
                            continue;
                        }
                        message = licenseCount > 0 ? rb.handleGetObject("adap.MSHandler.License_Level_Exceed_You_can_enable_only_limited_NetApp_Filer", new String[]{Integer.toString(licenseCount)}) : rb.getString("adap.LicenseUpgradeAction.You_are_using__licenseType");
                    }
                } else if (action.equalsIgnoreCase("Disable")) {
                    Iterator iter = dataObj.getRows("AUDComputerEventRead");
                    while (iter.hasNext()) {
                        Row row = (Row)iter.next();
                        int machineType = (Integer)row.get("MACHINE_TYPE");
                        if ((machineType & 0x80000) == 524288) {
                            machineType |= 0x100000;
                            machineType &= 0xFFF7FFFF;
                        } else {
                            machineType |= 0x200;
                            machineType &= 0xFFFFFEFF;
                        }
                        row.set("MACHINE_TYPE", (Object)machineType);
                        dataObj.updateRow(row);
                        EventSchedulerUtil.enableDisableScheduler((Long)row.get("SCHEDULE_ID"), "Disable");
                    }
                    CommonUtil.getPersistence(new boolean[0]).update(dataObj);
                    message = rb.getString("adap.NetAppHandler.event_collection_from_the_selected_NetApp_Filer_has_been_stopped");
                } else if (action.equalsIgnoreCase("Delete")) {
                    ArrayList<String> objectGuids = new ArrayList<String>();
                    FileServerHandler.deleteSharesForServers(id);
                    ArrayList<Long> deletedSchedule = new ArrayList<Long>();
                    Iterator iter = dataObj.getRows("AUDComputerEventRead");
                    while (iter.hasNext()) {
                        Row row = (Row)iter.next();
                        objectGuids.add((String)row.get("OBJECT_GUID"));
                        int machineType = (Integer)row.get("MACHINE_TYPE");
                        machineType &= 0xFFFFFEFF;
                        logger.log(Level.INFO, "machineType:" + (machineType &= 0xFFFFFDFF));
                        deletedSchedule.add((Long)row.get("SCHEDULE_ID"));
                    }
                    Criteria scheduleCrit = new Criteria(Column.getColumn((String)"Schedule", (String)"SCHEDULE_ID"), (Object)deletedSchedule.toArray(new Long[deletedSchedule.size()]), 8);
                    CommonUtil.getPersistenceLite().delete(scheduleCrit);
                    NetAppHandler.deleteNetAppAuditDetails(objectGuids.toArray(new String[objectGuids.size()]));
                    NetAppVserverDBHandler.deleteEntry(objectGuids.toArray(new String[objectGuids.size()]));
                    GpoHandler.removeSecurityFilter(domainName, "ADAuditPlusPolicy", objectGuids.toArray(new String[objectGuids.size()]));
                    message = rb.getString("adap.AdminHandler.Successfully_Deleted");
                } else if (action.equalsIgnoreCase("timePeriodChange")) {
                    Long timePeriod = Long.parseLong(timePeriodText);
                    ArrayList<Long> schedule_id = new ArrayList<Long>();
                    Iterator iter = dataObj.getRows("AUDComputerEventRead");
                    while (iter.hasNext()) {
                        Row row = (Row)iter.next();
                        row.set("TIME_PERIOD", (Object)timePeriod);
                        dataObj.updateRow(row);
                        schedule_id.add((Long)row.get("SCHEDULE_ID"));
                    }
                    CommonUtil.getPersistence(new boolean[0]).update(dataObj);
                    message = rb.getString("adap.MSHandler.Successfully_Changed_the_Event_Fetch");
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("TIME_PERIOD", timePeriod);
                    map.put("UNIT_OF_TIME", "Minutes");
                    map.put("SCHEDULE_ID", schedule_id.toArray(new Long[schedule_id.size()]));
                    SchedulerUtil.updatePeriodicScheduler(map);
                }
            } else {
                message = "Data Object is empty";
            }
        }
        EventDataUtil.getComputerDetails(null, null);
        return message;
    }

    public static HashMap[] getNetAppAuditOptions() throws Exception {
        ArrayList list = new ArrayList();
        try {
            Long[] uvhValues = null;
            uvhValues = DBObjectUtil.getUVHValues("AUDNetAppAuditSettings", netAppAuditOptions);
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDNetAppAuditSettings", (String)"NETAPP_FILER_AUDIT_ID"), (Object)uvhValues, 8);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDNetAppAuditSettings", criteria);
            if (!dataObject.isEmpty()) {
                Row optionRow = dataObject.getFirstRow("AUDNetAppAuditSettings");
                HashMap<String, String> map = new HashMap<String, String>();
                HashMap<String, Object> map2 = new HashMap<String, Object>();
                for (String string : audNetAppAuditSettingsDBColumns) {
                    Object DBValue = optionRow.get(string);
                    String val = null;
                    String key = null;
                    val = DBValue.toString();
                    if (string.equals("EVT_FILE_EXTENSION")) {
                        key = "cifs.audit.autosave.file.extension";
                    } else if (string.equals("EVT_FILE_LIMIT")) {
                        key = "cifs.audit.autosave.file.limit";
                    } else if (string.equals("IS_AUDIT_ENABLED")) {
                        key = "cifs.audit.enable";
                    } else if (string.equals("IS_FILE_AUDIT_ENABLED")) {
                        key = "cifs.audit.file_access_events.enable";
                    } else if (string.equals("IS_AUTO_SAVE_SIZE")) {
                        key = "cifs.audit.autosave.onsize.enable";
                    } else if (string.equals("AUTO_SAVE_ONSIZE_THRESHOLD")) {
                        key = "cifs.audit.autosave.onsize.threshold";
                    } else if (string.equals("IS_AUTO_SAVE_TIME")) {
                        key = "cifs.audit.autosave.ontime.enable";
                    } else if (string.equals("AUTO_SAVE_TIME_INTERVAL")) {
                        key = "cifs.audit.autosave.ontime.interval";
                    } else if (string.equals("AUDIT_LOG_SIZE")) {
                        key = "cifs.audit.logsize";
                    } else if (string.equals("IS_LIVE_VIEW")) {
                        key = "cifs.audit.liveview.enable";
                    }
                    map.put(key, val);
                    map2.put(string, DBValue);
                }
                list.add(map);
                list.add(map2);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        HashMap[] maps = list.toArray(new HashMap[list.size()]);
        return maps;
    }

    public static void SetAuditSettings(String pFilerName, String vFilerName, String userName, String password, Boolean isVfiler, Boolean isHttp, Integer portNo) throws Exception {
        NaElement xi = null;
        NaElement argsarray = null;
        NaElement xo = null;
        try (NaServer s = null;){
            s = new NaServer(pFilerName, 1, 7);
            s.setStyle(1);
            s.setAdminUser(userName, password);
            if (isHttp.booleanValue()) {
                s.setTransportType(1);
                s.setPort(portNo.intValue());
            } else {
                s.setTransportType(2);
                s.setPort(portNo.intValue());
            }
            HashMap[] keyValuesMap = NetAppHandler.getNetAppAuditOptions();
            Set keyValueSet = keyValuesMap[0].keySet();
            for (String key : keyValueSet) {
                String keyValue = (String)keyValuesMap[0].get(key);
                xi = new NaElement("system-cli");
                argsarray = new NaElement("args");
                if (isVfiler.booleanValue()) {
                    argsarray.addNewChild("arg", "vfiler");
                    argsarray.addNewChild("arg", "run");
                    argsarray.addNewChild("arg", vFilerName);
                }
                argsarray.addNewChild("arg", "options");
                argsarray.addNewChild("arg", key);
                argsarray.addNewChild("arg", keyValue);
                xi.addChildElem(argsarray);
                try {
                    xo = s.invokeElem(xi);
                }
                catch (SSLException se) {
                    logger.log(Level.INFO, "NetAppHandler.SetAuditSettings SSLException : Trying SSLv3...");
                    s.enableSSLv3();
                    s.disableTLS();
                    xo = s.invokeElem(xi);
                }
                String output = xo.getChildContent("cli-output");
                logger.log(Level.INFO, "output:" + output);
                if (!output.contains("Vfiler not found")) continue;
                throw new Exception("The given vfiler is not found");
            }
        }
    }

    public static HashMap<String, Object> getAuditSettings(String objectGuid, String pFilerName, String vFilerName, String userName, String password, Boolean isVfiler, Boolean isHttp, Integer portNo) throws Exception {
        HashMap<String, Object> auditOptions;
        block15: {
            auditOptions = null;
            try (NaServer s = null;){
                NaElement xo;
                s = new NaServer(pFilerName, 1, 7);
                s.setStyle(1);
                s.setAdminUser(userName, password);
                if (isHttp.booleanValue()) {
                    s.setTransportType(1);
                    s.setPort(portNo.intValue());
                } else {
                    s.setTransportType(2);
                    s.setPort(portNo.intValue());
                }
                s.setServerType(1);
                if (isVfiler.booleanValue()) {
                    NaElement xo2;
                    NaElement xi = new NaElement("system-cli");
                    NaElement argsarray = new NaElement("args");
                    argsarray.addNewChild("arg", "vfiler");
                    argsarray.addNewChild("arg", "run");
                    argsarray.addNewChild("arg", vFilerName);
                    argsarray.addNewChild("arg", "options");
                    argsarray.addNewChild("arg", "cifs.audit");
                    xi.addChildElem(argsarray);
                    try {
                        xo2 = s.invokeElem(xi);
                    }
                    catch (SSLException se) {
                        logger.log(Level.INFO, "NetAppHandler.getAuditSettings SSLException : Trying SSLv3...");
                        s.enableSSLv3();
                        s.disableTLS();
                        xo2 = s.invokeElem(xi);
                    }
                    auditOptions = new HashMap();
                    String output = xo2.getChildContent("cli-output");
                    String Inline = null;
                    logger.log(Level.INFO, "output:" + output);
                    if (output.contains("Vfiler not found")) {
                        throw new Exception("The given vfiler is not found");
                    }
                    BufferedReader bfre = new BufferedReader(new StringReader(output));
                    while ((Inline = bfre.readLine()) != null) {
                        String[] tokens = Inline.split("\\s+");
                        if (tokens.length < 2 || tokens[0] == null || tokens[1] == null) continue;
                        NetAppHandler.setOnMap(tokens[0], tokens[1], auditOptions);
                    }
                    break block15;
                }
                NaElement xi = new NaElement("options-list-info");
                try {
                    xo = s.invokeElem(xi);
                }
                catch (SSLException se) {
                    logger.log(Level.INFO, "NetAppHandler.getAuditSettings SSLException : Trying SSLv3...");
                    s.enableSSLv3();
                    s.disableTLS();
                    xo = s.invokeElem(xi);
                }
                auditOptions = new HashMap<String, Object>();
                List optionList = xo.getChildByName("options").getChildren();
                for (NaElement optionInfo : optionList) {
                    String name = optionInfo.getChildContent("name");
                    String value = optionInfo.getChildContent("value");
                    if (name == null || value == null) continue;
                    NetAppHandler.setOnMap(name, value, auditOptions);
                }
            }
        }
        return auditOptions;
    }

    public static void setOnMap(String name, String value, HashMap<String, Object> auditOptions) throws Exception {
        if (name.equals("cifs.audit.enable")) {
            if (value.equalsIgnoreCase("on")) {
                auditOptions.put("IS_AUDIT_ENABLED", true);
            } else if (value.equalsIgnoreCase("off")) {
                auditOptions.put("IS_AUDIT_ENABLED", false);
            }
        } else if (name.equals("cifs.audit.file_access_events.enable")) {
            if (value.equalsIgnoreCase("on")) {
                auditOptions.put("IS_FILE_AUDIT_ENABLED", true);
            } else if (value.equalsIgnoreCase("off")) {
                auditOptions.put("IS_FILE_AUDIT_ENABLED", false);
            }
        } else if (name.equals("cifs.audit.autosave.file.extension")) {
            auditOptions.put("EVT_FILE_EXTENSION", value);
        } else if (name.equals("cifs.audit.autosave.file.limit")) {
            auditOptions.put("EVT_FILE_LIMIT", Long.parseLong(value));
        } else if (name.equals("cifs.audit.autosave.onsize.enable")) {
            if (value.equalsIgnoreCase("on")) {
                auditOptions.put("IS_AUTO_SAVE_SIZE", true);
            } else if (value.equalsIgnoreCase("off")) {
                auditOptions.put("IS_AUTO_SAVE_SIZE", false);
            }
        } else if (name.equals("cifs.audit.autosave.onsize.threshold")) {
            if (value != null) {
                auditOptions.put("AUTO_SAVE_ONSIZE_THRESHOLD", value);
            }
        } else if (name.equals("cifs.audit.autosave.ontime.enable")) {
            if (value.equalsIgnoreCase("on")) {
                auditOptions.put("IS_AUTO_SAVE_TIME", true);
            } else if (value.equalsIgnoreCase("off")) {
                auditOptions.put("IS_AUTO_SAVE_TIME", false);
            }
        } else if (name.equals("cifs.audit.autosave.ontime.interval")) {
            auditOptions.put("AUTO_SAVE_TIME_INTERVAL", value);
        } else if (name.equals("cifs.audit.logsize")) {
            auditOptions.put("AUDIT_LOG_SIZE", Long.parseLong(value));
        } else if (name.equals("cifs.audit.liveview.enable")) {
            if (value.equalsIgnoreCase("on")) {
                auditOptions.put("IS_LIVE_VIEW", true);
            } else if (value.equalsIgnoreCase("off")) {
                auditOptions.put("IS_LIVE_VIEW", false);
            }
        }
    }

    public static boolean isAuditEnabled(String objectGuid) throws Exception {
        Boolean isAuditEnabled;
        block4: {
            isAuditEnabled = false;
            try {
                Criteria criteria2 = new Criteria(Column.getColumn((String)"AUDNetAppFilerDetails", (String)"OBJECT_GUID"), (Object)objectGuid, 0);
                DataObject nfObj = CommonUtil.getPersistence(new boolean[0]).get("AUDNetAppFilerDetails", criteria2);
                if (nfObj.isEmpty()) break block4;
                Row row = nfObj.getRow("AUDNetAppFilerDetails");
                HashMap[] keyValuesMap = NetAppHandler.getNetAppAuditOptions();
                Set keyValueSet = keyValuesMap[1].keySet();
                for (String key : keyValueSet) {
                    Object DBValue;
                    Object keyValue = keyValuesMap[1].get(key);
                    if (!keyValue.equals(DBValue = row.get(key))) {
                        isAuditEnabled = false;
                        break;
                    }
                    isAuditEnabled = true;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return isAuditEnabled;
    }

    public static void updateAuditOptions(String objectGuid, HashMap auditOptions) throws Exception {
        try {
            Criteria criteria2 = new Criteria(Column.getColumn((String)"AUDNetAppFilerDetails", (String)"OBJECT_GUID"), (Object)objectGuid, 0);
            DataObject nfObj = CommonUtil.getPersistence(new boolean[0]).get("AUDNetAppFilerDetails", criteria2);
            if (!nfObj.isEmpty()) {
                Row row = nfObj.getRow("AUDNetAppFilerDetails");
                if (row != null) {
                    Set keyValueSet = auditOptions.keySet();
                    for (String key : keyValueSet) {
                        Object keyValue = auditOptions.get(key);
                        row.set(key, keyValue);
                    }
                    nfObj.updateRow(row);
                }
                CommonUtil.getPersistence(new boolean[0]).update(nfObj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void deleteNetAppAuditDetails(String[] objectGuid) throws Exception {
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDNetAppFilerDetails", (String)"OBJECT_GUID"), (Object)objectGuid, 8);
            CommonUtil.getPersistenceLite().delete(criteria);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Properties getNetAppDetails(String filerGUID) throws Exception {
        Properties netApp = new Properties();
        try {
            Criteria criteria2 = new Criteria(Column.getColumn((String)"AUDNetAppFilerDetails", (String)"OBJECT_GUID"), (Object)filerGUID, 0);
            DataObject nfObj = CommonUtil.getPersistence(new boolean[0]).get("AUDNetAppFilerDetails", criteria2);
            if (!nfObj.isEmpty()) {
                Row row = nfObj.getRow("AUDNetAppFilerDetails");
                netApp.put("OBJECT_GUID", (String)row.get("OBJECT_GUID"));
                netApp.put("EVT_FILE_SHARE_PATH", (String)row.get("EVT_FILE_SHARE_PATH"));
                netApp.put("EVT_FILE_NAME", (String)row.get("EVT_FILE_NAME"));
                netApp.put("MSG_DLL_SHARE_PATH", (String)row.get("MSG_DLL_SHARE_PATH"));
                netApp.put("MSG_DLL_NAME", (String)row.get("MSG_DLL_NAME"));
                netApp.put("PFILER_NAME", (String)row.get("PFILER_NAME"));
                netApp.put("IS_VFILER", (Boolean)row.get("IS_VFILER"));
                netApp.put("USER_NAME", (String)row.get("USER_NAME"));
                netApp.put("PASSWORD", (String)row.get("PASSWORD"));
                netApp.put("LAST_READ_EVT_FILE_TIME", ((Long)row.get("LAST_READ_EVT_FILE_TIME")).toString());
                netApp.put("IS_HTTP", (Boolean)row.get("IS_HTTP"));
                netApp.put("PORT_NO", (Integer)row.get("PORT_NO"));
                Boolean isAutoSave = null;
                Boolean autoSaveSize = (Boolean)row.get("IS_AUTO_SAVE_SIZE");
                Boolean autoSaveTime = (Boolean)row.get("IS_AUTO_SAVE_TIME");
                if (autoSaveSize != null && autoSaveSize.booleanValue() || autoSaveTime != null && autoSaveTime.booleanValue()) {
                    isAutoSave = true;
                } else if (autoSaveSize != null && !autoSaveSize.booleanValue() && autoSaveTime != null && !autoSaveTime.booleanValue()) {
                    isAutoSave = false;
                }
                if (isAutoSave != null) {
                    netApp.put("IS_AUTO_SAVE_REQUIRED", isAutoSave.toString());
                }
                boolean isAuditEnabled = NetAppHandler.isAuditEnabled(filerGUID);
                netApp.put("IS_NETAPP_AUDIT_ENABLED", (Object)isAuditEnabled);
                if (row.get("VFILER_NAME") != null) {
                    netApp.put("VFILER_NAME", (String)row.get("VFILER_NAME"));
                }
                if (row.get("EVT_FILE_EXTENSION") != null) {
                    netApp.put("EVT_FILE_EXTENSION", (String)row.get("EVT_FILE_EXTENSION"));
                }
                if (row.get("EVT_FILE_LIMIT") != null) {
                    netApp.put("EVT_FILE_LIMIT", (Long)row.get("EVT_FILE_LIMIT"));
                }
                if (row.get("IS_AUTO_SAVE_SIZE") != null) {
                    netApp.put("IS_AUTO_SAVE_SIZE", ((Boolean)row.get("IS_AUTO_SAVE_SIZE")).toString());
                }
                if (row.get("IS_AUTO_SAVE_TIME") != null) {
                    netApp.put("IS_AUTO_SAVE_TIME", ((Boolean)row.get("IS_AUTO_SAVE_TIME")).toString());
                }
                if (row.get("AUTO_SAVE_TIME_INTERVAL") != null) {
                    netApp.put("AUTO_SAVE_TIME_INTERVAL", (String)row.get("AUTO_SAVE_TIME_INTERVAL"));
                }
                if (row.get("AUTO_SAVE_ONSIZE_THRESHOLD") != null) {
                    netApp.put("AUTO_SAVE_ONSIZE_THRESHOLD", (String)row.get("AUTO_SAVE_ONSIZE_THRESHOLD"));
                }
                if (row.get("IS_AUDIT_ENABLED") != null) {
                    netApp.put("IS_AUDIT_ENABLED", ((Boolean)row.get("IS_AUDIT_ENABLED")).toString());
                }
                if (row.get("IS_FILE_AUDIT_ENABLED") != null) {
                    netApp.put("IS_FILE_AUDIT_ENABLED", ((Boolean)row.get("IS_FILE_AUDIT_ENABLED")).toString());
                }
                if (row.get("AUDIT_LOG_SIZE") != null) {
                    netApp.put("AUDIT_LOG_SIZE", ((Long)row.get("AUDIT_LOG_SIZE")).toString());
                }
                if (row.get("IS_LIVE_VIEW") != null) {
                    netApp.put("IS_LIVE_VIEW", ((Boolean)row.get("IS_LIVE_VIEW")).toString());
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return netApp;
    }

    public static Properties getNetAppOptions(String filerGUID) throws Exception {
        Boolean isUpdated = true;
        String netappAuditMsg = rb.getString("adap.NetAppHandler.Error_while_enabling_netapp_audit_options");
        Properties netAppDetails = NetAppHandler.getNetAppDetails(filerGUID);
        if (netAppDetails.get("IS_AUTO_SAVE_REQUIRED") == null) {
            isUpdated = false;
        } else if (((String)netAppDetails.get("IS_AUTO_SAVE_REQUIRED")).equals("true") && (netAppDetails.get("EVT_FILE_EXTENSION") == null || netAppDetails.get("EVT_FILE_LIMIT") == null)) {
            isUpdated = false;
        }
        if (!isUpdated.booleanValue()) {
            HashMap<String, Object> auditOptions;
            block12: {
                auditOptions = null;
                try {
                    auditOptions = NetAppHandler.getAuditSettings((String)netAppDetails.get("OBJECT_GUID"), (String)netAppDetails.get("PFILER_NAME"), (String)netAppDetails.get("VFILER_NAME"), (String)netAppDetails.get("USER_NAME"), (String)netAppDetails.get("PASSWORD"), (Boolean)netAppDetails.get("IS_VFILER"), (Boolean)netAppDetails.get("IS_HTTP"), (Integer)netAppDetails.get("PORT_NO"));
                }
                catch (NaAuthenticationException na) {
                    netappAuditMsg = netappAuditMsg + rb.getString("adap.NetAppHandler.Bad_username_or_password");
                }
                catch (SocketException se) {
                    netappAuditMsg = netappAuditMsg + rb.getString("adap.NetAppHandler.Unable_to_connect_the_netapp_filer_through_mentioned_port_protocol");
                }
                catch (NaProtocolException nap) {
                    netappAuditMsg = netappAuditMsg + rb.getString("adap.NetAppHandler.Unable_to_connect_the_netapp_filer_through_mentioned_port_protocol");
                }
                catch (Throwable ex) {
                    if (ex.getMessage() == null) break block12;
                    netappAuditMsg = netappAuditMsg + ex.getMessage();
                }
            }
            if (auditOptions != null) {
                NetAppHandler.updateAuditOptions((String)netAppDetails.get("OBJECT_GUID"), auditOptions);
            }
            if ((netAppDetails = NetAppHandler.getNetAppDetails(filerGUID)).get("IS_AUTO_SAVE_REQUIRED") == null) {
                throw new Exception(netappAuditMsg);
            }
            if (((String)netAppDetails.get("IS_AUTO_SAVE_REQUIRED")).equals("true") && (netAppDetails.get("EVT_FILE_EXTENSION") == null || netAppDetails.get("EVT_FILE_LIMIT") == null)) {
                throw new Exception(netappAuditMsg);
            }
        }
        return netAppDetails;
    }

    public static void saveEvtFile(String objectGuid, String pFilerName, String vFilerName, String userName, String password, Boolean isVfiler, Boolean isHttp, Integer portNo) throws Exception {
        NaElement xi = null;
        NaElement argsarray = null;
        NaElement xo = null;
        try (NaServer s = null;){
            s = new NaServer(pFilerName, 1, 7);
            s.setStyle(1);
            s.setAdminUser(userName, password);
            if (isHttp.booleanValue()) {
                s.setTransportType(1);
                s.setPort(portNo.intValue());
            } else {
                s.setTransportType(2);
                s.setPort(portNo.intValue());
            }
            logger.log(Level.INFO, "Saving Evt File");
            xi = new NaElement("system-cli");
            argsarray = new NaElement("args");
            if (isVfiler.booleanValue()) {
                argsarray.addNewChild("arg", "vfiler");
                argsarray.addNewChild("arg", "run");
                argsarray.addNewChild("arg", vFilerName);
            }
            argsarray.addNewChild("arg", "cifs");
            argsarray.addNewChild("arg", "audit");
            argsarray.addNewChild("arg", "save");
            argsarray.addNewChild("arg", "-f");
            xi.addChildElem(argsarray);
            try {
                xo = s.invokeElem(xi);
            }
            catch (SSLException se) {
                logger.log(Level.INFO, "NetAppHandler.saveEvtFile SSLException : Trying SSLv3...");
                s.enableSSLv3();
                s.disableTLS();
                xo = s.invokeElem(xi);
            }
            logger.log(Level.INFO, "Status is" + xo.getAttr("status"));
        }
    }

    public static void generateEvtFile(String objectGuid) throws Exception {
        Properties netAppDetails = NetAppHandler.getNetAppDetails(objectGuid);
        NetAppHandler.saveEvtFile((String)netAppDetails.get("OBJECT_GUID"), (String)netAppDetails.get("PFILER_NAME"), (String)netAppDetails.get("VFILER_NAME"), (String)netAppDetails.get("USER_NAME"), (String)netAppDetails.get("PASSWORD"), (Boolean)netAppDetails.get("IS_VFILER"), (Boolean)netAppDetails.get("IS_HTTP"), (Integer)netAppDetails.get("PORT_NO"));
    }

    public static int[] getMachineTypes(String fileServerType, String action) {
        int[] machineTypes = new int[]{};
        if (fileServerType.equalsIgnoreCase("NetApp Server")) {
            machineTypes = action.equalsIgnoreCase("Enable") ? new int[]{256, 524288} : (action.equalsIgnoreCase("Disable") ? new int[]{512, 0x100000} : new int[]{256, 512, 524288, 0x100000});
        } else if (fileServerType.equalsIgnoreCase("EMC Server")) {
            machineTypes = action.equalsIgnoreCase("Enable") ? new int[]{131072} : (action.equalsIgnoreCase("Disable") ? new int[]{262144} : new int[]{131072, 262144});
        }
        return machineTypes;
    }

    public static void updateNaVserverVolPaths(String domainName, String cifsServerName) throws Exception {
        if (domainName != null && cifsServerName != null) {
            NetAppVserver naVserver = new NetAppVserver(null, domainName, cifsServerName);
            naVserverVolPath.put((domainName + cifsServerName).toLowerCase(), naVserver.fetchVolumeJuncPaths());
        }
    }

    public static void setNaVserverVolPaths(String domainName, String cifsServerName, HashMap<String, String> volPaths) {
        if (domainName != null && cifsServerName != null && volPaths != null && !volPaths.isEmpty()) {
            naVserverVolPath.put((domainName + cifsServerName).toLowerCase(), volPaths);
        }
    }

    public static String getNaVserverVolPath(String domainName, String cifsServerName, String volName) throws Exception {
        String juncPath = null;
        if (domainName != null && cifsServerName != null && volName != null) {
            if (naVserverVolPath.get((domainName + cifsServerName).toLowerCase()) == null || naVserverVolPath.get((domainName + cifsServerName).toLowerCase()).get(volName) == null) {
                logger.log(Level.INFO, "Netapp junction path for volume not found, querying the device...(domainName : " + domainName + ", cifsServerName : " + cifsServerName + ", volName : " + volName);
                NetAppHandler.updateNaVserverVolPaths(domainName, cifsServerName);
            }
            if (naVserverVolPath.get((domainName + cifsServerName).toLowerCase()) != null) {
                juncPath = naVserverVolPath.get((domainName + cifsServerName).toLowerCase()).get(volName);
            }
        }
        return juncPath;
    }

    public static boolean setNaVserverEventObjJuncPath(Hashtable<String, Object> eventTable, boolean isNewUnc) {
        boolean isSuccess = false;
        String objJuncPath = null;
        String objectName = null;
        objectName = isNewUnc ? (String)eventTable.get("NEW_UNC_NAME") : (String)eventTable.get(RB.getString("adap.AUDRuleVariables.variable_name.Object_Name"));
        if (objectName == null) {
            return false;
        }
        if (objectName.startsWith("/")) {
            objJuncPath = objectName;
        } else {
            String volJuncPath = (String)eventTable.get("VolumeJunctionPath");
            if (volJuncPath == null) {
                String volName = objectName.substring(1, objectName.indexOf(");"));
                try {
                    volJuncPath = NetAppHandler.getNaVserverVolPath((String)eventTable.get("DomainName"), (String)eventTable.get("DomainController"), volName);
                    eventTable.put("VolumeJunctionPath", volJuncPath);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (volJuncPath != null) {
                volJuncPath = volJuncPath.equals("/") ? "" : volJuncPath;
                objJuncPath = objectName.replaceFirst(".*\\);", volJuncPath);
            }
        }
        if (objJuncPath != null) {
            eventTable.put(isNewUnc ? "NEW_UNC_NAME" : "OBJECT_JUNC_PATH", objJuncPath);
            isSuccess = true;
        }
        return isSuccess;
    }

    public static JSONObject getNetAppDetailsEmber(String filerGUID) throws Exception {
        JSONObject netApp = new JSONObject();
        try {
            Criteria criteria2 = new Criteria(Column.getColumn((String)"AUDNetAppFilerDetails", (String)"OBJECT_GUID"), (Object)filerGUID, 0);
            DataObject nfObj = CommonUtil.getPersistence(new boolean[0]).get("AUDNetAppFilerDetails", criteria2);
            if (!nfObj.isEmpty()) {
                Row row = nfObj.getRow("AUDNetAppFilerDetails");
                netApp.put("OBJECT_GUID", (Object)((String)row.get("OBJECT_GUID")));
                netApp.put("evtFileSharePath", (Object)((String)row.get("EVT_FILE_SHARE_PATH")));
                netApp.put("EVT_FILE_NAME", (Object)((String)row.get("EVT_FILE_NAME")));
                netApp.put("msgDllPath", (Object)((String)row.get("MSG_DLL_SHARE_PATH")));
                netApp.put("MSG_DLL_NAME", (Object)((String)row.get("MSG_DLL_NAME")));
                netApp.put("pFilerName", (Object)((String)row.get("PFILER_NAME")));
                netApp.put("isVfiler", (Object)((Boolean)row.get("IS_VFILER")));
                netApp.put("userName", (Object)((String)row.get("USER_NAME")));
                netApp.put("password", (Object)((String)row.get("PASSWORD")));
                netApp.put("LAST_READ_EVT_FILE_TIME", (Object)((Long)row.get("LAST_READ_EVT_FILE_TIME")).toString());
                if (((Boolean)row.get("IS_HTTP")).booleanValue()) {
                    netApp.put("protocol", (Object)"http");
                } else {
                    netApp.put("protocol", (Object)"https");
                }
                netApp.put("portNo", (Object)((Integer)row.get("PORT_NO")));
                netApp.put("isSyncNetApp", true);
                netApp.put("isConfigAudit", true);
                netApp.put("machineType", 256);
                Boolean isAutoSave = null;
                Boolean autoSaveSize = (Boolean)row.get("IS_AUTO_SAVE_SIZE");
                Boolean autoSaveTime = (Boolean)row.get("IS_AUTO_SAVE_TIME");
                String evtPath = (String)netApp.get("evtFileSharePath") + netApp.get("EVT_FILE_NAME").toString();
                netApp.put("evtFileSharePath", (Object)evtPath);
                if (autoSaveSize != null && autoSaveSize.booleanValue() || autoSaveTime != null && autoSaveTime.booleanValue()) {
                    isAutoSave = true;
                } else if (autoSaveSize != null && !autoSaveSize.booleanValue() && autoSaveTime != null && !autoSaveTime.booleanValue()) {
                    isAutoSave = false;
                }
                if (isAutoSave != null) {
                    netApp.put("IS_AUTO_SAVE_REQUIRED", (Object)isAutoSave.toString());
                }
                boolean isAuditEnabled = NetAppHandler.isAuditEnabled(filerGUID);
                netApp.put("isAuditEnabled", isAuditEnabled);
                if (row.get("VFILER_NAME") != null) {
                    netApp.put("VFILER_NAME", (Object)((String)row.get("VFILER_NAME")));
                    netApp.put("vFilerName", (Object)((String)row.get("VFILER_NAME")));
                }
                if (row.get("EVT_FILE_EXTENSION") != null) {
                    netApp.put("EVT_FILE_EXTENSION", (Object)((String)row.get("EVT_FILE_EXTENSION")));
                }
                if (row.get("EVT_FILE_LIMIT") != null) {
                    netApp.put("EVT_FILE_LIMIT", (Object)((Long)row.get("EVT_FILE_LIMIT")));
                }
                if (row.get("IS_AUTO_SAVE_SIZE") != null) {
                    netApp.put("IS_AUTO_SAVE_SIZE", (Object)((Boolean)row.get("IS_AUTO_SAVE_SIZE")).toString());
                }
                if (row.get("IS_AUTO_SAVE_TIME") != null) {
                    netApp.put("IS_AUTO_SAVE_TIME", (Object)((Boolean)row.get("IS_AUTO_SAVE_TIME")).toString());
                }
                if (row.get("AUTO_SAVE_TIME_INTERVAL") != null) {
                    netApp.put("AUTO_SAVE_TIME_INTERVAL", (Object)((String)row.get("AUTO_SAVE_TIME_INTERVAL")));
                }
                if (row.get("AUTO_SAVE_ONSIZE_THRESHOLD") != null) {
                    netApp.put("AUTO_SAVE_ONSIZE_THRESHOLD", (Object)((String)row.get("AUTO_SAVE_ONSIZE_THRESHOLD")));
                }
                if (row.get("IS_AUDIT_ENABLED") != null) {
                    netApp.put("IS_AUDIT_ENABLED", (Object)((Boolean)row.get("IS_AUDIT_ENABLED")).toString());
                }
                if (row.get("IS_FILE_AUDIT_ENABLED") != null) {
                    netApp.put("IS_FILE_AUDIT_ENABLED", (Object)((Boolean)row.get("IS_FILE_AUDIT_ENABLED")).toString());
                }
                if (row.get("AUDIT_LOG_SIZE") != null) {
                    netApp.put("AUDIT_LOG_SIZE", (Object)((Long)row.get("AUDIT_LOG_SIZE")).toString());
                }
                if (row.get("IS_LIVE_VIEW") != null) {
                    netApp.put("IS_LIVE_VIEW", (Object)((Boolean)row.get("IS_LIVE_VIEW")).toString());
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return netApp;
    }

    public static ArrayList<HashMap<String, Object>> getNetAppAuditSettings(String filerGUID) throws Exception {
        Properties netApp = new Properties();
        ArrayList<HashMap<String, Object>> rowList = new ArrayList<HashMap<String, Object>>();
        try {
            Criteria criteria2 = new Criteria(Column.getColumn((String)"AUDNetAppFilerDetails", (String)"OBJECT_GUID"), (Object)filerGUID, 0);
            DataObject nfObj = CommonUtil.getPersistence(new boolean[0]).get("AUDNetAppFilerDetails", criteria2);
            if (!nfObj.isEmpty()) {
                HashMap<String, String> row0 = new HashMap<String, String>();
                HashMap<String, Object> row1 = new HashMap<String, Object>();
                HashMap<String, Object> row2 = new HashMap<String, Object>();
                HashMap<String, Object> row3 = new HashMap<String, Object>();
                HashMap<String, String> row4 = new HashMap<String, String>();
                HashMap<String, Object> row5 = new HashMap<String, Object>();
                HashMap<String, Object> row6 = new HashMap<String, Object>();
                HashMap<String, Object> row7 = new HashMap<String, Object>();
                HashMap<String, Object> row8 = new HashMap<String, Object>();
                HashMap<String, Object> row9 = new HashMap<String, Object>();
                HashMap<String, Object> row10 = new HashMap<String, Object>();
                row0.put("NAME", "CIFS SERVER TYPE");
                row0.put("VALUE", "7 MODE(VFILER)");
                Row row = nfObj.getRow("AUDNetAppFilerDetails");
                Boolean isAutoSave = null;
                Boolean autoSaveSize = (Boolean)row.get("IS_AUTO_SAVE_SIZE");
                Boolean autoSaveTime = (Boolean)row.get("IS_AUTO_SAVE_TIME");
                if (autoSaveSize != null && autoSaveSize.booleanValue() || autoSaveTime != null && autoSaveTime.booleanValue()) {
                    isAutoSave = true;
                } else if (autoSaveSize != null && !autoSaveSize.booleanValue() && autoSaveTime != null && !autoSaveTime.booleanValue()) {
                    isAutoSave = false;
                }
                if (isAutoSave != null) {
                    netApp.put("IS_AUTO_SAVE_REQUIRED", isAutoSave.toString());
                }
                boolean isAuditEnabled = NetAppHandler.isAuditEnabled(filerGUID);
                netApp.put("isAuditEnabled", (Object)isAuditEnabled);
                if (row.get("VFILER_NAME") != null) {
                    netApp.put("VFILER_NAME", (String)row.get("VFILER_NAME"));
                }
                row4.put("NAME", "EVT_FILE_EXTENSION");
                if (row.get("EVT_FILE_EXTENSION") != null) {
                    row4.put("VALUE", (String)row.get("EVT_FILE_EXTENSION"));
                } else {
                    row4.put("VALUE", "");
                }
                row1.put("NAME", "EVT_FILE_LIMIT");
                row1.put("VALUE", row.get("EVT_FILE_LIMIT") == null ? "" : row.get("EVT_FILE_LIMIT"));
                row5.put("NAME", "IS_AUTO_SAVE_SIZE");
                row5.put("VALUE", row.get("IS_AUTO_SAVE_SIZE") == null ? "" : row.get("IS_AUTO_SAVE_SIZE"));
                row9.put("NAME", "IS_AUTO_SAVE_TIME");
                row9.put("VALUE", row.get("IS_AUTO_SAVE_TIME") == null ? "" : row.get("IS_AUTO_SAVE_TIME"));
                row3.put("NAME", "AUTO_SAVE_TIME_INTERVAL");
                row3.put("VALUE", row.get("AUTO_SAVE_TIME_INTERVAL") == null ? "" : row.get("AUTO_SAVE_TIME_INTERVAL"));
                row8.put("NAME", "AUTO_SAVE_ONSIZE_THRESHOLD");
                row8.put("VALUE", row.get("EVT_FILE_LIMIT") == null ? "" : row.get("EVT_FILE_LIMIT"));
                row2.put("NAME", "IS_AUDIT_ENABLED");
                row2.put("VALUE", row.get("IS_AUDIT_ENABLED") == null ? "" : row.get("IS_AUDIT_ENABLED"));
                row7.put("NAME", "IS_FILE_AUDIT_ENABLED");
                row7.put("VALUE", row.get("IS_FILE_AUDIT_ENABLED") == null ? "" : row.get("IS_FILE_AUDIT_ENABLED"));
                row10.put("NAME", "AUDIT_LOG_SIZE");
                row10.put("VALUE", row.get("AUDIT_LOG_SIZE") == null ? "" : row.get("AUDIT_LOG_SIZE"));
                row6.put("NAME", "IS_LIVE_VIEW");
                row6.put("VALUE", row.get("IS_LIVE_VIEW") == null ? "" : row.get("IS_LIVE_VIEW"));
                rowList.add(row0);
                rowList.add(row1);
                rowList.add(row2);
                rowList.add(row3);
                rowList.add(row4);
                rowList.add(row5);
                rowList.add(row6);
                rowList.add(row7);
                rowList.add(row8);
                rowList.add(row9);
                rowList.add(row10);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return rowList;
    }

    public static HashMap<String, Object> addNetAppFilerEmber(Hashtable<String, Object> fsDetails) throws Exception {
        String message = "";
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        String msgType = "success";
        String linkMsg = null;
        try {
            HashMap<String, Object> auditOptions;
            int fsMachineType;
            block29: {
                String netappAuditMsg = rb.getString("adap.NetAppHandler.Error_while_enabling_netapp_audit_options");
                String objectGuid = (String)fsDetails.get("OBJECT_GUID");
                DataObject msObj = null;
                fsMachineType = 0;
                boolean isNetAppServer = ServerConfigAPI.isConfiguredNetAppFiler(objectGuid);
                Criteria criteria = new Criteria(Column.getColumn((String)"AUDComputerEventRead", (String)"OBJECT_GUID"), (Object)objectGuid, 0);
                msObj = CommonUtil.getPersistence(new boolean[0]).get("AUDComputerEventRead", criteria);
                if (isNetAppServer) {
                    ArrayList shareNameList = (ArrayList)fsDetails.get("LOCATIONS");
                    ArrayList<String> conShareList = FileServerHandler.getConfiguredShares((String)fsDetails.get("serverName"), (String)fsDetails.get("domainName"));
                    for (int i = 0; i < conShareList.size(); ++i) {
                        if (!shareNameList.contains(conShareList.get(i))) continue;
                        shareNameList.remove(conShareList.get(i));
                    }
                    fsDetails.put("LOCATIONS", shareNameList);
                    message = rb.getString("adap.NetAppHandler.File_Shares_are_added_successfully_for_auditing");
                } else if (msObj == null || msObj.isEmpty()) {
                    DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                    Row fsRow = FileServerHandler.getFileServerRow(dataObj, fsDetails, 256);
                    fsRow.set("OS_NAME", (Object)"Data ONTAP");
                    fsRow.set("WINDOWS_DIR", (Object)"C:\\vol\\vol1\\etc");
                    fsRow.set("OS_VERSION", (Object)"5.2");
                    fsRow.set("OS_ARCHITECTURE", (Object)"32-bit");
                    dataObj.addRow(fsRow);
                    CommonUtil.getPersistence(new boolean[0]).add(dataObj);
                    fsMachineType = (Integer)fsRow.get("MACHINE_TYPE");
                    message = rb.getString("adap.NetAppHandler.Successfully_configured_NetApp_Filer");
                } else {
                    Row fsRow = FileServerHandler.getFileServerRow(msObj, fsDetails, 256);
                    fsRow.set("OS_NAME", (Object)"Data ONTAP");
                    fsRow.set("WINDOWS_DIR", (Object)"C:\\vol\\vol1\\etc");
                    fsRow.set("OS_VERSION", (Object)"5.2");
                    fsRow.set("OS_ARCHITECTURE", (Object)"32-bit");
                    msObj.updateRow(fsRow);
                    CommonUtil.getPersistence(new boolean[0]).update(msObj);
                    fsMachineType = (Integer)fsRow.get("MACHINE_TYPE");
                    message = rb.getString("adap.NetAppHandler.Successfully_configured_NetApp_Filer");
                }
                if ((String)fsDetails.get("MESSAGE") != null) {
                    message = (String)fsDetails.get("MESSAGE");
                }
                if (isNetAppServer) {
                    AudFileMonitorCriteriaHandler.addFileServersShares((String)fsDetails.get("domainName"), (String)fsDetails.get("serverName"), (ArrayList)fsDetails.get("LOCATIONS"));
                } else {
                    AudFileMonitorCriteriaHandler.addFileServersShares(fsDetails);
                }
                try {
                    NetAppHandler.addNetAppDetails(fsDetails);
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    message = ex.getMessage();
                }
                if (((String)fsDetails.get("IS_POLICY")).equalsIgnoreCase("true")) {
                    try {
                        NetAppHandler.SetAuditSettings((String)fsDetails.get("PFILER_NAME"), (String)fsDetails.get("VFILER_NAME"), (String)fsDetails.get("USER_NAME"), (String)fsDetails.get("PASSWORD"), (Boolean)fsDetails.get("IS_VFILER"), (Boolean)fsDetails.get("IS_HTTP"), (Integer)fsDetails.get("PORT_NO"));
                    }
                    catch (NaAuthenticationException na) {
                        message = netappAuditMsg + rb.getString("adap.NetAppHandler.Bad_username_or_password");
                    }
                    catch (SocketException se) {
                        message = netappAuditMsg + rb.getString("adap.NetAppHandler.Unable_to_connect_the_netapp_filer_through_mentioned_port_protocol");
                    }
                    catch (NaProtocolException nap) {
                        message = netappAuditMsg + rb.getString("adap.NetAppHandler.Unable_to_connect_the_netapp_filer_through_mentioned_port_protocol");
                    }
                    catch (Throwable ex) {
                        if (ex.getMessage() != null) {
                            message = netappAuditMsg + ex.getMessage();
                        }
                    }
                } else {
                    message = rb.getString("adap.NetAppHandler.Netapp_audit_options_and_auditing_permissions");
                }
                if (((String)fsDetails.get("IS_SACL")).equalsIgnoreCase("true")) {
                    new ModifySaclThread(fsDetails);
                }
                auditOptions = null;
                try {
                    auditOptions = NetAppHandler.getAuditSettings((String)fsDetails.get("OBJECT_GUID"), (String)fsDetails.get("PFILER_NAME"), (String)fsDetails.get("VFILER_NAME"), (String)fsDetails.get("USER_NAME"), (String)fsDetails.get("PASSWORD"), (Boolean)fsDetails.get("IS_VFILER"), (Boolean)fsDetails.get("IS_HTTP"), (Integer)fsDetails.get("PORT_NO"));
                }
                catch (NaAuthenticationException na) {
                    message = netappAuditMsg + rb.getString("adap.NetAppHandler.Bad_username_or_password");
                }
                catch (SocketException se) {
                    message = netappAuditMsg + rb.getString("adap.NetAppHandler.Unable_to_connect_the_netapp_filer_through_mentioned_port_protocol");
                }
                catch (NaProtocolException nap) {
                    message = netappAuditMsg + rb.getString("adap.NetAppHandler.Unable_to_connect_the_netapp_filer_through_mentioned_port_protocol");
                }
                catch (Throwable ex) {
                    if (ex.getMessage() == null) break block29;
                    message = netappAuditMsg + ex.getMessage();
                }
            }
            if (auditOptions != null) {
                NetAppHandler.updateAuditOptions((String)fsDetails.get("OBJECT_GUID"), auditOptions);
            }
            if ((fsMachineType & 0x100) == 256) {
                FileServerHandler.runEventScheduler((Long)fsDetails.get("SCHEDULE_ID"));
            }
            FileServerHandler.addFileUpdateDetails(fsDetails, false);
            EventDataUtil.getComputerDetails(null, null);
            if (!message.contains("Successfully")) {
                msgType = "failure";
                linkMsg = rb.getString("adap.common.text.policy_update_link.click_here");
                retMap.put("linkMsg", linkMsg);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            message = ex.getMessage();
            msgType = "failure";
        }
        retMap.put("msgTxt", message);
        retMap.put("msgType", msgType);
        return retMap;
    }
}

