/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.fileaudit.netapp;

import com.adventnet.sym.adsm.auditing.server.fileaudit.netapp.NetAppHandler;
import com.adventnet.sym.adsm.auditing.server.fileaudit.netapp.NetAppVserverDBHandler;
import com.adventnet.sym.adsm.auditing.server.util.EventDataUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.EscapeUtil;
import com.adventnet.sym.adsm.common.server.util.JSONUtil;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import netapp.manage.NaAuthenticationException;
import netapp.manage.NaElement;
import netapp.manage.NaException;
import netapp.manage.NaProtocolException;
import netapp.manage.NaServer;
import org.json.JSONException;
import org.json.JSONObject;

public class NetAppVserver {
    String cifsHostName;
    String vserverName;
    String guid;
    String username;
    String password;
    String mgntIp;
    String mgntIpType;
    Boolean isHttp;
    Integer portNo;
    String domainName;
    int machineType;
    Boolean isLogPathCreate;
    String volumeName;
    String volumeSize;
    String aggrName;
    Boolean isApplyDefaultAuditPolicy;
    Boolean isApplyDefaultSaclPolicy;
    ArrayList<String> shareLocations;
    String shareAction;
    String evtFileNamePattern;
    String evtFileUncPath;
    String evtFileJunctionPath;
    String evtMsgDllFileName;
    String evtFileFormat;
    int evtFileRotateLimit;
    String evtFileSize;
    Boolean isFileAuditEnabled;
    String evtRotateMonth;
    String evtRotateDay;
    String evtRotateDayOfWeek;
    String evtRotateHour;
    String evtRotateMinute;
    String evtRotateBasedOn;
    NaServer naServerHandle;
    public String errMessage;
    Hashtable<String, Object> hTable;
    private Logger logger = Logger.getLogger(NetAppVserver.class.getName());
    private AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();

    public NetAppVserver(HttpServletRequest request) {
        this.guid = request.getParameter("hostGuid");
        this.cifsHostName = request.getParameter("hostName");
        this.domainName = request.getParameter("domain");
        this.parseShareLocation(request.getParameter("SHARE_LOCATIONS"));
        this.machineType = 524288;
        this.shareAction = request.getParameter("shareAction");
        this.username = request.getParameter("UserName");
        this.password = request.getParameter("Password");
        this.isApplyDefaultAuditPolicy = request.getParameter("IsPolicy") == null ? Boolean.FALSE : Boolean.valueOf(request.getParameter("IsPolicy"));
        this.isApplyDefaultSaclPolicy = request.getParameter("IsSACL") == null ? Boolean.FALSE : Boolean.valueOf(request.getParameter("IsSACL"));
        this.portNo = request.getParameter("PortNo") == null ? 0 : new Integer(request.getParameter("PortNo"));
        this.isHttp = request.getParameter("IsHttp") == null ? Boolean.FALSE : Boolean.valueOf(request.getParameter("IsHttp"));
        this.mgntIp = request.getParameter("mgntIp");
        this.mgntIpType = request.getParameter("cifsVserverMgntIpType");
        this.isLogPathCreate = request.getParameter("isLogPathCreate") == null ? Boolean.TRUE : Boolean.valueOf(request.getParameter("isLogPathCreate"));
        HashMap<String, String> defaultSettings = NetAppHandler.getNaVserverDefaultAuditConfig();
        String evtUncSharePath = "\\\\" + this.cifsHostName + "\\c$";
        this.evtFileNamePattern = defaultSettings.get("EVT_FILE_NAME");
        this.evtMsgDllFileName = defaultSettings.get("MSG_DLL_FILE");
        this.evtFileFormat = defaultSettings.get("EVT_FILE_FORMAT");
        if (this.isApplyDefaultAuditPolicy.booleanValue()) {
            this.volumeName = defaultSettings.get("EVT_VOLUME_NAME");
            this.volumeSize = defaultSettings.get("EVT_VOLUME_SIZE");
            this.evtFileRotateLimit = Integer.parseInt(defaultSettings.get("ROTATE_LIMIT"));
            this.evtFileSize = defaultSettings.get("ROTATE_SIZE");
            if (this.isLogPathCreate.booleanValue()) {
                this.evtFileJunctionPath = defaultSettings.get("EVT_FILE_JUNCTION_PATH");
                this.evtFileUncPath = evtUncSharePath + "\\" + defaultSettings.get("EVT_VOLUME_NAME") + "\\";
                this.aggrName = request.getParameter("aggrName");
            } else {
                this.evtFileJunctionPath = request.getParameter("logPathName");
                this.evtFileUncPath = evtUncSharePath + (this.evtFileJunctionPath.startsWith("/") ? "" : "\\") + this.evtFileJunctionPath.replaceAll("/", "\\\\") + (this.evtFileJunctionPath.endsWith("/") ? "" : "\\");
            }
        }
        this.hTable = new Hashtable();
    }

    public NetAppVserver(JSONObject serverInputParams, String hostGuid, String hostName, String domainName, String shareAction) {
        try {
            this.guid = hostGuid;
            this.cifsHostName = hostName;
            this.domainName = domainName;
            ArrayList shareLocations = new ArrayList();
            if (serverInputParams.has("selectedShares")) {
                shareLocations = (ArrayList)JSONUtil.JSONArrayToList(serverInputParams.getJSONArray("selectedShares"));
            }
            this.shareLocations = shareLocations;
            this.machineType = 524288;
            this.shareAction = shareAction;
            this.username = serverInputParams.getString("userName");
            this.password = serverInputParams.getString("password");
            this.isApplyDefaultAuditPolicy = serverInputParams.getBoolean("isAuditPolicy");
            this.isApplyDefaultSaclPolicy = serverInputParams.getBoolean("isSACL");
            this.portNo = serverInputParams.getInt("portNo");
            String isHttp = serverInputParams.getString("protocol");
            this.isHttp = isHttp.equals("http") ? Boolean.valueOf(true) : Boolean.valueOf(false);
            this.mgntIp = serverInputParams.getString("mgntIp");
            this.mgntIpType = serverInputParams.getString("cifsVserverMgntIpType");
            this.isLogPathCreate = serverInputParams.has("isLogPathCreate") ? serverInputParams.getBoolean("isLogPathCreate") : true;
            HashMap<String, String> defaultSettings = NetAppHandler.getNaVserverDefaultAuditConfig();
            String evtUncSharePath = "\\\\" + this.cifsHostName + "\\c$";
            this.evtFileNamePattern = defaultSettings.get("EVT_FILE_NAME");
            this.evtMsgDllFileName = defaultSettings.get("MSG_DLL_FILE");
            this.evtFileFormat = defaultSettings.get("EVT_FILE_FORMAT");
            if (this.isApplyDefaultAuditPolicy.booleanValue()) {
                this.volumeName = defaultSettings.get("EVT_VOLUME_NAME");
                this.volumeSize = defaultSettings.get("EVT_VOLUME_SIZE");
                this.evtFileRotateLimit = Integer.parseInt(defaultSettings.get("ROTATE_LIMIT"));
                this.evtFileSize = defaultSettings.get("ROTATE_SIZE");
                if (this.isLogPathCreate.booleanValue()) {
                    this.evtFileJunctionPath = defaultSettings.get("EVT_FILE_JUNCTION_PATH");
                    this.evtFileUncPath = evtUncSharePath + "\\" + defaultSettings.get("EVT_VOLUME_NAME") + "\\";
                    this.aggrName = serverInputParams.getString("aggrName");
                } else {
                    this.evtFileJunctionPath = serverInputParams.getString("logPathName");
                    this.evtFileUncPath = evtUncSharePath + (this.evtFileJunctionPath.startsWith("/") ? "" : "\\") + this.evtFileJunctionPath.replaceAll("/", "\\\\") + (this.evtFileJunctionPath.endsWith("/") ? "" : "\\");
                }
            }
            this.hTable = new Hashtable();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public NetAppVserver(String hostGuid, String domainName, String hostName) throws Exception {
        if (hostGuid == null) {
            HashMap computerDetails = EventDataUtil.getComputerProperties(domainName, hostName);
            hostGuid = (String)computerDetails.get("OBJECT_GUID");
        }
        Properties prop = NetAppVserverDBHandler.getProperties(hostGuid);
        this.guid = hostGuid;
        this.cifsHostName = hostName;
        this.machineType = 524288;
        this.username = prop.getProperty("USER_NAME");
        this.password = prop.getProperty("PASSWORD");
        this.isApplyDefaultAuditPolicy = false;
        this.portNo = (Integer)prop.get("PORT_NO");
        this.isHttp = (Boolean)prop.get("IS_HTTP");
        this.mgntIp = prop.getProperty("MANAGEMENT_IP");
        this.mgntIpType = prop.getProperty("MANAGEMENT_IP_TYPE");
        this.hTable = new Hashtable();
    }

    public void setShareLocations(ArrayList<String> shareLocations) {
        this.shareLocations = shareLocations;
    }

    public Hashtable<String, Object> getHashtable() {
        this.hTable.put("OBJECT_GUID", this.guid);
        this.hTable.put("serverName", this.cifsHostName);
        this.hTable.put("domainName", this.domainName);
        this.hTable.put("SHARE_ACTION", this.shareAction);
        this.hTable.put("MACHINE_TYPE", this.machineType);
        this.hTable.put("LOCATIONS", this.shareLocations);
        this.hTable.put("USER_NAME", this.username);
        this.hTable.put("PASSWORD", this.password);
        this.hTable.put("PORT_NO", this.portNo);
        this.hTable.put("IS_HTTP", this.isHttp);
        this.hTable.put("IS_POLICY", this.isApplyDefaultAuditPolicy.toString());
        this.hTable.put("IS_SACL", this.isApplyDefaultSaclPolicy.toString());
        this.hTable.put("EVT_FILE_NAME", this.evtFileNamePattern);
        this.hTable.put("MSG_DLL_FILE", this.evtMsgDllFileName);
        this.hTable.put("MANAGEMENT_IP", this.mgntIp);
        this.hTable.put("MANAGEMENT_IP_TYPE", this.mgntIpType);
        if (this.evtFileUncPath != null) {
            this.hTable.put("EVT_FILE_UNC_PATH", this.evtFileUncPath);
        }
        if (this.evtFileJunctionPath != null) {
            this.hTable.put("EVT_FILE_JUNCTION_PATH", this.evtFileJunctionPath);
        }
        if (this.aggrName != null) {
            this.hTable.put("EVT_AGGREGATE_NAME", this.aggrName);
        }
        return this.hTable;
    }

    public String getJSONString() {
        JSONObject params = null;
        try {
            params = new JSONObject();
            params.put("OBJECT_GUID", (Object)this.guid);
            params.put("hostName", (Object)this.cifsHostName);
            params.put("MANAGEMENT_IP", (Object)this.mgntIp);
            params.put("MANAGEMENT_IP_TYPE", (Object)this.mgntIpType);
            params.put("EVT_FILE_UNC_PATH", (Object)this.evtFileUncPath);
            params.put("EVT_FILE_JUNCTION_PATH", (Object)this.evtFileJunctionPath);
            params.put("EVT_AGGREGATE_NAME", (Object)this.aggrName);
            params.put("EVT_FILE_FORMAT", (Object)this.evtFileFormat);
            params.put("IS_FILE_AUDIT_ENABLED", (Object)this.isFileAuditEnabled);
            params.put("ROTATE_LIMIT", this.evtFileRotateLimit);
            params.put("ROTATE_SIZE", (Object)this.evtFileSize);
            params.put("ROTATE_SCHEDULE_MONTH", (Object)this.evtRotateMonth);
            params.put("ROTATE_SCHEDULE_DAYOFWEEK", (Object)this.evtRotateDayOfWeek);
            params.put("ROTATE_SCHEDULE_DAY", (Object)this.evtRotateDay);
            params.put("ROTATE_SCHEDULE_HOUR", (Object)this.evtRotateHour);
            params.put("ROTATE_SCHEDULE_MINUTE", (Object)this.evtRotateMinute);
            params.put("ROTATE_BASED_ON", (Object)this.evtRotateBasedOn);
        }
        catch (JSONException je) {
            this.errMessage = je.getMessage();
            je.printStackTrace();
        }
        return params.toString();
    }

    private void parseShareLocation(String locationStr) {
        ArrayList<String> shareLocationList = new ArrayList<String>();
        if (locationStr != null) {
            StringTokenizer st = new StringTokenizer(locationStr, ",");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                this.logger.log(Level.INFO, "Sharename  in ConfiguredNetAppVserver is : " + token);
                if (CommonUtil.getDBServerName().equalsIgnoreCase("mssql")) {
                    token = EscapeUtil.escSplCharsAsMSSQL(token);
                }
                if (shareLocationList.contains(token)) continue;
                shareLocationList.add(token);
            }
        }
        this.shareLocations = shareLocationList;
    }

    private void updateAuditParams(HashMap<String, String> auditParams) {
        this.evtFileJunctionPath = auditParams.get("EVT_FILE_JUNCTION_PATH");
        this.evtFileUncPath = auditParams.get("EVT_FILE_UNC_PATH");
        this.evtFileFormat = auditParams.get("EVT_FILE_FORMAT");
        this.isFileAuditEnabled = Boolean.valueOf(auditParams.get("IS_FILE_AUDIT_ENABLED"));
        this.evtFileRotateLimit = new Integer(auditParams.get("ROTATE_LIMIT"));
        this.evtFileSize = auditParams.get("ROTATE_SIZE");
        this.evtRotateMonth = auditParams.get("ROTATE_SCHEDULE_MONTH");
        this.evtRotateDayOfWeek = auditParams.get("ROTATE_SCHEDULE_DAYOFWEEK");
        this.evtRotateDay = auditParams.get("ROTATE_SCHEDULE_DAY");
        this.evtRotateHour = auditParams.get("ROTATE_SCHEDULE_HOUR");
        this.evtRotateMinute = auditParams.get("ROTATE_SCHEDULE_MINUTE");
        this.evtRotateBasedOn = auditParams.get("ROTATE_BASED_ON");
    }

    private String getDivErrMessage(int action, String msg) {
        String[] actionStr = new String[]{this.rb.getString("adap.NetAppHandler.Error_while_enabling_netapp_audit_options"), this.rb.getString("adap.NetAppVserver.Err_Sync_Device")};
        String divErrMsg = "<div id=\"commentForm\" style=\"display:block\"> <a class=\"greenlinktxt\" href=\"javascript:void(0)\" onclick=\"yreg_popLayer('updateNetAppDetails_";
        String divErrMsg1 = "',this, -75, 18) \">Click Here</a></div>";
        return actionStr[action] + "  " + msg + divErrMsg + this.guid + divErrMsg1;
    }

    public Boolean updateEntryInDB() {
        return NetAppVserverDBHandler.updateEntry(this);
    }

    public boolean applyAuditPolicyInDevice(boolean isCreate, boolean isModifyIfExist) {
        this.errMessage = null;
        boolean isSuccess = false;
        try {
            this.initLogPath();
            NaElement elmtIn = new NaElement(isCreate ? "fileservice-audit-config-create" : "fileservice-audit-config-modify");
            elmtIn.addNewChild("destination", this.evtFileJunctionPath);
            elmtIn.addNewChild("format", this.evtFileFormat);
            elmtIn.addNewChild("rotate-limit", "" + this.evtFileRotateLimit);
            elmtIn.addNewChild("rotate-size", this.evtFileSize);
            NaElement elmtOut = this.executeNaServerCommand(elmtIn);
            int execCount = 10;
            while (execCount > 0) {
                elmtIn = new NaElement("fileservice-audit-enable");
                try {
                    --execCount;
                    elmtOut = this.executeNaServerCommand(elmtIn);
                    this.errMessage = elmtOut.toString().contains("passed") ? this.rb.getString("adap.NetAppVserver.Success_Audit_Policy_Enabled") : elmtOut.toString();
                    break;
                }
                catch (Exception e) {
                    if (e.toString().contains("Final consolidation is in progress") && execCount > 0) {
                        this.logger.log(Level.INFO, "Cannot enable auditing for Vserver. Final consolidation is in progress. Retrying after 3 Secs..");
                        this.errMessage = elmtOut.toString();
                        Thread.sleep(3000L);
                        continue;
                    }
                    throw e;
                }
            }
            isSuccess = true;
        }
        catch (NaAuthenticationException na) {
            this.errMessage = this.rb.getString("adap.NetAppHandler.Bad_username_or_password");
            isSuccess = false;
        }
        catch (SocketException se) {
            this.errMessage = this.rb.getString("adap.NetAppHandler.Unable_to_connect_the_netapp_filer_through_mentioned_port_protocol");
            isSuccess = false;
        }
        catch (NaProtocolException nap) {
            this.errMessage = this.rb.getString("adap.NetAppHandler.Unable_to_connect_the_netapp_filer_through_mentioned_port_protocol");
            isSuccess = false;
        }
        catch (Exception ex) {
            if (ex.toString().contains("audit configuration already exists") && isModifyIfExist) {
                if (isModifyIfExist) {
                    try {
                        this.disableAuditPolicyInDevice();
                        isSuccess = this.applyAuditPolicyInDevice(false, false);
                    }
                    catch (Exception e) {
                        isSuccess = false;
                        this.errMessage = this.rb.getString("adap.NetAppVserver.Err_Disable_Audit");
                        e.printStackTrace();
                    }
                } else {
                    isSuccess = false;
                    this.errMessage = this.rb.getString("adap.NetAppVserver.Err_Audit_Exist_Unable_To_Disable");
                }
            }
            isSuccess = false;
            this.errMessage = this.rb.getString("adap.NetAppHandler.Error_while_enabling_netapp_audit_options") + "  " + ex.getMessage();
            ex.printStackTrace();
        }
        return isSuccess;
    }

    public boolean disableAuditPolicyInDevice() throws Exception {
        this.errMessage = null;
        boolean isSuccess = true;
        NaElement elmtOut = null;
        int execCount = 10;
        while (execCount > 0) {
            try {
                --execCount;
                NaElement elmtIn = new NaElement("fileservice-audit-disable");
                elmtOut = this.executeNaServerCommand(elmtIn);
                this.errMessage = elmtOut.toString().contains("passed") ? this.rb.getString("adap.NetAppVserver.Success_Audit_Policy_Disabled") : elmtOut.toString();
                break;
            }
            catch (Exception ex) {
                if (ex.toString().contains("Final consolidation is in progress") && execCount > 0) {
                    this.logger.log(Level.INFO, "Cannot disable auditing for Vserver. Final consolidation is in progress. Retrying after 3 Secs..");
                    this.errMessage = elmtOut.toString();
                    Thread.sleep(3000L);
                    continue;
                }
                if (ex.toString().contains("Auditing is already disabled")) {
                    this.errMessage = this.rb.getString("adap.NetAppVserver.Success_Audit_Policy_Disabled");
                    break;
                }
                this.errMessage = ex.toString();
                isSuccess = false;
                throw ex;
            }
        }
        return isSuccess;
    }

    public boolean syncAuditPolicyWithDevice(boolean isUpdateDb) {
        this.errMessage = null;
        boolean isSuccess = false;
        HashMap<String, String> map = null;
        String[] keyList = new String[]{"destination", "format", "is-enabled", "rotate-limit", "rotate-size", "rotate-schedule-month", "rotate-schedule-dayofweek", "rotate-schedule-day", "rotate-schedule-hour", "rotate-schedule-minute"};
        String[] dbKeyList = new String[]{"EVT_FILE_JUNCTION_PATH", "EVT_FILE_FORMAT", "IS_FILE_AUDIT_ENABLED", "ROTATE_LIMIT", "ROTATE_SIZE", "ROTATE_SCHEDULE_MONTH", "ROTATE_SCHEDULE_DAYOFWEEK", "ROTATE_SCHEDULE_DAY", "ROTATE_SCHEDULE_HOUR", "ROTATE_SCHEDULE_MINUTE"};
        List<String> monthStr = Arrays.asList("January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December");
        List<String> dayStr = Arrays.asList("Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday");
        try {
            NaElement elmtIn = new NaElement("fileservice-audit-config-get-iter");
            NaElement elmtOut = this.executeNaServerCommand(elmtIn);
            if (elmtOut.getChildIntValue("num-records", 0) == 1) {
                map = new HashMap<String, String>();
                NaElement auditInfo = elmtOut.getChildByName("attributes-list").getChildByName("fileservice-audit-config");
                int index = 0;
                for (String key : keyList) {
                    NaElement attrElmt = auditInfo.getChildByName(key);
                    String value = null;
                    if (attrElmt != null) {
                        if (attrElmt.hasChildren()) {
                            value = "";
                            for (NaElement attrChildElmt : new ArrayList(attrElmt.getChildren())) {
                                if (key.equals("rotate-schedule-month")) {
                                    value = value + "," + monthStr.get(Integer.parseInt(attrChildElmt.getContent()));
                                    continue;
                                }
                                if (key.equals("rotate-schedule-dayofweek")) {
                                    value = value + "," + dayStr.get(Integer.parseInt(attrChildElmt.getContent()));
                                    continue;
                                }
                                value = value + "," + attrChildElmt.getContent();
                            }
                            value = value.substring(1);
                        } else {
                            value = attrElmt.getContent();
                        }
                    }
                    map.put(dbKeyList[index++], value);
                    if (!key.equals("destination")) continue;
                    map.put("EVT_FILE_UNC_PATH", "\\\\" + this.cifsHostName + "\\c$" + value.replaceAll("/", "\\\\") + "\\");
                }
                if (map.get("ROTATE_SIZE") != null) {
                    map.put("ROTATE_BASED_ON", "size");
                } else if (map.get("ROTATE_SCHEDULE_MINUTE") != null || map.get("ROTATE_SCHEDULE_MONTH") != null || map.get("ROTATE_SCHEDULE_DAYOFWEEK") != null || map.get("ROTATE_SCHEDULE_HOUR") != null || map.get("ROTATE_SCHEDULE_DAY") != null) {
                    map.put("ROTATE_BASED_ON", "time");
                } else {
                    map.put("ROTATE_BASED_ON", "-");
                }
            } else {
                throw new Exception(this.rb.getString("adap.NetAppVserver.Err_Fetch_Audit"));
            }
            if (map != null) {
                this.updateAuditParams(map);
                if (isUpdateDb) {
                    NetAppVserverDBHandler.updateEntry(this.guid, map);
                }
                NetAppHandler.setNaVserverVolPaths(this.domainName, this.cifsHostName, this.fetchVolumeJuncPaths());
            }
            this.errMessage = this.rb.getString("adap.NetAppVserver.Success_Sync_Device");
            isSuccess = true;
        }
        catch (NaAuthenticationException na) {
            this.errMessage = this.rb.getString("adap.NetAppVserver.Err_Sync_Device") + " :: " + this.rb.getString("adap.NetAppHandler.Bad_username_or_password");
            isSuccess = false;
        }
        catch (SocketException se) {
            this.errMessage = this.rb.getString("adap.NetAppVserver.Err_Sync_Device") + " :: " + this.rb.getString("adap.NetAppHandler.Unable_to_connect_the_netapp_filer_through_mentioned_port_protocol");
            isSuccess = false;
        }
        catch (NaProtocolException nap) {
            this.errMessage = this.rb.getString("adap.NetAppVserver.Err_Sync_Device") + " :: " + this.rb.getString("adap.NetAppHandler.Unable_to_connect_the_netapp_filer_through_mentioned_port_protocol");
            isSuccess = false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.errMessage = this.rb.getString("adap.NetAppVserver.Err_Sync_Device") + " :: " + ex.getMessage();
            isSuccess = false;
        }
        return isSuccess;
    }

    public boolean rotateLog() throws Exception {
        this.errMessage = null;
        NaElement elmtIn = new NaElement("fileservice-audit-rotate-log");
        NaElement elmtOut = this.executeNaServerCommand(elmtIn);
        this.errMessage = elmtOut.toString().contains("passed") ? "Rotated logs successfully" : elmtOut.toString();
        return true;
    }

    public HashMap<String, String> fetchVolumeJuncPaths() {
        this.errMessage = null;
        boolean isSuccess = true;
        HashMap<String, String> map = null;
        String tag = "";
        try {
            map = new HashMap<String, String>();
            while (tag != null) {
                NaElement elmtOut;
                NaElement elmtIn = new NaElement("volume-get-iter");
                elmtIn.addNewChild("max-records", "100");
                if (!tag.equals("")) {
                    elmtIn.addNewChild("tag", tag);
                }
                if ((elmtOut = this.executeNaServerCommand(elmtIn)) == null || elmtOut.getChildIntValue("num-records", 0) == 0) continue;
                tag = elmtOut.getChildContent("next-tag");
                List volList = elmtOut.getChildByName("attributes-list").getChildren();
                for (NaElement volInfo : volList) {
                    NaElement volIdAttrs = volInfo.getChildByName("volume-id-attributes");
                    if (volIdAttrs == null) continue;
                    map.put(volIdAttrs.getChildContent("name"), volIdAttrs.getChildContent("junction-path"));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.errMessage = "Error while getting junction paths of volumes  :: " + ex.getMessage();
            isSuccess = false;
        }
        this.logger.log(Level.INFO, "Volume paths for netapp server '" + this.cifsHostName + "' :: " + (map == null ? null : map.toString()));
        return map;
    }

    private NaServer getNaServerObj() throws Exception {
        if (this.naServerHandle == null) {
            this.naServerHandle = new NaServer(this.mgntIp, 1, 21);
            this.naServerHandle.setServerType(1);
            this.naServerHandle.setTransportType(this.isHttp != false ? 1 : 2);
            this.naServerHandle.setPort(this.portNo.intValue());
            this.naServerHandle.setStyle(1);
            this.naServerHandle.setAdminUser(this.username, this.password);
            if (this.mgntIpType != null && this.mgntIpType.equals("cluster")) {
                if (this.vserverName == null || this.vserverName.length() == 0) {
                    this.fetchNaVserverName(this.naServerHandle);
                }
                if (this.vserverName == null || this.vserverName.length() == 0) {
                    throw new Exception(this.rb.getString("adap.NetAppVserver.Err_Vserver_Name_Fetch") + " '" + this.cifsHostName + "'");
                }
                this.naServerHandle.setVserver(this.vserverName);
            }
        }
        return this.naServerHandle;
    }

    private void fetchNaVserverName(NaServer server) throws Exception {
        block3: {
            try {
                NaElement elmtIn = new NaElement("cifs-server-get-iter");
                elmtIn.addNewChild("max-records", "500");
                NaElement elmtOut = this.executeNaServerCommand(elmtIn);
                if (elmtOut.getChildIntValue("num-records", 0) == 0) break block3;
                for (NaElement vserverInfo : elmtOut.getChildByName("attributes-list").getChildren()) {
                    if (!vserverInfo.getChildContent("cifs-server").equalsIgnoreCase(this.cifsHostName)) continue;
                    this.vserverName = vserverInfo.getChildContent("vserver");
                    this.logger.log(Level.INFO, "Vserver name for server '" + this.cifsHostName + "' is '" + this.vserverName + "'");
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
    }

    private boolean initLogPath() throws Exception {
        this.errMessage = null;
        boolean isSuccess = false;
        int disableSS = 0;
        NaElement elmtOut = null;
        if (this.isApplyDefaultAuditPolicy.booleanValue() && this.isLogPathCreate.booleanValue()) {
            do {
                try {
                    NaElement elmtIn = new NaElement("volume-create");
                    elmtIn.addNewChild("containing-aggr-name", this.aggrName);
                    elmtIn.addNewChild("volume", this.volumeName);
                    elmtIn.addNewChild("junction-path", this.evtFileJunctionPath);
                    elmtIn.addNewChild("size", this.volumeSize);
                    if (disableSS == 0) {
                        elmtIn.addNewChild("snapshot-policy", null);
                    }
                    elmtIn.addNewChild("percentage-snapshot-reserve", "0");
                    elmtOut = this.executeNaServerCommand(elmtIn);
                    this.errMessage = elmtOut.toString().contains("passed") ? this.rb.getString("adap.NetAppVserver.Success_Volume_Created") : elmtOut.toString();
                    isSuccess = true;
                    disableSS = 2;
                }
                catch (NaException e) {
                    if (e.toString().contains("Duplicate volume name")) {
                        disableSS = 2;
                        this.logger.log(Level.INFO, "Volume '" + this.volumeName + "' already exist, hence using the existing volume...");
                        this.errMessage = this.rb.getString("adap.NetAppVserver.Success_Volume_Created");
                        isSuccess = true;
                        continue;
                    }
                    if (e.toString().contains("Snapshot policy  not found")) {
                        ++disableSS;
                        this.logger.log(Level.INFO, "Error while creating volume with snapshot disabled, hence trying without snapshot configuration...");
                        this.errMessage = this.rb.getString("adap.NetAppVserver.Success_Volume_Created");
                        continue;
                    }
                    disableSS = 2;
                    throw e;
                }
            } while (disableSS == 1);
        } else {
            this.errMessage = this.rb.getString("adap.NetAppVserver.Success_Volume_Created");
            isSuccess = true;
        }
        if (this.errMessage == null || !this.errMessage.contains("created successfully")) {
            throw new Exception(this.rb.getString("adap.NetAppVserver.Err_Init_Log_path"));
        }
        return isSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NaElement executeNaServerCommand(NaElement elmtIn) throws Exception {
        NaElement elmtOut = null;
        try {
            elmtOut = this.getNaServerObj().invokeElem(elmtIn);
        }
        finally {
            this.naServerHandle.close();
        }
        return elmtOut;
    }
}

