/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.fileaudit.netapp;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.fileaudit.netapp.NetAppVserver;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public class NetAppVserverDBHandler {
    public static String errMessage;
    private static Logger logger;
    private static AdventNetResourceBundle rb;
    private static String netappVserverTableName;

    public static boolean updateEntry(NetAppVserver naServer) {
        errMessage = null;
        boolean isSuccess = true;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)netappVserverTableName, (String)"OBJECT_GUID"), (Object)naServer.guid, 0);
            DataObject navObj = CommonUtil.getPersistence(new boolean[0]).get(netappVserverTableName, criteria);
            Row row = navObj.isEmpty() ? new Row(netappVserverTableName) : navObj.getRow(netappVserverTableName);
            row.set("USER_NAME", (Object)naServer.username);
            row.set("PASSWORD", (Object)naServer.password);
            row.set("EVT_FILE_UNC_PATH", (Object)naServer.evtFileUncPath);
            row.set("EVT_FILE_JUNCTION_PATH", (Object)naServer.evtFileJunctionPath);
            row.set("MSG_DLL_FILE", (Object)naServer.evtMsgDllFileName);
            row.set("MANAGEMENT_IP", (Object)naServer.mgntIp);
            row.set("MANAGEMENT_IP_TYPE", (Object)naServer.mgntIpType);
            row.set("PORT_NO", (Object)naServer.portNo);
            row.set("IS_HTTP", (Object)naServer.isHttp);
            if (naServer.aggrName != null) {
                row.set("EVT_AGGREGATE_NAME", (Object)naServer.aggrName);
            }
            if (navObj.isEmpty()) {
                row.set("OBJECT_GUID", (Object)naServer.guid);
                navObj.addRow(row);
            } else {
                navObj.updateRow(row);
            }
            CommonUtil.getPersistence(new boolean[0]).update(navObj);
            errMessage = "Updated in DB successfully";
        }
        catch (Exception e) {
            errMessage = e.getMessage();
            isSuccess = false;
            e.printStackTrace();
        }
        naServer.errMessage = errMessage;
        return isSuccess;
    }

    public static ArrayList<HashMap<String, Object>> getNetAppAuditSettings(String filerGUID) throws Exception {
        ArrayList<HashMap<String, Object>> rowList = new ArrayList<HashMap<String, Object>>();
        try {
            Criteria criteria2 = new Criteria(Column.getColumn((String)netappVserverTableName, (String)"OBJECT_GUID"), (Object)filerGUID, 0);
            DataObject nfObj = CommonUtil.getPersistence(new boolean[0]).get(netappVserverTableName, criteria2);
            if (!nfObj.isEmpty()) {
                HashMap<String, String> row0 = new HashMap<String, String>();
                HashMap<String, Object> row1 = new HashMap<String, Object>();
                HashMap<String, Object> row2 = new HashMap<String, Object>();
                HashMap<String, Object> row3 = new HashMap<String, Object>();
                HashMap<String, Object> row4 = new HashMap<String, Object>();
                HashMap<String, Object> row5 = new HashMap<String, Object>();
                HashMap<String, Object> row6 = new HashMap<String, Object>();
                Row row = nfObj.getRow(netappVserverTableName);
                row0.put("NAME", "CIFS SERVER TYPE");
                row0.put("VALUE", "CLUSTER MODE(VSERVER)");
                row1.put("NAME", rb.getString("adap.NetAppEventLogViewer.IS_FILE_AUDIT_ENABLED"));
                row1.put("VALUE", row.get("IS_FILE_AUDIT_ENABLED") == null ? "-" : row.get("IS_FILE_AUDIT_ENABLED"));
                row2.put("NAME", rb.getString("adap.NetAppEventLogViewer.EVT_FILE_JUNCTION_PATH"));
                row2.put("VALUE", row.get("EVT_FILE_JUNCTION_PATH") == null ? "-" : row.get("EVT_FILE_JUNCTION_PATH"));
                row3.put("NAME", rb.getString("adap.NetAppEventLogViewer.EVT_FILE_FORMAT"));
                row3.put("VALUE", row.get("EVT_FILE_FORMAT") == null ? "-" : row.get("EVT_FILE_FORMAT"));
                row4.put("NAME", rb.getString("adap.NetAppEventLogViewer.ROTATE_LIMIT"));
                row4.put("VALUE", row.get("ROTATE_LIMIT") == null ? "-" : row.get("ROTATE_LIMIT"));
                row5.put("NAME", rb.getString("adap.NetAppEventLogViewer.ROTATE_BASED_ON"));
                row5.put("VALUE", row.get("ROTATE_BASED_ON") == null ? "-" : row.get("ROTATE_BASED_ON"));
                rowList.add(row0);
                rowList.add(row1);
                rowList.add(row2);
                rowList.add(row3);
                rowList.add(row4);
                rowList.add(row5);
                if (row.get("ROTATE_BASED_ON") != null && row.get("ROTATE_BASED_ON").equals("size")) {
                    row6.put("NAME", rb.getString("adap.NetAppEventLogViewer.ROTATE_SIZE"));
                    row6.put("VALUE", row.get("ROTATE_SIZE") == null ? "-" : row.get("ROTATE_SIZE"));
                    rowList.add(row6);
                } else {
                    HashMap<String, Object> row7 = new HashMap<String, Object>();
                    HashMap<String, Object> row8 = new HashMap<String, Object>();
                    HashMap<String, Object> row9 = new HashMap<String, Object>();
                    HashMap<String, Object> row10 = new HashMap<String, Object>();
                    row6.put("NAME", rb.getString("adap.NetAppEventLogViewer.ROTATE_SCHEDULE_MONTH"));
                    row6.put("VALUE", row.get("ROTATE_SCHEDULE_MONTH") == null ? "-" : row.get("ROTATE_SCHEDULE_MONTH"));
                    row7.put("NAME", rb.getString("adap.NetAppEventLogViewer.ROTATE_SCHEDULE_DAYOFWEEK"));
                    row7.put("VALUE", row.get("ROTATE_SCHEDULE_DAYOFWEEK") == null ? "-" : row.get("ROTATE_SCHEDULE_DAYOFWEEK"));
                    row8.put("NAME", rb.getString("adap.NetAppEventLogViewer.ROTATE_SCHEDULE_DAY"));
                    row8.put("VALUE", row.get("ROTATE_SCHEDULE_DAY") == null ? "-" : row.get("ROTATE_SCHEDULE_DAY"));
                    row9.put("NAME", rb.getString("adap.NetAppEventLogViewer.ROTATE_SCHEDULE_HOUR"));
                    row9.put("VALUE", row.get("ROTATE_SCHEDULE_HOUR") == null ? "-" : row.get("ROTATE_SCHEDULE_HOUR"));
                    row10.put("NAME", rb.getString("adap.NetAppEventLogViewer.ROTATE_SCHEDULE_MINUTE"));
                    row10.put("VALUE", row.get("ROTATE_SCHEDULE_MINUTE") == null ? "-" : row.get("ROTATE_SCHEDULE_MINUTE"));
                    rowList.add(row6);
                    rowList.add(row7);
                    rowList.add(row8);
                    rowList.add(row9);
                    rowList.add(row10);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return rowList;
    }

    public static boolean updateEntry(String hostGuid, HashMap<String, String> auditOptions) throws Exception {
        errMessage = null;
        boolean isSuccess = true;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)netappVserverTableName, (String)"OBJECT_GUID"), (Object)hostGuid, 0);
            DataObject nfObj = CommonUtil.getPersistence(new boolean[0]).get(netappVserverTableName, criteria);
            if (!nfObj.isEmpty()) {
                Row row = nfObj.getRow(netappVserverTableName);
                if (row != null) {
                    Set<String> keyValueSet = auditOptions.keySet();
                    for (String key : keyValueSet) {
                        String keyValue = auditOptions.get(key);
                        row.set(key, (Object)keyValue);
                    }
                    nfObj.updateRow(row);
                }
                CommonUtil.getPersistence(new boolean[0]).update(nfObj);
            }
            errMessage = "Updated in DB successfully";
        }
        catch (Exception e) {
            errMessage = e.getMessage();
            isSuccess = false;
            e.printStackTrace();
        }
        return isSuccess;
    }

    public static boolean updateLastReadEvtFileTime(String hostGuid, String evtFileTime) {
        errMessage = null;
        boolean isSuccess = true;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)netappVserverTableName, (String)"OBJECT_GUID"), (Object)hostGuid, 0);
            DataObject nfObj = CommonUtil.getPersistence(new boolean[0]).get(netappVserverTableName, criteria);
            if (!nfObj.isEmpty()) {
                Row row = nfObj.getRow(netappVserverTableName);
                logger.log(Level.INFO, "Existing Time is " + row.get("LAST_READ_EVT_FILE_TIME"));
                Long time = (Long)row.get("LAST_READ_EVT_FILE_TIME");
                Long lastReadFileTime = Long.parseLong(evtFileTime);
                if (lastReadFileTime > time) {
                    row.set("LAST_READ_EVT_FILE_TIME", (Object)lastReadFileTime);
                    nfObj.updateRow(row);
                    CommonUtil.getPersistence(new boolean[0]).update(nfObj);
                }
            }
            errMessage = "Updated in DB successfully";
        }
        catch (Exception e) {
            errMessage = e.getMessage();
            isSuccess = false;
            e.printStackTrace();
        }
        return isSuccess;
    }

    public static boolean deleteEntry(String[] hostGuid) throws Exception {
        errMessage = null;
        boolean isSuccess = true;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)netappVserverTableName, (String)"OBJECT_GUID"), (Object)hostGuid, 8);
            CommonUtil.getPersistenceLite().delete(criteria);
            errMessage = "Deleted entries from DB successfully";
        }
        catch (Exception e) {
            errMessage = e.getMessage();
            isSuccess = false;
            e.printStackTrace();
        }
        return isSuccess;
    }

    public static JSONObject getPropertiesEmber(String hostGuid) {
        errMessage = null;
        JSONObject netApp = null;
        ArrayList<String> bigintCols = new ArrayList<String>(Arrays.asList("ROTATE_LIMIT"));
        ArrayList<String> intCols = new ArrayList<String>(Arrays.asList("EVT_FILE_FETCH_MODE"));
        ArrayList<String> filledCols = new ArrayList<String>(Arrays.asList("USER_NAME,PASSWORD,EVT_FILE_UNC_PATH,EVT_FILE_JUNCTION_PATH,MSG_DLL_FILE,MANAGEMENT_IP,MANAGEMENT_IP_TYPE,PORT_NO,IS_HTTP,EVT_AGGREGATE_NAME"));
        try {
            netApp = new JSONObject();
            Criteria criteria = new Criteria(Column.getColumn((String)netappVserverTableName, (String)"OBJECT_GUID"), (Object)hostGuid, 0);
            DataObject nfObj = CommonUtil.getPersistence(new boolean[0]).get(netappVserverTableName, criteria);
            if (!nfObj.isEmpty()) {
                Row row = nfObj.getRow(netappVserverTableName);
                netApp.put("userName", (Object)((String)row.get("USER_NAME")));
                netApp.put("password", (Object)((String)row.get("PASSWORD")));
                netApp.put("evtFileUncPath", (Object)((String)row.get("EVT_FILE_UNC_PATH")));
                netApp.put("evtFileJunctionPath", (Object)((String)row.get("EVT_FILE_JUNCTION_PATH")));
                netApp.put("evtMsgDllFileName", (Object)((String)row.get("MSG_DLL_FILE")));
                netApp.put("mgntIp", (Object)((String)row.get("MANAGEMENT_IP")));
                netApp.put("cifsVserverMgntIpType", (Object)((String)row.get("MANAGEMENT_IP_TYPE")));
                netApp.put("portNo", (Object)((Integer)row.get("PORT_NO")));
                if (((Boolean)row.get("IS_HTTP")).booleanValue()) {
                    netApp.put("protocol", (Object)"http");
                } else {
                    netApp.put("protocol", (Object)"https");
                }
                netApp.put("aggrName", row.get("EVT_AGGREGATE_NAME"));
                netApp.put("naVserverDefRotType", (Object)"size");
                netApp.put("naVserverDefFileCnt", (Object)"10");
                netApp.put("naVserverDefFileSize", (Object)"200MB");
                netApp.put("naVserverDefFilePath", (Object)"/cifs_audit_log");
                ArrayList colList = new ArrayList(row.getColumns());
                for (String col : colList) {
                    if (row.get(col) == null || filledCols.contains(col)) continue;
                    if (intCols.contains(col)) {
                        netApp.put(col, (Object)((Integer)row.get(col)));
                        continue;
                    }
                    if (bigintCols.contains(col)) {
                        netApp.put(col, (Object)((Long)row.get(col)));
                        continue;
                    }
                    netApp.put(col, (Object)row.get(col).toString());
                }
            }
        }
        catch (Exception ex) {
            errMessage = ex.getMessage();
            ex.printStackTrace();
        }
        return netApp;
    }

    public static Properties getProperties(String hostGuid) {
        errMessage = null;
        Properties netApp = null;
        ArrayList<String> booleanCols = new ArrayList<String>(Arrays.asList("IS_HTTP"));
        ArrayList<String> bigintCols = new ArrayList<String>(Arrays.asList("ROTATE_LIMIT"));
        ArrayList<String> intCols = new ArrayList<String>(Arrays.asList("PORT_NO", "EVT_FILE_FETCH_MODE"));
        try {
            netApp = new Properties();
            Criteria criteria = new Criteria(Column.getColumn((String)netappVserverTableName, (String)"OBJECT_GUID"), (Object)hostGuid, 0);
            DataObject nfObj = CommonUtil.getPersistence(new boolean[0]).get(netappVserverTableName, criteria);
            if (!nfObj.isEmpty()) {
                Row row = nfObj.getRow(netappVserverTableName);
                ArrayList colList = new ArrayList(row.getColumns());
                for (String col : colList) {
                    if (row.get(col) == null) continue;
                    if (booleanCols.contains(col)) {
                        netApp.put(col, (Boolean)row.get(col));
                        continue;
                    }
                    if (intCols.contains(col)) {
                        netApp.put(col, (Integer)row.get(col));
                        continue;
                    }
                    if (bigintCols.contains(col)) {
                        netApp.put(col, (Long)row.get(col));
                        continue;
                    }
                    netApp.put(col, row.get(col).toString());
                }
            }
        }
        catch (Exception ex) {
            errMessage = ex.getMessage();
            ex.printStackTrace();
        }
        return netApp;
    }

    static {
        logger = Logger.getLogger(NetAppVserver.class.getName());
        rb = ResourceBundleMgr.getInstance().getBundle();
        netappVserverTableName = "AUDNetAppVserverDetails";
    }
}

