/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.fileintegrity;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.fileintegrity.FIMConstants;
import com.adventnet.sym.adsm.auditing.server.util.EventDataUtil;
import com.adventnet.sym.adsm.auditing.server.util.WindowsDirUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public final class FileIntegrityManager
implements FIMConstants {
    private static final Logger REPORT_LOGGER = Logger.getLogger("ReportLogger");
    private static final AdventNetResourceBundle RB = ResourceBundleMgr.getInstance().getBundle();
    private static volatile FileIntegrityManager fileIntegrityManager = null;
    private static HashMap<String, ArrayList<String>> configuredFolders = new HashMap();
    private static HashMap<String, ArrayList<String>> configuredFileTypes = new HashMap();
    private static HashMap<String, String> systemDriveForDC = new HashMap();
    private static HashMap<String, Integer> fimEnabledOnMap = new HashMap();
    private static List<String> fimConfiguredDomains = Collections.synchronizedList(new ArrayList());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FileIntegrityManager getInstance() {
        if (fileIntegrityManager != null) return fileIntegrityManager;
        Class<FileIntegrityManager> clazz = FileIntegrityManager.class;
        synchronized (FileIntegrityManager.class) {
            if (fileIntegrityManager != null) return fileIntegrityManager;
            fileIntegrityManager = new FileIntegrityManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return fileIntegrityManager;
        }
    }

    private FileIntegrityManager() {
        this.setFimEnabledDomainList();
        this.setConfiguredList("AUDFIMFolderConf");
        this.setConfiguredList("AUDFIMFileConf");
        this.setFIMEnabledServers();
    }

    public ArrayList<String> getConfiguredFolderList(String domainName) {
        ArrayList<String> configuredFoldersList = configuredFolders.get(domainName);
        return configuredFoldersList;
    }

    public ArrayList<String> getConfiguredFileTypeList(String domainName) {
        ArrayList<String> configuredFileTypeList = configuredFileTypes.get(domainName);
        return configuredFileTypeList;
    }

    public boolean isFIMEnabledForMachineType(String domainName, int machineType) {
        int resultantType;
        boolean finalResult = Boolean.FALSE;
        Integer fimEnabledMachineTypes = fimEnabledOnMap.get(domainName);
        if (fimEnabledMachineTypes != null && (resultantType = machineType & fimEnabledMachineTypes) != 0) {
            finalResult = Boolean.TRUE;
        }
        return finalResult;
    }

    public Hashtable<Long, ArrayList<Object>> getConfiguredDomainList() {
        Hashtable<Long, ArrayList<Object>> configuredDomainProps = new Hashtable<Long, ArrayList<Object>>();
        try {
            Column col = Column.getColumn((String)"AUDFIMDomainConfiguration", (String)"UNIQUE_ID");
            Criteria criteria = new Criteria(col, null, 1);
            DataObject defaultDO = CommonUtil.getPersistence(new boolean[0]).get("AUDFIMDomainConfiguration", criteria);
            if (defaultDO.isEmpty()) {
                REPORT_LOGGER.log(Level.SEVERE, "FIM->No Data Available in AUDFIMDomainConfiguration");
            } else {
                int rowCount = defaultDO.size("AUDFIMDomainConfiguration");
                Iterator iterator = defaultDO.getRows("AUDFIMDomainConfiguration");
                for (int i = 0; i < rowCount; ++i) {
                    Row row = (Row)iterator.next();
                    ArrayList<Object> props = new ArrayList<Object>();
                    props.add(row.get("IS_CONFIGURED"));
                    String domainName = (String)row.get("DOMAIN_NAME");
                    props.add(domainName);
                    Hashtable<String, Hashtable<String, Object>> fimEnabledOn = this.getFimEnabledMachineTypes(domainName);
                    Hashtable<String, Object> serverProps = fimEnabledOn.get(RB.getString(MACHINE_TYPES_STRING[0]));
                    Integer isFimEnabled = (Integer)serverProps.get("IS_SELECTED");
                    int[] dcCount = this.getConfiguredDCCount(domainName, "");
                    if (isFimEnabled == 0) {
                        props.add(RB.getString("adap.common.text.filter_link.disabled"));
                    } else {
                        props.add(dcCount[1] + " " + RB.getString("adap.configureFIM.Out_Of") + " " + dcCount[0]);
                    }
                    serverProps = fimEnabledOn.get(RB.getString(MACHINE_TYPES_STRING[1]));
                    isFimEnabled = (Integer)serverProps.get("IS_SELECTED");
                    int[] msCount = this.getConfiguredMemberServersCount(domainName, "");
                    if (isFimEnabled == 0) {
                        props.add(RB.getString("adap.common.text.filter_link.disabled"));
                    } else {
                        props.add(msCount[1] + " " + RB.getString("adap.configureFIM.Out_Of") + " " + msCount[0]);
                    }
                    props.add(RB.getString((String)row.get("GPO_CREATION")));
                    configuredDomainProps.put((Long)row.get("UNIQUE_ID"), props);
                }
            }
        }
        catch (Exception ex) {
            REPORT_LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
        }
        return configuredDomainProps;
    }

    public void insertOrUpdateFimDomainConfTable(String domainName, String status, Integer isEnabled) {
        try {
            Column col = Column.getColumn((String)"AUDFIMDomainConfiguration", (String)"DOMAIN_NAME");
            Criteria criteria = new Criteria(col, (Object)domainName, 0);
            DataObject confTableDO = CommonUtil.getPersistence(new boolean[0]).get("AUDFIMDomainConfiguration", criteria);
            if (confTableDO.isEmpty()) {
                Row fimDomainConfTableRow = new Row("AUDFIMDomainConfiguration");
                fimDomainConfTableRow.set("DOMAIN_NAME", (Object)domainName);
                fimDomainConfTableRow.set("GPO_CREATION", (Object)status);
                fimDomainConfTableRow.set("IS_CONFIGURED", (Object)isEnabled);
                confTableDO.addRow(fimDomainConfTableRow);
                CommonUtil.getPersistence(new boolean[0]).add(confTableDO);
                REPORT_LOGGER.log(Level.INFO, "FIM->New Domain configured for FIM");
            } else {
                Row fimDomainConfTableRow = confTableDO.getFirstRow("AUDFIMDomainConfiguration");
                fimDomainConfTableRow.set("GPO_CREATION", (Object)status);
                fimDomainConfTableRow.set("IS_CONFIGURED", (Object)isEnabled);
                confTableDO.updateRow(fimDomainConfTableRow);
                CommonUtil.getPersistence(new boolean[0]).update(confTableDO);
                REPORT_LOGGER.log(Level.INFO, "FIM->Domain updated in FIM");
            }
        }
        catch (Exception ex) {
            REPORT_LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSystemDrive(String machineName, String domainName) {
        String key = domainName + "," + machineName;
        String systemDrive = "c:";
        String value = systemDriveForDC.get(key);
        if (value == null) {
            Properties properties = null;
            try {
                HashMap propMap = EventDataUtil.getComputerProperties(domainName, machineName);
                properties = WindowsDirUtil.getWindowsDirFromDB(machineName, domainName, propMap);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            HashMap<String, String> hashMap = systemDriveForDC;
            synchronized (hashMap) {
                if (properties == null || properties.getProperty("WindowsDirectory") == null) {
                    systemDriveForDC.put(key, systemDrive);
                    REPORT_LOGGER.log(Level.FINE, "FIM->systemDriveForDC not available for" + key);
                } else {
                    systemDrive = properties.getProperty("WindowsDirectory");
                    systemDriveForDC.put(key, systemDrive.substring(0, 2));
                }
            }
        }
        systemDrive = value;
        return systemDrive;
    }

    private boolean createConfForDomain(String domainName, String defaultTable, String confTable, String confColumn) {
        try {
            Column col = Column.getColumn((String)defaultTable, (String)"UNIQUE_ID");
            Criteria criteria = new Criteria(col, null, 1);
            DataObject defaultDO = CommonUtil.getPersistence(new boolean[0]).get(defaultTable, criteria);
            int rowCount = defaultDO.size(defaultTable);
            if (defaultDO.isEmpty()) {
                REPORT_LOGGER.log(Level.SEVERE, "FIM->No Data Available in " + defaultTable);
            } else {
                Column col_dName = Column.getColumn((String)confTable, (String)"DOMAIN_NAME");
                Criteria criteria_dName = new Criteria(col_dName, (Object)domainName, 0);
                DataObject confDO = CommonUtil.getPersistence(new boolean[0]).get(confTable, criteria_dName);
                Iterator iterator = defaultDO.getRows(defaultTable);
                for (int i = 0; i < rowCount; ++i) {
                    Row row = (Row)iterator.next();
                    String confValue = (String)row.get(confColumn);
                    Object is_selected = row.get("IS_SELECTED");
                    Row confRow = new Row(confTable);
                    confRow.set("DOMAIN_NAME", (Object)domainName);
                    confRow.set(confColumn, (Object)confValue);
                    confRow.set("IS_SELECTED", is_selected);
                    confDO.addRow(confRow);
                }
                CommonUtil.getPersistence(new boolean[0]).add(confDO);
                this.setConfiguredList(confTable);
                REPORT_LOGGER.log(Level.INFO, "FIM->Table Updated With Default Value for " + domainName + " from " + defaultTable);
            }
        }
        catch (Exception ex) {
            REPORT_LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
        }
        return Boolean.TRUE;
    }

    public Hashtable<Long, Hashtable<String, Object>> getConfiguration(String domainName, String confString) {
        String confColumn;
        String confTable;
        String defaultTable;
        Hashtable<Long, Hashtable<String, Object>> resultMap = new Hashtable<Long, Hashtable<String, Object>>();
        if (confString.equalsIgnoreCase("Folder")) {
            REPORT_LOGGER.log(Level.INFO, "FIM->Getting Folder Configuration");
            defaultTable = "AUDDefaultFIMFolders";
            confTable = "AUDFIMFolderConf";
            confColumn = "FOLDER_PATH";
        } else {
            REPORT_LOGGER.log(Level.INFO, "FIM->Getting File Configuration");
            defaultTable = "AUDDefaultFIMFileTypes";
            confTable = "AUDFIMFileConf";
            confColumn = "FILE_TYPE";
        }
        try {
            boolean isDataAvailableInTable;
            Column col = Column.getColumn((String)confTable, (String)"DOMAIN_NAME");
            Criteria criteria = new Criteria(col, (Object)domainName, 0);
            DataObject confDO = CommonUtil.getPersistence(new boolean[0]).get(confTable, criteria);
            boolean bl = isDataAvailableInTable = !confDO.isEmpty();
            if (confDO.isEmpty()) {
                REPORT_LOGGER.log(Level.INFO, "FIM->Create from default table for " + domainName + " in " + confTable);
                isDataAvailableInTable = this.createConfForDomain(domainName, defaultTable, confTable, confColumn);
            }
            if (isDataAvailableInTable) {
                confDO = CommonUtil.getPersistence(new boolean[0]).get(confTable, criteria);
                Iterator iterator = confDO.getRows(confTable);
                int rowCount = confDO.size(confTable);
                for (int i = 0; i < rowCount; ++i) {
                    Row row = (Row)iterator.next();
                    Long uniqueKey = (Long)row.get("UNIQUE_ID");
                    String confValue = (String)row.get(confColumn);
                    Object is_selected = row.get("IS_SELECTED");
                    Hashtable<String, Object> value = new Hashtable<String, Object>();
                    value.put(confColumn, confValue);
                    value.put("IS_SELECTED", is_selected);
                    resultMap.put(uniqueKey, value);
                }
                REPORT_LOGGER.log(Level.INFO, "FIM->Returning  ConfigurationMap for " + domainName + " from " + confTable);
            }
        }
        catch (Exception ex) {
            REPORT_LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
        }
        return resultMap;
    }

    public void setConfiguration(String domainName, JSONObject confMapJSON, String confTable) {
        try {
            Column col = Column.getColumn((String)confTable, (String)"DOMAIN_NAME");
            Criteria criteria = new Criteria(col, (Object)domainName, 0);
            DataObject confDO = CommonUtil.getPersistence(new boolean[0]).get(confTable, criteria);
            int rowCount = confDO.size(confTable);
            if (confDO.isEmpty()) {
                REPORT_LOGGER.log(Level.SEVERE, "FIM->No Data Available for Updating " + domainName + " in " + confTable);
                return;
            }
            Iterator iterator = confDO.getRows(confTable);
            for (int i = 0; i < rowCount; ++i) {
                Row row = (Row)iterator.next();
                if (confMapJSON.isNull(row.get("UNIQUE_ID").toString())) continue;
                row.set("IS_SELECTED", (Object)confMapJSON.getInt(row.get("UNIQUE_ID").toString()));
                confDO.updateRow(row);
            }
            CommonUtil.getPersistence(new boolean[0]).update(confDO);
            REPORT_LOGGER.log(Level.INFO, "FIM->Updated Configuration for " + domainName + " from " + confTable);
        }
        catch (Exception ex) {
            REPORT_LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public Hashtable<String, Hashtable<String, Object>> getFimEnabledMachineTypes(String domainName) {
        Hashtable<String, Hashtable<String, Object>> resultMap = new Hashtable<String, Hashtable<String, Object>>();
        try {
            boolean isDataAvailableInTable;
            Column col = Column.getColumn((String)"AUDFIMSeverConf", (String)"DOMAIN_NAME");
            Criteria criteria = new Criteria(col, (Object)domainName, 0);
            DataObject confDO = CommonUtil.getPersistence(new boolean[0]).get("AUDFIMSeverConf", criteria);
            boolean bl = isDataAvailableInTable = !confDO.isEmpty();
            if (confDO.isEmpty()) {
                REPORT_LOGGER.log(Level.INFO, "FIM->No Data Available for " + domainName + " in " + "AUDFIMSeverConf");
                for (int i = 0; i < MACHINE_TYPES_STRING.length; ++i) {
                    Row confRow = new Row("AUDFIMSeverConf");
                    confRow.set("DOMAIN_NAME", (Object)domainName);
                    confRow.set("MACHINE_TYPE", (Object)MACHINE_TYPES_STRING[i]);
                    confRow.set("IS_SELECTED", (Object)1);
                    confDO.addRow(confRow);
                }
                CommonUtil.getPersistence(new boolean[0]).add(confDO);
                REPORT_LOGGER.log(Level.INFO, "FIM->Entries added for " + domainName + " in " + "AUDFIMSeverConf");
                isDataAvailableInTable = Boolean.TRUE;
            }
            if (isDataAvailableInTable) {
                confDO = CommonUtil.getPersistence(new boolean[0]).get("AUDFIMSeverConf", criteria);
                Iterator iterator = confDO.getRows("AUDFIMSeverConf");
                int rowCount = confDO.size("AUDFIMSeverConf");
                for (int i = 0; i < rowCount; ++i) {
                    Hashtable<String, Object> props = new Hashtable<String, Object>();
                    Row row = (Row)iterator.next();
                    props.put("UNIQUE_ID", row.get("UNIQUE_ID"));
                    props.put("IS_SELECTED", row.get("IS_SELECTED"));
                    resultMap.put(RB.getString((String)row.get("MACHINE_TYPE")), props);
                    resultMap.put((String)row.get("MACHINE_TYPE"), props);
                }
                REPORT_LOGGER.log(Level.INFO, "FIM->Getting  ServerConf for " + domainName + " from " + "AUDFIMSeverConf");
            }
        }
        catch (Exception ex) {
            REPORT_LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
        }
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfiguredList(String confTable) {
        String confColumn;
        HashMap<String, ArrayList<String>> configuredListMap;
        boolean folderStringReplaceFlag = false;
        if (confTable.equals("AUDFIMFileConf")) {
            configuredListMap = configuredFileTypes;
            confColumn = "FILE_TYPE";
        } else {
            configuredListMap = configuredFolders;
            confColumn = "FOLDER_PATH";
            folderStringReplaceFlag = true;
        }
        HashMap<String, ArrayList<String>> hashMap = configuredListMap;
        synchronized (hashMap) {
            try {
                configuredListMap.clear();
                Column col = Column.getColumn((String)confTable, (String)"IS_SELECTED");
                Criteria criteria = new Criteria(col, (Object)1, 0);
                DataObject confDO = CommonUtil.getPersistence(new boolean[0]).get(confTable, criteria);
                if (confDO.isEmpty()) {
                    REPORT_LOGGER.log(Level.SEVERE, "FIM->No Data Available in " + confTable);
                } else {
                    Iterator iterator = confDO.getRows(confTable);
                    int rowCount = confDO.size(confTable);
                    for (int i = 0; i < rowCount; ++i) {
                        Row row = (Row)iterator.next();
                        String confValue = (String)row.get(confColumn);
                        String domainName = (String)row.get("DOMAIN_NAME");
                        ArrayList<String> configuredList = configuredListMap.get(domainName);
                        if (configuredList == null) {
                            configuredList = new ArrayList();
                        }
                        if (folderStringReplaceFlag) {
                            for (int j = 0; j < SYSTEM_VARIABLES.length; ++j) {
                                if (!confValue.startsWith(SYSTEM_VARIABLES[j].toString())) continue;
                                confValue = confValue.replace(SYSTEM_VARIABLES[j], SYSTEM_VARIABLES_REPLACE_STRING[j]);
                                break;
                            }
                        }
                        configuredList.add(confValue);
                        configuredListMap.put(domainName, configuredList);
                    }
                    REPORT_LOGGER.log(Level.FINE, "FIM->Initializing  Configured List from " + confTable + configuredListMap);
                }
            }
            catch (Exception ex) {
                REPORT_LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    public boolean deleteWithUniqueId(Long uniqueId, String tableName) {
        boolean flag = false;
        try {
            CommonUtil.getPersistenceLite().delete(new Criteria(Column.getColumn((String)tableName, (String)"UNIQUE_ID"), (Object)uniqueId, 0));
            flag = true;
        }
        catch (Exception ex) {
            REPORT_LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
        }
        return flag;
    }

    public boolean changeDomainStatusInFIM(Long uniqueId, int isEnabled) {
        boolean result = Boolean.TRUE;
        try {
            Column col = Column.getColumn((String)"AUDFIMDomainConfiguration", (String)"UNIQUE_ID");
            Criteria criteria = new Criteria(col, (Object)uniqueId, 0);
            DataObject tableDO = CommonUtil.getPersistence(new boolean[0]).get("AUDFIMDomainConfiguration", criteria);
            if (tableDO.isEmpty()) {
                REPORT_LOGGER.log(Level.INFO, "FIM->No data found for ID" + uniqueId + " in table " + "AUDFIMDomainConfiguration");
            } else {
                Row row = tableDO.getFirstRow("AUDFIMDomainConfiguration");
                row.set("IS_CONFIGURED", (Object)isEnabled);
                tableDO.updateRow(row);
                CommonUtil.getPersistence(new boolean[0]).update(tableDO);
                REPORT_LOGGER.log(Level.INFO, "FIM->Change updated for the " + uniqueId + " in table " + "AUDFIMDomainConfiguration");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public ArrayList<Properties> getConfiguredMemberServers(String domainName, String searchString, int startIndex, int range) {
        Table baseTable = Table.getTable((String)"AUDComputerEventRead", (String)"AUDComputerEventRead_Alias");
        Table joinTable = Table.getTable((String)"ADSMComputerGeneralDetails", (String)"ADSMComputerGeneralDetails_Alias");
        ArrayList<Properties> configuredServersList = new ArrayList<Properties>();
        try {
            SelectQueryImpl sq = new SelectQueryImpl(baseTable);
            sq.addSelectColumn(Column.getColumn((String)"AUDComputerEventRead_Alias", (String)"COMPUTER_ID", (String)"COMPUTER_ID"));
            sq.addSelectColumn(Column.getColumn((String)"AUDComputerEventRead_Alias", (String)"IS_FIM_ENABLED", (String)"IS_FIM_ENABLED"));
            sq.addSelectColumn(Column.getColumn((String)"AUDComputerEventRead_Alias", (String)"OBJECT_GUID", (String)"AUDComputerEventRead_AliasOBJECT_GUID"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMComputerGeneralDetails_Alias", (String)"DOMAIN_NAME", (String)"DOMAIN_NAME"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMComputerGeneralDetails_Alias", (String)"ROLE", (String)"ROLE"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMComputerGeneralDetails_Alias", (String)"OPERATING_SYSTEM", (String)"OPERATING_SYSTEM"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMComputerGeneralDetails_Alias", (String)"COMMON_NAME", (String)"COMMON_NAME"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMComputerGeneralDetails_Alias", (String)"NAME", (String)"NAME"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMComputerGeneralDetails_Alias", (String)"CANONICAL_NAME", (String)"CANONICAL_NAME"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMComputerGeneralDetails_Alias", (String)"OBJECT_GUID", (String)"ADSMComputerGeneralDetails_AliasOBJECT_GUID"));
            Join join = new Join(baseTable, joinTable, new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 2);
            sq.addJoin(join);
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails_Alias", (String)"DOMAIN_NAME"), (Object)domainName, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails_Alias", (String)"ROLE"), (Object)"*Server*", 2));
            crit = crit.and(new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails_Alias", (String)"OPERATING_SYSTEM"), (Object)"*Server*", 2));
            if (searchString != null && !"".equals(searchString)) {
                searchString = "*" + searchString + "*";
                crit = crit.and(new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails_Alias", (String)"COMMON_NAME"), (Object)searchString, 2));
            }
            SortColumn sortColumn = new SortColumn(Column.getColumn((String)"ADSMComputerGeneralDetails_Alias", (String)"NAME"), true);
            sq.addSortColumn(sortColumn);
            sq.setRange(new Range(startIndex, range));
            sq.setCriteria(crit);
            DataObject compEventReadDataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            Iterator compEventReadIterator = compEventReadDataObj.getRows("AUDComputerEventRead_Alias");
            while (compEventReadIterator.hasNext()) {
                Row compEventReadRow = (Row)compEventReadIterator.next();
                String objectGuid = (String)compEventReadRow.get("OBJECT_GUID");
                Criteria joinCrit = new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails_Alias", (String)"OBJECT_GUID"), (Object)objectGuid, 0);
                Row compDetailsRow = compEventReadDataObj.getRow("ADSMComputerGeneralDetails_Alias", joinCrit);
                Properties computerDetails = new Properties();
                computerDetails.put("UniqueId", compEventReadRow.get("COMPUTER_ID").toString());
                computerDetails.put("Name", compDetailsRow.get("COMMON_NAME"));
                computerDetails.put("CanonicalName", compDetailsRow.get("CANONICAL_NAME"));
                computerDetails.put("IsFIMEnabled", compEventReadRow.get("IS_FIM_ENABLED").toString());
                configuredServersList.add(computerDetails);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return configuredServersList;
    }

    public int[] getConfiguredMemberServersCount(String domainName, String searchString) {
        Table baseTable = Table.getTable((String)"AUDComputerEventRead");
        Table joinTable = Table.getTable((String)"ADSMComputerGeneralDetails");
        int[] count = new int[2];
        try {
            SelectQueryImpl sq = new SelectQueryImpl(baseTable);
            Join join = new Join(baseTable, joinTable, new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 2);
            sq.addJoin(join);
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"DOMAIN_NAME"), (Object)domainName, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"ROLE"), (Object)"*Server*", 2));
            crit = crit.and(new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"OPERATING_SYSTEM"), (Object)"*Server*", 2));
            if (searchString != null && !"".equals(searchString)) {
                searchString = "*" + searchString + "*";
                crit = crit.and(new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"COMMON_NAME"), (Object)searchString, 2));
            }
            sq.setCriteria(crit);
            sq.addSelectColumn(Column.getColumn(null, (String)"*"));
            DataObject compEventReadDataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            count[0] = compEventReadDataObj.size("ADSMComputerGeneralDetails");
            if (count[0] == -1) {
                count[0] = 0;
            }
            crit = new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"DOMAIN_NAME"), (Object)domainName, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)"AUDComputerEventRead", (String)"IS_FIM_ENABLED"), (Object)1, 0));
            crit = crit.and(new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"ROLE"), (Object)"*Server*", 2));
            crit = crit.and(new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"OPERATING_SYSTEM"), (Object)"*Server*", 2));
            sq.setCriteria(crit);
            compEventReadDataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            count[1] = compEventReadDataObj.size("ADSMComputerGeneralDetails");
            if (count[1] == -1) {
                count[1] = 0;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return count;
    }

    public int[] getConfiguredDCCount(String domainName, String searchString) {
        Table baseTable = Table.getTable((String)"AUDDCEventRead");
        Table joinTable = Table.getTable((String)"ADSMDCConfiguration");
        int[] count = new int[2];
        try {
            SelectQueryImpl sq = new SelectQueryImpl(baseTable);
            Join join = new Join(baseTable, joinTable, new String[]{"DOMAIN_CONTROLLER_ID"}, new String[]{"DOMAIN_CONTROLLER_ID"}, 2);
            sq.addJoin(join);
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMDCConfiguration", (String)"DOMAIN_NAME"), (Object)domainName, 0);
            if (searchString != null && !"".equals(searchString)) {
                searchString = "*" + searchString + "*";
                crit = crit.and(new Criteria(Column.getColumn((String)"ADSMDCConfiguration", (String)"DOMAIN_CONTROLLER_NAME"), (Object)searchString, 2));
            }
            sq.setCriteria(crit);
            sq.addSelectColumn(Column.getColumn(null, (String)"*"));
            DataObject compEventReadDataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            count[0] = compEventReadDataObj.size("ADSMDCConfiguration");
            if (count[0] == -1) {
                count[0] = 0;
            }
            crit = new Criteria(Column.getColumn((String)"ADSMDCConfiguration", (String)"DOMAIN_NAME"), (Object)domainName, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)"AUDDCEventRead", (String)"IS_FIM_ENABLED"), (Object)1, 0));
            sq.setCriteria(crit);
            compEventReadDataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            count[1] = compEventReadDataObj.size("ADSMDCConfiguration");
            if (count[1] == -1) {
                count[1] = 0;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return count;
    }

    public ArrayList<Properties> getConfiguredDCs(String domainName, String searchString, int startIndex, int range) {
        Table joinTable1 = Table.getTable((String)"AUDDCEventRead", (String)"AUDDCEventRead_Alias");
        Table joinTable2 = Table.getTable((String)"ADSMDCConfiguration", (String)"ADSMDCConfiguration_Alias");
        ArrayList<Properties> configuredServersList = new ArrayList<Properties>();
        try {
            SelectQueryImpl sq = new SelectQueryImpl(joinTable1);
            sq.addSelectColumn(Column.getColumn((String)"ADSMDCConfiguration_Alias", (String)"DOMAIN_NAME", (String)"DOMAIN_NAME"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMDCConfiguration_Alias", (String)"DOMAIN_CONTROLLER_NAME", (String)"DOMAIN_CONTROLLER_NAME"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMDCConfiguration_Alias", (String)"DOMAIN_CONTROLLER_ID", (String)"ADSMDCConfiguration_AliasDOMAIN_CONTROLLER_ID"));
            sq.addSelectColumn(Column.getColumn((String)"AUDDCEventRead_Alias", (String)"IS_FIM_ENABLED", (String)"IS_FIM_ENABLED"));
            sq.addSelectColumn(Column.getColumn((String)"AUDDCEventRead_Alias", (String)"DOMAIN_CONTROLLER_ID", (String)"AUDDCEventRead_AliasDOMAIN_CONTROLLER_ID"));
            Join join = new Join(joinTable1, joinTable2, new String[]{"DOMAIN_CONTROLLER_ID"}, new String[]{"DOMAIN_CONTROLLER_ID"}, 2);
            sq.addJoin(join);
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMDCConfiguration_Alias", (String)"DOMAIN_NAME"), (Object)domainName, 0);
            if (searchString != null && !"".equals(searchString)) {
                searchString = "*" + searchString + "*";
                crit = crit.and(new Criteria(Column.getColumn((String)"ADSMDCConfiguration_Alias", (String)"DOMAIN_CONTROLLER_NAME"), (Object)searchString, 2));
            }
            SortColumn sortColumn = new SortColumn(Column.getColumn((String)"ADSMDCConfiguration_Alias", (String)"DOMAIN_CONTROLLER_NAME"), true);
            sq.addSortColumn(sortColumn);
            sq.setRange(new Range(startIndex, range));
            sq.setCriteria(crit);
            DataObject compEventReadDataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            Iterator compEventReadIterator = compEventReadDataObj.getRows("AUDDCEventRead_Alias");
            while (compEventReadIterator.hasNext()) {
                Row compEventReadRow = (Row)compEventReadIterator.next();
                Long dcId = (Long)compEventReadRow.get("DOMAIN_CONTROLLER_ID");
                Criteria joinCrit = new Criteria(Column.getColumn((String)"ADSMDCConfiguration_Alias", (String)"DOMAIN_CONTROLLER_ID"), (Object)dcId, 0);
                Row compDetailsRow = compEventReadDataObj.getRow("ADSMDCConfiguration_Alias", joinCrit);
                String dcName = (String)compDetailsRow.get("DOMAIN_CONTROLLER_NAME");
                Properties computerDetails = new Properties();
                computerDetails.put("UniqueId", dcId.toString());
                computerDetails.put("Name", dcName);
                computerDetails.put("IsFIMEnabled", compEventReadRow.get("IS_FIM_ENABLED").toString());
                joinCrit = new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"DOMAIN_NAME"), (Object)domainName, 0);
                Criteria crit2 = new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"NAME"), (Object)dcName, 0);
                crit2 = crit2.or(new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"DNS_NAME"), (Object)dcName, 0));
                crit2 = crit2.or(new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"COMMON_NAME"), (Object)dcName, 0));
                joinCrit = joinCrit.and(crit2);
                DataObject compGeneralDetailsDataObj = CommonUtil.getPersistence(new boolean[0]).get("ADSMComputerGeneralDetails", joinCrit);
                computerDetails.put("CanonicalName", compGeneralDetailsDataObj.getRow("ADSMComputerGeneralDetails").get("CANONICAL_NAME"));
                configuredServersList.add(computerDetails);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return configuredServersList;
    }

    public boolean updateServerSelectionForFIM(String tableName, String criteriaColumn, JSONObject confMap) {
        boolean result = Boolean.TRUE;
        try {
            Iterator keys = confMap.keys();
            Column col = Column.getColumn((String)tableName, (String)criteriaColumn);
            while (keys.hasNext()) {
                String key = keys.next().toString();
                Criteria criteria = new Criteria(col, (Object)key, 0);
                DataObject tableDO = CommonUtil.getPersistence(new boolean[0]).get(tableName, criteria);
                if (tableDO.isEmpty()) {
                    REPORT_LOGGER.log(Level.INFO, "FIM->No data found for ID" + key + " in table " + tableName);
                    continue;
                }
                Row row = tableDO.getFirstRow(tableName);
                row.set("IS_FIM_ENABLED", (Object)Integer.valueOf(confMap.get(key).toString()));
                tableDO.updateRow(row);
                CommonUtil.getPersistence(new boolean[0]).update(tableDO);
                REPORT_LOGGER.log(Level.INFO, "FIM->Change updated for the " + key + " in table " + confMap.get(key));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFimEnabledDomainList() {
        List<String> list = fimConfiguredDomains;
        synchronized (list) {
            try {
                fimConfiguredDomains.clear();
                Criteria criteria = new Criteria(Column.getColumn((String)"AUDFIMDomainConfiguration", (String)"UNIQUE_ID"), null, 1);
                criteria = criteria.and(new Criteria(Column.getColumn((String)"AUDFIMDomainConfiguration", (String)"IS_CONFIGURED"), (Object)1, 0));
                DataObject defaultDO = CommonUtil.getPersistence(new boolean[0]).get("AUDFIMDomainConfiguration", criteria);
                if (defaultDO.isEmpty()) {
                    REPORT_LOGGER.log(Level.SEVERE, "FIM->No Data Available in AUDFIMDomainConfiguration");
                } else {
                    int rowCount = defaultDO.size("AUDFIMDomainConfiguration");
                    Iterator iterator = defaultDO.getRows("AUDFIMDomainConfiguration");
                    for (int i = 0; i < rowCount; ++i) {
                        Row row = (Row)iterator.next();
                        String domainName = (String)row.get("DOMAIN_NAME");
                        fimConfiguredDomains.add(domainName);
                    }
                }
                REPORT_LOGGER.log(Level.FINE, "FIM->fimConfiguredDomains->" + fimConfiguredDomains);
            }
            catch (Exception ex) {
                REPORT_LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    public boolean isFIMEnabledInDomain(String domainName) {
        return fimConfiguredDomains.contains(domainName);
    }

    public boolean addNewData(String tableName, String domainName, JSONObject newDatas) {
        String keyColumn = "FOLDER_PATH";
        if (tableName.equals("AUDFIMFileConf")) {
            keyColumn = "FILE_TYPE";
        }
        boolean result = Boolean.TRUE;
        try {
            Iterator keys = newDatas.keys();
            DataObject tableDO = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            while (keys.hasNext()) {
                String key = keys.next().toString();
                Row row = new Row(tableName);
                row.set("DOMAIN_NAME", (Object)domainName);
                row.set(keyColumn, (Object)key);
                row.set("IS_SELECTED", (Object)Integer.valueOf(newDatas.get(key).toString()));
                tableDO.addRow(row);
                REPORT_LOGGER.log(Level.INFO, "FIM->Change updated for the " + key + " in table " + newDatas.get(key));
            }
            CommonUtil.getPersistence(new boolean[0]).add(tableDO);
        }
        catch (Exception ex) {
            result = Boolean.FALSE;
            ex.printStackTrace();
        }
        return result;
    }

    public boolean isDuplicate(String domainName, String tableName, String columnName, String value, String deletedList) {
        boolean result = Boolean.FALSE;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)domainName, 0);
            criteria = criteria.and(new Criteria(Column.getColumn((String)tableName, (String)columnName), (Object)value, 0, false));
            DataObject confTableDO = CommonUtil.getPersistence(new boolean[0]).get(tableName, criteria);
            result = !confTableDO.isEmpty();
            REPORT_LOGGER.log(Level.INFO, "FIM->IsDuplicate - " + result + " value -> " + value + " Domain-> " + domainName);
            if (result) {
                Row r = confTableDO.getRow(tableName);
                Long uniqueid = (Long)r.get("UNIQUE_ID");
                StringTokenizer list = new StringTokenizer(deletedList, ",");
                while (list.hasMoreTokens()) {
                    result = !uniqueid.equals(Long.valueOf(list.nextToken()));
                }
            }
        }
        catch (Exception ex) {
            REPORT_LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFIMEnabledServers() {
        HashMap<String, Integer> hashMap = fimEnabledOnMap;
        synchronized (hashMap) {
            fimEnabledOnMap.clear();
            try {
                int size = fimConfiguredDomains.size();
                for (int i = 0; i < size; ++i) {
                    Integer result = 0;
                    String domainName = fimConfiguredDomains.get(i);
                    Hashtable<String, Hashtable<String, Object>> fimEnabledOn = this.getFimEnabledMachineTypes(domainName);
                    Hashtable<String, Object> serverProps = fimEnabledOn.get(RB.getString(MACHINE_TYPES_STRING[0]));
                    Integer isFimEnabled = (Integer)serverProps.get("IS_SELECTED");
                    if (isFimEnabled == 1) {
                        result = result + MACHINE_TYPE_CONSTANTS[0];
                    }
                    if ((isFimEnabled = (Integer)(serverProps = fimEnabledOn.get(RB.getString(MACHINE_TYPES_STRING[1]))).get("IS_SELECTED")) == 1) {
                        result = result + MACHINE_TYPE_CONSTANTS[1];
                    }
                    fimEnabledOnMap.put(domainName, result);
                }
                REPORT_LOGGER.log(Level.FINE, "FIM->fimEnabledOnMap=" + fimEnabledOnMap);
            }
            catch (Exception ex) {
                REPORT_LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    public static String getDomainName(Long uniqueId) throws Exception {
        Criteria crit = new Criteria(Column.getColumn((String)"AUDFIMDomainConfiguration", (String)"UNIQUE_ID"), (Object)uniqueId, 0);
        DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("AUDFIMDomainConfiguration", crit);
        Row row = dObj.getFirstRow("AUDFIMDomainConfiguration");
        return (String)row.get("DOMAIN_NAME");
    }
}

