/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.gpo;

import com.adventnet.sym.adsm.auditing.server.gpo.GPOUtil;
import com.adventnet.sym.adsm.auditing.server.gpo.extensions.ExtensionCompator;
import com.adventnet.sym.adsm.auditing.server.gpo.extensions.PrefComparator;
import java.util.HashMap;
import java.util.Properties;

public class ExtnComparatorAPI {
    private static ExtnComparatorAPI comparatorAPI = null;
    private static HashMap<String, ExtensionCompator> extnComparatorMap = null;
    private static Properties extnComparatorProperties = null;
    private static final String[] COMP_CLASSES = new String[]{"SecurityComparator", "AuditSettingsComparator", "AdmTemplateComparator", "ScriptsComparator", "SoftwareSettingsComparator", "FRSettingsComparator", "EQOSComparator", "IESComparator", "SecurityComparator", "SecurityComparator", "SecurityComparator", "SecurityComparator"};
    private static final String PACKAGE_NAME = "com.adventnet.sym.adsm.auditing.server.gpo.extensions";
    private static ExtensionCompator prefComparator = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExtnComparatorAPI getInstance() {
        if (comparatorAPI != null) return comparatorAPI;
        Class<ExtnComparatorAPI> clazz = ExtnComparatorAPI.class;
        synchronized (ExtnComparatorAPI.class) {
            comparatorAPI = new ExtnComparatorAPI();
            // ** MonitorExit[var0] (shouldn't be in output)
            return comparatorAPI;
        }
    }

    private ExtnComparatorAPI() {
        extnComparatorProperties = new Properties();
        for (int i = 0; i < COMP_CLASSES.length; ++i) {
            extnComparatorProperties.setProperty(GPOUtil.POLICY_EXTN_ELEMENTS[i], COMP_CLASSES[i]);
        }
        this.getExtnComparators();
        prefComparator = new PrefComparator();
    }

    public ExtensionCompator getPrefComparator() {
        return prefComparator;
    }

    private void getExtnComparators() {
        extnComparatorMap = new HashMap();
        for (int i = 0; i < COMP_CLASSES.length; ++i) {
            try {
                Class<?> classToInvoke = Class.forName("com.adventnet.sym.adsm.auditing.server.gpo.extensions." + COMP_CLASSES[i].trim());
                ExtensionCompator compator = (ExtensionCompator)classToInvoke.newInstance();
                extnComparatorMap.put(GPOUtil.POLICY_EXTN_ELEMENTS[i], compator);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public ExtensionCompator getExtensionCompator(String extnName) {
        if (extnComparatorMap == null) {
            this.getExtnComparators();
        }
        if (extnComparatorMap.get(extnName) == null) {
            try {
                Class<?> classToInvoke = Class.forName("com.adventnet.sym.adsm.auditing.server.gpo.extensions." + extnComparatorProperties.getProperty(extnName).trim());
                extnComparatorMap.put(extnName, (ExtensionCompator)classToInvoke.newInstance());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return extnComparatorMap.get(extnName);
    }
}

