/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.gpo;

import com.adventnet.sym.adsm.auditing.server.gpo.ExtnComparatorAPI;
import com.adventnet.sym.adsm.auditing.server.gpo.GPOPolicyPathAPI;
import com.adventnet.sym.adsm.auditing.server.gpo.GPOUtil;
import com.adventnet.sym.adsm.auditing.server.gpo.XMLParserUtil;
import com.adventnet.sym.adsm.auditing.server.gpo.extensions.ExtensionCompator;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GPOComparator {
    private static final Logger EVENT_LOGGER = Logger.getLogger("EventLogger");
    private static GPOComparator gpoComparator = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GPOComparator getInstance() {
        if (gpoComparator != null) return gpoComparator;
        Class<GPOComparator> clazz = GPOComparator.class;
        synchronized (GPOComparator.class) {
            gpoComparator = new GPOComparator();
            // ** MonitorExit[var0] (shouldn't be in output)
            return gpoComparator;
        }
    }

    private GPOComparator() {
    }

    public HashMap compareGPO(String newFileName, String oldFileName) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        HashMap changeMap = new HashMap();
        List<Element> newElementList = XMLParserUtil.getElementList(newFileName);
        Element newCompConfElement = XMLParserUtil.getElement(newElementList, "Computer");
        Element newUserConfElement = XMLParserUtil.getElement(newElementList, "User");
        Element oldCompConfElement = null;
        Element oldUserConfElement = null;
        if (oldFileName != null) {
            List<Element> oldElementList = XMLParserUtil.getElementList(oldFileName);
            oldCompConfElement = XMLParserUtil.getElement(oldElementList, "Computer");
            oldUserConfElement = XMLParserUtil.getElement(oldElementList, "User");
        }
        this.getChanges(newCompConfElement, oldCompConfElement, changeMap, "Computer");
        this.getChanges(newUserConfElement, oldUserConfElement, changeMap, "User");
        return changeMap;
    }

    public ArrayList<String> compareGPOForLink(String newFileName, String oldFileName) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        ArrayList<String> linkValuesList = new ArrayList<String>();
        try {
            Document doc = XMLParserUtil.parseXml(new File(newFileName));
            NodeList list1 = doc.getElementsByTagName("LinksTo");
            for (int i = 0; i < list1.getLength(); ++i) {
                HashMap changeMap = new HashMap();
                Element newElement = (Element)list1.item(i);
                this.getLinksToValues(newElement, changeMap);
                String OUName = (String)changeMap.get("SOMName");
                if (!changeMap.get("Enabled").equals("true")) continue;
                linkValuesList.add(OUName);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return linkValuesList;
    }

    private void getChanges(Element newElement, Element oldElement, HashMap changeMap, String settingType) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        this.getVersionChanges(newElement, oldElement, changeMap);
        this.getExtensionChanges(newElement, oldElement, changeMap, settingType);
    }

    private void getExtensionChanges(Element newElement, Element oldElement, HashMap changeMap, String settingType) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        List<Element> oldExtensionList;
        List<Element> newExtensionList;
        ExtensionCompator compator;
        int i;
        HashMap<String, List<Element>> newExtnMap = XMLParserUtil.getExtenstionMap(newElement);
        HashMap<String, List<Element>> oldExtnMap = XMLParserUtil.getExtenstionMap(oldElement);
        List<String> newErrorList = XMLParserUtil.getExtnErrors(newElement);
        List<String> oldErrorList = XMLParserUtil.getExtnErrors(oldElement);
        if (oldExtnMap == null) {
            oldExtnMap = new HashMap();
        }
        for (i = 0; i < GPOUtil.POLICY_EXTN_ELEMENTS.length; ++i) {
            compator = ExtnComparatorAPI.getInstance().getExtensionCompator(GPOUtil.POLICY_EXTN_ELEMENTS[i]);
            if (compator != null) {
                try {
                    newExtensionList = newExtnMap.get(GPOUtil.POLICY_EXTN_ELEMENTS[i]);
                    oldExtensionList = oldExtnMap.get(GPOUtil.POLICY_EXTN_ELEMENTS[i]);
                    if (newExtensionList == null && oldExtensionList == null || newErrorList.contains(GPOUtil.POLICY_EXTN_ELEMENT_NAMES[i]) || oldErrorList.contains(GPOUtil.POLICY_EXTN_ELEMENT_NAMES[i])) continue;
                    compator.compareExtension(newExtensionList, oldExtensionList, changeMap, settingType, GPOUtil.POLICY_EXTN_ELEMENTS[i]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            EVENT_LOGGER.warning("Not able to getComparator Class for Extn Element :" + GPOUtil.POLICY_EXTN_ELEMENTS[i]);
        }
        for (i = 0; i < GPOUtil.SIMPLE_PREF_EXTN_ELEMENTS.length; ++i) {
            compator = ExtnComparatorAPI.getInstance().getPrefComparator();
            if (compator != null) {
                try {
                    newExtensionList = newExtnMap.get(GPOUtil.SIMPLE_PREF_EXTN_ELEMENTS[i]);
                    oldExtensionList = oldExtnMap.get(GPOUtil.SIMPLE_PREF_EXTN_ELEMENTS[i]);
                    if (newExtensionList == null && oldExtensionList == null) continue;
                    EVENT_LOGGER.info("COMPARING :" + GPOUtil.SIMPLE_PREF_EXTN_ELEMENTS[i]);
                    compator.compareExtension(newExtensionList, oldExtensionList, changeMap, settingType, GPOUtil.SIMPLE_PREF_EXTN_ELEMENTS[i], i);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            EVENT_LOGGER.warning("Not able to getComparator Class for Extn Element :" + GPOUtil.SIMPLE_PREF_EXTN_ELEMENTS[i]);
        }
    }

    private void getLinksToValues(Element newElement, HashMap detailMap) {
        for (int i = 0; i < GPOUtil.VERSION_PROPLINK.length; ++i) {
            Element newVerElement = XMLParserUtil.getChildElement(newElement, GPOUtil.VERSION_PROPLINK[i]);
            String newVerValue = newVerElement.getTextContent();
            detailMap.put(GPOUtil.VERSION_PROPLINK[i], newVerValue);
        }
    }

    private void getVersionChanges(Element newElement, Element oldElement, HashMap changeMap) {
        Long policyPathId;
        ArrayList changeList;
        int changeType = 1;
        if (oldElement != null) {
            changeType = 2;
        }
        if ((changeList = (ArrayList)changeMap.get(policyPathId = Long.valueOf(GPOPolicyPathAPI.getInstance().getPolicyPathId("adap.AUDGPPolicyPathMapping.policy_path.Details", "AudGPPolicyPathMapping:policy_path_id:1")))) == null) {
            changeList = new ArrayList();
        }
        for (int i = 0; i < GPOUtil.VERSION_PROP.length; ++i) {
            Element newVerElement = XMLParserUtil.getChildElement(newElement, GPOUtil.VERSION_PROP[i]);
            String newVerValue = newVerElement.getTextContent();
            HashMap<String, Object> detailMap = new HashMap<String, Object>();
            boolean changed = false;
            if (changeType == 2) {
                Element oldVerElement = XMLParserUtil.getChildElement(oldElement, GPOUtil.VERSION_PROP[i]);
                String oldVerValue = oldVerElement.getTextContent();
                if (!oldVerValue.equals(newVerValue)) {
                    changed = true;
                    detailMap.put("SETTING_OLD_VALUE", oldVerValue);
                }
            } else {
                changed = true;
            }
            if (!changed) continue;
            detailMap.put("CHANGE_TYPE", changeType);
            detailMap.put("CHANGE_TYPE_TEXT", GPOUtil.getChangeText(changeType));
            detailMap.put("SETTING_NAME", newElement.getNodeName() + " " + GPOUtil.VERSION_PROP_TEXT[i]);
            detailMap.put("SETTING_NEW_VALUE", newVerValue);
            changeList.add(detailMap);
        }
        if (!changeList.isEmpty()) {
            changeMap.put(policyPathId, changeList);
        }
    }
}

