/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.gpo;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.GroupByClause;
import com.adventnet.ds.query.GroupByColumn;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.sym.adsm.auditing.server.gpo.GPODetailsAPI;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;

public class GPODCDetailsAPI {
    private static volatile GPODCDetailsAPI gpoDCDetailsAPI = null;
    private static Hashtable<String, ArrayList<String>> prefDCPropeties = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GPODCDetailsAPI getInstance() {
        if (gpoDCDetailsAPI != null) return gpoDCDetailsAPI;
        Class<GPODetailsAPI> clazz = GPODetailsAPI.class;
        synchronized (GPODetailsAPI.class) {
            gpoDCDetailsAPI = new GPODCDetailsAPI();
            // ** MonitorExit[var0] (shouldn't be in output)
            return gpoDCDetailsAPI;
        }
    }

    private GPODCDetailsAPI() {
        prefDCPropeties = new Hashtable();
        if (prefDCPropeties.isEmpty()) {
            this.setPrefDCPropeties();
        }
    }

    public static ArrayList<String> getPrefDCPropeties(String domainName) {
        return prefDCPropeties.get(domainName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPrefDCPropeties() {
        DataSet dataSet = null;
        Connection connection = null;
        try {
            Column sourceColumn = Column.getColumn((String)"AUDGPOMgmt", (String)"SOURCE");
            Column domainColumn = Column.getColumn((String)"AUDGPOMgmt", (String)"PRIMARY_DOMAIN");
            Column uniqueIdCountColumn = Column.getColumn((String)"AUDGPOMgmt", (String)"UNIQUE_ID").count();
            GroupByColumn groupBySourceColumn = new GroupByColumn(sourceColumn, false);
            GroupByColumn groupByDomainColumn = new GroupByColumn(domainColumn, false);
            ArrayList<GroupByColumn> groupByColumnList = new ArrayList<GroupByColumn>();
            groupByColumnList.add(groupByDomainColumn);
            groupByColumnList.add(groupBySourceColumn);
            GroupByClause groupByClause = new GroupByClause(groupByColumnList);
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"AUDGPOMgmt"));
            selectQuery.setGroupByClause(groupByClause);
            selectQuery.addSelectColumn(domainColumn);
            selectQuery.addSelectColumn(sourceColumn);
            selectQuery.addSelectColumn(uniqueIdCountColumn);
            selectQuery.addSortColumn(new SortColumn(uniqueIdCountColumn, false));
            connection = RelationalAPI.getInstance().getConnection();
            dataSet = RelationalAPI.getInstance().executeQuery((Query)selectQuery, connection);
            if (dataSet != null) {
                while (dataSet.next()) {
                    String domainName = dataSet.getValue(1).toString();
                    ArrayList<Object> dcCountTable = prefDCPropeties.get(domainName) == null ? new ArrayList() : prefDCPropeties.get(domainName);
                    dcCountTable.add(dataSet.getValue(2).toString());
                    prefDCPropeties.put(domainName, dcCountTable);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (dataSet != null) {
                    dataSet.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
    }
}

