/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.gpo;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.objects.ObjectAttributeHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;

public class GPODetailsAPI {
    private static GPODetailsAPI detailsAPI = null;
    public static HashMap gpoGUIDMap = null;
    public static HashMap gpoNameGUIDMap = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GPODetailsAPI getInstance() {
        if (detailsAPI != null) return detailsAPI;
        Class<GPODetailsAPI> clazz = GPODetailsAPI.class;
        synchronized (GPODetailsAPI.class) {
            detailsAPI = new GPODetailsAPI();
            // ** MonitorExit[var0] (shouldn't be in output)
            return detailsAPI;
        }
    }

    private GPODetailsAPI() {
        try {
            gpoGUIDMap = new HashMap();
            this.setGPOObjectGUIDMap();
            this.setGPONameMap();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public HashMap getGPODetails(String objectGUID) {
        HashMap<String, String> gpoDetailsMap = new HashMap<String, String>();
        try {
            String tableName = "ADSMGPODetails";
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)tableName));
            selectQuery.addSelectColumn(Column.getColumn((String)tableName, (String)"*"));
            Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"OBJECT_GUID"), (Object)objectGUID, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get(tableName, crit);
            Row row = obj.getRow(tableName);
            if (row != null) {
                gpoDetailsMap = new HashMap();
                String domainName = (String)row.get("DOMAIN_NAME");
                String gpoName = (String)row.get("GPO_NAME");
                gpoDetailsMap.put("DOMAIN_NAME", domainName);
                gpoDetailsMap.put("GPO_NAME", gpoName);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return gpoDetailsMap;
    }

    public void updateGPO(String domainName, String gpoNameGUID) {
        try {
            String tableName = "ADSMGPODetails";
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"GPO_NAME"), (Object)gpoNameGUID, 0);
            criteria = criteria.and(new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)domainName, 0));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(tableName, criteria);
            if (dataObject.getRow(tableName) == null) {
                ArrayList arrayList = ObjectAttributeHandler.getInstance().getTotalColumn(503);
                ArrayList<String> attributeList = new ArrayList<String>();
                for (Object object2 : arrayList) {
                    Properties properties = (Properties)object2;
                    attributeList.add(properties.getProperty("ATTRIB_LDAP_NAME"));
                }
                Properties domainDetails = DomainHandler.getConfiguredValues(domainName, 1L);
                String searchString = "(&(objectClass=groupPolicyContainer)(name=" + gpoNameGUID + "))";
                ArrayList objectsList = ADHandler.getObjectsWithOutListener(domainDetails, domainDetails.getProperty("DEFAULT_NAMING_CONTEXT"), attributeList, searchString);
                String[] propertyKey = new String[]{"objectGUID", "name", "canonicalName", "displayName"};
                String[] columnName = new String[]{"OBJECT_GUID", "GPO_NAME", "CANONICAL_NAME", "NAME"};
                Properties prop = (Properties)objectsList.get(0);
                Row row = new Row(tableName);
                row.set("DOMAIN_NAME", (Object)domainName);
                for (int i = 0; i < propertyKey.length; ++i) {
                    ArrayList list = (ArrayList)prop.get(propertyKey[i]);
                    if (list == null || list.isEmpty()) continue;
                    row.set(columnName[i], list.get(0));
                }
                ArrayList list = (ArrayList)prop.get("whenCreated");
                row.set("WHEN_CREATED", (Object)Long.parseLong((String)list.get(0)));
                list = (ArrayList)prop.get("whenChanged");
                row.set("WHEN_CHANGED", (Object)Long.parseLong((String)list.get(0)));
                dataObject.addRow(row);
                CommonUtil.getPersistence(new boolean[0]).update(dataObject);
            }
            this.setGPOObjectGUIDMap();
            this.setGPONameMap();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public HashMap getGPOObjectGUIDMap(String domainName) {
        HashMap domainGUIDMap = new HashMap();
        try {
            if (gpoGUIDMap == null) {
                this.setGPOObjectGUIDMap();
            }
            domainGUIDMap = (HashMap)gpoGUIDMap.get(domainName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return domainGUIDMap;
    }

    public void setGPOObjectGUIDMap() {
        try {
            String tableName = "ADSMGPODetails";
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)tableName));
            selectQuery.addSelectColumn(Column.getColumn((String)tableName, (String)"*"));
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get(tableName, (Criteria)null);
            Iterator iterator = obj.getRows(tableName);
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                String domainName = (String)row.get("DOMAIN_NAME");
                String gpoName = (String)row.get("GPO_NAME");
                String objectGuId = (String)row.get("OBJECT_GUID");
                HashMap<String, String> gpoNameMap = (HashMap<String, String>)gpoGUIDMap.get(domainName);
                if (gpoNameMap == null) {
                    gpoNameMap = new HashMap<String, String>();
                }
                gpoNameMap.put(gpoName.toLowerCase(), objectGuId);
                gpoGUIDMap.put(domainName, gpoNameMap);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setGPONameMap() {
        try {
            String tableName = "ADSMGPODetails";
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)tableName));
            selectQuery.addSelectColumn(Column.getColumn((String)tableName, (String)"*"));
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get(tableName, (Criteria)null);
            Iterator iterator = obj.getRows(tableName);
            gpoNameGUIDMap = new HashMap();
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                String objectGUID = (String)row.get("OBJECT_GUID");
                String gpoName = (String)row.get("NAME");
                gpoNameGUIDMap.put(objectGUID.toLowerCase(), gpoName);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getGPOName(String gpoGUID) {
        String gpoName = "-";
        try {
            gpoName = (String)gpoNameGUIDMap.get(gpoGUID);
            if (gpoNameGUIDMap == null || gpoName == null) {
                this.setGPONameMap();
            }
            gpoName = (String)gpoNameGUIDMap.get(gpoGUID);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return gpoName;
    }
}

