/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.gpo;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.gpo.GPOComparator;
import com.adventnet.sym.adsm.auditing.server.gpo.GPODetailsAPI;
import com.adventnet.sym.adsm.auditing.server.gpo.GPOUtil;
import com.adventnet.sym.adsm.auditing.server.gpo.XMLParserUtil;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.ADSMPersUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GPOManagementListener {
    private static final Logger EVENT_LOGGER = Logger.getLogger("EventLogger");
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private static GPOManagementListener gpoManagementListener = null;
    private static HashMap gpoMap = null;
    public static Queue gpoQueue = null;
    public static Action action = null;
    private static long gpoXMLGenerationWaitTime = 60000L;

    private GPOManagementListener() {
        try {
            gpoMap = new HashMap();
            gpoQueue = new LinkedList();
            String waitTimeFromDB = ADSMPersUtil.getSyMParameter("GPO_XML_GENERATION_WAIT_TIME");
            if (waitTimeFromDB != null) {
                gpoXMLGenerationWaitTime = Long.parseLong(waitTimeFromDB);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GPOManagementListener getInstance() {
        if (gpoManagementListener != null) return gpoManagementListener;
        Class<GPOManagementListener> clazz = GPOManagementListener.class;
        synchronized (GPOManagementListener.class) {
            gpoManagementListener = new GPOManagementListener();
            // ** MonitorExit[var0] (shouldn't be in output)
            return gpoManagementListener;
        }
    }

    public void addGPONameInQueue(String domainName) {
        try {
            if (LicenseUtil.isProfEdn()) {
                String tableName = "ADSMGPODetails";
                Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)domainName, 0);
                DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(tableName, crit);
                if (!dataObj.isEmpty()) {
                    GPODetailsAPI.getInstance().setGPOObjectGUIDMap();
                    Iterator iterator = dataObj.getRows(tableName);
                    LinkedList gpoQueue = new LinkedList();
                    while (iterator.hasNext()) {
                        Row row = (Row)iterator.next();
                        if (row == null) continue;
                        HashMap<String, Object> queueMap = new HashMap<String, Object>();
                        String gpoName = (String)row.get("GPO_NAME");
                        queueMap.put("DomainName", domainName);
                        queueMap.put("GPOGuID", gpoName.toLowerCase());
                        queueMap.put("isCompare", false);
                        gpoQueue.add(queueMap);
                    }
                    this.startProcessThread(gpoQueue);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void startFileWatcher(Boolean b) {
        try {
            String domainName = "";
            if (LicenseUtil.isProfEdn()) {
                String tableName = "AUDGPOFileWatcherDetails";
                SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)tableName));
                Criteria criteria = null;
                if (!b.booleanValue()) {
                    criteria = new Criteria(Column.getColumn((String)tableName, (String)"STATUS"), (Object)b, 0);
                    query.setCriteria(criteria);
                }
                query.addSelectColumn(Column.getColumn((String)tableName, (String)"*"));
                DataObject obj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
                if (!obj.isEmpty()) {
                    Iterator iterator = obj.getRows(tableName);
                    while (iterator.hasNext()) {
                        Row row = (Row)iterator.next();
                        domainName = (String)row.get("DOMAIN_NAME");
                        this.startFileWatcherThread(domainName);
                    }
                } else if (b.booleanValue()) {
                    ArrayList domainList = DomainHandler.getDomainList();
                    for (Object object : domainList) {
                        Properties domainNameProp = (Properties)object;
                        domainName = domainNameProp.getProperty("DOMAIN_NAME");
                        HashMap<String, Object> rowDataMap = new HashMap<String, Object>();
                        rowDataMap.put("DOMAIN_NAME", domainName);
                        rowDataMap.put("MESSAGE", "Success");
                        rowDataMap.put("STATUS", true);
                        GPOManagementListener.getInstance().updateGPOFileWatcherDetails(rowDataMap);
                        this.startFileWatcherThread(domainName);
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public synchronized void addInQueue(Object object) {
        try {
            HashMap<String, Object> queueMap = new HashMap<String, Object>();
            if (gpoQueue == null) {
                gpoQueue = new LinkedList();
            }
            Hashtable hashtable = (Hashtable)object;
            String fileName = (String)hashtable.get("FileName");
            String domainName = (String)hashtable.get("DomainName");
            String gpoGuId = null;
            if (fileName != null) {
                gpoGuId = GPOUtil.getGPONameGUID(fileName);
            }
            if (gpoGuId != null && domainName != null) {
                queueMap.put("DomainName", domainName);
                queueMap.put("GPOGuID", gpoGuId.toLowerCase());
            }
            queueMap.put("isCompare", true);
            Long modifiedTime = 0L;
            if (gpoQueue != null && !gpoQueue.contains(queueMap)) {
                gpoQueue.add(queueMap);
                this.startAction();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void startAction() {
        try {
            if (action == null) {
                action = new Action();
                action.start();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void startProcessThread(Queue queue) {
        try {
            if (!queue.isEmpty()) {
                ProcessThread processThread = new ProcessThread(queue);
                processThread.start();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void process(HashMap queueMap) {
        String message = rb.getString("adap.common.text.status_msg.success");
        String fileName = null;
        HashMap<String, Object> xmlDetailsMap = new HashMap<String, Object>();
        HashMap<String, String> gpoAuditInfoMap = new HashMap<String, String>();
        try {
            Hashtable result;
            String gpoGuId = (String)queueMap.get("GPOGuID");
            String domainName = (String)queueMap.get("DomainName");
            String gpoXmlDir = GPOUtil.getGPOXMLDir(domainName, gpoGuId);
            HashMap domainObjectGUIDMap = GPODetailsAPI.getInstance().getGPOObjectGUIDMap(domainName);
            String objectGUID = null;
            if (domainObjectGUIDMap != null && domainObjectGUIDMap.get(gpoGuId) != null) {
                objectGUID = (String)domainObjectGUIDMap.get(gpoGuId);
                if (objectGUID != null) {
                    xmlDetailsMap.put("OBJECT_GUID", objectGUID);
                    gpoAuditInfoMap.put("OBJECT_GUID", objectGUID);
                }
            } else {
                GPODetailsAPI.getInstance().updateGPO(domainName, gpoGuId);
                Thread.sleep(2000L);
                domainObjectGUIDMap = GPODetailsAPI.getInstance().getGPOObjectGUIDMap(domainName);
                if (domainObjectGUIDMap != null) {
                    objectGUID = (String)domainObjectGUIDMap.get(gpoGuId);
                    xmlDetailsMap.put("OBJECT_GUID", objectGUID);
                    gpoAuditInfoMap.put("OBJECT_GUID", objectGUID);
                }
            }
            if ((result = (Hashtable)ADHandler.generateGpoReport(domainName, gpoGuId, gpoXmlDir)) != null) {
                String fileLocation = (String)result.get("GPO_TARGET_PATH");
                fileName = (String)result.get("VER_FILE_NAME");
                xmlDetailsMap.put("FILE_NAME", fileName);
                xmlDetailsMap.put("FILE_LOCATION", fileLocation);
                Integer gpoVersion = (Integer)result.get("GPO_VERSION");
                xmlDetailsMap.put("VERSION", gpoVersion.longValue());
                String isHtmlGenerated = (String)result.get("IS_HTML_GENERATED");
                Boolean htmlGenerated = Boolean.valueOf(isHtmlGenerated);
                xmlDetailsMap.put("IS_HTML_GENERATED", htmlGenerated);
                boolean isCompare = (Boolean)queueMap.get("isCompare");
                if (isCompare) {
                    GPOUtil.setCallerUserName(result, domainName, objectGUID, gpoGuId, gpoAuditInfoMap);
                    String absoluteFileName = fileLocation + File.separator + fileName;
                    Map<String, List<String>> errorMap = XMLParserUtil.getExtnErrors(absoluteFileName);
                    EVENT_LOGGER.log(Level.INFO, "Started Comparing xmls for GPO :" + objectGUID);
                    if (errorMap != null) {
                        xmlDetailsMap.put("ERROR_DETAILS", errorMap);
                    }
                    String previousVersionFile = GPOUtil.getFileInfo(objectGUID, null, "xml", true);
                    HashMap changeMap = GPOComparator.getInstance().compareGPO(absoluteFileName, previousVersionFile);
                    xmlDetailsMap.put("CHANGE_DETAILS", changeMap);
                    ArrayList<String> LinkMapList = GPOComparator.getInstance().compareGPOForLink(absoluteFileName, previousVersionFile);
                    if (!LinkMapList.isEmpty()) {
                        gpoAuditInfoMap.put("LINK_ENABLED", Arrays.toString(LinkMapList.toArray(new String[LinkMapList.size()])));
                    }
                } else {
                    gpoAuditInfoMap = null;
                }
            }
            Long systemCurrentTime = System.currentTimeMillis() / 1000L;
            xmlDetailsMap.put("XML_CREATION_TIME", systemCurrentTime);
            xmlDetailsMap.put("ZIP_STATUS", false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            message = ex.getMessage();
        }
        finally {
            try {
                xmlDetailsMap.put("STATUS", message);
                if (fileName != null) {
                    this.updateGPOXMLDetails(xmlDetailsMap, gpoAuditInfoMap);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void updateGPOXMLDetails(HashMap rowDataMap, HashMap gpoAuditInfoMap) {
        try {
            boolean add = false;
            String tableName = "AudGPOXMLDetails";
            String objectGuId = (String)rowDataMap.get("OBJECT_GUID");
            Long gpoVersion = (Long)rowDataMap.get("VERSION");
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"OBJECT_GUID"), (Object)objectGuId, 0);
            criteria = criteria.and(new Criteria(Column.getColumn((String)tableName, (String)"VERSION"), (Object)gpoVersion, 0));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(tableName, criteria);
            Row row = dataObject.getRow(tableName);
            if (row == null) {
                row = new Row(tableName);
                add = true;
            }
            GPOUtil.setRowValues(rowDataMap, dataObject, row, add, gpoAuditInfoMap);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void updateGPOFileWatcherDetails(HashMap rowDataMap) {
        try {
            DataObject dataObject;
            Row row;
            boolean add = false;
            String tableName = "AUDGPOFileWatcherDetails";
            String domainName = (String)rowDataMap.get("DOMAIN_NAME");
            Criteria criteria = null;
            if (domainName != null) {
                criteria = new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)domainName, 0);
            }
            if ((row = (dataObject = CommonUtil.getPersistence(new boolean[0]).get(tableName, criteria)).getRow(tableName)) == null) {
                row = new Row(tableName);
                add = true;
            }
            GPOUtil.setRowValues(rowDataMap, dataObject, row, add, null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void startFileWatcherThread(String domainName) {
        try {
            FileWatcherThread fileWatcherThread = new FileWatcherThread(domainName);
            fileWatcherThread.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    class Action
    extends Thread {
        private boolean shutDown = false;

        Action() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try {
                block2: while (!this.shutDown) {
                    if (gpoQueue.size() > 0) {
                        block3: while (true) {
                            if (gpoQueue.size() <= 0) continue block2;
                            int i = 0;
                            while (true) {
                                if (i >= gpoQueue.size()) continue block3;
                                this.waitForUpdate(gpoXMLGenerationWaitTime);
                                HashMap queueMap = (HashMap)gpoQueue.remove();
                                GPOManagementListener.this.process(queueMap);
                                ++i;
                            }
                            break;
                        }
                    }
                    this.waitForUpdate(30000L);
                }
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void shutDown() {
            this.shutDown = true;
        }

        public synchronized void waitForUpdate(long t) {
            try {
                super.wait(t);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public synchronized void notifyThread() {
            try {
                super.notify();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class FileWatcherThread
    extends Thread {
        private boolean shutDown = false;
        private String domainName = null;

        public FileWatcherThread(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public void run() {
            try {
                ADHandler.watchGpoFilePath(this.domainName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void shutDown() {
            this.shutDown = true;
        }

        public synchronized void waitForUpdate(long t) {
            try {
                super.wait(t);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class ProcessThread
    extends Thread {
        private boolean shutDown = false;
        Queue queue = null;

        public ProcessThread(Queue queue) {
            this.queue = queue;
        }

        @Override
        public void run() {
            try {
                if (this.queue.size() > 0) {
                    for (int j = this.queue.size(); j > 0; --j) {
                        HashMap gpoMap = (HashMap)this.queue.remove();
                        GPOManagementListener.this.process(gpoMap);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void shutDown() {
            this.shutDown = true;
        }

        public synchronized void waitForUpdate(long t) {
            try {
                super.wait(t);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

