/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.gpo;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class GPOPolicyPathAPI {
    private static GPOPolicyPathAPI policyPathAPI = null;
    private static ArrayList policyPathList = null;
    private static HashMap<Long, String> policyPathDisplayMap = null;
    private static HashMap<Long, String> localizedPolicyPathDisplayMap = null;
    public static final String POLICY_PATH_TABLE_NAME = "AudGPPolicyPathMapping";
    public static final String POLICY_PATH_ID = "POLICY_PATH_ID";
    public static final String PARENT_POLICY_PATH_ID = "PARENT_POLICY_PATH_ID";
    public static final String POLICY_PATH = "POLICY_PATH";
    public static final String HAS_CHILD_NODES = "HAS_CHILD_NODES";
    public static final String PRIORITY_ID = "PRIORITY_ID";
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GPOPolicyPathAPI getInstance() {
        if (policyPathAPI != null) return policyPathAPI;
        Class<GPOPolicyPathAPI> clazz = GPOPolicyPathAPI.class;
        synchronized (GPOPolicyPathAPI.class) {
            policyPathAPI = new GPOPolicyPathAPI();
            // ** MonitorExit[var0] (shouldn't be in output)
            return policyPathAPI;
        }
    }

    public GPOPolicyPathAPI() {
        if (policyPathList == null) {
            this.getPolicyPathDetails();
        }
    }

    private void getPolicyPathDetails() {
        policyPathList = new ArrayList();
        policyPathDisplayMap = new HashMap();
        localizedPolicyPathDisplayMap = new HashMap();
        try {
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(POLICY_PATH_TABLE_NAME, (Row)null);
            Criteria criteria = new Criteria(Column.getColumn((String)POLICY_PATH_TABLE_NAME, (String)PARENT_POLICY_PATH_ID), (Object)0, 0);
            Iterator rowIterator = dataObject.getRows(POLICY_PATH_TABLE_NAME, criteria);
            while (rowIterator.hasNext()) {
                HashMap<String, Object> policyPathMap = new HashMap<String, Object>();
                Row row = (Row)rowIterator.next();
                Long policyId = (Long)row.get(POLICY_PATH_ID);
                policyPathMap.put(POLICY_PATH_ID, policyId);
                policyPathMap.put(POLICY_PATH, row.get(POLICY_PATH));
                policyPathDisplayMap.put((Long)row.get(POLICY_PATH_ID), this.getFullPath(row, dataObject, null));
                localizedPolicyPathDisplayMap.put((Long)row.get(POLICY_PATH_ID), this.getLocalizedFullPath(row, dataObject, null));
                HashMap childMap = new HashMap();
                this.getAllChildPoliciesMap(policyId, dataObject, childMap);
                policyPathMap.put("CHILD_POLICIES", childMap);
                policyPathList.add(policyPathMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getAllChildPoliciesMap(Long policyId, DataObject dataObject, HashMap childMap) {
        try {
            Criteria criteria2 = new Criteria(Column.getColumn((String)POLICY_PATH_TABLE_NAME, (String)PARENT_POLICY_PATH_ID), (Object)policyId, 0);
            Iterator rowIterator2 = dataObject.getRows(POLICY_PATH_TABLE_NAME, criteria2);
            while (rowIterator2.hasNext()) {
                Row row2 = (Row)rowIterator2.next();
                Long policyPathId = (Long)row2.get(POLICY_PATH_ID);
                childMap.put(row2.get(POLICY_PATH), row2.get(POLICY_PATH_ID));
                policyPathDisplayMap.put(policyPathId, this.getFullPath(row2, dataObject, null));
                localizedPolicyPathDisplayMap.put(policyPathId, this.getLocalizedFullPath(row2, dataObject, null));
                Boolean hasChildNodes = (Boolean)row2.get(HAS_CHILD_NODES);
                if (!hasChildNodes.booleanValue()) continue;
                this.getAllChildPoliciesMap(policyPathId, dataObject, childMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getFullPath(Row row, DataObject dataObject, StringBuilder pathBuilder) {
        Long parentId;
        if (pathBuilder == null) {
            pathBuilder = new StringBuilder();
        }
        if ((parentId = (Long)row.get(PARENT_POLICY_PATH_ID)) == 0L) {
            if (!pathBuilder.toString().equalsIgnoreCase("")) {
                pathBuilder.insert(0, "/");
            }
            pathBuilder.insert(0, row.get(POLICY_PATH).toString());
        } else {
            try {
                if (!pathBuilder.toString().equalsIgnoreCase("")) {
                    pathBuilder.insert(0, "/");
                }
                pathBuilder.insert(0, row.get(POLICY_PATH).toString());
                Criteria criteria = new Criteria(Column.getColumn((String)POLICY_PATH_TABLE_NAME, (String)POLICY_PATH_ID), (Object)parentId, 0);
                Row row2 = dataObject.getRow(POLICY_PATH_TABLE_NAME, criteria);
                this.getFullPath(row2, dataObject, pathBuilder);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return pathBuilder.toString();
    }

    public String getLocalizedFullPath(Row row, DataObject dataObject, StringBuilder pathBuilder) {
        Long parentId;
        if (pathBuilder == null) {
            pathBuilder = new StringBuilder();
        }
        if ((parentId = (Long)row.get(PARENT_POLICY_PATH_ID)) == 0L) {
            if (!pathBuilder.toString().equalsIgnoreCase("")) {
                pathBuilder.insert(0, "/");
            }
            pathBuilder.insert(0, rb.getString(row.get(POLICY_PATH).toString()));
        } else {
            try {
                if (!pathBuilder.toString().equalsIgnoreCase("")) {
                    pathBuilder.insert(0, "/");
                }
                pathBuilder.insert(0, rb.getString(row.get(POLICY_PATH).toString()));
                Criteria criteria = new Criteria(Column.getColumn((String)POLICY_PATH_TABLE_NAME, (String)POLICY_PATH_ID), (Object)parentId, 0);
                Row row2 = dataObject.getRow(POLICY_PATH_TABLE_NAME, criteria);
                this.getLocalizedFullPath(row2, dataObject, pathBuilder);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return pathBuilder.toString();
    }

    public String getDisplayPolicyPath(Long policyPathId) {
        return policyPathDisplayMap.get(policyPathId);
    }

    public String getLocalizedPolicyPath(Long policyPathId) {
        return rb.getString(localizedPolicyPathDisplayMap.get(policyPathId));
    }

    public long getPolicyPathId(String policyPath, String basePolicyIdPattern, String configurationTypePattern) {
        long policyPathId = 0L;
        policyPathId = this.getPolicyPathId(policyPath, configurationTypePattern);
        if (policyPathId == 0L) {
            long parentId = DBObjectUtil.getUVHValues(POLICY_PATH_TABLE_NAME, basePolicyIdPattern);
            policyPathId = this.updatePolicyPath(policyPath, parentId);
        }
        return policyPathId;
    }

    public long getPolicyPathId(String policyPath, Long parentPolicyId, String configurationTypePattern) {
        long policyPathId = 0L;
        policyPathId = this.getPolicyPathId(policyPath, configurationTypePattern);
        if (policyPathId == 0L) {
            policyPathId = this.updatePolicyPath(policyPath, parentPolicyId);
        }
        return policyPathId;
    }

    public long getPolicyPathId(String policyPath, String basePolicyIdPattern) {
        long policyPathId = 0L;
        long parentId = DBObjectUtil.getUVHValues(POLICY_PATH_TABLE_NAME, basePolicyIdPattern);
        for (Object object : policyPathList) {
            HashMap childPoliciesMap;
            HashMap policyPathMap = (HashMap)object;
            if ((Long)policyPathMap.get(POLICY_PATH_ID) != parentId || (childPoliciesMap = (HashMap)policyPathMap.get("CHILD_POLICIES")).get(policyPath) == null) continue;
            policyPathId = (Long)childPoliciesMap.get(policyPath);
            break;
        }
        return policyPathId;
    }

    public long getATPolicyPathId(String policyPath, String configurationType) {
        long policyPathId = 0L;
        String basePolicyIdPattern = "-";
        if (configurationType.equalsIgnoreCase("computer")) {
            basePolicyIdPattern = "AudGPPolicyPathMapping:policy_path_id:2";
        } else if (configurationType.equalsIgnoreCase("user")) {
            basePolicyIdPattern = "AudGPPolicyPathMapping:policy_path_id:3";
        }
        policyPathId = this.getPolicyPathId(policyPath, basePolicyIdPattern);
        if (policyPathId == 0L) {
            policyPathId = this.updateATPolicyPath(policyPath, configurationType);
        }
        return policyPathId;
    }

    public long updatePolicyPath(String policyPath, long parentId) {
        long policyPathId = 0L;
        try {
            Row row = new Row(POLICY_PATH_TABLE_NAME);
            row.set(POLICY_PATH, (Object)policyPath);
            row.set(PRIORITY_ID, (Object)(this.getMaxPriorityId(parentId) + 1));
            row.set(PARENT_POLICY_PATH_ID, (Object)parentId);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            dataObject.addRow(row);
            CommonUtil.getPersistence(new boolean[0]).add(dataObject);
            policyPathId = (Long)row.get(POLICY_PATH_ID);
            for (Object object : policyPathList) {
                HashMap policyPathMap = (HashMap)object;
                HashMap childPoliciesMap = (HashMap)policyPathMap.get("CHILD_POLICIES");
                if (!childPoliciesMap.containsValue(parentId)) continue;
                childPoliciesMap.put(policyPath, policyPathId);
            }
            policyPathDisplayMap.put(policyPathId, this.getDisplayPolicyPath(parentId) + "/" + policyPath);
            localizedPolicyPathDisplayMap.put(policyPathId, this.getLocalizedPolicyPath(parentId) + "/" + rb.getString(policyPath));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return policyPathId;
    }

    public long updateATPolicyPath(String policyPath, String configurationType) {
        long parentId = 0L;
        if (configurationType.equalsIgnoreCase("computer")) {
            parentId = DBObjectUtil.getUVHValues(POLICY_PATH_TABLE_NAME, "AudGPPolicyPathMapping:policy_path_id:213");
        } else if (configurationType.equalsIgnoreCase("user")) {
            parentId = DBObjectUtil.getUVHValues(POLICY_PATH_TABLE_NAME, "AudGPPolicyPathMapping:policy_path_id:313");
        }
        long policyPathId = this.updatePolicyPath(policyPath, parentId);
        return policyPathId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getMaxPriorityId(long parentId) {
        int priorityId = 0;
        String query = "SELECT MAX(PRIORITY_ID) FROM AudGPPolicyPathMapping WHERE PARENT_POLICY_PATH_ID=" + parentId;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = RelationalAPI.getInstance().getConnection();
            statement = connection.createStatement();
            resultSet = QueryUtil.executeQuery("Getting Max of Priority Id", statement, query);
            if (resultSet.next()) {
                priorityId = resultSet.getInt(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return priorityId;
    }
}

