/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.gpo;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.AuditEventAPI;
import com.adventnet.sym.adsm.auditing.server.alert.GPOAlertProfileListener;
import com.adventnet.sym.adsm.auditing.server.eventcollection.EventCollectionUtil;
import com.adventnet.sym.adsm.auditing.server.gpo.GPODCDetailsAPI;
import com.adventnet.sym.adsm.auditing.server.gpo.GPOPolicyPathAPI;
import com.adventnet.sym.adsm.auditing.server.gpo.PDCHandler;
import com.adventnet.sym.adsm.auditing.server.util.EventDataUtil;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.ADSMPersUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import com.adventnet.sym.adsm.common.server.util.TimeUtil;
import com.adventnet.sym.adsm.common.server.util.UserAttributeUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class GPOUtil {
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    public static final String[] VERSION_PROP = new String[]{"VersionDirectory", "VersionSysvol", "Enabled"};
    public static final String[] VERSION_PROP_TEXT = new String[]{"Version (AD) ", "Version (Sysvol)", "Settings Enabled"};
    public static final String[] VERSION_PROPLINK = new String[]{"SOMName", "SOMPath", "Enabled", "NoOverride"};
    private static final String AUD_GP_POLICY_PATH_MAPPING_TABLE = "AUDGPPolicyPathMapping";
    public static final String[] POLICY_EXTN_ELEMENTS = new String[]{"SecuritySettings", "AuditSettings", "RegistrySettings", "Scripts", "SoftwareInstallationSettings", "FolderRedirectionSettings", "EQoSSettings", "InternetExplorerSettings", "SoftwareRestrictionSettings", "PublicKeySettings", "Policy", "WLanSvcSettings"};
    public static final String[] POLICY_EXTN_ELEMENT_NAMES = new String[]{"Security", "Advanced Audit Configuration", "Registry", "Scripts", "Software Installation", "Folder Redirection", "Policy-based QoS", "Internet Explorer Maintenance", "Software Restriction", "Public Key", "Application Control Policies", "WLanSvc Networks"};
    public static final String[] SIMPLE_PREF_EXTN_ELEMENTS = new String[]{"EnvironmentVariablesSettings", "FilesSettings", "FoldersSettings", "IniFilesSettings", "RegistrySettings", "NetworkSharesSettings", "ShortcutSettings", "DriveMapSettings", "RegionalOptionsSettings", "DataSourcesSettings", "DevicesSettings", "LugsSettings", "FolderOptionsSettings", "NetworkOptionsSettings", "PowerOptionsSettings", "ServiceSettings", "ScheduledTasksSettings", "PrintersSettings", "InternetSettings", "StartMenuSettings"};
    public static final Long[] USER_PREF_PATH_ID = new Long[]{DBObjectUtil.getUVHValues("AUDGPPolicyPathMapping", "AudGPPolicyPathMapping:policy_path_id:3201"), DBObjectUtil.getUVHValues("AUDGPPolicyPathMapping", "AudGPPolicyPathMapping:policy_path_id:3202"), DBObjectUtil.getUVHValues("AUDGPPolicyPathMapping", "AudGPPolicyPathMapping:policy_path_id:3203"), DBObjectUtil.getUVHValues("AUDGPPolicyPathMapping", "AudGPPolicyPathMapping:policy_path_id:3204"), DBObjectUtil.getUVHValues("AUDGPPolicyPathMapping", "AudGPPolicyPathMapping:policy_path_id:3205"), -1L, DBObjectUtil.getUVHValues("AUDGPPolicyPathMapping", "AudGPPolicyPathMapping:policy_path_id:3208"), DBObjectUtil.getUVHValues("AUDGPPolicyPathMapping", "AudGPPolicyPathMapping:policy_path_id:3207"), DBObjectUtil.getUVHValues("AUDGPPolicyPathMapping", "AudGPPolicyPathMapping:policy_path_id:3218"), DBObjectUtil.getUVHValues("AUDGPPolicyPathMapping", "AudGPPolicyPathMapping:policy_path_id:3209"), DBObjectUtil.getUVHValues("AUDGPPolicyPathMapping", "AudGPPolicyPathMapping:policy_path_id:3210"), DBObjectUtil.getUVHValues("AUDGPPolicyPathMapping", "AudGPPolicyPathMapping:policy_path_id:3212"), DBObjectUtil.getUVHValues("AUDGPPolicyPathMapping", "AudGPPolicyPathMapping:policy_path_id:3211"), DBObjectUtil.getUVHValues("AUDGPPolicyPathMapping", "AudGPPolicyPathMapping:policy_path_id:3213"), DBObjectUtil.getUVHValues("AUDGPPolicyPathMapping", "AudGPPolicyPathMapping:policy_path_id:3214"), -1L, DBObjectUtil.getUVHValues("AUDGPPolicyPathMapping", "AudGPPolicyPathMapping:policy_path_id:3216"), DBObjectUtil.getUVHValues("AUDGPPolicyPathMapping", "AudGPPolicyPathMapping:policy_path_id:3215"), DBObjectUtil.getUVHValues("AUDGPPolicyPathMapping", "AudGPPolicyPathMapping:policy_path_id:3217"), DBObjectUtil.getUVHValues("AUDGPPolicyPathMapping", "AudGPPolicyPathMapping:policy_path_id:3219")};
    public static final Long[] COMP_PREF_PATH_ID = new Long[]{DBObjectUtil.getUVHValues("AUDGPPolicyPathMapping", "AudGPPolicyPathMapping:policy_path_id:2201"), DBObjectUtil.getUVHValues("AUDGPPolicyPathMapping", "AudGPPolicyPathMapping:policy_path_id:2202"), DBObjectUtil.getUVHValues("AUDGPPolicyPathMapping", "AudGPPolicyPathMapping:policy_path_id:2203"), DBObjectUtil.getUVHValues("AUDGPPolicyPathMapping", "AudGPPolicyPathMapping:policy_path_id:2204"), DBObjectUtil.getUVHValues("AUDGPPolicyPathMapping", "AudGPPolicyPathMapping:policy_path_id:2205"), DBObjectUtil.getUVHValues("AUDGPPolicyPathMapping", "AudGPPolicyPathMapping:policy_path_id:2206"), DBObjectUtil.getUVHValues("AUDGPPolicyPathMapping", "AudGPPolicyPathMapping:policy_path_id:2207"), -1L, -1L, DBObjectUtil.getUVHValues("AUDGPPolicyPathMapping", "AudGPPolicyPathMapping:policy_path_id:2208"), DBObjectUtil.getUVHValues("AUDGPPolicyPathMapping", "AudGPPolicyPathMapping:policy_path_id:2209"), DBObjectUtil.getUVHValues("AUDGPPolicyPathMapping", "AudGPPolicyPathMapping:policy_path_id:2211"), DBObjectUtil.getUVHValues("AUDGPPolicyPathMapping", "AudGPPolicyPathMapping:policy_path_id:2210"), DBObjectUtil.getUVHValues("AUDGPPolicyPathMapping", "AudGPPolicyPathMapping:policy_path_id:2212"), DBObjectUtil.getUVHValues("AUDGPPolicyPathMapping", "AudGPPolicyPathMapping:policy_path_id:2213"), DBObjectUtil.getUVHValues("AUDGPPolicyPathMapping", "AudGPPolicyPathMapping:policy_path_id:2216"), DBObjectUtil.getUVHValues("AUDGPPolicyPathMapping", "AudGPPolicyPathMapping:policy_path_id:2215"), DBObjectUtil.getUVHValues("AUDGPPolicyPathMapping", "AudGPPolicyPathMapping:policy_path_id:2214"), -1L, -1L};
    public static final String[] SIMPLE_EXTN_ELEMENT_NAMES = new String[]{"Environment Variables", "Files", "Folders", "Ini Files", "Windows Registry", "Network Shares", "Shortcuts", "Drive Maps", "Regional Options", "Data Sources", "Local Users and Groups", "Folder Options", "Network Options", "Power Options", "Services", "Scheduled Tasks", "Printers", "Internet Options", "Start Menu"};
    public static final String[] SIMPLE_PREF_EXTN_SUB_HEADINGS = new String[]{"EnvironmentVariables", "FilesSettings", "Folders", "IniFiles", "RegistrySettings", "NetworkShares", "ShortcutSettings", "DriveMapSettings", "RegionalOptionsSettings", "DataSourcesSettings", "DevicesSettings", "LocalUsersAndGroups", "FolderOptions", "NetworkOptions", "PowerOptions", "NTServices", "ScheduledTasks", "Printers", "InternetOptions", "StartMenuSettings"};
    public static final String[][] SIMPLE_PREF_EXTN_SUB_ELEMENTS = new String[][]{{"EnvironmentVariable"}, {"File"}, {"Folder"}, {"Ini"}, {"Registry", "Collection"}, {"NetShare"}, {"Shortcut"}, {"Drive"}, {"RegionalOptions"}, {"DataSource"}, {"Device"}, {"User", "Group"}, {"FileType"}, {"VPN", "DUN"}, {"GlobalPowerOptions", "PowerScheme"}, {"NTService"}, {"Task", "ImmediateTask", "TaskV2", "ImmediateTaskV2"}, {"PortPrinter", "LocalPrinter", "SharedPrinter"}, {"Internet", "IE7", "IE8"}, {"StartMenu", "StartMenuVista"}};
    public static final int GP_SETTING_ADDED = 1;
    public static final int GP_SETTING_MODIFIED = 2;
    public static final int GP_SETTING_REMOVED = 3;
    private static String[] properties = new String[]{"Category", "ComputerName", "EventCode", "Message", "RecordNumber", "SourceName", "TimeGenerated", "EventType", "Type", "User"};
    public static final String GPO_EVT_QUERY_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSSSS";
    public static final String GPO_EVT_QUERY_FORMAT_SUFFIX = "Z";
    public static final String GPO_WMI_QUERY_FORMAT = "yyyyMMddHHmmss";
    public static final String GPO_WMI_QUERY_FORMAT_SUFFIX = ".000000-000";

    public static String getChangeText(int changeType) {
        String changeTypeText = rb.getString("adap.GPOComparator.No_Change");
        if (changeType == 3) {
            changeTypeText = rb.getString("adap.ObjectAccessListener.removed");
        } else if (changeType == 1) {
            changeTypeText = rb.getString("adap.Reports.Schedule_Report.added");
        } else if (changeType == 2) {
            changeTypeText = rb.getString("adap.GPOComparator.Modified");
        }
        return changeTypeText;
    }

    public static HashMap getDetailsFromXML(Hashtable hashTable, String[] properties) {
        HashMap<String, String> gpoDetails = new HashMap<String, String>();
        try {
            String fileLocation = (String)hashTable.get("GPO_TARGET_PATH");
            String fileName = (String)hashTable.get("VER_FILE_NAME");
            fileName = fileLocation + File.separator + fileName;
            File file = new File(fileName);
            BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            Document document = factory.newDocumentBuilder().parse(inputStream);
            for (String property : properties) {
                NodeList nodelist = document.getElementsByTagName(property);
                for (int i = 0; i < nodelist.getLength(); ++i) {
                    Element element = (Element)nodelist.item(0);
                    if (element.getNodeType() != 1) continue;
                    NodeList modifiedTimeNodeList = element.getChildNodes();
                    gpoDetails.put(property, modifiedTimeNodeList.item(0).getNodeValue());
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return gpoDetails;
    }

    public static String setCallerUserName(Hashtable hashTable, String domainName, String objectGUID, String gpoName, HashMap gpoAuditInfoMap) {
        String callerUserName = null;
        String pdcName = PDCHandler.getInstance().getPDCName(domainName, true);
        HashMap detailMap = GPOUtil.getDetailsFromXML(hashTable, new String[]{"Name", "ModifiedTime"});
        String modifiedTime = (String)detailMap.get("ModifiedTime");
        String displayName = (String)detailMap.get("Name");
        Hashtable eventTable = GPOUtil.getCallerUserName(domainName, pdcName, objectGUID, gpoName, modifiedTime);
        if (eventTable == null) {
            GPODCDetailsAPI.getInstance();
            ArrayList<String> prefGPOList = GPODCDetailsAPI.getPrefDCPropeties(domainName);
            if (prefGPOList != null) {
                for (String string : prefGPOList) {
                    if (!string.equalsIgnoreCase(pdcName) && (eventTable = GPOUtil.getCallerUserName(domainName, string, objectGUID, gpoName, modifiedTime)) != null) break;
                }
            }
        }
        if (eventTable != null && !eventTable.isEmpty()) {
            Integer eventNumber = (Integer)eventTable.get("EventCode");
            Long recordNumber = (Long)eventTable.get("RecordNumber");
            String source = (String)eventTable.get("DomainController");
            if (eventNumber == 5136) {
                callerUserName = (String)eventTable.get(rb.getString("adap.AUDRuleVariables.variable_display_name.Subject_Account_Domain")) + "\\" + (String)eventTable.get(rb.getString("adap.AUDRuleVariables.variable_display_name.Subject_Account_Name"));
            } else if (eventNumber == 566) {
                callerUserName = (String)eventTable.get(rb.getString("adap.AUDReportColumns.column_display_name.Client_Domain")) + "\\" + (String)eventTable.get(rb.getString("adap.AUDRuleVariables.variable_display_name.Client_User_Name"));
            }
            gpoAuditInfoMap.put("CALLER_USER_NAME", callerUserName);
            gpoAuditInfoMap.put("EVENT_NUMBER", Long.valueOf(eventNumber.intValue()));
            gpoAuditInfoMap.put("RECORD_NUMBER", recordNumber);
            gpoAuditInfoMap.put("SOURCE", source);
        }
        gpoAuditInfoMap.put("DISPLAY_NAME", displayName);
        Long gpoModifiedTime = TimeUtil.getTimeFromGPOXMLTime(modifiedTime);
        gpoAuditInfoMap.put("TIME_GENERATED", gpoModifiedTime);
        gpoAuditInfoMap.put("DOMAIN_NAME", domainName);
        return callerUserName;
    }

    private static Hashtable getCallerUserName(String domainName, String domainControllerName, String objectGUID, String gpoName, String modifiedTime) {
        Hashtable eventTable = null;
        try {
            long postiveOffset;
            int[] eventCode = new int[]{566, 5136};
            Properties domainDetails = DomainHandler.getConfiguredValues(domainName, 1L, domainControllerName);
            String dcName = (String)((ArrayList)domainDetails.get("DOMAIN_CONTROLLER_LIST")).get(0);
            String osVersion = EventDataUtil.getOSversion(dcName, domainName);
            String negOffsetFromDB = ADSMPersUtil.getSyMParameter("GQT_NEG_OFFSET");
            long negativeOffset = negOffsetFromDB != null ? Long.parseLong(negOffsetFromDB) : 0L;
            String posOffsetFromDB = ADSMPersUtil.getSyMParameter("GQT_POS_OFFSET");
            long l = postiveOffset = posOffsetFromDB != null ? Long.parseLong(posOffsetFromDB) : 60000L;
            if (osVersion != null && osVersion.startsWith("6.") && !osVersion.startsWith("5.0")) {
                String fromTime = TimeUtil.getGPOModifiedTime(modifiedTime, GPO_EVT_QUERY_FORMAT, GPO_EVT_QUERY_FORMAT_SUFFIX, negativeOffset, true);
                String toTime = TimeUtil.getGPOModifiedTime(modifiedTime, GPO_EVT_QUERY_FORMAT, GPO_EVT_QUERY_FORMAT_SUFFIX, postiveOffset, false);
                String evtQuery = EventCollectionUtil.getEVTQueryForGPO(fromTime, toTime, eventCode[1]);
                eventTable = GPOUtil.getEventData(domainName, evtQuery, objectGUID, gpoName, domainDetails, dcName, osVersion);
            } else {
                String fromTime = TimeUtil.getGPOModifiedTime(modifiedTime, GPO_WMI_QUERY_FORMAT, GPO_WMI_QUERY_FORMAT_SUFFIX, negativeOffset, true);
                String toTime = TimeUtil.getGPOModifiedTime(modifiedTime, GPO_WMI_QUERY_FORMAT, GPO_WMI_QUERY_FORMAT_SUFFIX, postiveOffset, false);
                String wmiQuery = EventCollectionUtil.getWMIQueryForGPO(fromTime, toTime, eventCode);
                eventTable = GPOUtil.getEventData(domainName, wmiQuery, objectGUID, gpoName, domainDetails, dcName, osVersion);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return eventTable;
    }

    public static Hashtable getEventData(String domainName, String wmiQuery, String objectGUID, String gpoName, Properties domainDetails, String dcName, String osVersion) {
        Hashtable<String, Object> eventTable;
        block7: {
            eventTable = null;
            try {
                String userName = null;
                String password = null;
                if (!domainDetails.getProperty("IS_AUTHENTICATION_REQUIRED").equalsIgnoreCase("false")) {
                    userName = (String)domainDetails.get("USER_NAME");
                    password = (String)domainDetails.get("PASSWORD");
                }
                ArrayList eventDataList = new ArrayList();
                String winVersion = "";
                if (osVersion != null && osVersion.startsWith("6.") && !osVersion.startsWith("5.0")) {
                    winVersion = osVersion.startsWith("6.0") ? "2k8" : (osVersion.startsWith("6.1") ? "2k8r2" : (osVersion.startsWith("6.2") ? "2k12" : "2k8r2"));
                    eventDataList = ADHandler.getAdvancedGPOevt(domainDetails, dcName, wmiQuery, winVersion);
                } else {
                    Hashtable retHash = new Hashtable();
                    eventDataList = ADHandler.getWindowsDirectory(dcName, domainName, userName, password, properties, wmiQuery, retHash, 1, 1);
                }
                if (eventDataList == null || eventDataList.isEmpty()) break block7;
                Hashtable firstEventTable = (Hashtable)eventDataList.get(0);
                Integer eventNumber = (Integer)((Hashtable)eventDataList.get(0)).get("EventCode");
                Hashtable ruleTable = GPOUtil.getRuleTable(eventNumber, objectGUID, gpoName);
                for (Object object : eventDataList) {
                    Boolean b;
                    Hashtable<String, Object> modData = AuditEventAPI.getInstance().parseEvent((Hashtable)object);
                    String objectName = null;
                    if (eventNumber == 566 && (objectName = (String)modData.get(rb.getString("adap.AUDRuleVariables.variable_name.Object_Name"))) != null) {
                        String[] splitArray = objectName.split(",");
                        objectName = splitArray[0];
                        objectName = objectName.replace("CN=", "");
                        modData.put(rb.getString("adap.AUDRuleVariables.variable_name.Object_Name"), objectName);
                    }
                    if (!(b = GPOUtil.evaluate(modData, ruleTable)).booleanValue()) continue;
                    modData.put("DomainController", dcName);
                    eventTable = modData;
                    break;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return eventTable;
    }

    public static Boolean evaluate(Hashtable eventTable, Hashtable ruleTable) {
        Boolean flag = false;
        try {
            Set keySet = ruleTable.keySet();
            for (Object object : keySet) {
                Hashtable conditionTable = (Hashtable)ruleTable.get(object);
                String conditionValue = (String)conditionTable.get("value");
                int operation = (Integer)conditionTable.get("operator");
                String value = (String)eventTable.get(object);
                flag = GPOUtil.compareStringValues(value, conditionValue, operation);
                if (flag.booleanValue()) continue;
                return flag;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return flag;
    }

    public static Boolean compareStringValues(Object value, Object conditionValue, int operation) {
        boolean flag = false;
        try {
            String conditionString = conditionValue.toString().toLowerCase();
            String valueString = value.toString().toLowerCase();
            if (operation == 1) {
                flag = valueString.equalsIgnoreCase(conditionString);
            } else if (operation == 2) {
                flag = !valueString.equalsIgnoreCase(conditionString);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    public static Hashtable getRuleTable(Integer eventNumber, String objectGUID, String gpoName) {
        Hashtable ruleTable = new Hashtable();
        Hashtable<String, Object> operatorTable = new Hashtable<String, Object>();
        try {
            if (eventNumber == 5136) {
                operatorTable = new Hashtable();
                operatorTable.put("operator", 1);
                operatorTable.put("value", "versionNumber");
                ruleTable.put(rb.getString("adap.AUDRuleVariables.variable_name.Attribute_LDAP_Display_Name"), operatorTable);
                operatorTable = new Hashtable();
                operatorTable.put("operator", 2);
                operatorTable.put("value", "-");
                ruleTable.put(rb.getString("adap.AUDRuleVariables.variable_name.Subject_Account_Name"), operatorTable);
                operatorTable = new Hashtable();
                operatorTable.put("operator", 1);
                operatorTable.put("value", objectGUID);
                ruleTable.put(rb.getString("adap.AUDRuleVariables.variable_name.Object_GUID"), operatorTable);
            } else if (eventNumber == 566) {
                operatorTable = new Hashtable();
                operatorTable.put("operator", 2);
                operatorTable.put("value", "-");
                ruleTable.put(rb.getString("adap.AUDRuleVariables.variable_name.Client_User_Name"), operatorTable);
                operatorTable = new Hashtable();
                operatorTable.put("operator", 1);
                operatorTable.put("value", gpoName);
                ruleTable.put(rb.getString("adap.AUDRuleVariables.variable_name.Object_Name"), operatorTable);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return ruleTable;
    }

    public static String getPreviousVersion(String objectGUID, String fileExtn) {
        String fileName = null;
        try {
            String tableName = "AudGPOXMLDetails";
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"OBJECT_GUID"), (Object)objectGUID, 0);
            Table table = Table.getTable((String)tableName);
            SelectQueryImpl query = new SelectQueryImpl(table);
            query.setCriteria(criteria);
            query.addSortColumn(new SortColumn(Column.getColumn((String)tableName, (String)"VERSION"), false));
            query.addSelectColumn(Column.getColumn((String)tableName, (String)"*"));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            if (!dataObject.isEmpty()) {
                Row row = dataObject.getRow(tableName);
                fileName = "";
                if (fileExtn.equalsIgnoreCase("xml")) {
                    fileName = (String)row.get("FILE_LOCATION") + File.separator;
                }
                Long version = (Long)row.get("VERSION");
                fileName = fileName + version + "." + fileExtn;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fileName;
    }

    public static String getGPOXMLDir(String domainName, String gpoGuId) {
        String gpoXmlDir = null;
        try {
            gpoXmlDir = System.getProperty("server.dir") + File.separator + "webapps" + File.separator + "adap" + File.separator + "GPODetails" + File.separator + domainName + File.separator + gpoGuId.toLowerCase();
            if (!new File(gpoXmlDir).isDirectory()) {
                new File(gpoXmlDir).mkdirs();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return gpoXmlDir;
    }

    public static void setRowValues(HashMap rowDataMap, DataObject dataObject, Row row, Boolean add, HashMap gpoAuditInfoMap) {
        try {
            Boolean gpoAlertFlag = false;
            HashMap changeMap = (HashMap)rowDataMap.remove("CHANGE_DETAILS");
            Map errorMap = (Map)rowDataMap.remove("ERROR_DETAILS");
            Set keySet = rowDataMap.keySet();
            for (Object object : keySet) {
                row.set((String)object, rowDataMap.get(object));
            }
            Row auditInfoRow = null;
            if (add.booleanValue()) {
                dataObject.addRow(row);
                if (gpoAuditInfoMap != null && !gpoAuditInfoMap.isEmpty()) {
                    auditInfoRow = new Row("AudGPOAuditInfo");
                    Set auditInfoKeySet = gpoAuditInfoMap.keySet();
                    for (Object object : auditInfoKeySet) {
                        auditInfoRow.set((String)object, gpoAuditInfoMap.get(object));
                    }
                }
                int addedSettings = 0;
                int modifiedSettings = 0;
                int removedSettings = 0;
                if (changeMap != null && !changeMap.isEmpty()) {
                    gpoAlertFlag = true;
                    DataAccess.generateValues((Row)auditInfoRow);
                    auditInfoRow.set("UNIQUE_ID", auditInfoRow.get("UNIQUE_ID"));
                    Set policyPathSet = changeMap.keySet();
                    for (Object policyPathId : policyPathSet) {
                        int ppAddedSettings = 0;
                        int ppModifiedSettings = 0;
                        int ppRemovedSettings = 0;
                        Row policyPathRow = new Row("AUDGPOPolicyPathInfo");
                        policyPathRow.set("UNIQUE_ID", auditInfoRow.get("UNIQUE_ID"));
                        policyPathRow.set("POLICY_PATH_ID", policyPathId);
                        policyPathRow.set("POLICY_PATH", (Object)GPOPolicyPathAPI.getInstance().getLocalizedPolicyPath((Long)policyPathId));
                        ArrayList changeList = (ArrayList)changeMap.get(policyPathId);
                        for (Object objectMap : changeList) {
                            HashMap settingMap = (HashMap)objectMap;
                            Row settingRow = new Row("AUDGPOSettingsInfo");
                            settingRow.set("CHANGE_ID", policyPathRow.get("CHANGE_ID"));
                            Integer changeType = (Integer)settingMap.get("CHANGE_TYPE");
                            if (changeType == 1) {
                                ++addedSettings;
                                ++ppAddedSettings;
                            } else if (changeType == 2) {
                                ++modifiedSettings;
                                ++ppModifiedSettings;
                            } else if (changeType == 3) {
                                ++removedSettings;
                                ++ppRemovedSettings;
                            }
                            settingRow.set("CHANGE_TYPE", (Object)changeType);
                            settingRow.set("CHANGE_TYPE_TEXT", settingMap.get("CHANGE_TYPE_TEXT"));
                            settingRow.set("SETTING_NAME", (Object)rb.getString(settingMap.get("SETTING_NAME").toString()));
                            settingRow.set("SETTING_NEW_VALUE", settingMap.get("SETTING_NEW_VALUE"));
                            if (settingMap.get("SETTING_OLD_VALUE") != null) {
                                settingRow.set("SETTING_OLD_VALUE", settingMap.get("SETTING_OLD_VALUE"));
                            }
                            if (settingMap.get("IS_ADM_TEMPLATE") != null && Boolean.valueOf(settingMap.get("IS_ADM_TEMPLATE").equals(true)).booleanValue()) {
                                settingRow.set("IS_ADM_TEMPLATE", settingMap.get("IS_ADM_TEMPLATE"));
                                settingRow.set("COMMENT_NEW_VALUE", settingMap.get("COMMENT_NEW_VALUE"));
                                if (settingMap.get("COMMENT_OLD_VALUE") != null) {
                                    settingRow.set("COMMENT_OLD_VALUE", settingMap.get("COMMENT_OLD_VALUE"));
                                }
                            }
                            dataObject.addRow(settingRow);
                        }
                        policyPathRow.set("SETTINGS_ADDED", (Object)ppAddedSettings);
                        policyPathRow.set("SETTINGS_REMOVED", (Object)ppRemovedSettings);
                        policyPathRow.set("SETTINGS_MODIFIED", (Object)ppModifiedSettings);
                        dataObject.addRow(policyPathRow);
                    }
                    if (auditInfoRow != null) {
                        auditInfoRow.set("SETTINGS_ADDED", (Object)addedSettings);
                        auditInfoRow.set("SETTINGS_REMOVED", (Object)removedSettings);
                        auditInfoRow.set("SETTINGS_MODIFIED", (Object)modifiedSettings);
                    }
                }
                if (auditInfoRow != null) {
                    dataObject.addRow(auditInfoRow);
                }
                if (errorMap != null && !errorMap.isEmpty()) {
                    Set errorPathSet = errorMap.keySet();
                    row.set("HAS_EXTN_ERRORS", (Object)true);
                    for (String confString : errorPathSet) {
                        List errorExtnList = (List)errorMap.get(confString);
                        for (String errorExtnString : errorExtnList) {
                            Row errorRow = new Row("AudGPOXMLExtnErrors");
                            errorRow.set("GPO_XML_ID", row.get("GPO_XML_ID"));
                            errorRow.set("CONF_NAME", (Object)confString);
                            errorRow.set("EXTN_NAME", (Object)errorExtnString);
                            dataObject.addRow(errorRow);
                        }
                    }
                }
            } else {
                dataObject.updateRow(row);
            }
            CommonUtil.getPersistence(new boolean[0]).update(dataObject);
            if (gpoAlertFlag.booleanValue()) {
                if (auditInfoRow.get("SOURCE") == null) {
                    auditInfoRow.set("SOURCE", (Object)"-");
                }
                GPOAlertProfileListener.getInstance().addInQueue(auditInfoRow);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static String getName(String gpoLdapStr) {
        String gpoNames = null;
        try {
            Pattern pattern = UserAttributeUtil.getUserParameterPattern(CommonUtil.patternStr);
            Matcher match = pattern.matcher(gpoLdapStr);
            ArrayList<String> patternList = new ArrayList<String>();
            while (match.find()) {
                String matchStr = match.group();
                patternList.add(matchStr);
            }
            String tableName = "ADSMGPODetails";
            Table table = Table.getTable((String)tableName);
            SelectQueryImpl selectQuery = new SelectQueryImpl(table);
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"GPO_NAME"), (Object)patternList.toArray(), 8);
            selectQuery.addSelectColumn(Column.getColumn((String)tableName, (String)"*"));
            selectQuery.setCriteria(criteria);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
            Iterator iterator = dataObject.getRows(tableName);
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                String gpoName = (String)row.get("NAME");
                if (gpoNames != null) {
                    gpoNames = gpoNames + "," + gpoName;
                    continue;
                }
                gpoNames = gpoName;
            }
            if (gpoNames == null && !patternList.isEmpty()) {
                gpoNames = patternList.toString();
                gpoNames = gpoNames.replaceAll("\\[", "");
                gpoNames = gpoNames.replaceAll("\\]", "");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return gpoNames;
    }

    public static String getGPONameGUID(String fileName) {
        String gpoNameGUID = null;
        try {
            Pattern pattern = UserAttributeUtil.getUserParameterPattern(CommonUtil.patternStr);
            Matcher match = pattern.matcher(fileName);
            while (match.find()) {
                String matchStr;
                gpoNameGUID = matchStr = match.group();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return gpoNameGUID;
    }

    public static Row getRow(String objectGUID, Long versionNumber) {
        Row row = null;
        try {
            String tableName = "AudGPOXMLDetails";
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"OBJECT_GUID"), (Object)objectGUID, 0);
            if (versionNumber != null && versionNumber != 0L) {
                criteria = criteria.and(Column.getColumn((String)tableName, (String)"VERSION"), (Object)versionNumber, 0);
            }
            Table table = Table.getTable((String)tableName);
            SelectQueryImpl query = new SelectQueryImpl(table);
            query.setCriteria(criteria);
            if (versionNumber == null || versionNumber == 0L) {
                query.addSortColumn(new SortColumn(Column.getColumn((String)tableName, (String)"VERSION"), false));
            }
            query.addSelectColumn(Column.getColumn((String)tableName, (String)"*"));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            if (!dataObject.isEmpty()) {
                row = dataObject.getRow(tableName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return row;
    }

    public static String getFileInfo(String objectGUID, Long versionNumber, String fileExtn, boolean isAbsolutePath) {
        String fileName = null;
        try {
            Row row = GPOUtil.getRow(objectGUID, versionNumber);
            if (row != null) {
                StringBuilder fileNameBuilder = new StringBuilder("");
                if (isAbsolutePath) {
                    fileNameBuilder.append((String)row.get("FILE_LOCATION"));
                    fileNameBuilder.append(File.separator);
                }
                String xmlFileName = (String)row.get("FILE_NAME");
                if (fileExtn.equalsIgnoreCase("xml")) {
                    fileNameBuilder.append(xmlFileName);
                } else {
                    String[] fileNames = xmlFileName.split("\\.");
                    fileNameBuilder.append(fileNames[0]);
                    fileNameBuilder.append(".");
                    fileNameBuilder.append(fileExtn);
                }
                fileName = fileNameBuilder.toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fileName;
    }

    public static Long getPreviousVersionNumber(String objectGUID) {
        Long previousVersion = 0L;
        try {
            Row row = GPOUtil.getRow(objectGUID, null);
            if (row != null) {
                previousVersion = (Long)row.get("VERSION");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return previousVersion;
    }
}

