/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.gpo;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.gpo.GPOManagementListener;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class GPOZipUtility {
    private static GPOZipUtility gpoHandler = null;
    public static ArrayList localDomainList = null;
    private static int archiveBufferSize = 8192;

    private GPOZipUtility() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GPOZipUtility getInstance() {
        if (gpoHandler != null) return gpoHandler;
        Class<GPOZipUtility> clazz = GPOZipUtility.class;
        synchronized (GPOZipUtility.class) {
            gpoHandler = new GPOZipUtility();
            // ** MonitorExit[var0] (shouldn't be in output)
            return gpoHandler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Boolean createZipFile(String dirName, String zipFileName, ArrayList list) throws Exception {
        boolean b = true;
        try {
            String[] fileNameArray = new String[]{".xml", ".html"};
            BufferedInputStream origin = null;
            FileOutputStream dest = null;
            ZipOutputStream zos = null;
            String tmpFileName = null;
            FileInputStream fi = null;
            File directory = new File(dirName);
            ArrayList<String> deleteFileList = new ArrayList<String>();
            if (!directory.isDirectory()) {
                return null;
            }
            File[] files = directory.listFiles();
            try {
                tmpFileName = directory.getAbsolutePath() + File.separator + zipFileName + ".tmp";
                File tmpFile = new File(tmpFileName);
                if (!tmpFile.exists()) {
                    tmpFile.createNewFile();
                }
                zipFileName = directory.getAbsolutePath() + File.separator + zipFileName + ".zip";
                zipFileName = zipFileName.replace("\\", "\\\\");
                tmpFileName = tmpFileName.replace("\\", "\\\\");
                dest = new FileOutputStream(tmpFileName);
                zos = new ZipOutputStream(new BufferedOutputStream(dest));
                this.copyExistingEntries(zipFileName, zos);
                byte[] data = new byte[archiveBufferSize];
                for (int j = 5; j < list.size(); ++j) {
                    HashMap xmlMap = (HashMap)list.get(j);
                    String fileLocation = (String)xmlMap.get("FILE_LOCATION");
                    Long version = (Long)xmlMap.get("VERSION");
                    String fileName = (String)xmlMap.get("FILE_NAME");
                    fileName = fileName.substring(0, fileName.indexOf(".xml"));
                    for (String object : fileNameArray) {
                        int count;
                        String fName = fileName + object.toString();
                        String location = fileLocation + File.separator + fName;
                        File file = new File(location);
                        if (!file.isFile()) continue;
                        fi = new FileInputStream(file);
                        origin = new BufferedInputStream(fi, archiveBufferSize);
                        ZipEntry entry = new ZipEntry(fName);
                        zos.putNextEntry(entry);
                        while ((count = origin.read(data, 0, archiveBufferSize)) != -1) {
                            zos.write(data, 0, count);
                        }
                        fi.close();
                        origin.close();
                        xmlMap.put("ZIP_STATUS", true);
                        GPOManagementListener.getInstance().updateGPOXMLDetails(xmlMap, null);
                        deleteFileList.add(fName);
                    }
                }
            }
            catch (Exception e) {
                b = false;
                e.printStackTrace();
            }
            finally {
                try {
                    if (origin != null) {
                        origin.close();
                    }
                    if (zos != null) {
                        zos.close();
                    }
                    if (dest != null) {
                        dest.close();
                    }
                    if (fi != null) {
                        fi.close();
                    }
                    for (int i = 0; i < files.length; ++i) {
                        String fileName = files[i].getName();
                        if (!deleteFileList.contains(fileName)) continue;
                        files[i].delete();
                    }
                    File tmpFileObject = new File(tmpFileName);
                    File zipFileObject = new File(zipFileName);
                    if (tmpFileObject.exists()) {
                        zipFileObject.delete();
                        File file1 = new File(directory.getAbsolutePath() + File.separator + "12.zip");
                        boolean rename = tmpFileObject.renameTo(zipFileObject);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return b;
    }

    public Boolean copyExistingEntries(String zipFileName, ZipOutputStream zos) throws IOException {
        Boolean b = true;
        Object entryName = null;
        int entry = 0;
        File sourceFile = new File(zipFileName);
        if (!sourceFile.exists()) {
            return null;
        }
        ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFileName));
        ZipEntry oldZipEntry = null;
        int noOfEntries = 0;
        oldZipEntry = zis.getNextEntry();
        if (oldZipEntry != null) {
            ++noOfEntries;
        }
        zis.close();
        if (noOfEntries <= 0) {
            return null;
        }
        ZipFile zf = new ZipFile(new File(zipFileName));
        Enumeration<? extends ZipEntry> en = zf.entries();
        block0: while (en.hasMoreElements()) {
            ZipEntry zipentry = en.nextElement();
            InputStream is = zf.getInputStream(zipentry);
            zos.putNextEntry(new ZipEntry(zipentry.getName()));
            ++entry;
            while (true) {
                byte[] arr = new byte[archiveBufferSize];
                int len = 0;
                len = is.read(arr);
                if (len < 0) {
                    is.close();
                    zos.closeEntry();
                    continue block0;
                }
                zos.write(arr, 0, len);
                zos.flush();
            }
        }
        zf.close();
        return b;
    }

    public HashMap getGPOZipMap() {
        HashMap map = new HashMap();
        try {
            String tableName = "AudGPOXMLDetails";
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)tableName));
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"ZIP_STATUS"), (Object)false, 0);
            selectQuery.setCriteria(criteria);
            selectQuery.addSelectColumn(Column.getColumn((String)tableName, (String)"*"));
            selectQuery.addSortColumn(new SortColumn(Column.getColumn((String)tableName, (String)"VERSION"), false));
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
            Iterator iterator = obj.getRows(tableName);
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                String objectGUID = (String)row.get("OBJECT_GUID");
                Long version = (Long)row.get("VERSION");
                String location = (String)row.get("FILE_LOCATION");
                String fileName = (String)row.get("FILE_NAME");
                Boolean isHtmlGenerated = (Boolean)row.get("IS_HTML_GENERATED");
                ArrayList list = (ArrayList)map.get(objectGUID);
                if (list == null) {
                    list = new ArrayList();
                }
                HashMap<String, Object> dataMap = new HashMap<String, Object>();
                dataMap.put("VERSION", version);
                dataMap.put("FILE_LOCATION", location);
                dataMap.put("FILE_NAME", fileName);
                dataMap.put("OBJECT_GUID", objectGUID);
                dataMap.put("IS_HTML_GENERATED", isHtmlGenerated);
                list.add(dataMap);
                map.put(objectGUID, list);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return map;
    }

    public void deleteDuplicateXMLFiles(HashMap map) {
        try {
            Set keySet = map.keySet();
            for (Object object : keySet) {
                ArrayList list = (ArrayList)map.get(object);
                for (Object listEntry : list) {
                    File[] foundFiles;
                    HashMap xmlMap = (HashMap)listEntry;
                    String fileLocation = (String)xmlMap.get("FILE_LOCATION");
                    String fileName = (String)xmlMap.get("FILE_NAME");
                    fileName = fileName.substring(0, fileName.indexOf(".xml"));
                    Long version = (Long)xmlMap.get("VERSION");
                    File dir = new File(fileLocation);
                    for (File file : foundFiles = dir.listFiles()) {
                        String fName = file.getName();
                        if (!fName.startsWith(version + "_") || fName.startsWith(fileName)) continue;
                        file.delete();
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void generateGPOZipFile() {
        try {
            HashMap map = this.getGPOZipMap();
            this.deleteDuplicateXMLFiles(map);
            Set keySet = map.keySet();
            ArrayList keyList = new ArrayList();
            for (Object object : keySet) {
                ArrayList list = (ArrayList)map.get(object);
                if (list.size() > 5) continue;
                keyList.add(object);
            }
            for (Object listKey : keyList) {
                map.remove(listKey);
            }
            if (!map.isEmpty()) {
                Set keySets = map.keySet();
                for (Object keyObject : keySets) {
                    ArrayList listObject = (ArrayList)map.get(keyObject);
                    HashMap xmlMap = (HashMap)listObject.get(0);
                    String fileLocation = (String)xmlMap.get("FILE_LOCATION");
                    this.createZipFile(fileLocation, (String)keyObject, listObject);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

