/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.gpo;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import net.sourceforge.jtds.jdbc.ClobImpl;

public class GPSettingsHandler {
    private static final String[] SETTINGS_COLUMN = new String[]{"CHANGE_TYPE", "CHANGE_TYPE_TEXT", "SETTING_NAME", "SETTING_OLD_VALUE", "SETTING_NEW_VALUE", "IS_ADM_TEMPLATE", "COMMENT_NEW_VALUE", "COMMENT_OLD_VALUE"};

    public static String getSelectQuery(String columnName, String queryValues) {
        StringBuilder queryBuilder = new StringBuilder(GPSettingsHandler.getBaseQuery());
        queryBuilder.append(columnName);
        queryBuilder.append(" IN (");
        queryBuilder.append(queryValues);
        queryBuilder.append(" )");
        return queryBuilder.toString();
    }

    public static String getBaseQuery() {
        StringBuilder queryBuilder = new StringBuilder("SELECT AUDGPOPolicyPathInfo.POLICY_PATH as POLICY_PATH");
        for (String string : SETTINGS_COLUMN) {
            queryBuilder.append(",");
            queryBuilder.append("AUDGPOSettingsInfo.");
            queryBuilder.append(string);
            queryBuilder.append(" as ");
            queryBuilder.append(string);
        }
        queryBuilder.append(" FROM AUDGPOPolicyPathInfo JOIN AUDGPOSettingsInfo ON AUDGPOPolicyPathInfo.CHANGE_ID=AUDGPOSettingsInfo.CHANGE_ID WHERE AUDGPOPolicyPathInfo.");
        return queryBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<String, ArrayList> getSettingsChangeRow(String columnName, String queryValues) {
        HashMap<String, ArrayList> settingsMap = new HashMap<String, ArrayList>();
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = RelationalAPI.getInstance().getConnection();
            statement = connection.createStatement();
            String query = GPSettingsHandler.getSelectQuery(columnName, queryValues);
            resultSet = QueryUtil.executeQuery("GPO Settings Change Report", statement, query);
            int count = 0;
            while (resultSet.next()) {
                String policyPath = resultSet.getString("POLICY_PATH");
                ArrayList settingsChangeList = settingsMap.get(policyPath);
                if (settingsChangeList == null) {
                    settingsChangeList = new ArrayList();
                }
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                for (String string : SETTINGS_COLUMN) {
                    hashMap.put(string, resultSet.getObject(string));
                }
                settingsChangeList.add(hashMap);
                settingsMap.put(policyPath, settingsChangeList);
                ++count;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return settingsMap;
    }

    public static Object getChangeId(Object changeIdObject) throws Exception {
        String dbServerName = CommonUtil.getDBServerName();
        if (changeIdObject.getClass().isArray()) {
            ArrayList<String> changeIdList = new ArrayList<String>();
            byte[] changeIdBytes = (byte[])changeIdObject;
            String string = new String(changeIdBytes);
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                changeIdList.add(stringTokenizer.nextToken());
            }
            return changeIdList;
        }
        if (changeIdObject.getClass().getName().equalsIgnoreCase("net.sourceforge.jtds.jdbc.ClobImpl")) {
            ArrayList<String> changeIdList = new ArrayList<String>();
            ClobImpl clobObj = (ClobImpl)changeIdObject;
            String val = clobObj.getSubString(1L, (int)clobObj.length());
            StringTokenizer stringTokenizer = new StringTokenizer(val, ",");
            while (stringTokenizer.hasMoreTokens()) {
                changeIdList.add(stringTokenizer.nextToken());
            }
            return changeIdList;
        }
        if (changeIdObject.getClass().getName().equalsIgnoreCase("java.lang.String") && dbServerName.equalsIgnoreCase("postgres")) {
            ArrayList<Long> changeIdList = new ArrayList<Long>();
            StringTokenizer stringTokenizer = new StringTokenizer(changeIdObject.toString(), ",");
            while (stringTokenizer.hasMoreTokens()) {
                changeIdList.add(new Long(stringTokenizer.nextToken()));
            }
            return changeIdList;
        }
        return changeIdObject;
    }
}

