/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.gpo;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.gpo.GPOManagementListener;
import com.adventnet.sym.adsm.auditing.server.gpo.GPOUtil;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainDetailsAPI;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;

public class PDCHandler {
    private static PDCHandler pdcHandler = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PDCHandler getInstance() {
        if (pdcHandler != null) return pdcHandler;
        Class<PDCHandler> clazz = PDCHandler.class;
        synchronized (PDCHandler.class) {
            pdcHandler = new PDCHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return pdcHandler;
        }
    }

    private PDCHandler() {
    }

    public void startNativeThread(String domainName) {
        try {
            NativeThread nativeThread = new NativeThread(domainName);
            nativeThread.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Long getPDCID(String domainName) {
        Long dcId = 0L;
        try {
            Hashtable pdcTable = (Hashtable)ADHandler.getPrimaryDC(domainName);
            String pdcDNSName = (String)pdcTable.get("PDC_DNS_NAME");
            String pdcFlatName = (String)pdcTable.get("PDC_FLAT_NAME");
            if (pdcDNSName != null && pdcFlatName != null) {
                pdcDNSName = pdcDNSName.replace("\\\\", "");
                pdcDNSName = pdcDNSName.trim();
                pdcFlatName = pdcFlatName.replace("\\\\", "");
                pdcFlatName = pdcFlatName.trim();
                ArrayList<String> domainControllerList = new ArrayList<String>();
                domainControllerList.add(pdcDNSName);
                domainControllerList.add(pdcFlatName);
                dcId = this.getDCId(domainControllerList, domainName);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return dcId;
    }

    public Long getDCId(ArrayList domainControllerList, String domainName) {
        Long dcId = 0L;
        try {
            if (domainControllerList != null && !domainControllerList.isEmpty()) {
                String tableName = "ADSMDCConfiguration";
                SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)tableName));
                Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_CONTROLLER_NAME"), (Object)domainControllerList.toArray(), 8, false);
                criteria = criteria.and(new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)domainName, 0, false));
                query.setCriteria(criteria);
                query.addSelectColumn(Column.getColumn((String)tableName, (String)"*"));
                DataObject obj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
                Row row = obj.getRow(tableName);
                if (row != null) {
                    dcId = (Long)row.get("DOMAIN_CONTROLLER_ID");
                } else {
                    ArrayList<String> dcList = new ArrayList<String>();
                    String pdcName = (String)domainControllerList.get(0);
                    dcList.add(pdcName);
                    Properties domainProperties = DomainHandler.getConfiguredValuesForModify(domainName);
                    domainProperties.put("DOMAIN_CONTROLLER_LIST", dcList);
                    DomainHandler.getDomainDetails(domainProperties, true);
                    DomainHandler.addDomainControllers(domainProperties);
                    dcId = PDCHandler.getInstance().getDCIdFromDB(domainName, pdcName);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return dcId;
    }

    public Long getDCIdFromDB(String domainName, String dcName) {
        Long dcId = 0L;
        try {
            String tableName = "ADSMComputerGeneralDetails";
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)tableName));
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"NAME"), (Object)dcName, 0, false);
            criteria = criteria.or(new Criteria(Column.getColumn((String)tableName, (String)"COMMON_NAME"), (Object)dcName, 0, false));
            criteria = criteria.or(new Criteria(Column.getColumn((String)tableName, (String)"DNS_NAME"), (Object)dcName, 0, false));
            criteria = criteria.and(new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)domainName, 0, false));
            query.setCriteria(criteria);
            query.addSelectColumn(Column.getColumn((String)tableName, (String)"*"));
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            Row row = obj.getRow(tableName);
            if (row != null) {
                ArrayList<String> dcNameList = new ArrayList<String>();
                String name = (String)row.get("NAME");
                String commonName = (String)row.get("COMMON_NAME");
                String dnsName = (String)row.get("DNS_NAME");
                dcNameList.add(name);
                dcNameList.add(commonName);
                dcNameList.add(dnsName);
                dcId = this.getDCId(dcNameList, domainName);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return dcId;
    }

    public String getPDCName(String domainName, Boolean b) {
        String dcName = null;
        String tableName = "ADSMDCConfiguration";
        String tableGPOFileWatcherName = "AUDGPOFileWatcherDetails";
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)domainName, 0);
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)tableName));
            query.setCriteria(criteria);
            query.addSelectColumn(Column.getColumn((String)tableName, (String)"*"));
            Join join = new Join(tableName, tableGPOFileWatcherName, new String[]{"DOMAIN_CONTROLLER_ID"}, new String[]{"DOMAIN_CONTROLLER_ID"}, 2);
            query.addJoin(join);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            Row row = dataObj.getRow(tableName);
            if (row != null) {
                dcName = (String)row.get("DOMAIN_CONTROLLER_NAME");
            } else if (b.booleanValue()) {
                this.updatePDC(domainName, null);
                dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
                row = dataObj.getRow(tableName);
                if (row != null) {
                    dcName = (String)row.get("DOMAIN_CONTROLLER_NAME");
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return dcName;
    }

    public void updatePDC() {
        for (String domainName : DomainDetailsAPI.getConfiguredDomainList()) {
            this.updatePDC(domainName, null);
        }
    }

    public void updatePDC(String domainName, Long pdcId) {
        try {
            if (pdcId == null) {
                pdcId = this.getPDCID(domainName);
            }
            HashMap<String, Object> rowDataMap = new HashMap<String, Object>();
            rowDataMap.put("DOMAIN_NAME", domainName);
            rowDataMap.put("DOMAIN_CONTROLLER_ID", pdcId);
            GPOManagementListener.getInstance().updateGPOFileWatcherDetails(rowDataMap);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean updateIsGPMCInstalled() {
        Boolean b = false;
        HashMap<String, Boolean> rowDataMap = new HashMap<String, Boolean>();
        try {
            Object domainFlatName = null;
            b = ADHandler.isGpmcInstalled();
            rowDataMap.put("IS_GPMC_INSTALLED", b);
        }
        catch (Exception ex) {
            b = false;
            ex.printStackTrace();
        }
        finally {
            try {
                this.updateIsGPMCInstalled(rowDataMap);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return b;
    }

    public void updateIsGPMCInstalled(HashMap rowDataMap) {
        try {
            boolean add = false;
            String tableName = "AUDGPOFileWatcherDetails";
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(tableName, (Criteria)null);
            Iterator iterator = dataObject.getRows(tableName);
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                GPOUtil.setRowValues(rowDataMap, dataObject, row, add, null);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static Boolean isGPMCInstalled() {
        Boolean b = true;
        try {
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDGPOFileWatcherDetails", (Criteria)null);
            if (!dataObject.isEmpty()) {
                Row row = dataObject.getRow("AUDGPOFileWatcherDetails");
                b = (Boolean)row.get("IS_GPMC_INSTALLED");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return b;
    }

    class NativeThread
    extends Thread {
        private boolean shutDown = false;
        String domainName = null;

        public NativeThread(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public void run() {
            try {
                PDCHandler.this.updatePDC(this.domainName, null);
                PDCHandler.this.updateIsGPMCInstalled();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void shutDown() {
            this.shutDown = true;
        }

        public synchronized void waitForUpdate(long t) {
            try {
                super.wait(t);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

